* program:chembase.prg
* system : tscreen
* programmer: Kevin Stroupe, PES

PARAMETER mprompt, mvarread,mprogram

SET CURSOR OFF
SET CONFIRM OFF
PUBLIC mode,Chemname,Boil,Spcheat1,Spcheat2,Spcheat3,Spcheat4,Molewt
PUBLIC Latentheat,Ldensity,chemrow,chemparam,CritTemp

IF LEN(mprompt) <> 0          &&Picked a chemical
   HIDE WINDOW surround
   HIDE POPUP chempop
ELSE                          && adding a chemical
   *DEFINE WINDOW srrnd FROM 0,0 TO 24,79 COLOR &IPColor NONE
   *ACTIVATE WINDOW srrnd
   HIDE POPUP ALL
   HIDE WINDOW ALL
   HIDE MENU ALL
   @0,0 SAY PADC("",80,' ') COLOR W+/BG
ENDIF
chemrow = -1
mode = ''
chemlabel = ' Chemical Data '   
DEFINE WINDOW chemwind FROM 5,3 TO 20,75 COLOR SCHEME 1 SHADOW TITLE chemlabel
ACTIVATE WINDOW chemwind
DO ChemInit
   
keypress = 0
DO WHILE keypress <> 27
   IF mode = 'add'
      DO ChemEdit
      EXIT
   ENDIF

*   wait for a key to be pressed
   keypress = 0
   DO WHILE keypress = 0
      keypress = INKEY()
   ENDDO

*   operations
   DO CASE
      CASE keypress = 13 .AND. mode = 'viewpt'  &&     enter
         &mvarread = LEFT(ALLTRIM(chemparam)+SPACE(8),8)
         KEYBOARD CHR(27)                          
         EXIT
      CASE keypress = 27                        &&      escape         
         EXIT 
      CASE keypress = 22                        &&      ins
         IF mode = 'viewpt'
            @ chemrow,47 SAY ' '
         ENDIF
         mode = 'edit'
         DO ChemEdit
         DO ChemEL
         DO ChemInit
      CASE keypress = 7                         &&       del 
         mode = 'del'
         DO ChemDel 
         EXIT
   ENDCASE
ENDDO
   
RELEASE WINDOW chemwind

IF mode <> 'add'
   USE chembase INDEX chembase EXCLUSIVE  
   IF mode <> 'del'
      SHOW WINDOW surround
   ENDIF
   SET CONFIRM ON
ELSE 
   @0,0 SAY PADC("",80,' ') COLOR W+/B
   IF mprogram = 'CHEMMEN'      
      SHOW MENU ALL
   ELSE
      SHOW WINDOW ALL
   ENDIF   
*   RELEASE WINDOW srrnd
ENDIF
IF mode = 'del'
   DEACTIVATE WINDOW surround
   DEACTIVATE POPUP chempop
ENDIF
RELEASE mode,Chemname,Boil,Spcheat1,Spcheat2,Spcheat3,Spcheat4,Molewt,CritTemp
RELEASE Latentheat,Ldensity,chemrow,chemparam
SET CURSOR ON
RETURN

********************************** Chem Edit ******************************
PROCEDURE chemedit

DO ChemEL
SET CURSOR ON
DO WHILE LASTKEY() <> 27
   IF mode = 'add'
      @ 0,15 GET Chemname PICTURE '@!S56' VALID ChkChem(Chemname) COLOR &IPColor
   ENDIF
   @ 1,48 GET Boil PICTURE '@!' VALID chk(Boil,-1) COLOR &IPColor
   @ 3,48 GET Spcheat1 PICTURE '@!' VALID chk(Spcheat1,-1) COLOR &IPColor
   @ 4,48 GET Spcheat2 PICTURE '@!' VALID chk(Spcheat2,-1) COLOR &IPColor
   @ 6,48 GET Spcheat3 PICTURE '@!' VALID chk(Spcheat3,-1) COLOR &IPColor
   @ 7,48 GET Spcheat4 PICTURE '@!' VALID chk(Spcheat4,-1) COLOR &IPColor
   @ 8,48 GET Molewt PICTURE '@!' VALID chk(Molewt,-1) COLOR &IPColor
   @ 9,48 GET Latentheat PICTURE '@!' VALID chk(Latentheat,-1) COLOR &IPColor
   @ 10,48 GET Ldensity PICTURE '@!' VALID chk(Ldensity,-1) COLOR &IPColor
   @ 11,48 GET CritTemp PICTURE '@!' VALID chk(CritTemp,8) COLOR &IPColor
   READ
ENDDO
IF LEN(ALLTRIM(Chemname)) <> 0
   DO chemsave
ENDIF
SET CURSOR OFF
RETURN

********************************* Chem Init *******************************
PROCEDURE ChemInit

IF LEN(mprompt) > 0
   USE chembase INDEX chembase EXCLUSIVE
   SEEK mprompt
   SCATTER MEMVAR
ELSE 
   USE chembase INDEX chembase EXCLUSIVE
   SCATTER MEMVAR BLANK
ENDIF
USE
@ 12,1 SAY PADC('',69,'') COLOR  W+/B &&  &ELColor

@ 0, 0 SAY ' Chemical Name '+Chemname
@ 1, 0 SAY ' Normal Boiling Point Temperature ............  '+Boil + ' K'
@ 2, 0 SAY ' Specific Heat of Liquid '
@ 3, 0 SAY '   at Constant Pressure ......................  '+Spcheat1 +' J/kg K'
@ 4, 0 SAY '   at Constant Volume ........................  '+Spcheat2 +' J/kg K'
@ 5, 0 SAY ' Specific Heat of Vapor'
@ 6, 0 SAY '   at Constant Pressure ......................  '+Spcheat3 +' J/kg K'
@ 7, 0 SAY '   at Constant Volume ........................  '+Spcheat4 +' J/kg K'
@ 8, 0 SAY ' Molecular Weight ............................  '+ Molewt +' kg/kmol'
@ 9, 0 SAY ' Latent Heat of Vaporization .................  '+ Latentheat +' J/kg'
@ 10,0 SAY ' Liquid Density ..............................  '+ Ldensity + ' kg/cubic m'
@ 11,0 SAY ' Critical Temperature ........................  '+ CritTemp + ' K'

@ 0,15 FILL TO 0,70 COLOR &IPColor
@ 1,48 FILL TO 1,55 COLOR &IPColor
@ 3,48 FILL TO 3,55 COLOR &IPColor
@ 4,48 FILL TO 4,55 COLOR &IPColor
@ 6,48 FILL TO 6,55 COLOR &IPColor
@ 7,48 FILL TO 7,55 COLOR &IPColor
@ 8,48 FILL TO 8,55 COLOR &IPColor
@ 9,48  FILL TO 9,55 COLOR &IPColor
@ 10,48 FILL TO 10,55 COLOR &IPColor
@ 11,48 FILL TO 11,55 COLOR &IPColor

IF mprogram = 'HELPSYS'
   DO CASE 
      CASE mvarread = 'TB'
         chemparam = Boil
         chemrow = 1 
      CASE mvarread = 'CPL'
         chemparam =  Spcheat1
         chemrow = 3
      CASE mvarread = 'CP'
         chemparam =  Spcheat3
         chemrow = 6
      CASE mvarread = 'MW'.OR. mvarread = 'MS' .OR. mvarread = 'MWC'
         chemparam = Molewt
         chemrow = 8
      CASE mvarread = 'LVAP' 
         chemparam = Latentheat
         chemrow = 9
      CASE mvarread = 'PL'
         chemparam = Ldensity
         chemrow = 10
      CASE mvarread = 'TC'
         chemparam = CritTemp
         chemrow = 11         
   ENDCASE
   @ chemrow ,47 SAY ''
   mode = 'viewpt'
ELSE
   IF LEN(mprompt) > 0
      mode = 'view'
   ELSE 
      mode = 'add'
   ENDIF
ENDIF

DO ChemEL

RETURN

***************************** ChemEL ******************************************
PROCEDURE ChemEL

DO CASE 
   CASE mode = 'viewpt'
      @ 13,1 SAY PADC('<Ins>Edit  <Del>Delete  <Enter>Exit/Select Data  <Esc>Exit/No Select',69) COLOR &ELColor
   CASE mode = 'edit'
      @ 13,1 SAY PADC('<> Up       <> Down       <Esc> Exit Edit Screen',69) COLOR &ELColor   
   CASE mode = 'view'
      @ 13,1 SAY PADC('<Ins> Edit      <Del> Delete      <Esc> Exit View Screen',69) COLOR &ELColor      
   CASE mode = 'add'
      @ 13,1 SAY PADC('<> Up       <> Down       <Esc> Exit Add Screen',69) COLOR &ELColor         
ENDCASE

RETURN


******************************* Chem Save *************************************
PROCEDURE ChemSave

procd = 'N'
DEFINE WINDOW question FROM 10,15 TO 14,63 SHADOW COLOR &MesColor
ACTIVATE WINDOW question  
@ 1,44 FILL TO 1,44 COLOR &IPColor
@ 1,0 SAY PADC('Do you want to save this data (Y/N) -> ',48)
@ 1,43 GET procd PICTURE '@!' VALID ChkYN(procd)
READ
RELEASE WINDOW question       
USE chembase INDEX chembase EXCLUSIVE 
IF procd ='Y'      
   SEEK M->Chemname
   IF .NOT. FOUND()
      GO BOTTOM
      APPEND BLANK
   ENDIF
   GATHER MEMVAR
ENDIF
*IF procd ='Y'      
*   DO CASE              
*      CASE mode = 'edit'
*         SEEK M->Chemname                  
*      CASE mode = 'add'
*         GO BOTTOM
*         APPEND BLANK
*   ENDCASE
*   GATHER MEMVAR
*ENDIF    
USE
RETURN

***************************** Check Chemical ***************************
FUNCTION ChkChem
PARAMETER st

USE chembase INDEX chembase EXCLUSIVE
IF LASTKEY() = 27
   RETURN 1
ENDIF
SEEK st
DO CASE
   CASE FOUND()
      USE
      WAIT 'Chemical '+ ALLTRIM(st) + ' has already been entered, '+press WINDOW
      RETURN 0
   CASE LEN(ALLTRIM(st)) = 0
      USE
      WAIT 'Enter a chemical name, '+press WINDOW
      RETURN 0
   OTHERWISE      
      USE
      RETURN 1
ENDCASE

******************************* Chem Del *********************************
PROCEDURE ChemDel

SET CURSOR ON
USE chembase INDEX chembase EXCLUSIVE
procd = 'N'
DEFINE WINDOW question FROM 10,15 TO 14,63 SHADOW COLOR &MesColor
ACTIVATE WINDOW question  
@ 1,44 FILL TO 1,44 COLOR &IPColor
@ 1,0 SAY PADC('Do you want to delete this data (Y/N) -> ',48)
@ 1,44 GET procd PICTURE '@!' VALID ChkYN(procd)
READ
RELEASE WINDOW question       
USE chembase INDEX chembase EXCLUSIVE 
IF procd ='Y'      
   SEEK mprompt
   DELETE
   PACK
ENDIF

SET CURSOR OFF
RETURN
