*===============================================*
*                 DGEUDFS.PRG                   *
*                 ===========                   *
*                                               *
*               UDF'S FOR FOXBASE               *
*                 dGE Version 4                 *
*                                               *
* SYNTAX:       LOAD DGE (DGE.BIN)              *
*               SET PROCEDURE TO DGEUDFS        *
*               (put dGE functions here)        *
*               CLOSE PROCEDURE                 *
*                                               *
*       (C) Bits Per Second Ltd                 *
*===============================================*

PROCEDURE SETHIRES
PARAMETER Q__SCREEN
Q__ = 'N0 '+STR(Q__SCREEN,3)
SET CONSOLE OFF
CALL DGE WITH Q__
RETURN (0)

PROCEDURE SETTEXT
PRIVATE Q__
Q__ = 'N1'
CALL DGE WITH Q__
SET CONSOLE ON
RETURN (0)

PROCEDURE DISKFILE
PARAMETER Q__MODE, Q__FNAME
PRIVATE Q__
Q__ = 'N2 '+STR(Q__MODE,3)+' '+CHR(255)+' '+Q__FNAME+' '
CALL DGE WITH Q__
RETURN(0)

PROCEDURE PRINTSCRN
PRIVATE Q__
Q__ = 'N3 '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE LOADCSET
PARAMETER Q__CSET,Q__FNAME
PRIVATE Q__
Q__ = 'N4 '+STR(Q__CSET,3)+' '+CHR(255)+' '+Q__FNAME+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE GETSIN
PARAMETER Q__ANG,Q__MODE
PRIVATE Q__
Q__ = 'R5 '+STR(Q__ANG,7,1)+' '+STR(Q__MODE,3)
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE DRAWLINE
PARAMETER Q__X0,Q__Y0,Q__X1,Q__Y1,Q__MODE,Q__STYLE,Q__COL
PRIVATE Q__
Q__ = 'N6 '+STR(Q__X0,7,1)+' '+STR(Q__Y0,7,1)+' '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__MODE,3)+' '+STR(Q__STYLE,3)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE DRAWCIRC
PARAMETER Q__X1,Q__Y1,Q__RA,Q__ANG1,Q__ANG2,Q__MODE,Q__STYLE ,Q__COL
PRIVATE Q__
Q__ = 'N7 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__RA,7,1)+' '+STR(Q__ANG1,7,1)+' '+STR(Q__ANG2,7,1)+' '+STR(Q__MODE,3)+' '+STR(Q__STYLE,3)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE SHADE
PARAMETER Q__X1,Q__Y1,Q__PATT,Q__COL
PRIVATE Q__
Q__ = 'N8 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__PATT,7,1)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE BOXFILL
PARAMETER Q__X,Q__Y,Q__WID,Q__HT,Q__PATT,Q__COL
PRIVATE Q__
Q__ = 'N9 '+STR(Q__X,7,1)+' '+STR(Q__Y,7,1)+' '+STR(Q__WID,7,1)+' '+STR(Q__HT,7,1)+' '+STR(Q__PATT,7,1)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE CLRSCREEN
PRIVATE Q__
Q__ = 'N10 '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE CLRLINE
PARAMETER Q__X1,Q__Y1,Q__NC
PRIVATE Q__
Q__ = 'N11 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__NC,3)
CALL DGE WITH Q__
RETURN (0)

* Old V1 function .. can be removed for V2 mode
PROCEDURE CLRWINDOW
PARAMETER Q__X1,Q__Y1,Q__WID,Q__HT
PRIVATE Q__
Q__ = 'N12 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__WID,7,1)+' '+STR(Q__HT,7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE XYAXES
PARAMETER Q__X1,Q__Y1,Q__WID,Q__HT,Q__XDIV,Q__YDIV,Q__MODE,Q__COL
PRIVATE Q__
Q__ = 'N13 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__WID,7,1)+' '+STR(Q__HT,7,1)+' '+STR(Q__XDIV,7,1)+' '+STR(Q__YDIV,7,1)+' '+STR(Q__MODE,3)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE POLARAXES
PARAMETER Q__X1,Q__Y1,Q__RA,Q__ND,Q__COL
PRIVATE Q__
Q__ = 'N14 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__RA,7,1)+' '+STR(Q__ND,7,1)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE GETCHAR
PARAMETER Q__MODE
PRIVATE Q__
Q__ = 'R15 '+STR(Q__MODE,3)
CALL DGE WITH Q__
RETURN (TRIM(Q__))

PROCEDURE GETSTRING
PARAMETER Q__X1,Q__Y1,Q__CSET,Q__NC,Q__COL
PRIVATE Q__,Q__PAD
Q__PAD = Q__NC-25
IF Q__PAD < 1
  Q__PAD = 1
ENDIF
Q__ = 'R16 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__CSET,3)+' '+STR(Q__NC,7,1)+' '+STR(Q__COL,3)+SPACE(Q__PAD)
CALL DGE WITH Q__
RETURN (TRIM(Q__))

PROCEDURE  SAYSTRING
PARAMETER Q__X,Q__Y,Q__CSET,Q__MODE,Q__COL,Q__STRG
PRIVATE Q__
Q__ = 'N17 '+STR(Q__X,7,1)+' '+STR(Q__Y,7,1)+' '+STR(Q__CSET,3)+' '+STR(Q__MODE,3)+' '+STR(Q__COL,3)+' '+CHR(255)+' '+Q__STRG+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE SAYICON
PARAMETER Q__X1,Q__Y1,Q__MODE,Q__ICON,Q__COL
PRIVATE Q__
IF Q__MODE = 0
Q__ = 'N18 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' 0 0 '+STR(Q__COL,3)+' '+CHR(255)+' '+Q__ICON+' '
ELSE
Q__ = 'N18 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' 1 '+STR(Q__ICON,3)+' '+STR(Q__COL,3)
ENDIF
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  DATARESET
PRIVATE Q__
Q__ = 'N19 '
CALL DGE WITH Q__
RETURN (0)

* NOTE: in relative polyline plotting "rounding" will improve precision
PROCEDURE DATASTORE
PARAMETER Q__P1,Q__P2,Q__P3,Q__P4
PRIVATE Q__
** Q__ = 'N20 '+STR(Q__P1,7,1)+' '+STR(Q__P2,7,1)+' '+STR(Q__P3,7,1)+' '+STR(Q__P4,7,1)
Q__ = 'N20 '+STR(ROUND(Q__P1,0),7,1)+' '+STR(ROUND(Q__P2,0),7,1)+' '+STR(ROUND(Q__P3,0),7,1)+' '+STR(ROUND(Q__P4,0),7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE PIECHART
PARAMETER Q__X1,Q__Y1,Q__RA
PRIVATE Q__
Q__ = 'N21 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__RA,7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  BARGRAPH
PARAMETER Q__X1,Q__Y1,Q__XINC,Q__MODE,Q__SZ
PRIVATE Q__
Q__ = 'N22 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__XINC,7,1)+' '+STR(Q__MODE,3)+' '+STR(Q__SZ,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  XYGRAPH
PARAMETER Q__X1,Q__Y1,Q__XINC,Q__MODE,Q__COL
PRIVATE Q__
Q__ = 'N23 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__XINC,7,1)+' '+STR(Q__MODE,3)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  POLARGR
PARAMETER Q__X1,Q__Y1,CYCLES,Q__MODE,Q__COL
PRIVATE Q__
Q__ = 'N24 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(CYCLES,7,1)+' '+STR(Q__MODE,3)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  STATS
PARAMETER Q__WID,Q__MODE,Q__STYLE,Q__COL
PRIVATE Q__
Q__ = 'N25 '+STR(Q__WID,7,1)+' '+STR(Q__MODE,3)+' '+STR(Q__STYLE,3)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  BESTFIT
PARAMETER Q__WID,Q__HT,Q__STYLE,Q__COL
PRIVATE Q__
Q__ = 'N26 '+STR(Q__WID,7,1)+' '+STR(Q__HT,7,1)+' '+STR(Q__STYLE,3)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  POLYLINE
PARAMETER Q__X1,Q__Y1,Q__MODE,Q__STYLE,Q__COL
PRIVATE Q__
Q__ = 'N27 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__MODE,3)+' '+STR(Q__STYLE,3)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE SETPAL
PARAMETER Q__BG,Q__INTENS,Q__FG
PRIVATE Q__
Q__ = 'N29 '+STR(Q__BG,3)+' '+STR(Q__INTENS,3)+' '+STR(Q__FG,3)
CALL DGE WITH Q__
RETURN(0)

PROCEDURE SETVER
PARAMETER Q__VER
PRIVATE Q__
Q__ = 'N30 '+STR(Q__VER,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  HLCGRAPH
PARAMETER Q__X1,Q__Y1,Q__XINC,Q__COL
PRIVATE Q__
Q__ = 'N31 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__XINC,7,1)+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE SETWIN
PARAMETER Q__X0,Q__Y0,Q__X1,Q__Y1
PRIVATE Q__
Q__ = 'N32 '+STR(Q__X0,7,1)+' '+STR(Q__Y0,7,1)+' '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE SETDELIM
PARAMETER Q__DELIM
PRIVATE Q__
Q__ = 'N33 '+STR(Q__DELIM,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE FIXPOS
PARAMETER Q__X1,Q__Y1
PRIVATE Q__
Q__ = 'N34 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE MOVEVEC
PARAMETER Q__LEN,Q__ANG
PRIVATE Q__
Q__ = 'N35 '+STR(ROUND(Q__LEN,0),7,1)+' '+STR(ROUND(Q__ANG,0),7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE DRAWVEC
PARAMETER Q__LEN,Q__ANG,Q__UPD,Q__MODE,Q__STYLE,Q__COL
PRIVATE Q__
Q__ = 'N36 '+STR(ROUND(Q__LEN,0),7,1)+' '+STR(ROUND(Q__ANG,0),7,1)+' '+STR(Q__UPD,3)+' '+STR(Q__MODE,3)+' '+STR(Q__STYLE,3)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  POLYVEC
PARAMETER Q__X1,Q__Y1,Q__TYPE,Q__ANG, Q__MODE,Q__STYLE,Q__COL
PRIVATE Q__
Q__ = 'N37 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__TYPE,3)+' '+STR(Q__ANG,7,1)+' '+STR(Q__MODE,3)+' '+STR(Q__STYLE,3)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  VECSTRING
PARAMETER Q__LEN,Q__ANG,Q__CSET,Q__MODE,Q__COL,STRG
PRIVATE Q__
Q__ = 'N38 '+STR(Q__LEN,7,1)+' '+STR(Q__ANG,7,1)+' '+STR(Q__CSET,3)+' '+STR(Q__MODE,3)+' '+STR(Q__COL,3)+' '+CHR(255)+' '+STRG+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE VECICON
PARAMETER Q__LEN,Q__ANG,Q__MODE,Q__ICON,Q__COL
PRIVATE Q__
IF Q__MODE = 0
Q__ = 'N39 '+STR(Q__LEN,7,1)+' '+STR(Q__ANG,7,1)+' 0 0 '+STR(Q__COL,3)+' '+CHR(255)+' '+Q__ICON+' '
ELSE
Q__ = 'N39 '+STR(Q__LEN,7,1)+' '+STR(Q__ANG,7,1)+' 1 '+STR(Q__ICON,3)+' '+STR(Q__COL,3)
ENDIF
CALL DGE WITH Q__
RETURN (0)

PROCEDURE DATAPC
PARAMETER Q__PC
PRIVATE Q__
Q__ = 'N40 '+STR(Q__PC,7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE DATARANGE
PARAMETER Q__NIN, Q__NOUT
PRIVATE Q__
Q__ = 'N41 '+STR(Q__NIN,7,1)+' '+STR(Q__NOUT,7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE EDSTRING
PARAMETER Q__X1,Q__Y1,Q__CSET,Q__COL,Q__STRG
PRIVATE Q__
Q__ = 'R42 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__CSET,3)+' '+STR(Q__COL,3)+' '+CHR(255)+' '+Q__STRG+' '
CALL DGE WITH Q__
RETURN (TRIM(Q__))

PROCEDURE  CLRSTRING
PRIVATE Q__
Q__ = 'N43 '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE PLOTON
PARAMETER Q__X0,Q__Y0,Q__WID,Q__MODE,Q__UNITS
PRIVATE Q__
Q__ = 'N44 '+STR(Q__X0,7,1)+' '+STR(Q__Y0,7,1)+' '+STR(Q__WID,7,1)+' '+STR(Q__MODE,7,1)+' '+STR(Q__UNITS,7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE PLOTCSET
PARAMETER Q__CSET,Q__SIZE,Q__STYLE,Q__LANG
PRIVATE Q__
Q__ = 'N45 '+STR(Q__CSET,3)+' '+STR(Q__SIZE,7,1)+' '+STR(Q__STYLE,3)+' '+STR(Q__LANG,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  PLOTOFF
PRIVATE Q__
Q__ = 'N46 '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE PRINTFILE
PARAMETER Q__MODE, Q__FNAME
PRIVATE Q__
Q__ = 'N47 '+STR(Q__MODE,3)+' '+CHR(255)+' '+Q__FNAME+' '
CALL DGE WITH Q__
RETURN(0)

PROCEDURE PRINTPCL
PARAMETER Q__MODE,Q__HOFF,Q__VOFF,Q__DENSITY
PRIVATE Q__
Q__ = 'N48 '+STR(Q__MODE,3)+' '+STR(Q__HOFF,7,1)+' '+STR(Q__VOFF,7,1)+' '+STR(Q__DENSITY,7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE TIMEGRAPH
PARAMETER Q__X,Q__Y,Q__XINT,Q__XPTS,Q__CH1,Q__CH2,Q__CH3,Q__CH4
PRIVATE Q__
Q__ = 'N49 '+STR(Q__X,7,1)+' '+STR(Q__Y,7,1)+' '+STR(Q__XINT,7,1)+' '+STR(Q__XPTS,7,1)+' '+STR(Q__CH1,4)+' '+STR(Q__CH2,4)+' '+STR(Q__CH3,4)+' '+STR(Q__CH4,4)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE TIMEDATA
PARAMETER P1,P2,P3,P4
PRIVATE Q__
Q__ = 'N50 '+STR(P1,7,1)+' '+STR(P2,7,1)+' '+STR(P3,7,1)+' '+STR(P4,7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE GETASIN
PARAMETER Q__VAL,Q__MODE
PRIVATE Q__
Q__ = 'R51 '+STR(Q__VAL,8,1)+' '+STR(Q__MODE,3)
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE MOVEXY
PARAMETER Q__X, Q__Y
PRIVATE Q__
Q__ = 'N52 '+STR(ROUND(Q__X,0),7,1)+' '+STR(ROUND(Q__Y,0),7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE DRAWXY
PARAMETER Q__X,Q__Y,Q__UPD,Q__MODE,Q__STYLE,Q__COL
PRIVATE Q__
Q__ = 'N53 '+STR(ROUND(Q__X,0),7,1)+' '+STR(ROUND(Q__Y,0),7,1)+' '+STR(Q__UPD,3)+' '+STR(Q__MODE,3)+' '+STR(Q__STYLE,3)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE PLOTPEN
PARAMETER Q__COL,Q__PEN,Q__THICK
PRIVATE Q__
Q__ = 'N54 '+STR(Q__COL,5,1)+' '+STR(Q__PEN,5,1)+' '+STR(Q__THICK,5,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  LABELX
PARAMETER Q__X,Q__Y,Q__INC,Q__LEN,Q__CSET,Q__MODE,Q__COL,Q__STRG
PRIVATE Q__
Q__ = 'N55 '+STR(Q__X,7,1)+' '+STR(Q__Y,7,1)+' '+STR(Q__INC,7,1)+' '+STR(Q__LEN,7,1)+' '+STR(Q__CSET,3)+' '+STR(Q__MODE,3)+' '+STR(Q__COL,3)+' '+CHR(255)+' '+Q__STRG+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  LABELY
PARAMETER Q__X,Q__Y,Q__INC,Q__LEN,Q__CSET,Q__MODE,Q__COL,Q__STRG
PRIVATE Q__
Q__ = 'N56 '+STR(Q__X,7,1)+' '+STR(Q__Y,7,1)+' '+STR(Q__INC,7,1)+' '+STR(Q__LEN,7,1)+' '+STR(Q__CSET,3)+' '+STR(Q__MODE,3)+' '+STR(Q__COL,3)+' '+CHR(255)+' '+Q__STRG+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  LABELPIE
PARAMETER Q__XLEN,Q__RAD,Q__LEN,Q__CSET,Q__MODE,Q__COL,Q__STRG
PRIVATE Q__
Q__ = 'N57 '+STR(Q__XLEN,7,1)+' '+STR(Q__RAD,7,1)+' '+STR(Q__LEN,7,1)+' '+STR(Q__CSET,3)+' '+STR(Q__MODE,3)+' '+STR(Q__COL,3)+' '+CHR(255)+' '+Q__STRG+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE GETCURX
PRIVATE Q__
Q__ = 'R58       '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE GETCURY
PRIVATE Q__
Q__ = 'R59       '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE GETCC
PRIVATE Q__
Q__ = 'R60       '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE GETMAX
PRIVATE Q__
Q__ = 'R61       '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE GETMEAN
PRIVATE Q__
Q__ = 'R62       '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE GETMIN
PRIVATE Q__
Q__ = 'R63       '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE GETSD
PRIVATE Q__
Q__ = 'R64       '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE  MINMAX
PARAMETER Q__WID,Q__STYLE,Q__COL
PRIVATE Q__
Q__ = 'N65 '+STR(Q__WID,7,1)+' '+STR(Q__STYLE,3)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE CLRWIN
PARAMETER Q__X0,Q__Y0,Q__X1,Q__Y1
PRIVATE Q__
Q__ = 'N66 '+STR(Q__X0,7,1)+' '+STR(Q__Y0,7,1)+' '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)
CALL DGE WITH Q__
RETURN (0)

** MPCONFIG .. Procedure 67 .. only for linked object file

PROCEDURE SETVIDEO
PARAMETER Q__MODE
PRIVATE Q__
Q__ = 'N68 '+STR(Q__MODE,5,1)+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE GETVIDEO
PARAMETER Q__MODE
PRIVATE Q__
Q__ = 'R69 '+STR(Q__MODE,5,1)+' '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE USERICON
PARAMETER Q__NUM, Q__ICON
PRIVATE Q__
Q__ = 'N70 '+STR(Q__NUM,3)+' '+CHR(255)+' '+Q__ICON+' '
CALL DGE WITH Q__
RETURN(0)

PROCEDURE DRAWICON
PARAMETER Q__X1,Q__Y1,Q__MODE,Q__ICON,Q__COL
PRIVATE Q__
Q__ = 'N71 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__MODE,3)+' '+STR(Q__ICON,3)+' '+STR(Q__COL,3)+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE MRESET
PRIVATE Q__
Q__ = 'R72      '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE MCURON
PRIVATE Q__
Q__ = 'N73'
CALL DGE WITH Q__
RETURN (0)

PROCEDURE MCUROFF
PRIVATE Q__
Q__ = 'N74'
CALL DGE WITH Q__
RETURN (0)

PROCEDURE MFIXPOS
PARAMETER Q__X1,Q__Y1
PRIVATE Q__
Q__ = 'N75 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE MSTATUS
PRIVATE Q__
Q__ = 'R76      '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE MGETX
PRIVATE Q__
Q__ = 'R77      '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE MGETY
PRIVATE Q__
Q__ = 'R78      '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE MSETWIN
PARAMETER Q__X0,Q__Y0,Q__X1,Q__Y1
PRIVATE Q__
Q__ = 'N79 '+STR(Q__X0,7,1)+' '+STR(Q__Y0,7,1)+' '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE MMOTION
PRIVATE Q__
Q__ = 'R80      '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE MCURTYPE
PARAMETER Q__TYPE
PRIVATE Q__
Q__ = 'N81 '+STR(Q__TYPE,5,1)+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  PICWRITE
PARAMETER Q__X0,Q__Y0,Q__X1,Q__Y1,Q__FORMAT,Q__FNAME
PRIVATE Q__
Q__ = 'N82 '+STR(Q__X0,7,1)+' '+STR(Q__Y0,7,1)+' '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__FORMAT,3)+' '+CHR(255)+' '+Q__FNAME+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  PICREAD
PARAMETER Q__X0,Q__Y0,Q__FORMAT,Q__FNAME
PRIVATE Q__
Q__ = 'N83 '+STR(Q__X0,7,1)+' '+STR(Q__Y0,7,1)+' '+STR(Q__FORMAT,3)+' '+CHR(255)+' '+Q__FNAME+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  GANTT
PARAMETER Q__X1,Q__Y1,Q__XINC,Q__MODE,Q__SZ
PRIVATE Q__
Q__ = 'N84 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__XINC,7,1)+' '+STR(Q__MODE,3)+' '+STR(Q__SZ,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE LOADVTEXT
PARAMETER Q__FNAME
PRIVATE Q__
Q__ = 'N85 '+CHR(255)+' '+Q__FNAME+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  DRAWVTEXT
PARAMETER Q__X,Q__Y,Q__ANG,Q__LEN,Q__HT,Q__CSET,Q__MODE,Q__COL,Q__STRG
PRIVATE Q__
Q__ = 'N86 '+STR(Q__X,7,1)+' '+STR(Q__Y,7,1)+' '+STR(Q__ANG,7,1)+' '+STR(Q__LEN,7,1)+' '+STR(Q__HT,7,1)+' '+STR(Q__CSET,3)+' '+STR(Q__MODE,3)+' '+STR(Q__COL,3)+' '+CHR(255)+' '+Q__STRG+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE LOADICON
PARAMETER Q__FNAME
PRIVATE Q__
Q__ = 'N87 '+CHR(255)+' '+Q__FNAME+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE SETPRN
PARAMETER Q__PORT,Q__BAUD,Q__PAR,Q__BITS,Q__STOP
PRIVATE Q__
Q__ = 'N88 '+STR(Q__PORT,3)+' '+STR(Q__BAUD,3)+' '+STR(Q__PAR,3)+' '+STR(Q__BITS,3)+' '+STR(Q__STOP,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE XORBLOCK
PARAMETER Q__X1,Q__Y1,Q__WID,Q__HT,Q__COL
PRIVATE Q__
Q__ = 'N89 '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__WID,7,1)+' '+STR(Q__HT,7,1)+' '+STR(Q__COL,3)
CALL DGE WITH Q__
RETURN (0)

**      This function name truncated!!
**
PROCEDURE GETFONT
PARAMETER Q__MODE
PRIVATE Q__
Q__ = 'R90 '+STR(Q__MODE,5,1)+' '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE LOADMPRN
PARAMETER Q__NO,Q__FNAME
PRIVATE Q__
Q__ = 'N91 '+STR(Q__NO,3)+' '+CHR(255)+' '+Q__FNAME+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE MSETHOT
PARAMETER Q__REG,Q__X1,Q__Y1,Q__WID,Q__HT
PRIVATE Q__
Q__ = 'N92 '+STR(Q__REG,3)+' '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__WID,7,1)+' '+STR(Q__HT,7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE MGETHOT
PRIVATE Q__
Q__ = 'R93      '
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE ENUMMPRN
PARAMETER Q__NO,Q__FNAME
PRIVATE Q__
Q__ = 'R94 '+STR(Q__NO,3)+'                   '+CHR(255)+' '+Q__FNAME+' '
CALL DGE WITH Q__
RETURN (TRIM(Q__))

PROCEDURE  PRINTPS
PARAMETER Q__MODE,Q__HOFF,Q__VOFF,Q__HSCALE, Q__VSCALE,Q__DENS
PRIVATE Q__
Q__ = 'N95 '+STR(Q__MODE,3)+' '+STR(Q__HOFF,6,1)+' '+STR(Q__VOFF,6,1)+' '+STR(Q__HSCALE,6,1)+' '+STR(Q__VSCALE,6,1)+' '+STR(Q__DENS,3)
CALL DGE WITH Q__
RETURN (0)

** V4.1
PROCEDURE VPON
PARAMETER Q__HOFF,Q__VOFF,Q__XLEN,Q__UNIT,Q__YPC,Q__ORIENT,Q__MODE
PRIVATE Q__
Q__ = 'N96 '+STR(Q__HOFF,7,1)+' '+STR(Q__VOFF,7,1)+' '+STR(Q__XLEN,7,1)+' '+STR(Q__UNIT,7,1)+' '+STR(Q__YPC,7,1)+' '+STR(Q__ORIENT,7,1)+' '+STR(Q__MODE,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE VPOFF
PARAMETER Q__MODE
PRIVATE Q__
Q__ = 'N97 '+STR(Q__MODE,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE PSFONT
PARAMETER Q__NAME
PRIVATE Q__
Q__ = 'N98 '+CHR(255)+' '+Q__NAME+' '
CALL DGE WITH Q__
RETURN (0)

PROCEDURE SETRGBPAL
PARAMETER Q__CLR,Q__RGB
PRIVATE Q__
Q__ = 'N99 '+STR(Q__CLR,3)+' '+STR(Q__RGB,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE SETRGBDAC
PARAMETER Q__REG,Q__RED,Q__GREEN,Q__BLUE
PRIVATE Q__
Q__ = 'N100 '+STR(Q__REG,3)+' '+STR(Q__RED,3)+' '+STR(Q__GREEN,3)+' '+STR(Q__BLUE,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE CLIPWIN
PARAMETER Q__X0,Q__Y0,Q__X1,Q__Y1
PRIVATE Q__
Q__ = 'N101 '+STR(Q__X0,7,1)+' '+STR(Q__Y0,7,1)+' '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE GETPIX
PARAMETER Q__X,Q__Y
PRIVATE Q__
Q__ = 'R102 '+STR(Q__X,7,1)+' '+STR(Q__Y,7,1)
CALL DGE WITH Q__
RETURN (VAL(TRIM(Q__)))

PROCEDURE GETBF
PARAMETER Q__MODE
PRIVATE Q__
Q__ = 'R103 '+STR(Q__MODE,3)
CALL DGE WITH Q__
RETURN (VAL(TRIM(Q__)))

PROCEDURE  SNAPCOPY
PARAMETER Q__X0,Q__Y0,Q__X1,Q__Y1,Q__MODE
PRIVATE Q__
Q__ = 'R104 '+STR(Q__X0,7,1)+' '+STR(Q__Y0,7,1)+' '+STR(Q__X1,7,1)+' '+STR(Q__Y1,7,1)+' '+STR(Q__MODE,3)
CALL DGE WITH Q__
RETURN (VAL(TRIM(Q__)))

PROCEDURE  SNAPPASTE
PARAMETER Q__X0,Q__Y0,Q__HANDLE
PRIVATE Q__
Q__ = 'N105 '+STR(Q__X0,7,1)+' '+STR(Q__Y0,7,1)+' '+STR(Q__HANDLE,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE  SNAPKILL
PARAMETER Q__HANDLE
PRIVATE Q__
Q__ = 'N106 '+STR(Q__HANDLE,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE GETSNAPINF
PARAMETER Q__MODE
PRIVATE Q__
Q__ = 'R107 '+STR(Q__MODE,3)
CALL DGE WITH Q__
RETURN (VAL(Q__))

PROCEDURE PRNDEV
PARAMETER Q__DEV, Q__CHAN
PRIVATE Q__
Q__ = 'N108 '+STR(Q__DEV,3)+' '+STR(Q__CHAN,3)
CALL DGE WITH Q__
RETURN (0)

PROCEDURE PCLFONT
PARAMETER Q__A,Q__B,Q__C,Q__D,Q__E
PRIVATE Q__
Q__ = 'N109 '+STR(Q__A,3)+' '+STR(Q__B,3)+' '+STR(Q__C,3)+' '+STR(Q__D,3)+' '+STR(Q__E,3)
CALL DGE WITH Q__
RETURN (0)

