/*
         system: tscreen
   program name: graph.c
original author: kevin stroupe, pes
  original data: 7/23/1990
        purpose: to draw the graph of concentration vs distance
  update author:
 update purpose:
        comment:
    called from: graf.prg
         calles:
*/

#include    "c:\c51\include\stdio.h"
#include    "c:\c51\include\io.h"
#include    "c:\c51\include\string.h"
#include    "c:\c51\include\stdlib.h"
#include    "c:\c51\include\math.h"
#include    "c:\c51\include\dos.h"
#include    "c:\ingraf\igextern.h"

#define  MIN( x, y )	( ((x) < (y)) ? (x) : (y) )
#define  MAX( x, y )	( ((x) < (y)) ? (y) : (x) )

main()

/*>>>>>>>>>>>>>>>>>>>>>>>>>> DECLARATIONS <<<<<<<<<<<<<<<<<<<<<<<<<<< */
{
    static char *grafdev[] = { "cga3",
                               "ega4",
                               "vga1","vga2",
                               "hgc1",
                               "eps1", "eps2",
                               "epslq1","epslq2",
                               "necpw1","necpw2",
                               "oki1", "oki2",
                               "hplj1","hplj3",
                               "hpgl1",
                               "dmpl1"
                           };

    static short ngdev = sizeof(grafdev)/sizeof(char **);

    static char *dosdev[] = { "con:",
                              "lpt1:",
                              "com1:"
                            };
    static short nddev = sizeof(dosdev)/sizeof(char **);

    static float t = 97.6;

    char maxconc[77];

    float   xlo, xhi, ylo, yhi;
    float   x1, x2, y1, y2, z1, z2, yinterval,xinterval, xval, yval;
    float   concconvert[77];

    float   ymaxconvert, yconvertfactor;

    long    l1;

    short   i, j, k, num, j1, ycounter, ydivided;
    short   counter;
    int     grafindex,dosindex;
    FILE    *stream;
    char    fline[100],*result;
    char    title[40];
    static float fenceline, maxconcnum, maxconcdist;
    int     NumOfPts, RestOfF;
    static float conc[200], dist[200];
    static float distance;
    float   ht[10],mindist[10],maxdist[10],Hs;
    int     num_hts;
    int     mdl;
    int     plt_num_hts;
    float   htinterval;

/*>>>>>>>>>>>>>>>>>>>>>>>>>> MAIN PROGRAM <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

    /*++++++++++++++++++ Read Data from files ++++++++++++++++++*/
    num_hts = 0;
    if ((stream = fopen("htdist.fil","r")) != NULL){
        result = fgets(fline,100,stream);
        num_hts= atoi(fline);
        result = fgets(fline,100,stream);
        Hs = atof(fline);
        for(i=0;i<=num_hts-1;i++){
           result = fgets(fline,100,stream);
           ht[i] = atof(fline);
           result = fgets(fline,100,stream);
           mindist[i] = atof(fline)/1000;
           result = fgets(fline,100,stream);
           maxdist[i] = atof(fline)/1000;
        }
        fclose(stream);
    }

    if ((stream = fopen("devices","r")) != NULL){
        result = fgets(fline,100,stream);
        grafindex = atoi(fline);
        result = fgets(fline,100,stream);
        dosindex = atoi(fline);
        result = fgets(fline,100,stream);
        distance = atof(fline);
        result = fgets(fline,100,stream);
        mdl = atoi(fline);
    }
    else{
       printf("Unable to read file");
       fclose(stream);
       exit(1);
    }

    if ((stream = fopen("graph.fil", "r")) != NULL){
        result = fgets(fline,100,stream);
        strcpy(title,fline);
        result = fgets(fline,100,stream);
        NumOfPts = atoi(fline);
        result = fgets(fline,100,stream);
        fenceline = atof(fline)/1000;
        result = fgets(fline,100,stream);
        maxconcnum = atof(fline);
        result = fgets(fline,100,stream);
        maxconcdist = atof(fline)/1000;

        i = 0;
        result = fgets(fline,100,stream);
        conc[i] = atof(fline);
        result = fgets(fline,100,stream);
        dist[i] = atof(fline)/1000;
        while(dist[i] < distance && i < NumOfPts){
            i++;
            result = fgets(fline,100,stream);
            conc[i] = atof(fline);
            result = fgets(fline,100,stream);
            dist[i] = atof(fline)/1000;
        }
        RestOfF = NumOfPts - i;
        NumOfPts = i + 1;

        for (i = 0; i < RestOfF; i++){
            result = fgets(fline,100,stream);
            result = fgets(fline,100,stream);
        }
        fclose(stream);
    }
    else{
        printf("Unable to read file");
        exit(1);
    }

    vmode(2);


    /*+++++++++++++++++++++++++ Open output device ++++++++++++++++++*/

    if (dosindex > 0)
       printf("Generating graph on output device using:");

    k = gopen(grafdev[grafindex], dosdev[dosindex]); /* initialize plot parameters */

    if (dosindex > 0)
       printf("Please stand by. . .");

    if ( k > 0 ){
       /*+++++++++++++++ Set Screen Limits +++++++++++++++++++*/
       xlo = .8;
       if(num_hts==0)
          xhi = 9.9;
       else
          xhi = 9.2;

       x1 = xhi - xlo;
       ylo = 1.5;
       yhi = 7.2;
       y1 = yhi - ylo;

       i = plimit( xlo, ylo, x1, y1, 2 );

       if ((dosindex == 0) && (grafindex != 0) && (grafindex != 2) && (grafindex != 4))
          i = fillpa(1);

       /* ++++++++++++++++++get y interval+++++++++++++++ */
       y1 = y2 = conc[0];
       for ( i = 0; i < NumOfPts; i++ ){
           y1 = MIN( y1, conc[i] );
           y2 = MAX( y2, conc[i] );
       }

       ycounter = 0;
       ymaxconvert = y2;
       ydivided = 1;
       if (ymaxconvert > 100){
          while (ymaxconvert > 100){
              ymaxconvert /= 10;
              ycounter += 1;
              ydivided = -1;
           }
       }
       else if (ymaxconvert < 10 && ymaxconvert > 0) {
          while (ymaxconvert < 10){
             ymaxconvert *= 10;
             ycounter +=1;
             ydivided = 0;
          }
       }

       /* convert data */

       /* Get Number of Pts*/

       /* ++++++++++++++get x interval+++++++++++++++++ */
       x1 = x2 = dist[0];

       for ( i = 0; i < NumOfPts; i++ ){
          x1 = MIN( x1, dist[i] );
          x2 = MAX( x2, dist[i] );
       }

       x1 = 0;
       x2 = distance;
       xinterval = distance/10;

       /* +++++++++++++++++++++++++get y interval++++++++++++++++ */
       y1 = y2 = conc[0];
       for ( i = 0; i < NumOfPts; i++ ){
          y1 = MIN( y1, conc[i] );
          y2 = MAX( y2, conc[i] );
       }

       ycounter = 0;
       ymaxconvert = y2;
       ydivided = 1;
       if (ymaxconvert > 100){
         while (ymaxconvert > 100){
             ymaxconvert /= 10;
             ycounter += 1;
             ydivided = -1;
          }
       }
       else if (ymaxconvert < 10 && ymaxconvert > 0) {
           while (ymaxconvert < 10){
               ymaxconvert *= 10;
               ycounter +=1;
               ydivided = 0;
            }
       }

       z1 = z2 = 1.0 ;
       k = 1;

       do{
          yinterval = z2;
          if ( k == 9 ){
             k = 1;
             z1 *= 10.0;
          }
          z2 = k * z1;
          k++;
       }while( z2 < 0 );

       y1 = (l1 = (0/z1 + 0.001)*10.0 )*z1/10.0;
       yinterval = ymaxconvert - 0;
       z1 = 1.0;
       k = 1;

       do{
          if ( k == 9 ){
             k = 1;
             z1 *= 10.0;
          }
          z2 = 10 * k * z1;
          k++;
       }while( z2 < yinterval );

       yinterval = z1*(k-1);
       y2 = 0 + 10*yinterval;


       /* +++++++++++++++++++++++++++++convert data ++++++++++++++++++++*/
       yconvertfactor = 1;
       for (i = 0; i < ycounter; i++)
           yconvertfactor *= 10;

       if (ydivided == -1){
          for (i = 0; i < NumOfPts ; i++)
              concconvert[i] = conc[i] / yconvertfactor;
       }
       else if (ydivided == 0){
          for (i = 0; i < NumOfPts ; i++)
              concconvert[i] = conc[i] * yconvertfactor;
       }
       else{
          for (i = 0; i < NumOfPts ; i++)
             concconvert[i] = conc[i];
       }

       /* +++++++++++++++++++++scale the plotting area +++++++++++++++++*/
       i = scale( x1, x2, y1, y2);
       i = newpen(15);
       i = vgltype(3);
       i = pframe();

       j1 = getfont("vfont101.fnt");

       if (grafindex == 0)
          i = setfont(1);
       else
          i = setfont(j1);

       /* +++++++++++++++++++++label x-axis +++++++++++++++++*/

       i = lbldir( 0.0 );
       i = lblorg(6);
       z1 = x1;

       i = newpen( 15 );
       i = lblorg(9);

       i = csize(.08,.18);
       z1 = 0;
       j = 0;
       while(j<10){
           i = move( z1, 0 );
           i = grmove(-0.05, -0.05, 2);
           i = nlabel( z1, 2 );
           z1 += xinterval;
           j++;
       }
       i = move( z1, 0 );
       i = grmove(-0.05, -0.05, 2);
       i = nlabel( distance, 2 );

       i = xtsize(.1, 0, .1, 0 );
       i = xaxis( 0, x2, 0, xinterval, 0 );

       /* ++++++++++++++++++++++++label y-axis++++++++++++++++ */
       i = lblorg(7);
       for ( z1 = 0; z1 <= y2; z1 += yinterval ){
           i = move( x1, z1 );
           i = grmove(-0.05, 0.0, 2);
           i = nlabel( z1, -1 );
       }
       i = ytsize(.1, 0, .1, 0 );
       i = yaxis( 0, y2, x1, yinterval, 0 );

       i=setfont(j1);

       i = csize(0.15, 0.15);
       i = gmove( .2, (yval = (ylo + yhi)/2.0), 2);
       i = lbldir( 90.0 );
       i = lblorg(6);

       if (ydivided == 1){
          i = label("CONCENTRATION(ug/m )");
          i = grmove(-0.2,3.8,2);
          i = label("3");
       }
       else{
          i = label("CONCENTRATION X10  (ug/m )");
          i = grmove(-0.2,3.6,2);
          if (ydivided == 0)
             i = nlabel(-ycounter,-1);
          else
             i = nlabel(ycounter,-1);

          if ((ycounter > 10 && ydivided == -1) || (ycounter <= 10 && ydivided ==0))
             i = grmove(0,1.6, 2);
          else if (ycounter <= 10)
             i = grmove(0,1.5, 2);
          else
             i = grmove(0,1.7, 2);
          i = label("3");
       }

       if (grafindex == 0)
          i=setfont(1);

       i = lbldir( 0.0 );
       i = gmove((xval = (xlo + xhi)/2.0), .93, 2);
       if((num_hts!=0) && (dosindex == 0 ))
          i = gmove(xval, 1.15, 2);


       i = lblorg(6);

       i = label("DISTANCE(Km)");

       i=setfont(j1);

       i = lblorg(4);
       i = newpen(14);
       i = gmove(xval, (yval = yhi+0.1), 2);
       i = csize(0.15, 0.15);

       i = label(title);
       i = setsu();

       if (grafindex == 0)
          i=setfont(1);

       /* +++++++++++++++++++++draw the fenceline+++++++++++++++ */

       i = ltype(3);
       i = yline(0,y2,fenceline);
       i = csize(0.08, 0.2);
       i = newpen(14);

       if (fenceline <= (x2/2)){
          i = move(fenceline,y2-1);
          i = grmove(0.1, -0.05, 2);
          i = lblorg(2);
       }
       else{
          i = move(fenceline,y2-1);
          i = grmove(-0.1, -0.05, 2);
          i = lblorg(8);
       }
       i = csize(.08,.18);
        i = label("fenceline");

       /* +++++++++++++++++++++++++++write max concentration++++++++++++++++++ */
       i = move(0,0);
       if((num_hts!=0)&&(dosindex == 0 ))
          i = gmove((xval = (xlo + xhi)/2.0), .85, 2);
       else
          i = gmove((xval = (xlo + xhi)/2.0), .6, 2);
       i = lblorg(6);
       i = csize(.08,.18);
       
       if (mdl !=2)
          sprintf(maxconc, "Maximum concentration %.3E micrograms/cubic meter at %.3f Km", maxconcnum, maxconcdist);
       else
          sprintf(maxconc, "Maximum concentration %.3E ug/cubic m at %.3f Km (Automated Distances)", maxconcnum, maxconcdist);
       i = label(maxconc);

       /* +++++++++++++++++++++++++plot concentration data+++++++++++++++++ */
       i = ltype(0);
       i = newpen( 15 );
       i = setmark(2);

       i = apoly(dist,concconvert,NumOfPts);

      if(num_hts > 0){
         /* +++++++++++++++++ Redefine scale for terrain ++++++++ */
         j=0;
         while((mindist[j]< dist[NumOfPts-1])&& (j<num_hts) ){
            j++;
         }
         plt_num_hts = j++;

         htinterval = Hs/10;
         i = scale(x1,x2,y1,Hs);
         i = ytsize(0,.1,0,.1 );
         i = yaxis( 0,Hs, x2, htinterval, 0 );

/*         for(i = 0;i <plt_num_hts;i++){
            printf("mindist[%d]= %f  maxdist[%d]=%f \n  ",i,mindist[i],i,maxdist[i]);
            printf("ht[%d]= %f  ht[%d+1]=%f \n  ",i,ht[i],i,ht[i+1]);
         }
*/

         i = lblorg(1);
         z1=0;
         counter = 0;
         while(counter < 11)  {
           i = move(x2 ,z1 );
           i = grmove(0.05, 0.0, 2);
           i = nlabel( z1, 1 );
           counter++;
           z1 += htinterval;
         }
         j=0;
         i = newpen(10);
         i = ltype(5);



         while(j<plt_num_hts-1){
            i=xline(mindist[j],maxdist[j],ht[j]);
            i=yline(ht[j],ht[j+1],mindist[j+1]);
            j++;
         }
         i=xline(mindist[plt_num_hts-1],x2,ht[plt_num_hts-1]);

         i = csize(0.15, 0.15);
         i = gmove( xhi+.6,(yval = (ylo + yhi)/2.0)+2 , 2);
         i = lbldir( 270.0 );
         i = lblorg(2);
         i = newpen(15);
         i=setfont(j1);
         i = label("TERRAIN ELEVATION(m)");
/*         if (dosindex != 0 ){*/
         /*+++++++++++legend +++++++++*/
            i = csize(.08,.18);
            i = lbldir( 0.0 );
            if((dosindex == 0 )&&(grafindex == 0))
               i = gmove(xval-2, 0.250, 2);
            else if((dosindex == 0 )&&(grafindex > 0))
               i = gmove(xval-2, 0.35, 2);
            else
               i = gmove(xval-2, 0.05, 2);
            i = newpen(15);
            i = lblorg(4);
            if (grafindex == 0)
               i=setfont(1);
            label("Concentration");
            i = setpu();
            i = ltype(0);
            if(dosindex == 0 ){
               i = gmove(xval-1.2, 0.40, 2);
               i = line(xval-0.5, 0.40);
            }
            else{
               i = gmove(xval-1.2,0.1, 2);
               i = line(xval-0.5, 0.1);
            }

            if((dosindex == 0 )&&(grafindex == 0))
               i = gmove(xval+1, 0.250, 2);
            else if((dosindex == 0 )&&(grafindex > 0))
               i = gmove(xval+1, 0.35, 2);
            else
               i = gmove(xval+1, 0.05, 2);
            i = newpen(15);
            i = lblorg(4);
            label("Terrain Elevation");
            i = setpu();
            i = ltype(5);
            i = newpen(10);
            if(dosindex == 0 ){
               i = gmove(xval+2.0,0.40, 2);
               i = line(xval+2.8, 0.40);
            }
            else {
               i = gmove(xval+2.0,0.1, 2);
               i = line(xval+2.8, 0.1);
            }
/*         }*/
      }



      /* +++++++++++++++++++++ Form feed printer +++++++++++++++*/
      if (dosindex > 0)
         printf("\f");
       /* +++++++++++++++++++++ Exit message ++++++++++++++++++*/
       i = csize(.08,.18);
       if (dosindex == 0 ){
          i = lbldir( 0.0 );
          if ((num_hts >0)&&(grafindex == 0))
             i = gmove(xval, 0.00, 2);
          else
             i = gmove(xval, 0.05, 2);
          i = newpen(15);
          i = lblorg(4);
          if (grafindex == 0)
             i=setfont(1);
          label("Press any key to continue");
       }

       i = gclose();
       if (dosindex == 0 )
          i = inkey(&k);
       i = gclose();
       i = settxt();
       i = system("CLS");
    }
}
 
