* system : tscreen
* program : s8
* author : Kevin Stroupe, PES

model = 'Puff'
IF direct 
   ACTIVATE WINDOW datawind
ENDIF

IF direct
   DO WHILE .NOT. abort
      CLEAR
      DO ClrEL1Key 
      DO endline1
      DO EL1Keys
      edit = .F.
      prcd = .F.
      @ 0, 3 SAY 'Based on use input, PUFF model has been selected.'
      @ 2, 3 SAY 'PUFF MODEL INPUTS - Page 1 of 2'
      @ 6, 3 SAY 'RELEASE PARAMETERS'
      @ 7, 3 SAY '           Total Amount of Material Released (Q) -> ' +LEFT(Q+SPACE(8),8) +' g'  
      @ 8, 3 SAY '                Release Height above Ground (Hs) -> '+LEFT(Hs+SPACE(8),8) +' m'  
      @ 9, 3 SAY '                 Initial Lateral Dispersion (y) -> ' +LEFT(SigmaY+SPACE(8),8) +' m'  
      @ 10,3 SAY '                Initial Vertical Dispersion (z) -> '+LEFT(SigmaZ+SPACE(8),8) +' m'  
      @ 12,3 SAY 'FENCELINE'
      @ 13,3 SAY ' Enter the distance from the nearest edge of the'
      @ 14,3 SAY '                   source to the plant fenceline -> '+ LEFT(Fence+SPACE(8),8) + ' m'

      @ 7, 55 FILL TO 7,62 COLOR &IPColor         
      @ 8, 55 FILL TO 8,62 COLOR &IPColor         
      @ 9, 55 FILL TO 9,62 COLOR &IPColor         
      @ 10, 55 FILL TO 10,62 COLOR &IPColor         
      @ 14, 55 FILL TO 14,62 COLOR &IPColor         

      cntr = 0
      DO WHILE .NOT. abort
         DO CASE 
            CASE cntr = 0
               DO title
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT
                  CASE LASTKEY() = 5   && UP    
                     cntr = 0
                  CASE prev  && F9            
                     model = ''                  
                     RETURN                
                  OTHERWISE  
                     cntr = 1
               ENDCASE 
            CASE cntr = 1
               @ 7,55 GET Q PICTURE '@!' VALID Chk(Q,3)
               READ
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT 
                  CASE prev            && F9
                     model = ''                  
                     RETURN   
                  CASE LASTKEY() = 5   && UP 
                     cntr = 0
                  OTHERWISE  
                    IF VAL(Q) >= 1E+07
                       WAIT 'Amount of Material Released must be < 1E+07, '+press WINDOW
                       cntr = 1
                       LOOP
                    ENDIF
                    cntr = 2
               ENDCASE 
            CASE cntr = 2  
               @ 8,55 GET Hs PICTURE '@!' VALID Chk(Hs,2)
               READ
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT 
                  CASE prev            && F9
                     model = ''                  
                     RETURN   
                  CASE LASTKEY() = 5   && UP 
                     cntr = 1
                  OTHERWISE
                     IF VAL(Hs) > 10000
                        WAIT 'Release Height must be  10000, '+press WINDOW
                        cntr = 2
                        LOOP
                     ENDIF         
                     cntr = 3
               ENDCASE 
            CASE cntr = 3
               @ 9,55 GET SigmaY PICTURE '@!' VALID Chk(SigmaY,2)
               @ 10,55 GET SigmaZ PICTURE '@!' VALID Chk(SigmaZ,2)               
               READ
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT 
                  CASE prev            && F9
                     model = ''                  
                     RETURN   
                  CASE LASTKEY() = 5   && UP 
                     cntr = 2
                  OTHERWISE
                     cntr = 4
               ENDCASE                
            CASE cntr = 4
               @ 14, 55 GET Fence PICTURE '@!' VALID Chk(Fence,3)            
               READ
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT 
                  CASE prev
                     model = ''                  
                     RETURN   
                  CASE LASTKEY() = 5   && UP 
                     KEYBOARD CHR(13)
                     cntr = 3
                  OTHERWISE 
                     DO CASE 
                        CASE VAL(Fence) < 10
                           WAIT 'Fenceline must be  10 m, '+press WINDOW
                           cntr = 4
                           LOOP
                        CASE VAL(Fence) > 30000      
                           WAIT 'Release Height must be  30000 m, '+press WINDOW
                           cntr = 4
                           LOOP
                     ENDCASE   
                     DO EL2Keys
                     IF prev           && F9
                        model = ''                     
                        RETURN
                     ENDIF
                     IF prcd           && F10
                        DO puffx2
                     ENDIF
                     EXIT      
               ENDCASE 
          ENDCASE 
      ENDDO
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO 
ELSE
   DO WHILE .NOT. abort
      CLEAR
      DO ClrEL1Key 
      DO endline1
      DO EL1Keys
      edit = .F.
      prcd = .F.
      @ 0, 3 SAY 'Based on use input, PUFF model has been selected.'
      @ 1, 3 SAY 'PUFF MODEL INPUTS - Page 1 of 2'
      @ 3, 3 SAY 'RELEASE PARAMETER'
      @ 4, 3 SAY '                 Release Height above Ground (Hs)-> '+LEFT(Hs+SPACE(8),8) +' m'  
      @ 5, 3 SAY '                 Initial Lateral Dispersion (y) -> ' +LEFT(SigmaY+SPACE(8),8) +' m'  
      @ 6, 3 SAY '                Initial Vertical Dispersion (z) -> '+LEFT(SigmaZ+SPACE(8),8) +' m'  
      @ 8, 3 SAY 'FENCELINE DISTANCE'
      @ 9, 3 SAY ' Enter the distance from the nearest edge of the'
      @ 10,3 SAY '                   source to the plant fenceline -> '+ LEFT(Fence+SPACE(8),8) + ' m'

      @ 4, 55 FILL TO 4,62 COLOR &IPColor         
      @ 5, 55 FILL TO 5,62 COLOR &IPColor         
      @ 6, 55 FILL TO 6,62 COLOR &IPColor         
      @ 10, 55 FILL TO 10,62 COLOR &IPColor         

      cntr = 1
      DO WHILE .NOT. abort
         DO CASE 
            CASE cntr = 1  
               @ 4,55 GET Hs PICTURE '@!' VALID Chk(Hs,2)
               READ
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT 
                  CASE prev            && F9
                     model = ''                  
                     RETURN   
                  CASE LASTKEY() = 5   && UP 
                     cntr = 1
                  OTHERWISE
                     IF VAL(Hs) > 10000
                        WAIT 'Release Height must be  10000, '+press WINDOW
                        cntr = 1
                        LOOP
                     ENDIF         
                     cntr = 2
               ENDCASE 
            CASE cntr = 2
               @ 5,55 GET SigmaY PICTURE '@!' VALID Chk(SigmaY,2)
               @ 6,55 GET SigmaZ PICTURE '@!' VALID Chk(SigmaZ,2)               
               READ
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT 
                  CASE prev            && F9
                     model = ''                  
                     RETURN   
                  CASE LASTKEY() = 5   && UP 
                     cntr = 1
                  OTHERWISE
                     cntr = 3
               ENDCASE                               
            CASE cntr = 3
               @ 10, 55 GET Fence PICTURE '@!' VALID Chk(Fence,3)            
               READ
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT 
                  CASE prev
                     model = ''                  
                     RETURN   
                  CASE LASTKEY() = 5   && UP 
                     KEYBOARD CHR(13)
                     cntr = 2
                  OTHERWISE 
                     DO CASE 
                        CASE VAL(Fence) < 10
                           WAIT 'Fenceline must be  10 m, '+press WINDOW
                           cntr = 3
                           LOOP
                        CASE VAL(Fence) > 30000      
                           WAIT 'Fenceline must be  30000 m, '+press WINDOW
                           cntr = 3
                           LOOP
                     ENDCASE   
                     DO EL2Keys
                     IF prev           && F9
                        model = ''
                        RETURN
                     ENDIF
                     IF prcd           && F10
                        DO puffx2
                     ENDIF
                     EXIT      
               ENDCASE 
          ENDCASE 
      ENDDO
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO 
ENDIF      
              
DEACTIVATE WINDOW datawind
model = ''
RETURN


******************************* puffx2 ************************************
PROCEDURE puffx2

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'PUFF MODEL INPUTS - Page 2 of 2'
   @ 3, 3 SAY 'AVERAGING TIME'    
   @ 4, 3 SAY 'Select Desired Averaging Time from menu below for graphic output:'
   @ 5, 25 PROMPT 'Instantaneous (1 second)'
   @ 6, 25 PROMPT '1 minute      (60 second)'
   @ 7, 25 PROMPT '5 minutes     (300 seconds)'
   @ 8, 25 PROMPT '15 minutes    (900 seconds)'
   @ 9, 25 PROMPT '1 hour        (3600 seconds)'
     
   MENU TO Plotav
   IF prev           && F9
      RETURN 
   ENDIF
   IF LASTKEY() = 27
      abort = .T.
      EXIT
   ENDIF               
   
   DO CASE
      CASE Plotav = 1
         av =  'Instantaneous (1 second)'
      CASE Plotav = 2
         av = '1 minute (60 second)'
      CASE Plotav = 3
         av = '5 minutes (300 seconds)'
      CASE Plotav = 4
         av = '15 minutes (900 seconds)'   
      CASE Plotav = 5
         av = '1 hour (3600 seconds)'
   ENDCASE
   @ 12,3 SAY 'Selected Averaging Time: '+av
   
   DO EL3Keys
   IF prev           && F9
      RETURN 
   ENDIF
             
   IF prcd           && F10
      DO PuffSave
      
      DO RunModel
      abort = .T.
      EXIT
   ENDIF
   IF LASTKEY() = 27
      abort = .T.
      EXIT
   ENDIF               
    
ENDDO

RETURN


****************************** Puff Save *********************************
PROCEDURE PuffSave
ifp = FCREATE('ipuf.dat')
bytes = FPUTS(ifp,Title)
st = '1' + CHR(13) + CHR(10)                 && New run read all data
bytes = FPUTS(ifp,st)
st = '0,0,0,1'  + CHR(13) + CHR(10)             && give estimates for input data only
bytes = FPUTS(ifp,st)
*IF VAL(Hs) >= 1 .AND. VAL(Hs) < 1.04 
*   st = ALLTRIM(Q)+','+ALLTRIM(Hs)+','+'0.1,0.1' + CHR(13) + CHR(10) 
*ELSE   
   st = ALLTRIM(Q)+','+ALLTRIM(Hs)+','+ALLTRIM(SIGMAY)+','+ALLTRIM(SIGMAZ) + CHR(13) + CHR(10) 
*ENDIF      
bytes = FPUTS(ifp,st)
st = '1,500,15,2' + CHR(13) + CHR(10) 
bytes = FPUTS(ifp,st)
st = '12' + CHR(13) + CHR(10) 
bytes = FPUTS(ifp,st)
FOR i = 1 TO 12
   st = '1,0,0' + CHR(13) + CHR(10) 
   bytes = FPUTS(ifp,st)
NEXT i
st = ALLTRIM(STR(Plotav)) + CHR(13) + CHR(10) 
bytes = FPUTS(ifp,st)
fenceKM = STR(VAL(Fence)/1000,20,10)
st = ALLTRIM(fenceKM) + CHR(13) + CHR(10) 
bytes = FPUTS(ifp,st)
st = '999' + CHR(13) + CHR(10) 
bytes = FPUTS(ifp,st)
=FCLOSE(ifp)

RETURN
