*program :RunModel
*programmer:Kevin Stroupe,PES
*system : TSCREEN
*modified by: Roger Brode, PES, 5/13/94
*  modified 'SCREEN Model' to 'SCREEN2 Model'
*  added ScrnArea model for new area source algorithm
*modified by: Roger Brode, PES, 9/12/95
*  modified 'SCREEN2 Model' to 'SCREEN3 Model',
*  modified command line to run SCREEN3 model (SCRN3TS.EXE)


PROCEDURE RunModel

HIDE MENU mainmenu
HIDE POPUP ALL

DEACTIVATE WINDOW datawind
RELEASE WINDOW datawind

SET COLOR TO W+/BG 
CLEAR 

recordnum = 1
DO saverun WITH recordnum

DO CASE
   CASE model = 'Puff'
      COPY FILE 'ipuf.dat' TO 'ERROR.OUT'
      @ 12,1 SAY PADC('Please stand by, Running PUFF model...',78)      
      !/0 PuffTS 
   CASE model = 'ScrnA' .OR.  model = 'ScrnF' .OR.  model = 'ScrnP'
      COPY FILE 'screen.in' TO 'ERROR.OUT'
      @ 12,1 SAY PADC('Please stand by, Running SCREEN3 model...',79)
      !/0 Scrn3TS < screen.in
   CASE model = 'RVD'
      COPY FILE 'rvdin.dat' TO 'ERROR.OUT'
      @ 12,1 SAY PADC('Please stand by, Running RVD model...',79)      
      !/0 RVDTS
      IF FILE('GRAPH.FIL')
         DELETE FILE 'GRAPH.FIL'
      ENDIF                              
      IF .NOT. FILE('ERROR.OUT')
         RENAME 'RVD.FIL' TO 'GRAPH.FIL'
      ENDIF   
   CASE model = 'BM'
      COPY FILE 'BMTS.IN' TO 'ERROR.OUT'
      @ 12,1 SAY PADC('Please stand by, Running Britter-McQuaid model...',79)      
      !/0 BMTS                
      IF FILE('GRAPH.FIL')
         DELETE FILE 'GRAPH.FIL'
      ENDIF                              
      IF .NOT. FILE('ERROR.OUT')
         RENAME 'BM.FIL' TO 'GRAPH.FIL'
      ENDIF   
*   CASE model = 'RVDBM'
*      COPY FILE 'rvdin.dat' TO 'ERROR.OUT'
*      @ 12,1 SAY PADC('Please stand by, Running RVD model...',79)      
*      !/0 RVDTS
*      IF .NOT. FILE('ERROR.OUT')
*         handle = FOPEN('RVDMAX')
*         rvd_max = FGETS(handle)
*         =FCLOSE(handle)
*         DELETE FILE 'RVDMAX'
*         COPY FILE 'BMTS.IN' TO 'ERROR.OUT'
*         x=' '
*         @ 13,0 SAY PADC(x,79,' ')
*         @ 12,1 SAY PADC('Please stand by, Running Britter-McQuaid model...',79)      
*         !/0 BMTS                     
*         IF .NOT. FILE('ERROR.OUT')
*            handle = FOPEN('BMMAX')
*            bm_max = FGETS(handle)
*            =FCLOSE(handle)            
*            DELETE FILE 'BMMAX'            
*            IF FILE('GRAPH.FIL')
*               DELETE FILE 'GRAPH.FIL'
*            ENDIF                        
*            IF VAL(rvd_max) > VAL(bm_max)
*               model = 'RVD'               
*               RENAME 'RVD.FIL' TO 'GRAPH.FIL'
*               DELETE FILE 'bmts.in'
*               DELETE FILE 'bmts.out'      
*               DELETE FILE 'bm.fil'
*            ELSE
*               model = 'BM'
*               RENAME 'BM.FIL' TO 'GRAPH.FIL'
*               DELETE FILE 'rvdin.dat'
*               DELETE FILE 'rvd.out'
*               DELETE FILE 'rvd.fil'
*            ENDIF            
*         ENDIF                       
*      ENDIF
ENDCASE

IF FILE('RVDMAX')
   DELETE FILE 'RVDMAX'
ENDIF
IF FILE('BMMAX')
   DELETE FILE 'BMMAX'
ENDIF

IF FILE('ERROR.OUT')
   !/0 ErHandle
   abort = .T.
ELSE
   @ 12,1 
   @ 13,1
   @ 14,1
   @ 0,0 CLEAR TO 24,79
   SET COLOR OF SCHEME 1 TO &WindColor
   SET COLOR OF SCHEME 2 TO &PopColor

   IF LEFT(model,4) = 'Scrn'
      * Check is concentration is greater than .1 ug/cubic m
      *handle = FOPEN('scrn2.out')
      *FOR i = 1 TO 5 
      *   line1 = FGETS(handle)
      *NEXT i   
      *line1 = FGETS(handle)
      *line1 = FGETS(handle)
      *line1 = FGETS(handle)
      *line1 = FGETS(handle)
      *IF LEFT(line1,7) = ' SIMPLE' .OR.  LEFT(line1,8) = ' COMPLEX'
      *   conc = SUBSTR(line1,20,11)   
      *ENDIF   
      *=FCLOSE(handle)
      *IF VAL(conc) > .1
         DO CalcPPM         
      *ELSE
      *   PpmYN = 'N'   
      *ENDIF   
   ENDIF

   IF model = 'ScrnP' .OR. model = 'ScrnF'
      IF Simple = 'Y'    && IF only complex terrain do NOT get additional averaging times
         DO avetime         
      ENDIF
   ENDIF
   
   IF model <> 'BM' 
      DO Addmsg   
   ENDIF
   
   DO relmvars
   DO viewrpt 
   DO restormv WITH recordnum        
ENDIF

DO CASE
   CASE model = 'Puff'
      DELETE FILE 'ipuf.dat'
      DELETE FILE 'puff.out'
   CASE model = 'ScrnA' .OR.  model = 'ScrnF' .OR.  model = 'ScrnP' 
      DELETE FILE 'screen.in'
      DELETE FILE 'screen.dat'
      DELETE FILE 'screen.out'
      DELETE FILE 'scrn1.out'
      DELETE FILE 'scrn2.out'
      DELETE FILE 'scrn3.out'                        
      DELETE FILE 'distnum'
*   CASE model = 'ScrnA2'
*      DELETE FILE 'screen.in'
*      DELETE FILE 'screen.dat'
*      DELETE FILE 'screen.out'
*      DELETE FILE 'scrn1.out'
*      DELETE FILE 'scrn2.out'
*      DELETE FILE 'scrn3.out'
*      DELETE FILE 'distnum'
  CASE model = 'RVD'
      DELETE FILE 'rvdin.dat'
      DELETE FILE 'rvd.out'
  CASE model = 'BM'
      DELETE FILE 'bmts.in'
      DELETE FILE 'bmts.out'      
ENDCASE
DELETE FILE  'graph.fil'
IF FILE('htdist.fil')
   DELETE FILE  'htdist.fil'
ENDIF   

SET COLOR TO W+/BG 
CLEAR 
SET COLOR TO W+/B 
@0,0 SAY PADC("",80,' ') COLOR W/B

*SHOW MENU mainmenu
RETURN
