* system : tscreen
* program : s210
* author : Kevin Stroupe, PES

IF LEN(ALLTRIM(E)) = 0
   E = '0.2     '
ENDIF


ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 1 of 1'
   @  6,3 SAY 'EMISSION RATE'
   @  7,3 SAY ' Enter the Emission Rate (Qm), if unknown enter'
   @  8,3 SAY '         the boxed variables below to calculate -> '+LEFT(Qm+SPACE(8),8)+' g/s' 
   @  9,3 TO 18,75
   @ 10,5 SAY '                Evaporation Rate of Water (E) -> '+LEFT(E+SPACE(8),8)+' in/day'
   @ 11,4 SAY 'Enter V for Vegetated Land-S for Soil Surfaces'
   @ 12,5 SAY '                         W for Water Surfaces -> ' + LEFT(Type+' ',1)
   @ 13,5 SAY '                       Relative Humidity (Rh) -> ' + LEFT(Hr+SPACE(8),8) +' %'
   @ 14,5 SAY '                 Vapor Pressure of Water (Pw) -> ' + LEFT(P+SPACE(8),8) + ' atm'
   @ 15,5 SAY '  Vapor Pressure of Pesticide Ingredient (Pp) -> ' + LEFT(Pr+SPACE(8),8) + ' atm'
   @ 16,5 SAY ' Molecular Weight of Pesticide Ingredient(Mp) -> ' + LEFT(Mw+SPACE(8),8) + ' kg/kmol'
   @ 17,5 SAY '                      Area of Application (A) -> ' + LEFT(A+SPACE(8),8) + ' m'
   
   @ 8, 54 FILL TO 8,61 COLOR &IPColor  
   @ 10, 54 FILL TO 10,61 COLOR &IPColor 
   @ 12, 54 FILL TO 12,54 COLOR &IPColor 
   @ 13, 54 FILL TO 13,61 COLOR &IPColor 
   @ 14, 54 FILL TO 14,61 COLOR &IPColor 
   @ 15, 54 FILL TO 15,61 COLOR &IPColor    
   @ 16, 54 FILL TO 16,61 COLOR &IPColor       
   @ 17, 54 FILL TO 17,61 COLOR &IPColor       
   
   cntr = 0
   DO WHILE .NOT. abort
      holdf = Qm
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE                 
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 8,54 GET Qm PICTURE '@!' VALID Chk(Qm,-3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  RETURN   
               CASE LEN(ALLTRIM(Qm)) = 0
                  cntr = 2   
               OTHERWISE 
                  IF Qm <> holdf
                     E = SPACE(8)
                     Type = ' '
                     Hr = SPACE(8)
                     P = SPACE(8)
                     Pr = SPACE(8)
                     Mw = SPACE(8)
                     A = SPACE(8)
                  
                     @ 10, 54 SAY E                     
                     @ 12, 54 SAY Type
                     @ 13, 54 SAY Hr
                     @ 14, 54 SAY P
                     @ 15, 54 SAY Pr
                     @ 16, 54 SAY Mw
                     @ 17, 54 SAY A
               
                     @ 10, 54 FILL TO 10,61 COLOR &IPColor 
                     @ 12, 54 FILL TO 12,54 COLOR &IPColor 
                     @ 13, 54 FILL TO 13,61 COLOR &IPColor 
                     @ 14, 54 FILL TO 14,61 COLOR &IPColor 
                     @ 15, 54 FILL TO 15,61 COLOR &IPColor    
                     @ 16, 54 FILL TO 16,61 COLOR &IPColor       
                     @ 17, 54 FILL TO 17,61 COLOR &IPColor       
                  ENDIF   
                  cntr = 3
            ENDCASE    
         CASE cntr = 2
            @ 10,54 GET E PICTURE '@!' VALID Chk(E,3)           
            @ 12,54 GET Type PICTURE '@!' VALID ChkVSW(Type)           
            @ 13,54 GET Hr PICTURE '@!' VALID Chk(Hr,20)           
            @ 14,54 GET P PICTURE '@!' VALID Chk(P,3)           
            @ 15,54 GET Pr PICTURE '@!' VALID Chk(Pr,3)           
            @ 16,54 GET Mw PICTURE '@!' VALID Chk(Mw,8)           
            @ 17,54 GET A PICTURE '@!' VALID Chk(A,3)           
            
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE               
                  DO CASE
                     CASE Type = 'V'
                        adjust = .73
                     CASE Type = 'S'
                        adjust = .40
                     CASE Type = 'W'
                        adjust = .70
                  ENDCASE                  
                  
                  * Convert Evaporation rate of water E (in/day) to Ew (g/s)
                  Ew = VAL(E) * 226000 * (1/86400) * VAL(A)/3910.3445 * 453.593
                   
                  * calculate emission rate Qm                   
                  Qm = convert( ( adjust * Ew/(1 - VAL(Hr)/100) ) * ( (VAL(Pr)*760)*SQRT(VAL(Mw)) );
                   /((VAL(P)*760)*SQRT(18)) )
                                   
                  Qm = LEFT(Qm+SPACE(8),8)
                  @ 8,54 SAY Qm
                  @ 8,54 FILL TO 8,61 COLOR &IPColor
                  
                  cntr = 3
             ENDCASE 
          CASE cntr = 3
             IF VAL(Qm) <= 0
                WAIT 'Emission Rate must be > 0, '+press WINDOW
                cntr = 1
                LOOP
             ENDIF         
             DO EL2Keys
             IF prev           && F9
                RETURN
             ENDIF                 
             IF prcd           && F10
                IF LEN(ALLTRIM(A)) = 0 
                   GotArea = .F.
                ELSE 
                   GotArea = .T.
                ENDIF  
                DO scrnasub
             ENDIF   
             EXIT                               
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
             
DEACTIVATE WINDOW datawind

RETURN
