* system : tscreen
* program : s27
* author : Kevin Stroupe, PES

ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SOURCE PARAMETERS - Page 1 of 1'
   @ 6, 3 SAY 'EMISSION RATE'
   @ 7, 3 SAY '      Enter the Emission Rate (Qm), if unknown enter'
   @ 8, 3 SAY '              the boxed variables below to calculate -> '+LEFT(Qm+SPACE(8),8)+' g/s' 
   @ 9,3 TO 12,75
   @ 10,5 SAY '                              Production Rate (Pd) -> '+LEFT(Pd+SPACE(8),8)+' Mg/yr'
   @ 11,5 SAY 'Emission Factor from various fugitive sources (EF) -> ' + LEFT(Efs+SPACE(8),8) + ' kg/Mg'      
   
   @ 8, 59 FILL TO 8,66 COLOR &IPColor  
   @ 10, 59 FILL TO 10,66 COLOR &IPColor 
   @ 11, 59 FILL TO 11,66 COLOR &IPColor 
   
   cntr = 0
   DO WHILE .NOT. abort
      holdf = Qm
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE                 
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 8,59 GET Qm PICTURE '@!' VALID Chk(Qm,-3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  RETURN   
               CASE LEN(ALLTRIM(Qm)) = 0
                  cntr = 2   
               OTHERWISE 
                  IF Qm <> holdf
                     Pd =SPACE(8)
                     Efs=SPACE(8)
                     @ 10,59 SAY Pd
                     @ 11,59 SAY Efs
                     @ 10, 59 FILL TO 10,66 COLOR &IPColor   
                     @ 11, 59 FILL TO 11,66 COLOR &IPColor
                  ENDIF   

                  cntr = 3
            ENDCASE 
   
         CASE cntr = 2
            @ 10,59 GET Pd PICTURE '@!' VALID Chk(Pd,3)           
            @ 11,59 GET Efs PICTURE '@!' VALID Chk(Efs,3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE                              
                  Qm = convert(((((VAL(Pd) * VAL(Efs))/356)/86400))*1000)                
                  Qm = LEFT(Qm+SPACE(8),8)
                  @ 8,59 SAY Qm
                  @ 8,59 FILL TO 8,66 COLOR &IPColor
                  cntr = 3
             ENDCASE 
          CASE cntr = 3
             IF VAL(Qm) <= 0
                WAIT 'Emission Rate must be > 0, '+press WINDOW
                cntr = 1
                LOOP
             ENDIF         
             DO EL2Keys
             IF prev           && F9
                RETURN
             ENDIF                 
             IF prcd           && F10
               GotArea = .F.
               DO scrnasub
             ENDIF   
             EXIT                               
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
             
DEACTIVATE WINDOW datawind

RETURN


