* system : tscreen
* program : s29
* author : Kevin Stroupe, PES

IF LEN(ALLTRIM(K)) = 0
   K = '0.02    '
   M = '230     '
   Co = '8000    '
ENDIF
   

ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 1 of 1'
   @  6,3 SAY 'EMISSION RATE'
   @  7,3 SAY 'Enter the Emission Rate (Qm), if unknown'
   @  8,3 SAY ' enter the boxed variables below to calculate -> '+LEFT(Qm+SPACE(8),8)+' g/s' 
   @  9,3 TO 17,75
   @ 10,5 SAY '         Average Annual Acceptance Rate (R) -> '+LEFT(Rs+SPACE(8),8) + ' Mg/yr'
   @ 11,5 SAY '                     Year since Closure (c) -> '+LEFT(C+SPACE(8),8) 
   @ 12,5 SAY '                        Age of Landfill (t) -> '+LEFT(Dur+SPACE(8),8) + ' yrs'
   @ 13,5 SAY '       Methane Generation Rate Constant (k) -> '+LEFT(K+SPACE(8),8) + ' 1/yr'
   @ 14,5 SAY '   Refuse Methane Generation Potential (Lo) -> '+LEFT(M+SPACE(8),8) + ' cubic m/Mg'
   @ 15,5 SAY '              Concentration of NMOC (Cnmoc) -> '+LEFT(Co+SPACE(8),8) + ' ppmv as hexane'
   @ 16,5 SAY '       Constituent % of Total VOC Emissions -> ' + LEFT(Constper+SPACE(8),8) + ' %'      
   
   @ 8, 52 FILL TO 8,59 COLOR &IPColor  
   @ 10, 52 FILL TO 10,59 COLOR &IPColor 
   @ 11, 52 FILL TO 11,59 COLOR &IPColor 
   @ 12, 52 FILL TO 12,59 COLOR &IPColor 
   @ 13, 52 FILL TO 13,59 COLOR &IPColor 
   @ 14, 52 FILL TO 14,59 COLOR &IPColor 
   @ 15, 52 FILL TO 15,59 COLOR &IPColor 
   @ 16, 52 FILL TO 16,59 COLOR &IPColor 
   
   cntr = 0
   DO WHILE .NOT. abort
      holdf = Qm
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE                 
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 8,52 GET Qm PICTURE '@!' VALID Chk(Qm,-3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  RETURN   
               CASE LEN(ALLTRIM(Qm)) = 0
                  cntr = 2   
               OTHERWISE 
                  IF Qm <> holdf
                     Rs=SPACE(8) 
                     C =SPACE(8)
                     Dur=SPACE(8)
                     K =SPACE(8)
                     M =SPACE(8)
                     Co =SPACE(8)
                     Constper=SPACE(8)
                     @ 10,52 SAY Rs
                     @ 11,52 SAY C
                     @ 12,52 SAY Dur
                     @ 13,52 SAY K
                     @ 14,52 SAY M
                     @ 15,52 SAY Co
                     @ 16,52 SAY constper
                     @ 10, 52 FILL TO 10,59 COLOR &IPColor   
                     @ 11, 52 FILL TO 11,59 COLOR &IPColor
                     @ 12, 52 FILL TO 12,59 COLOR &IPColor 
                     @ 13, 52 FILL TO 13,59 COLOR &IPColor 
                     @ 14, 52 FILL TO 14,59 COLOR &IPColor 
                     @ 15, 52 FILL TO 15,59 COLOR &IPColor 
                     @ 16, 52 FILL TO 16,59 COLOR &IPColor 
                  ENDIF   
                  cntr = 3
            ENDCASE 
   
         CASE cntr = 2
            @ 10,52 GET Rs PICTURE '@!' VALID Chk(Rs,3)
            @ 11,52 GET C PICTURE '@!' VALID Chk(C,2)
            @ 12,52 GET Dur PICTURE '@!' VALID Chk(Dur,2)
            @ 13,52 GET K PICTURE '@!' VALID Chk(K,2)
            @ 14,52 GET M PICTURE '@!' VALID Chk(M,3)
            @ 15,52 GET Co PICTURE '@!' VALID Chk(Co,3)                       
            @ 16,52 GET Constper PICTURE '@!' VALID Chk(Constper,13)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE                               
                  Qm =  2 * VAL(M) * VAL(Rs) *;
                   (EXP(-VAL(K)*VAL(C))-EXP(-VAL(K)*VAL(Dur))) *  VAL(Co) * 3.595E-9 
                  Qm = convert(Qm * .0317 * (VAL(Constper)/100) ) 
                  Qm = LEFT(Qm + SPACE(8),8)
                  @ 8,52 SAY Qm
                  @ 8,52 FILL TO 8,59 COLOR &IPColor
                  cntr = 3
             ENDCASE 
          CASE cntr = 3
             IF VAL(Qm) <= 0
                WAIT 'Emission Rate must be > 0, '+press WINDOW
                cntr = 1
                LOOP
             ENDIF         
             DO EL2Keys
             IF prev           && F9
                RETURN
             ENDIF                 
             IF prcd           && F10          
               GotArea = .F.
               DO scrnasub
             ENDIF   
             EXIT                               
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
             
DEACTIVATE WINDOW datawind

RETURN


