* system : tscreen
* program : s31
* author : Kevin Stroupe, PES

ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SOURCE PARAMETERS - Page 1 of 1'
   @ 6, 3 SAY 'IMPOUNDMENT TYPE'
   @ 7, 3 SAY '         Enter Q for Quiescent - A for Aerated -> '+LEFT(Impoundtyp+' ',1)
   @ 9, 3 SAY 'EMISSION RATE'
   @ 10, 3 SAY 'Enter the Emission Rate (Qm), if unknown enter'
   @ 11, 3 SAY '        the boxed variables below to calculate -> '+LEFT(Qm+SPACE(8),8)+' g/s' 
   @ 12,3 TO 16,75
   @ 13,5 SAY '           Initial Concentration of Chemical'
   @ 14,5 SAY '                           in the Waste (Co) -> '+LEFT(Co+SPACE(8),8)+ ' g/cubic m'
   @ 15,5 SAY '                     Area of Impoundment (A) -> '+ LEFT(A+SPACE(8),8) + ' m'

   @ 7, 53 FILL TO 7,53 COLOR &IPColor
   @ 11, 53 FILL TO 11,60 COLOR &IPColor  
   @ 14, 53 FILL TO 14,60 COLOR &IPColor 
   @ 15, 53 FILL TO 15,60 COLOR &IPColor 
         
   
   cntr = 0
   DO WHILE .NOT. abort
      holdf = Qm
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE                 
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 7,53 GET Impoundtyp PICTURE '@!' VALID ChkQA(Impoundtyp)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  RETURN   
               OTHERWISE 
                  cntr = 2
            ENDCASE 

         CASE cntr = 2
            @ 11,53 GET Qm PICTURE '@!' VALID Chk(Qm,-3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  RETURN   
               CASE LEN(ALLTRIM(Qm)) = 0
                  cntr = 3   
               OTHERWISE 
                  IF Qm <> holdf
                     Co =SPACE(8)
                     A = SPACE(8)
                     @ 14,53 SAY Co
                     @ 15,53 SAY A
                     @  14, 53 FILL TO 14,60 COLOR &IPColor 
                     @  15, 53 FILL TO 15,60 COLOR &IPColor                                        
                  ENDIF   
                  cntr = 4
            ENDCASE 
   
         CASE cntr = 3
            @ 14,53 GET Co PICTURE '@!' VALID Chk(Co,3)  
            @ 15,53 GET A PICTURE '@!' VALID Chk(A,3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 2
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  IF Impoundtyp = 'Q'
                     Qm = convert(4e-6 * (VAL(Co)) * (VAL(A)))
                  ELSE 
                     Qm = convert(8e-4 * (VAL(Co)) * (VAL(A)))  
                  ENDIF               
                  Qm = LEFT(Qm+SPACE(8),8)
                  @ 11,53 SAY Qm
                  @ 11,53 FILL TO 11,60 COLOR &IPColor
                  cntr = 4
             ENDCASE 
          CASE cntr = 4
             IF VAL(Qm) <=0
                WAIT 'Emission Rate must be > 0, '+press WINDOW      
                cntr = 2
                LOOP
             ELSE
                DO EL2Keys
                IF prev           && F9
                   RETURN
                ENDIF                 
                IF prcd           && F10
                   IF LEN(ALLTRIM(A)) = 0 
                      GotArea = .F.
                   ELSE 
                      GotArea = .T.
                   ENDIF
                   DO scrnasub
                ENDIF   
                EXIT   
             ENDIF                            
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
             
DEACTIVATE WINDOW datawind

RETURN


