* system : tscreen
* program : s35
* author : Kevin Stroupe, PES

ACTIVATE WINDOW datawind

DO Inst_warning

R = 8314
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 1 of 4'
   @  5,3 SAY 'SOURCE OF LEAK'
   @  6,3 SAY '                Area (Ao) of Hole or Opening -> '+ LEFT(A0CM+SPACE(8),8) + ' cm'
   @  7,3 SAY '               Enter P for Pipe - T for Tank -> '+ LEFT(Type+' ',1)
   @ 12,3 SAY 'DISCHARGE TEMPERATURE'
   @ 13,3 SAY '                  Discharge Temperature (T2) ->          K'
   @ 14,3 TO 19,75
   @ 15,5 SAY '                     Ambient Pressure (Pa) -> '+LEFT(Pa+SPACE(8),8)+' Pa'
   @ 16,5 SAY '            Boiling Point Temperature (Tb) -> '+LEFT(Tb+SPACE(8),8)+' K'
   @ 17,5 SAY '        Latent Heat of Vaporization (Lvap) -> '+LEFT(Lvap+SPACE(8),8)+' J/kg'
   @ 18,5 SAY '                     Molecular Weight (Mw) -> '+LEFT(Mw+SPACE(8),8) + ' kg/kmol'
   
   @ 6, 51 FILL TO 6,58 COLOR &IPColor  
   @ 7, 51 FILL TO 7,51 COLOR &IPColor   
   @ 15, 51 FILL TO 15,58 COLOR &IPColor      
   @ 16, 51 FILL TO 16,58 COLOR &IPColor   
   @ 17, 51 FILL TO 17,58 COLOR &IPColor   
   @ 18, 51 FILL TO 18,58 COLOR &IPColor   

   cntr = 0
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE  
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 6,51 GET A0CM PICTURE '@!' VALID Chk(A0CM,3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  A0 = convert(VAL(A0CM)/10000)
                  D = convert(SQRT((4 * VAL(A0))/3.14159))                            
                  cntr = 2   
            ENDCASE         
         CASE cntr = 2
            @ 7,51 GET Type PICTURE '@!' VALID ChkPT(Type)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  IF Type = 'P'
                     cntr = 3
                  ELSE
                     P = '0       '
                     Dp = '1       '
                     @ 9, 3 CLEAR TO 10,75
                     cntr = 4   
                  ENDIF   
            ENDCASE      
         CASE cntr = 3
            @ 9,5 SAY '                        Pipe Diameter (Dp) -> '+LEFT(Dp+SPACE(8),8)+' m'
            @ 10,5 SAY '                          Pipe Length (Lp) -> '+LEFT(P+SPACE(8),8)+' m'
                    
            @ 9,51 FILL TO 9,58 
            @ 10,51 FILL TO 10,58 

            @ 9,51 GET Dp PICTURE '@!' VALID Chk(Dp,3)                        
            @ 10,51 GET P PICTURE '@!' VALID Chk(P,3)
            READ           

            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 2
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  cntr = 4   
            ENDCASE      
         CASE cntr = 4
            @ 15,51 GET Pa PICTURE '@!' VALID Chk(Pa,3)
            @ 16,51 GET Tb PICTURE '@!' VALID Chk(Tb,9)                       
            @ 17,51 GET Lvap PICTURE '@!' VALID Chk(Lvap,3)
            @ 18,51 GET Mw PICTURE '@!' VALID Chk(Mw,8)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  IF Type = 'P'
                     KEYBOARD CHR(13)
                     cntr = 3
                  ELSE
                     cntr = 2
                  ENDIF                  
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  IF VAL(Tb) - R/(VAL(Lvap)*VAL(Mw)) * LOG(VAL(Pa)/101325) <= 0
                      cntr = 5
                      LOOP
                  ENDIF                  
                  * Calculate Discharge Temperature Ts
                  Ts = Convert(1 / ( 1/VAL(Tb) - R/(VAL(Lvap)*VAL(Mw)) * LOG(VAL(Pa)/101325) ))
                  @ 13,51 SAY LEFT(Ts+SPACE(8),8)
                  cntr = 6
            ENDCASE   
         CASE cntr = 5
            DEFINE WINDOW msg FROM 6,12 TO 11,58 SHADOW COLOR &MesColor
            ACTIVATE WINDOW msg
            @ 1,0 SAY PADC('Invalid  combination of inputs !!!',44)
            @ 3,0 SAY PADC('Press any key to continue...',44)
            WAIT ""
            RELEASE WINDOW msg            
            cntr = 4               
         CASE cntr = 6
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
            
               DO s35x2               
             ENDIF   
             EXIT           
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
             
DEACTIVATE WINDOW datawind

RETURN


******************************* s35x2 ************************************
PROCEDURE s35x2

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 2 of 4'
   @  3,3 SAY 'VAPOR FRACTION AFTER DEPRESSURIZATION'
   @  4,3 SAY '  Vapor Fraction after Depressurization (X2) -> '
   @  5,3 TO  8,75 
   @  6,5 SAY '                  Vapor Heat Capacity (Cp) -> '+ LEFT(Cp+SPACE(8),8) +' J/kg K'
   @  7,5 SAY '                Reservoir Temperature (T1) -> '+ LEFT(T1+SPACE(8),8) + ' K'
   @ 10,3 SAY 'EMISSION RATE'
   @ 11,3 SAY '                          Emission Rate (Qm) ->          g/s'
   @ 12,3 TO 16,75
   @ 13,5 SAY '                   Reservoir Pressure (P1) -> '+ LEFT(Pr+SPACE(8),8) + ' Pa'
   @ 14,5 SAY '          Liquid Heat Capacity at T1 (Cpl) -> '+ LEFT(Cpl+SPACE(8),8) + ' J/kg K'
   @ 15,5 SAY '           Contaminant Liquid Density (1) -> '+ LEFT(Pl+SPACE(8),8) + ' kg/cubic m'
   
   @ 6,51 FILL TO 6,58 COLOR &IPColor
   @ 7,51 FILL TO 7,58 COLOR &IPColor  
   @ 13,51 FILL TO 13,58 COLOR &IPColor
   @ 14,51 FILL TO 14,58 COLOR &IPColor
   @ 15,51 FILL TO 15,58 COLOR &IPColor

   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 6,51 GET Cp PICTURE '@!' VALID Chk(Cp,3)
            @ 7,51 GET T1 PICTURE '@!' VALID Chk(T1,9)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  * Calculate Vapor Fraction after Depressurization X2
                  X2 = convert((VAL(Cp) * (VAL(T1) - VAL(Ts)))/VAL(Lvap))
                  @ 4,51 SAY LEFT(X2+SPACE(8),8)                  
                  DO CASE                  
                     CASE VAL(X2) <= 0
                        DEFINE WINDOW question FROM 11,13 TO 18,65 SHADOW COLOR &MesColor
                        ACTIVATE WINDOW question
                        @ 1,0 SAY PADC('Scenario 3.4.  -',53)
                        @ 2,0 SAY PADC('Instantaneous High Volatility Liquid Leaks',53)
                        @ 3,0 SAY PADC('may be more appropriate.',53)
                        WAIT
                        RELEASE WINDOW question
                        abort = .T.
                     CASE VAL(X2) >= 1 
                        DEFINE WINDOW question FROM 11,13 TO 18,65 SHADOW COLOR &MesColor
                        ACTIVATE WINDOW question
                        @ 1,0 SAY PADC('X1  1 ',53)
                         @ 2,0 SAY PADC('This case is unlikely on physical grounds.',53)
                        @ 3,0 SAY PADC('Enter new data in the data entry fields.',53)
                        WAIT
                        RELEASE WINDOW question                     
                     OTHERWISE
                        cntr = 2
                  ENDCASE   
             ENDCASE          
         CASE cntr = 2
            @ 13,51 GET Pr PICTURE '@!' VALID Chk(Pr,3)
            @ 14,51 GET Cpl PICTURE '@!' VALID Chk(Cpl,3)
            @ 15,51 GET Pl PICTURE '@!' VALID Chk(Pl,3)

            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  KEYBOARD CHR(13)
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  cntr = 3
             ENDCASE          
          CASE cntr = 3
             * Calculate Pressure at Discharge Temperature P1v
             P1v = 101325 * EXP( (VAL(Lvap)*VAL(Mw)/R) * (1/VAL(Tb) - 1/VAL(T1)) )
             
             * Calculate Effect of Friction on pipe F2
             IF Type = 'P'
                constf = .0015
                F2 = ( 1 / ( 1 + (4*constf*VAL(P)/VAL(Dp)) ) )
             ELSE
                F2 = 1
             ENDIF

             IF VAL(Pr) <= P1v
                cntr = 4
                LOOP
             ENDIF
             
             * Calculate Emission Rate Qm
             constc = .6
             Qm = convert( VAL(A0) * 1000 * SQRT( 2*constc^2*(VAL(Pr)-P1v)*VAL(Pl) +;
                  (F2/( VAL(Cpl)*VAL(T1))) * ( (VAL(Mw)*VAL(Lvap)*VAL(Pr))/(R*VAL(T1)) )^2 ) )
             @ 11,51 SAY LEFT(Qm+SPACE(8),8)                        
             IF VAL(Qm) <= 0
                WAIT 'Emission rate must be > 0, '+press WINDOW
                cntr = 2
                LOOP                      
             ELSE
                cntr = 5
             ENDIF   
          CASE cntr = 4
            DEFINE WINDOW msg FROM 6,12 TO 11,58 SHADOW COLOR &MesColor
            ACTIVATE WINDOW msg
            @ 1,0 SAY PADC('Invalid  combination of inputs !!!',44)
            @ 3,0 SAY PADC('Press any key to continue...',44)
            WAIT ""
            RELEASE WINDOW msg            
            cntr = 1             
          CASE cntr = 5
             DO EL2Keys
             IF prev           && F9
                RETURN
             ENDIF
             IF prcd           && F10

                DO s35x3
             ENDIF
             EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO

RETURN


************************* s35x3 ****************************************
PROCEDURE s35x3
           
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 3 of 4'
   @  3,3 SAY 'DISCHARGE DENSITY'
   @  4,3 SAY '                      Discharge Density (2) ->          kg/cubic m'
   @  9,3 SAY 'DENSITY OF AIR'
   @  10,3 SAY '                       Density of Air (air) ->          kg/cubic m'
   @  11,3 TO 13,75
   @  12,5 SAY '                  Ambient Temperature (Ta) -> ' + LEFT(Ta+SPACE(8),8) + ' K'

   @  12,51 FILL TO 12,58 COLOR &IPColor
   
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
          CASE cntr = 1  
             * Calculate Discharge Density RHO2
             rho2 = convert(1/( VAL(X2)*( (R*VAL(Ts))/(VAL(Pa)*VAL(Mw)) ) + ( (1-VAL(X2))/VAL(Pl) ) ))
             @  4,51 SAY LEFT(rho2+SPACE(8),8)
             cntr = 2       
          CASE cntr = 2
             @  12,51 GET Ta PICTURE '@!' VALID Chk(Ta,9)  	      
             READ
             DO CASE
                CASE LASTKEY() = 27  && ESCAPE
                   abort = .T.
                   EXIT 
                CASE LASTKEY() = 5   && UP 
                   cntr = 1
                CASE prev
                   RETURN   
                OTHERWISE      
                  rhoair = convert(VAL(Pa)*28.9/(R*VAL(Ta)))
                  @ 10,51 SAY LEFT(rhoair + SPACE(8),8)
                  IF VAL(rho2)/VAL(rhoair) > 1.02
                     buoyancy = 'N'
                     @ 14,3 SAY 'Buoyancy is Negative'
                  ELSE    
                     buoyancy = 'P'
                     @ 14,3 SAY 'Buoyancy is Positive'
                     IF VAL(rho2)/VAL(rhoair) > 1.00
                        DO DenseMsg
                     ENDIF
                  ENDIF
                   cntr = 3
             ENDCASE
         CASE cntr = 3   
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               *IF buoyancy = 'P'
               *   DO puffsub
               *ELSE
                  DO s35x4
               *ENDIF             
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN

******************************* s35x4 ************************************
PROCEDURE s35x4

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  0,3 SAY 'SOURCE PARAMETERS - Page 4 of 4'   
   @  2,3 SAY 'TIME'
   @  3,3 SAY '                         Release Duration (Td) ->          min'            
   @  4,3 TO 6,75
   @  5,5 SAY '       Total Amount of Material Released (Q) -> ' + LEFT(QKG+SPACE(8),8) + ' kg'
   @  5, 53 FILL TO 5,60 COLOR &IPColor                           
      
   IF buoyancy = 'N'
      @  8,3 SAY 'VERTICALLY DIRECTED JET'
      @  9,3 SAY '       Does the release result in a vertically '
      @ 10,3 SAY '                            directed jet (Y/N) -> '+LEFT(YN+' ',1)
      @ 10, 53 FILL TO 10,53 COLOR &IPColor   
   ENDIF   
 
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1            
            @ 5,53 GET QKG PICTURE '@!' VALID Chk(QKG,3)   
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  Q = convert(VAL(QKG)*1000)
                  * Calculate Release Duration (Dur)
                  Dur = convert(VAL(Q) / VAL(Qm) /60)
                  @ 3,53 SAY LEFT(Dur+SPACE(8),8) 
                  IF buoyancy = 'P'
                     cntr = 3
                  ELSE                     
                     cntr = 2
                  ENDIF                           
            ENDCASE                        
         CASE cntr = 2
         
            @ 10,53 GET YN PICTURE '@!' VALID ChkYN(YN)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  cntr = 3
            ENDCASE      
         CASE cntr = 3
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               IF buoyancy = 'P'
                  DO puffsub
               ELSE   
                  IF YN = 'Y'
                     DO rvdsub
                  ELSE
                     DO bmsub
                  ENDIF
               ENDIF   
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN
