* system : tscreen
* program : s36
* author : Kevin Stroupe, PES

R = 8314
g = 9.81
ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 1 of 4'
   @  6,3 SAY 'SOURCE OF LEAK'
   @  7,3 SAY '                Area (Ao) of Hole or Opening -> '+ LEFT(A0CM+SPACE(8),8) + ' cm'
   @  8,3 SAY '               Enter P for Pipe - T for Tank -> '+ LEFT(Type+' ',1)
   @ 12,3 SAY 'VAPOR PRESSURE'
   @ 13,3 SAY '                         Vapor Pressure (Pv) ->          Pa'
   @ 14,3 TO 19,75
   @ 15,5 SAY '        Latent Heat of Vaporization (Lvap) -> '+LEFT(Lvap+SPACE(8),8)+' J/kg'
   @ 16,5 SAY '            Boiling Point Temperature (Tb) -> '+LEFT(Tb+SPACE(8),8)+' K'
   @ 17,5 SAY '                Reservoir Temperature (T1) -> '+LEFT(T1+SPACE(8),8)+' K'
   @ 18,5 SAY '                     Molecular Weight (Mw) -> '+LEFT(Mw+SPACE(8),8)+' kg/kmol'
   
   @ 7, 51 FILL TO 7,58 COLOR &IPColor  
   @ 8, 51 FILL TO 8,51 COLOR &IPColor   
   @ 15, 51 FILL TO 15,58 COLOR &IPColor   
   @ 16, 51 FILL TO 16,58 COLOR &IPColor   
   @ 17, 51 FILL TO 17,58 COLOR &IPColor   
   @ 18, 51 FILL TO 18,58 COLOR &IPColor   
   
   cntr = 0
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE  
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 7,51 GET A0CM PICTURE '@!' VALID Chk(A0CM,3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  A0 = convert(VAL(A0CM)/10000)
                  D = convert(SQRT((4 * VAL(A0))/3.14159))                            
                  cntr = 2   
            ENDCASE         
         CASE cntr = 2
            @ 8,51 GET Type PICTURE '@!' VALID ChkPT(Type)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  IF Type = 'P'
                     cntr = 3                     
                  ELSE
                     Beta = 0
                     Dp = '1       '
                     @ 10, 3 CLEAR TO 11,75
                     cntr = 4   
                  ENDIF   
            ENDCASE      
         CASE cntr = 3
            @ 10,5 SAY '                        Pipe Diameter (Dp) -> '+LEFT(Dp+SPACE(8),8)+' m'                   
            @ 10,51 FILL TO 10,58 
            @ 10,51 GET Dp PICTURE '@!' VALID Chk(Dp,3)                        
            READ           
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 2
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  * Calculate flow area A1
                  A1 = 3.14159 * (VAL(Dp)/2)^2
                  Beta = SQRT(VAL(A0)/A1)
                  cntr = 4   
            ENDCASE      
         CASE cntr = 4
            @ 15,51 GET Lvap PICTURE '@!' VALID Chk(Lvap,3)                  
            @ 16,51 GET Tb PICTURE '@!' VALID Chk(Tb,9)
            @ 17,51 GET T1 PICTURE '@!' VALID Chk(T1,9)                       
            @ 18,51 GET Mw PICTURE '@!' VALID Chk(Mw,8)                       
            READ           
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  IF Type = 'P'
                     cntr = 3
                  ELSE
                     cntr = 2
                  ENDIF   
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  * Calculate Vapor Pressure (Pv)  
                  exponent = (VAL(Lvap)*VAL(Mw)/R) * ( (1/VAL(Tb)) - (1/VAL(T1)) )                  
                  Pv = convert(101325*EXP(exponent))
                  @ 13,51 SAY LEFT(Pv+SPACE(8),8) 
                  cntr = 5
                  
                  * Release temperature equal boiling temperature
                  Ts = Tb
                  
            ENDCASE      
         CASE cntr = 5
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               DO s36x2
             ENDIF   
             EXIT           
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
             
DEACTIVATE WINDOW datawind

RETURN
   

******************************* s36x2 ************************************
PROCEDURE s36x2

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 2 of 4'   
   @  3,3 SAY 'PRESSURE'
   @  4,3 SAY '          Liquid Pressure at Hole or Opening (P*) ->          Pa'
   IF Beta <= 0.2   
      @ 5,3 TO 11,75
   ELSE
      @ 5,3 TO 9,75
   ENDIF   
   @  6,5 SAY '                          Ambient Pressure (Pa) -> '+LEFT(Pa+SPACE(8),8) + ' Pa'
   @  7,5 SAY '                        Reservoir Pressure (P1) -> '+LEFT(Pr+SPACE(8),8) + ' Pa'
   @  8,4 SAY 'Contaminant Density (1) at Reservoir Conditions -> '+LEFT(Pl+SPACE(8),8) + ' kg/cubic m'
   IF Beta <= 0.2
      @  9,5 SAY '           Distance between the Hole or Opening '
      @ 10,5 SAY '                   and Top of Liquid Level (Hl) -> '+LEFT(H+SPACE(8),8) + ' m'
   ENDIF
   @ 13,3 SAY 'EMISSION'
   @ 14,3 SAY '                               Emission Rate (Qm) ->          g/s'

   @ 6,56 FILL TO 6,63 COLOR &IPColor
   @ 7,56 FILL TO 7,63 COLOR &IPColor  
   @ 8,56 FILL TO 8,63 COLOR &IPColor
   IF Beta <= 0.2
      @ 10,56 FILL TO 10,63 COLOR &IPColor
   ENDIF   

   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 6,56 GET Pa PICTURE '@!' VALID Chk(Pa,3)
            @ 7,56 GET Pr PICTURE '@!' VALID Chk(Pr,3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  IF VAL(Pr) < VAL(Pv)
                     DEFINE WINDOW msg FROM 10,13 TO 16,65 SHADOW COLOR &MesColor
                     ACTIVATE WINDOW msg
                     @ 1,0 SAY PADC('Reservoir Pressure must be  Vapor Pressure',53)
                     WAIT           
                     RELEASE WINDOW msg
                     KEYBOARD CHR(13)
                     cntr = 1
                  ELSE                  
                     cntr = 2
                  ENDIF   
             ENDCASE      
          CASE cntr = 2
             @ 8,56 GET Pl PICTURE '@!' VALID Chk(Pl,3)
             IF Beta <= 0.2
                @ 10,56 GET H PICTURE '@!' VALID Chk(H,2)
             ELSE
                H = '0       '   
             ENDIF   
             READ   
             DO CASE
                CASE LASTKEY() = 27  && ESCAPE
                   abort = .T.
                   EXIT 
                CASE LASTKEY() = 5   && UP 
                   KEYBOARD CHR(13)
                   cntr = 1
                CASE prev             && F9
                   RETURN   
                OTHERWISE                   
                   * Calculate Pressure at Hole or Opening Px
                   Px = convert((MAX(VAL(Pa),VAL(Pr))) + VAL(Pl)*g*VAL(H))
                   @ 4,56 SAY LEFT(Px+SPACE(8),8)            
                   cntr = 3       
             ENDCASE
          CASE cntr = 3      
             * Calculate Constant K
             ConstC = .65
             ConstK = ConstC/SQRT(1-Beta^4)
               
             IF (2*VAL(Pl)*((VAL(Px))-(VAL(Pa))) ) < 0
                cntr = 4
                LOOP
             ENDIF  
               
             * Calculate Emission Rate Qm
             g = 9.81
             Qm = convert(1000*ConstK*VAL(A0)*SQRT(2*VAL(Pl)*(VAL(Px)-VAL(Pa)) ))
             @ 14,56 SAY LEFT(Qm+SPACE(8),8)

             IF VAL(Qm) <= 0
                DEFINE WINDOW question FROM 10,13 TO 16,65 SHADOW COLOR &MesColor
                ACTIVATE WINDOW question
                @ 1,0 SAY PADC('Emission rate must be > 0.',53)
                WAIT           
                RELEASE WINDOW question    
                cntr = 1
             ELSE
                cntr = 5
             ENDIF   
          CASE cntr = 4
            DEFINE WINDOW msg FROM 6,12 TO 11,58 SHADOW COLOR &MesColor
            ACTIVATE WINDOW msg
            @ 1,0 SAY PADC('Invalid  combination of inputs !!!',44)
            @ 3,0 SAY PADC('Press any key to continue...',44)
            WAIT ""
            RELEASE WINDOW msg            
            cntr = 1
          CASE cntr = 5
             DO EL2Keys
             IF prev           && F9
                RETURN
             ENDIF
             IF prcd           && F10
                DO s36x3
             ENDIF
             EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO

RETURN


************************* s36x3 ****************************************
PROCEDURE s36x3

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 3 of 4'
   @  3,3 SAY 'DISCHARGE DENSITY'
   @  4,3 SAY '                      Discharge Density (2) ->          kg/cubic m'
   @  9,3 SAY 'DENSITY OF AIR'
   @ 10,3 SAY '                       Density of Air (air) ->          kg/cubic m'
   @ 11,3 TO 13,75
   @ 12,5 SAY '                  Ambient Temperature (Ta) -> ' + LEFT(Ta+SPACE(8),8) + ' K'

   @  12,51 FILL TO 12,58 COLOR &IPColor

   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
          CASE cntr = 1
             * Calculate Discharge Density RHO2
             rho2 = convert(VAL(Pa)*VAL(Mw)/(R*VAL(Ts)))
             @ 4,51 SAY LEFT(rho2 + SPACE(8),8)
             cntr = 2   
          CASE cntr = 2
             @  12,51 GET Ta PICTURE '@!' VALID Chk(Ta,9)  	      
             READ
             DO CASE
                CASE LASTKEY() = 27  && ESCAPE
                   abort = .T.
                   EXIT 
                CASE LASTKEY() = 5   && UP 
                   cntr = 1
                CASE prev
                   RETURN   
                OTHERWISE 
                  * Calculate Density of Air RHOair                 
                  rhoair = convert(VAL(Pa)*28.9/(R*VAL(Ta)))
                  @ 10,51 SAY LEFT(rhoair + SPACE(8),8)
                  IF  VAL(rho2)/VAL(rhoair) > 1.02
                     buoyancy = 'N'
                     @ 14,3 SAY 'Buoyancy is Negative'
                  ELSE    
                     buoyancy = 'P'
                     @ 14,3 SAY 'Buoyancy is Positive'
                     IF VAL(rho2)/VAL(rhoair) > 1.00
                        DO DenseMsg
                     ENDIF
                  ENDIF
                   cntr = 3
             ENDCASE
         CASE cntr = 3   
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               IF buoyancy = 'P'
                  DO scrnpsub
               ELSE
                  DO s36x4
               ENDIF             
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN

******************************* s36x4 ************************************
PROCEDURE s36x4

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  0,3 SAY 'SOURCE PARAMETERS - Page 4 of 4'
   @  2,3 SAY 'VERTICALLY DIRECTED JET'
   @  3,3 SAY '       Does the release result in a vertically '
   @  4,3 SAY '                            directed jet (Y/N) -> '+LEFT(YN+' ',1)
   @  6,3 SAY 'TIME'
   @  7,3 SAY '                         Release Duration (Td) ->          min'            
   @  8,3 TO 10,75
   @  9,5 SAY '       Total Amount of Material Released (Q) -> ' + LEFT(QKG+SPACE(8),8) + ' kg'
 
   @ 4, 53 FILL TO 4,53 COLOR &IPColor   
   @  9, 53 FILL TO 9,60 COLOR &IPColor                            

   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 4,53 GET YN PICTURE '@!' VALID ChkYN(YN)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  cntr = 2
            ENDCASE      
         CASE cntr = 2
            @ 9,53 GET QKG PICTURE '@!' VALID Chk(QKG,3)   
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  Q = convert(VAL(QKG)*1000)
                  * Calculate Release Duration (Dur)
                  Dur = convert(VAL(Q) / VAL(Qm) /60)
                  @ 7,53 SAY LEFT(Dur+SPACE(8),8) 
                  cntr = 3
            ENDCASE                  
         CASE cntr = 3
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               IF YN = 'Y'
                  DO rvdsub
               ELSE
                  DO bmsub
               ENDIF
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN

******************************* s36x4 ************************************
*PROCEDURE s36x4
*
*DO WHILE .NOT. abort
*   CLEAR
*   DO ClrEL1Key
*   DO endline1
*   DO EL1Keys
*   edit = .F.
*   prcd = .F.
*   @  0,3 SAY 'SOURCE PARAMETERS - Page 4 of 4'
*   @  2,3 SAY 'RELIEF VALVE'
*   @  3,3 SAY '      Is the release from a relief valve (Y/N) -> '+LEFT(YN+' ',1)
*   @  5,3 SAY 'RICHARDSON NUMBER'
*   @  6,3 SAY '                         Richardson Number-RVD ->'
*   
*   @ 3, 53 FILL TO 3,53 COLOR &IPColor   
*
*   cntr = 1
*   DO WHILE .NOT. abort
*      DO CASE
*         CASE cntr = 1
*            @ 3,53 GET YN PICTURE '@!' VALID ChkYN(YN)           
*            READ   
*            DO CASE
*               CASE LASTKEY() = 27  && ESCAPE
*                  abort = .T.
*                  EXIT 
*               CASE LASTKEY() = 5   && UP 
*                  cntr = 1
*               CASE prev             && F9
*                  RETURN                     
*               OTHERWISE
*                  cntr = 2
*            ENDCASE      
*         CASE cntr = 2
*            g = 9.81
*            * Calculate Richardson Number-RVD
*            RiRVD = convert(2725 * ( (VAL(rho2)/VAL(RhoAir) - 1) * VAL(Qm) ) / (VAL(D) * VAL(rho2)*1000))
*            IF VAL(RiRVD) > 30
*               DenseRVD = .T.
*               @ 6,53 SAY LEFT(RiRVD+SPACE(8),8)+' (Dense)'            
*            ELSE
*               DenseRVD = .F.
*               @ 6,53 SAY LEFT(RiRVD+SPACE(8),8)+' (Passive)'               
*            ENDIF   
*            
*            IF YN = 'N'            
*               RiBM = convert( ( (VAL(rho2) - VAL(RhoAir)) / VAL(RhoAir) ) *;
*                g * ( (VAL(Qm)/1000) / VAL(rho2) ) / VAL(D) )
*               IF VAL(RiBM) > 1/6^3
*                  DenseBM = .T.
*                  @ 7,3 SAY '                          Richardson Number-BM -> '+LEFT(RiBM+SPACE(8),8)+' (Dense)'                 
*               ELSE
*                  DenseBM = .F.
*                  @ 7,3 SAY '                          Richardson Number-BM -> '+LEFT(RiBM+SPACE(8),8)+' (Passive)'                  
*               ENDIF 
*            ELSE
*               @ 7,3 CLEAR TO 7,75
*               DenseBM = .F.   
*            ENDIF                            
*            IF DenseRVD .OR. DenseBM 
*               cntr = 3
*            ELSE 
*               cntr = 4
*               @ 9,3 CLEAR TO 13,75
*            ENDIF
*         CASE cntr = 3
*            @  9,3 SAY 'TIME'
*            @ 10,3 SAY '                         Release Duration (Td) ->          min'            
*	         @ 11,3 TO 13,75
*            @ 12,5 SAY '       Total Amount of Material Released (Q) -> ' + LEFT(QKG+SPACE(8),8) + ' kg'
*            @ 12, 53 FILL TO 12,60 COLOR &IPColor                           
*            @ 12,53 GET QKG PICTURE '@!' VALID Chk(QKG,3)   
*            READ   
*            DO CASE
*               CASE LASTKEY() = 27  && ESCAPE
*                  abort = .T.
*                  EXIT 
*               CASE LASTKEY() = 5   && UP 
*                  cntr = 1
*               CASE prev             && F9
*                  RETURN                     
*               OTHERWISE
*                  Q = convert(VAL(QKG)*1000)
*                  * Calculate Release Duration (Dur)
*                  Dur = convert(VAL(Q) / VAL(Qm) /60)
*                  @ 10,53 SAY LEFT(Dur+SPACE(8),8) 
*                  cntr = 4
*            ENDCASE                  
*         CASE cntr = 4   
*            DO EL2Keys
*            IF prev           && F9
*               RETURN
*            ENDIF                 
*            IF prcd           && F10
*               DO CASE
*                  CASE DenseRVD .AND. .NOT. DenseBM
*                     DO rvdsub
*                  CASE DenseRVD .AND. DenseBM 
*                     DO rvdbmsub
*                  CASE .NOT. DenseRVD .AND. DenseBM
*                     DO bmsub
*                  CASE .NOT. DenseRVD .AND. .NOT. DenseBM
*                     DO scrnpsub
*               ENDCASE      
*            ENDIF   
*            EXIT
*      ENDCASE
*      IF LASTKEY() = 27
*         abort = .T.
*         EXIT
*      ENDIF               
*   ENDDO  
*ENDDO   
*RETURN
