* Program: S39.prg
* System : TSCREEN
* Programmer: Kevin Stroupe, PES
* Modified by: Roger Brode, PES, 4/7/94
*   Corrected calculation of Ts to use MAX instead of MIN.

ACTIVATE WINDOW datawind

DO Inst_warning

R = 8314

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 1 of 4'
   @  6,3 SAY 'VOLUME'
   @  7,3 SAY '                Volume of Liquid Spilled (V) -> '+LEFT(V+SPACE(8),8) + ' cubic m'

   @  9,3 SAY 'TEMPERATURE'
   @ 10,3 SAY '                  Discharge Temperature (T2) ->          K'
   @ 11,3 TO 14,75
   @ 12,5 SAY '                  Storage Temperature (T1) -> '+LEFT(T1+SPACE(8),8) + ' K'
   @ 13,5 SAY '                  Ambient Temperature (Ta) -> '+LEFT(Ta+SPACE(8),8) + ' K'   
   @ 16,3 SAY 'PUDDLE AREA'  
   @ 17,3 SAY '     Is Maximum Puddle Area (Ap) Known (Y/N) -> '+LEFT(YN+SPACE(8),8)

   @ 7, 51 FILL TO 7,58 COLOR &IPColor  
   @ 12, 51 FILL TO 12,58 COLOR &IPColor  
   @ 13, 51 FILL TO 13,58 COLOR &IPColor  
   @ 17, 51 FILL TO 17,51 COLOR &IPColor   

   cntr = 0
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE  
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 7,51 GET V PICTURE '@!' VALID Chk(V,3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  * Calculate Spill Area
                  As  = convert(VAL(V) / .01)
                  cntr = 2   
            ENDCASE         
         CASE cntr = 2
            @ 12,51 GET T1 PICTURE '@!' VALID Chk(T1,9)            
            @ 13,51 GET Ta PICTURE '@!' VALID Chk(Ta,9)            
            READ           
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE
*                  Ts = Convert(MIN(VAL(T1),VAL(Ta)))
                  Ts = Convert(MAX(VAL(T1),VAL(Ta)))
                  @ 10,51 SAY LEFT(Ts+SPACE(8),8)                  
                  cntr = 3
            ENDCASE   
         CASE cntr = 3
            @ 17,51 GET YN PICTURE '@!' VALID ChkYN(YN)                  
            READ           
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  KEYBOARD CHR(13)
                  cntr = 2
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  IF YN = 'Y'
                     cntr = 4
                  ELSE
                     @ 18, 3 CLEAR TO 18,75
                     cntr = 5
                  ENDIF   
            ENDCASE   
         CASE cntr = 4
            @ 18,5 SAY '                  Maximum Puddle Area (Ap) -> '+LEFT(Ap+SPACE(8),8)+' m'                               
            @ 18,51 FILL TO 18,58 
            @ 18,51 GET Ap PICTURE '@!' VALID Chk(Ap,3)                        
            READ           
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 3
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  cntr = 5
            ENDCASE               
         CASE cntr = 5
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               DO s39x2
            ENDIF   
            EXIT           
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
             
DEACTIVATE WINDOW datawind

RETURN

******************************* s39x2 ************************************
PROCEDURE s39x2

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 2 of 4'
   @  3,3 SAY 'VAPOR PRESSURE'
   @  4,3 SAY '                         Vapor Pressure (Pv) ->          Pa'     
   @  5,3 TO 9,75   
   @  6,5 SAY '                     Molecular Weight (Mw) -> ' + LEFT(Mw+SPACE(8),8) + ' kg/kmol'
   @  7,5 SAY '        Latent Heat of Vaporization (Lvap) -> ' + LEFT(Lvap+SPACE(8),8) + ' J/kg'
   @  8,5 SAY '            Boiling Point Temperature (Tb) -> ' + LEFT(Tb+SPACE(8),8) + ' K'
*   @  9,5 SAY '                  Storage Temperature (T2) -> ' + LEFT(Ts+SPACE(8),8) + ' K'

   @ 6, 51 FILL TO 6,58 COLOR &IPColor   
   @ 7, 51 FILL TO 7,58 COLOR &IPColor   
   @ 8, 51 FILL TO 8,58 COLOR &IPColor   
*   @ 9, 51 FILL TO 9,58 COLOR &IPColor   
   
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 6,51 GET Mw PICTURE '@!' VALID Chk(Mw,8)
            @ 7,51 GET Lvap PICTURE '@!' VALID Chk(Lvap,3)
            @ 8,51 GET Tb PICTURE '@!' VALID Chk(Tb,9)
 *           @ 9,51 GET Ts PICTURE '@!' VALID Chk(Ts,9)            
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  * Calculate vapor pressure Pv
                  exponent = (VAL(Lvap)*VAL(Mw)/R) * ( (1/VAL(Tb)) - (1/VAL(Ts)) )                  
                  IF exponent > 88.02969
                     WAIT 'Invalid combination of inputs, '+press WINDOW
                     cntr = 1
                     LOOP
                  ELSE
                     Pv = convert(101325*EXP(exponent))
                     @ 4,51 SAY LEFT(Pv+SPACE(8),8) 
                     IF VAL(Pv) <= 0
                        WAIT 'Vapor Pressure must be > 0, '+press WINDOW
                        cntr = 1
                        LOOP
                     ENDIF
                  ENDIF               
                  cntr = 2
             ENDCASE          
          CASE cntr = 2
             DO EL2Keys
             IF prev           && F9
                RETURN
             ENDIF
             IF prcd           && F10
                DO s39x3
             ENDIF
             EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO

RETURN


************************* s39x3 ****************************************
PROCEDURE s39x3

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1   
   DO EL1Keys
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 3 of 4'   
   @  3,3 SAY 'EMISSION RATE'
   @  4,3 SAY '                          Emission Rate (Qm) ->          g/s'
   @  5,3 TO 7,75
   @  6,5 SAY '                           Wind Speed (Ur) -> '+LEFT(U+SPACE(8),8)+ ' m/s'
   @  9,3 SAY 'AREA'
   @ 10,3 SAY '                                        Area ->          m'   
   @ 12,3 SAY 'DISCHARGE DENSITY'
   @ 13,3 SAY '                      Discharge Density (2) ->          kg/cubic m'
   @ 15,3 SAY 'DENSITY OF AIR'
   @ 16,3 SAY '                       Density of Air (air) ->          kg/cubic m'
*   @ 16,3 TO 18,75
*   @ 17,5 SAY '                  Ambient Temperature (Ta) -> ' + LEFT(Ta+SPACE(8),8) + ' K'


   @  6,51 FILL TO 6,58 COLOR &IPColor
*   @  17,51 FILL TO 17,58 COLOR &IPColor
   
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
          CASE cntr = 1
             @  6,51 GET U PICTURE '@!' VALID Chk(U,3)  	      
             READ
             DO CASE
                CASE LASTKEY() = 27  && ESCAPE
                   abort = .T.
                   EXIT 
                CASE LASTKEY() = 5   && UP 
                   cntr = 2
                CASE prev
                   RETURN   
                OTHERWISE                    
                   IF YN = 'Y'
                     IF VAL(Ap) > VAL(As)
                        A = As
                     ELSE
                        A = Ap
                     ENDIF
                   ELSE
                      A = As  
                   ENDIF
                        
                   * Calculate Vapor Pressure Pvh of hydrazine at Ts
                   Pvh = EXP( 76.8580 - (7245.2/VAL(Ts)) - 8.22*LOG(VAL(Ts)) ;
                         + 0.0061557*VAL(Ts) )
                         
                   * Calculate Emission Rate Qm
                   Qm = convert(1000 * 6.94E-7 * (1+.0043*IIF(VAL(Ts)-273.15 < 0,0,(VAL(Ts)-273.15)^2))*;
                           VAL(U)^.75 * VAL(A) * VAL(Mw) * VAL(Pv)/Pvh )                 
                     
                  @ 4,51 SAY LEFT(Qm+SPACE(8),8)
                  @ 10,51 SAY LEFT(A+SPACE(8),8)
                  cntr = 2
                  
                  * Calculate diameter of the puddle
                  D = convert(SQRT((4 * VAL(A))/3.14159))                            
             ENDCASE  
          CASE cntr = 2             
             * Calculate Discharge Density RHO2
             rho2 = convert(VAL(Pa)*VAL(Mw)/(R*VAL(Ts)))
             @  13,51 SAY LEFT(rho2+SPACE(8),8)
             cntr = 3
          CASE cntr = 3
*             @  17,51 GET Ta PICTURE '@!' VALID Chk(Ta,9)  	      
*             READ
*             DO CASE
*                CASE LASTKEY() = 27  && ESCAPE
*                   abort = .T.
*                   EXIT 
*                CASE LASTKEY() = 5   && UP 
*                   cntr = 2
*                CASE prev
*                   RETURN   
*                OTHERWISE                   
                  rhoair = convert(VAL(Pa)*28.9/(R*VAL(Ta)))
                  @ 16,51 SAY LEFT(rhoair + SPACE(8),8)
                  IF VAL(rho2)/VAL(rhoair) > 1.02
                     buoyancy = 'N'
                     @ 18,3 SAY 'Buoyancy is Negative'
                  ELSE 
                     buoyancy = 'P'
                     @ 18,3 SAY 'Buoyancy is Positive'
                     IF VAL(rho2)/VAL(rhoair) > 1.00
                        DO DenseMsg
                     ENDIF
                  ENDIF
                  cntr = 4
 *            ENDCASE
         CASE cntr = 4
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               *IF buoyancy = 'P'
               *   DO puffsub
               *ELSE
                  DO s39x4
               *ENDIF             
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN
                        
******************************* s39x4 ************************************
PROCEDURE s39x4

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  0,3 SAY 'SOURCE PARAMETERS - Page 4 of 4'   
   @  2,3 SAY 'TIME'
   @  3,3 SAY '                         Release Duration (Td) ->          min'            
   @  4,3 TO 6,75
   @  5,5 SAY '       Total Amount of Material Released (Q) -> ' + LEFT(Qkg+SPACE(8),8) + ' kg'
   @  5, 53 FILL TO 5,60 COLOR &IPColor                           
       
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1            
            @ 5,53 GET Qkg PICTURE '@!' VALID Chk(Qkg,3)   
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  Q = convert(VAL(Qkg)*1000)
                  * Calculate Release Duration (Dur)
                  Dur = convert(VAL(Q) / VAL(Qm) /60)
                  @ 3,53 SAY LEFT(Dur+SPACE(8),8) 
                  cntr = 2
            ENDCASE                        
         CASE cntr = 2
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               IF buoyancy = 'P'
                  DO puffsub
               ELSE   
                  DO bmsub
               ENDIF   
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN
