C***********************************************************************
C
C                       **************************
C                       ***       SCREEN3      ***
C                       ***   (DATED  95250)   ***
C                       **************************
C
C        MODIFIED FROM:
C
C                       **************************
C                       ***       SCREEN2      ***
C                       ***   (DATED  92245)   ***
C                       **************************
C
C        MODIFIED FROM:
C
C                       **************************
C                       *** SCREEN-1.1 PROGRAM ***
C                       ***   (DATED  88300)   ***
C                       **************************
C
C***********************************************************************
C
C        MODIFIED BY:
C
C              ROGER W. BRODE
C              PACIFIC ENVIRONMENTAL SERVICES, Inc.
C              5001 SOUTH MIAMI BLVD., SUITE 300
C              P.O. BOX 12077
C              RESEARCH TRIANGLE PARK, NORTH CAROLINA 27709
C
C        MODIFICATION DATE:
C
C              SEPTEMBER 7, 1995
C
C        MODIFICATIONS INCLUDE:
C
C              INCORPORATION OF THE MODIFIED AREA SOURCE ALGORITHM
C              BASED ON THE ISCST3 MODEL (DATED 95250).
C              THIS NEW ALGORITHM USES A NUMERICAL INTEGRATION OF THE
C              POINT SOURCE FUNCTION OVER THE AREA TO ESTIMATE IMPACTS.
C              IT ALLOWS FOR RECTANGULAR-SHAPED AREAS, AND ALSO WILL
C              ESTIMATE IMPACTS WITHIN THE AREA ITSELF.  SINCE MAXIMUM
C              IMPACTS AT A GIVEN DISTANCE ARE A FUNCTION OF WIND
C              DIRECTION FOR RECTANGULAR AREAS, THE MODEL SEARCHES
C              THROUGH A RANGE OF WIND DIRECTIONS BASED ON A SERIES OF
C              LOOK-UP TABLES (AS A FUNCTION OF STABILITY CLASS, ASPECT
C              RATIO AND NORMALIZED DOWNWIND DISTANCE) TO DETERMINE THE
C              MAXIMUM IMPACT.  THE USER ALSO HAS THE OPTION OF SPECIFYING
C              A WIND DIRECTION ORIENTATION RELATIVE TO THE LONG DIMENSION
C              OF THE AREA.
C
C              A DRY DEPOSITION ALGORITHM BASED ON THE DEPST MODEL HAS ALSO
C              BEEN ADDED, BUT HAS NOT BEEN ACTIVATED.  THIS ALGORITHM IS
C              NOT COMPLETELY CONSISTENT WITH THE DRY DEPOSITION ALGORITHM
C              IN THE ISCST3 MODEL.
C
C              TWO MINOR BUGS WERE ALSO CORRECTED.  ONE BUG ALLOWED
C              FUMIGATION CALCULATIONS TO BE PERFORMED FOR FLARE SOURCES
C              UNDER URBAN CONDITIONS.  THE OTHER BUG INVOLVED USE OF
C              AN ERRORNEOUS VARIABLE NAME WHEN CHECKING FOR A NEGATIVE
C              SOURCE WIDTH FOR AREA SOURCES.
C
C***********************************************************************
C
C        MODIFIED BY:
C
C              ROGER W. BRODE
C              PACIFIC ENVIRONMENTAL SERVICES, Inc.
C              5001 SOUTH MIAMI BLVD., SUITE 300
C              P.O. BOX 12077
C              RESEARCH TRIANGLE PARK, NORTH CAROLINA 27709
C
C        MODIFICATION DATE:
C
C              SEPTEMBER 1, 1992
C
C        MODIFICATIONS INCLUDE:
C
C              UPDATING CODE FOR COMPATIBILITY WITH ISCST2 (92062).
C              THIS ESPECIALLY INCLUDES DOWNWASH ALGORITHMS.  SCREEN
C              MODEL CODE, ESPECIALLY SUBROUTINE USERX, HAS BEEN
C              RESTRUCTURED SLIGHTLY TO MAKE MAXIMUM USE OF ISC2
C              CALCULATION ROUTINES.
C
C              AREA SOURCE ALGORITHM IN SCREEN HAS BEEN MODIFIED
C              TO USE FINITE LINE SEGMENT APPROACH FOR COMPATIBILITY
C              WITH ISCST2 (92062).  DISTANCES ARE NOW MEASURED FROM
C              THE CENTER OF THE AREA (RATHER THAN FROM DOWNWIND EDGE
C              AS DONE WITH PREVIOUS VIRTUAL POINT SOURCE IMPLEMENTATION).
C              INPUT EMISSIONS ARE NOW IN GRAMS/(SEC-M**2), FOR
C              CONSISTENCY WITH ISCST2.
C
C              A NEW VOLUME SOURCE OPTION HAS BEEN ADDED FOR CONSISTENCY
C              WITH ISCST2 (92062).  USES A VIRTUAL POINT SOURCE APPROACH.
C
C              MODIFICATIONS HAVE BEEN MADE TO THE ITERATION ROUTINE TO
C              SEARCH FOR THE PEAK CONCENTRATION, AND F STABILITY HAS
C              BEEN ADDED TO THE URBAN OPTION.  ADDITIONAL WIND SPEEDS
C              IN 0.5 M/S INCREMENTS HAVE BEEN ADDED FOR SPEEDS < 5 M/S.
C              THESE CHANGES ARE INTENDED TO IMPROVE THE PERFORMANCE OF
C              SCREEN AS A CONSERVATIVE SCREENING TOOL RELATIVE TO ISCST2.
C
C              AN OPTION HAS BEEN ADDED TO INPUT THE VOLUMETRIC FLOW
C              RATE FOR STACK (i.e. POINT) RELEASES IN LIEU OF STACK
C              GAS EXIT VELOCITY.  FLOW RATE CAN BE INPUT IN AFCM OR
C              M**3/S.
C
C***********************************************************************
C
C        PC VERSION OF THE SCREENING PROCEDURES DOCUMENT, EPA-450/
C        4-88-010, FOR ESTIMATING MAXIMUM SHORT-TERM CONCENTRATIONS
C        FROM STATIONARY SOURCES.  THIS VERSION OF THE SCREEN MODEL
C        OFFERS AN ARRAY OF PRE-SELECTED DISTANCES AND ALSO
C        ACCEPTS USER-SPECIFIED DISTANCES. 
C
C        BUILDING DOWNWASH, FUMIGATION, AND COMPLEX TERRAIN SCREENING
C        CALCULATIONS ARE INCLUDED.  SIMPLE ROUTINES ARE ALSO
C        INCLUDED TO HANDLE RELEASES FROM FLARES AND FOR
C        SIMPLE AREA SOURCES.
C
C        A MECHANISM IS PROVIDED TO ACCOUNT FOR THE EFFECTS OF
C        TERRAIN BELOW STACK HEIGHT ON THE SIMPLE TERRAIN SCREENING
C        CALCULATIONS.
C
C        PROGRAMMED BY:
C
C                ROGER W. BRODE               THOMAS E. PIERCE 
C                U.S. EPA (MD-14)     AND     U.S. EPA (MD-80)
C                RTP, NC 27711                RTP, NC 27711
C
C        INPUT VARIABLES
C           Q    EMISSION RATE (G/S)
C           HS   STACK HT (M)
C           DS   STACK INSIDE DIAMETER (M)
C           VS   STACK GAS EXIT VELOCITY (M/S)
C           TS   STACK GAS TEMPERATURE (K)
C           TA   AMBIENT AIR TEMPERATURE (K)
C           ZR   RECEPTOR HEIGHT ABOVE GROUND (FLAGPOLE RECEPTOR) (M)
C           HB   BUILDING HEIGHT (M)
C           HL   MINIMUM HORIZ. BUILDING DIMENSION (M)
C           HW   MAXIMUM HORIZ. BUILDING DIMENSION (M)
C           IOPT URBAN/RURAL OPTION (U = URBAN, R = RURAL)
C           HTER MAXIMUM TERRAIN HEIGHT ABOVE STACK BASE (M)
C           X    DOWNWIND DISTANCE (M)
C
C        PARAMETERS
C           XAUTO ARRAY OF AUTOMATED DISTANCES
C           IRD   UNIT NUMBER FOR INPUT FROM KEYBOARD
C           IPRT  UNIT NUMBER FOR OUTPUT TO TERMINAL
C           IOUT  UNIT NUMBER FOR OUTPUT TO DISK FILE (SCREEN.OUT)
C           IDAT  UNIT NUMBER FOR CREATING INPUT DATA FILE (SCREEN.DAT)
C           
C        ROUTINES CALLED
C           INPUTP RETURNS INPUT DATA FOR POINT SOURCE
C           INPUTF RETURNS INPUT DATA FOR FLARE RELEASE
C           INPUTA RETURNS INPUT DATA FOR AREA SOURCE
C           INPUTV RETURNS INPUT DATA FOR VOLUME SOURCE
C           CHOICE SETS PARAMETERS TO CONTROL CHOICE OF METEOROLOGY
C           AUTOX  EXECUTES AUTOMATED DISTANCE OPTION
C           DISCX  EXECUTES DISCRETE DISTANCE OPTION
C           USERX  RETURNS MAX CONC AND THE CONDITIONS ASSOCIATED
C                  WITH THE MAX AT DISTANCE X (CALLED FROM SUB. AUTOX 
C                  AND DISCX)
C           CAVITY RETURNS MAX CONC, CAVITY HT, AND LENGTH OF 
C                  CAVITY IF PLUME IS FOUND TO BE ENTRAPPED IN 
C                  THE CAVITY RECIRCULATION REGION
C           FUMI   RETURNS MAX CONC AND DISTANCE TO MAX DUE TO 
C                  INVERSION BREAK-UP FUMIGATION CONDITIONS
C           FUMS   RETURNS MAX CONC AND DISTANCE TO MAX DUE TO 
C                  SHORELINE FUMIGATION CONDITIONS (IF APPLICABLE)
C           VALLEY RETURNS 24-HR CONCENTRATION FOR RECEPTORS ABOVE
C                  STACK HEIGHT USING VALLEY MODEL SCREENING TECHNIQUE 
C                  AND SIMPLE TERRAIN SCREENING PROCEDURES FOLLOWING 
C                  GUIDANCE (CALLED FROM SUB. INPUTP AND INPUTF)
C
C
      INCLUDE 'MAIN.INC'
      INTEGER*2 IPTHR, IPTMIN, IPTSEC, IPTHUN, IPTYR, IPTMON, IPTDAY
      CHARACTER*30 QVAR
      CHARACTER*80 BUF80
C
C        INITIALIZE VARIABLES
C
      OUTFIL = 'SCREEN.OUT'
      SYINIT = 0.
      SZINIT = 0.
      HB   = 0.
      HL   = 0.
      HW   = 0.
      HWP  = 0.
      DX   = 0.
      IOUT1= 13
      IOUT2= 14
      IOUT3= 15
      IERR = 10
      IDSCR= 16
      IPLT = 12
      POINT  = .FALSE.
      FLARE  = .FALSE.
      AREA   = .FALSE.
      VOLUME = .FALSE.
      DISC   = .FALSE.
      DEBUG  = .FALSE.
C
C        VALUES ASSOCIATED WITH MAXIMUM CONCENTRATIONS FOR EACH 
C        CALCULATION PROCEDURE: -ST FOR SIMPLE TERRAIN, -CT FOR 
C        COMPLEX TERRAIN, -IF FOR INVERSION BREAKUP FUMIGATION,
C        AND -SF FOR SHORELINE FUMIGATION.
C
      CMAXST = 0.0
      XMAXST = 0.0
      TMAXST = 0.0
      DMAXST = 0.0
      XMXDST = 0.0
      TMXDST = 0.0
      CMAXCT = 0.0
      XMAXCT = 0.0
      TMAXCT = 0.0 
      CMAXIF = 0.0
      XMAXIF = 0.0
      CMAXSF = 0.0
      XMAXSF = 0.0
      CAVCHI(1) = 0.0
      CAVCHI(2) = 0.0
C
C        HT, RMIN, AND RMAX TO KEEP TRACK OF TERRAIN HEIGHTS AND 
C        DISTANCE RANGES FOR SIMPLE TERRAIN PROCEDURES.
C
      IT = 0
      DO 60 I=1,50
         HT(I) = 0.0
         RMIN(I) = 0.0
         RMAX(I) = 0.0
60    CONTINUE
C
C        CALL DATE AND TIME FUNCTIONS, EITHER LAHEY OR MICROSOFT.
C
$IF DEFINED (LAHEY)
      CALL DATE(RUNDAT)
      CALL TIME(RUNTIM)
$ELSE
      CALL GETDAT(IPTYR, IPTMON, IPTDAY)
      CALL GETTIM(IPTHR, IPTMIN, IPTSEC, IPTHUN)
C     Convert Year to Two Digits
      IPTYR = IPTYR - 100*INT(IPTYR/100)
C     Write Date and Time to Character Variables, RUNDAT & RUNTIM
      WRITE(RUNDAT,'(2(I2.2,1H/),I2.2)') IPTMON, IPTDAY, IPTYR
      WRITE(RUNTIM,'(2(I2.2,1H:),I2.2)') IPTHR, IPTMIN, IPTSEC
$ENDIF
C
C***********************************************************************
C        BEGIN USER INPUT 
C***********************************************************************
C
C      WRITE(IPRT,108)
C      WRITE(IPRT,109) VERSN
C 108  FORMAT(1X,' ******  SCREEN3 MODEL  ******')
C 109  FORMAT(1X,' **** VERSION DATED ',A5,' ****')
C      WRITE(IPRT,*) ' '
C94    WRITE(IPRT,*) 'ENTER NAME FOR OUTPUT FILE'
C      READ(IRD,95) OUTFIL
C95    FORMAT(A12)
C
      OPEN(IOUT,FILE=OUTFIL,STATUS='UNKNOWN')
      OPEN(IDAT,FILE='SCREEN.DAT',STATUS='UNKNOWN')
C PES ADDED CODE BEGINS
      OPEN(IPLT,FILE='GRAPH.FIL',STATUS='UNKNOWN')
      OPEN(IOUT1,FILE='SCRN1.OUT',STATUS='UNKNOWN')
      OPEN(IOUT2,FILE='SCRN2.OUT',STATUS='UNKNOWN')
      OPEN(IOUT3,FILE='SCRN3.OUT',STATUS='UNKNOWN')
      OPEN(IDSCR,FILE='DISTNUM',STATUS='UNKNOWN')
      OPEN(IERR,FILE='ERROR.OUT',STATUS='UNKNOWN')
      READ(IDSCR,*) XNUMDIS,XNUMHT
C PES ADDED CODE ENDS
C
C PES MODIFIED CODE BEGINS
C
C      WRITE(IPRT,*) ' '
C      WRITE(IPRT,*) 'ENTER TITLE FOR THIS RUN (UP TO 79 CHARACTERS):'
      QVAR = 'TITLE'
      READ(IRD,79,ERR=999) TITLE
      WRITE(IDAT,79) TITLE
C      IF (TITLE(75:79) .EQ. 'DEBUG') THEN
CC        Debug output option selected if last five columns of TITLE = 'DEBUG'
C         DEBUG = .TRUE.
C         OPEN(IDBG,FILE='SCREEN.DBG',STATUS='UNKNOWN')
C      END IF
C      WRITE(IPRT,*) ' '
C2     WRITE(IPRT,81)
CCDEP  Change FORMAT statement to remove deposition options.
C81    FORMAT(' ENTER SOURCE TYPE: P    FOR POINT  ',/
C     &       '                    F    FOR FLARE  ',/
C     &       '                    A    FOR AREA   ',/
C     &       '                    V    FOR VOLUME ')
      QVAR = 'SOURCE'
CRWB81    FORMAT(' ENTER SOURCE TYPE: P    FOR POINT  - NO DEPOSITION ',/
CRWB     &       '                    F    FOR FLARE  - NO DEPOSITION ',/
CRWB     &       '                    A    FOR AREA   - NO DEPOSITION ',/
CRWB     &       '                    V    FOR VOLUME - NO DEPOSITION ',/
CRWB     &       '                    PDEP FOR POINT  - WITH DEPOSITION',/
CRWB     &       '                    FDEP FOR FLARE  - WITH DEPOSITION',/
CRWB     &       '                    ADEP FOR AREA   - WITH DEPOSITION',/
CRWB     &       '                    VDEP FOR VOLUME - WITH DEPOSITION')
2     READ(IRD,400,ERR=999) OPTG
C PES MODIFIED CODE ENDS
      CALL LWRUPR
      SOURCE = OPTG(1:4)
79    FORMAT(A79)
400   FORMAT(A80)
100   FORMAT(A1)
40    FORMAT(A4)
      IF (SOURCE.EQ.'P   ') THEN
         POINT = .TRUE.
         WRITE(IDAT,40) SOURCE
         CALL INPUTP
      ELSE IF (SOURCE.EQ.'F   ') THEN
         FLARE = .TRUE.
         WRITE(IDAT,40) SOURCE
         CALL INPUTF
      ELSE IF (SOURCE.EQ.'A   ') THEN
         AREA = .TRUE.
         WRITE(IDAT,40) SOURCE
         CALL INPUTA
      ELSE IF (SOURCE.EQ.'V   ') THEN
         VOLUME = .TRUE.
         WRITE(IDAT,40) SOURCE
         CALL INPUTV
CDEP  Comment out the deposition source options.
CRWB      ELSE IF (SOURCE.EQ.'PDEP') THEN
CRWB         POINT  = .TRUE.
CRWB         LDEP   = .TRUE.
CRWB         WRITE(IDAT,40) SOURCE
CRWB         CALL INPDEP
CRWB         CALL VDP1
CRWB      ELSE IF (SOURCE.EQ.'FDEP') THEN
CRWB         FLARE  = .TRUE.
CRWB         LDEP   = .TRUE.
CRWB         WRITE(IDAT,40) SOURCE
CRWB         CALL INFDEP
CRWB         CALL VDP1
CRWB      ELSE IF (SOURCE.EQ.'ADEP') THEN
CRWB         AREA   = .TRUE.
CRWB         LDEP   = .TRUE.
CRWB         WRITE(IDAT,40) SOURCE
CRWB         CALL INADEP
CRWB         CALL VDP1
CRWB      ELSE IF (SOURCE.EQ.'VDEP') THEN
CRWB         VOLUME = .TRUE.
CRWB         LDEP   = .TRUE.
CRWB         WRITE(IDAT,40) SOURCE
CRWB         CALL INVDEP
CRWB         CALL VDP1
      ELSE
         GO TO 2
      END IF
C
C        SEE IF USER WANTS TO STOP AFTER COMPLEX TERRAIN CALCS-STP=.TRUE.
C
      IF (STP) GO TO 4
C
C***********************************************************************
C        CHECK FOR USE OF SIMPLE ELEVATED TERRAIN 
C***********************************************************************
C
      IF (POINT .OR. FLARE .OR. VOLUME) THEN
C25       WRITE(IPRT,*) 'USE SIMPLE TERRAIN SCREEN WITH TERRAIN',
C     &                 ' ABOVE STACK BASE?'
C         WRITE(IPRT,*) 'ENTER Y OR N:'
         QVAR = 'SIMPLE TERRAIN QUERY'
25       READ(IRD,100,END=999) QUERY
         IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
            ELEV = .TRUE.
            FLAT = .FALSE.
         ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
            FLAT = .TRUE.
            ELEV = .FALSE.
         ELSE
            GO TO 25
         END IF
         WRITE(IDAT,100) QUERY
      ELSE
         FLAT = .TRUE.
         ELEV = .FALSE.
      END IF
C
C        CALCULATE BUOYANCY AND MOMENTUM FLUX AND WRITE TO FILE.
C
      IF (TA .GT. TS) THEN
         TS = TA
         FB = 0.0
         FM = TA*VS*VS*DS*DS/(4.*TS)
C         WRITE(IPRT,*) 'TA > TS!!!  BUOY. FLUX SET = 0.0'
         WRITE(IOUT3,*) 'TA > TS!!!  BUOY. FLUX SET = 0.0'
      ELSE
         FB = G*VS*DS*DS*(TS-TA)/(4.*TS)
         FM = TA*VS*VS*DS*DS/(4.*TS)
      END IF
      WRITE(IOUT3,110) FB,FM
110   FORMAT(/,1X,'BUOY. FLUX =',F9.3,' M**4/S**3;  MOM. FLUX =',
     &       F9.3,' M**4/S**2.',/)
C***********************************************************************
C        SPECIFY CHOICE OF METEOROLOGY
C***********************************************************************
C3     WRITE(IPRT,*) 'ENTER CHOICE OF METEOROLOGY;'
C      WRITE(IPRT,*) '1 - FULL METEOROLOGY (ALL STABILITIES & WIND',
C     &                                    ' SPEEDS)'
C      WRITE(IPRT,*) '2 - INPUT SINGLE STABILITY CLASS'
C      WRITE(IPRT,*) '3 - INPUT SINGLE STABILITY CLASS AND WIND SPEED'
      QVAR = 'IMET'
3     READ(IRD,*,ERR=999) IMET
      IF (IMET.NE.1 .AND. IMET.NE.2 .AND. IMET.NE.3) GO TO 3
C
      CALL CHOICE(IMET)
C
C**********************************************************************
C        AUTOMATED DISTANCE SECTION
C**********************************************************************
C
C5     WRITE(IPRT,*) 'USE AUTOMATED DISTANCE ARRAY?',
C     &              ' ENTER Y OR N:'
      QVAR = 'AUTO DIST QUERY'
5     READ(IRD,100,ERR=999) QUERY
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,100) QUERY
         CALL AUTOX(IT,CMAXST,XMAXST,TMAXST,DMAXST,XMXDST,TMXDST)
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,100) QUERY
         CONTINUE
      ELSE
         GO TO 5
      END IF
C
C**********************************************************************
C        DISCRETE (USER-SPECIFIED) DISTANCE SECTION
C**********************************************************************
C
C      WRITE(IPRT,*) ' '
C7     WRITE(IPRT,*) 'USE DISCRETE DISTANCES?',
C     &              '  ENTER Y OR N: '
      QVAR = 'DISCRETE DIST QUERY'
7     READ(IRD,100,ERR=999) QUERY
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,100) QUERY
         DISC = .TRUE.
         CALL DISCX(IT,CMAXST,XMAXST,TMAXST,DMAXST,XMXDST,TMXDST)
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,100) QUERY
         CONTINUE
      ELSE
         GO TO 7
      END IF
C***********************************************************************
C        SUMMARIZE TERRAIN HEIGHTS ENTERED FOR SIMPLE ELEVATED
C        TERRAIN PROCEDURE.
C***********************************************************************
      IF (.NOT.FLAT) THEN
         WRITE(IOUT3,510)
510      FORMAT(/1X,' ********************************************',
     &         /,1X,' *  SUMMARY OF TERRAIN HEIGHTS ENTERED FOR  *',
     &         /,1X,' *    SIMPLE ELEVATED TERRAIN PROCEDURE     *',
     &         /,1X,' ********************************************',
     &        //,1X,'      TERRAIN        DISTANCE RANGE (M)',
     &         /,1X,'       HT (M)       MINIMUM     MAXIMUM',
     &         /,1X,'      -------      --------    --------')
         DO 80 I = 1,50
            IF (RMIN(I) .GT. 0.0) THEN
               IF (RMAX(I) .GT. 0.0) THEN
                  WRITE(IOUT3,520) HT(I),RMIN(I),RMAX(I)
520               FORMAT(8X,F6.0,7X,F7.0,5X,F7.0)
               ELSE
                  WRITE(IOUT3,530) HT(I),RMIN(I)
530               FORMAT(8X,F6.0,7X,F7.0,9X,'--')
               END IF
            END IF
80       CONTINUE
      END IF
C
C***********************************************************************
C        PERFORM CAVITY CALCULATIONS & PRINT RESULTS FOR TWO
C        ORIENTATIONS - HL ALONGWIND FIRST, THEN HW ALONGWIND.
C***********************************************************************
C
      IF (HB.GT.0. .AND. HW.GT.0. .AND. HL.GT.0.) THEN
         CALL CAVITY
      END IF
C
C***********************************************************************
C        PERFORM OPTIONAL FUMIGATION CALCULATIONS IF RURAL CONDITIONS
C        APPLY.  INVERSION BREAK-UP FUMIGATION CALCULATION FIRST.
C***********************************************************************
C
      IF (RURAL .AND. HS.GE.10. .AND. (POINT .OR. FLARE)) THEN
C         WRITE(IPRT,*) ' '
C8        WRITE(IPRT,*) 'DO YOU WISH TO MAKE A FUMIGATION CALCULATION?',
C     &                 ' ENTER Y OR N:'
         QVAR = 'FUM CALC QUERY'
8        READ(IRD,100,ERR=999) QUERY
         IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
            WRITE(IDAT,100) QUERY
            CALL FUMI(CMAXIF,XMAXIF)
C
C***********************************************************************
C        DETERMINE MAXIMUM SHORELINE FUMIGATION CONCENTRATION
C        FOR SITES WITHIN 3000 M OF LARGE BODY OF WATER.
C***********************************************************************
C
C            WRITE(IPRT,*) ' '
C9           WRITE(IPRT,*) 'CONSIDER SHORELINE FUMIGATION (<=3000M FROM',
C     &                    ' SHORE)?  ENTER Y OR N:'
            QVAR = 'QUERY2'
9           READ(IRD,100,ERR=999) QUERY2
            IF (QUERY2 .EQ. 'Y' .OR. QUERY2 .EQ. 'y') THEN
               WRITE(IDAT,100) QUERY2
C50             WRITE(IPRT,*) 'ENTER SHORTEST DISTANCE TO SHORELINE (M):'
               QVAR = 'XS'
50             READ(IRD,*,ERR=999) XS
               WRITE(IDAT,*) XS
               CALL FUMS(CMAXSF,XMAXSF)
            ELSE IF (QUERY2 .EQ. 'N' .OR. QUERY2 .EQ. 'n') THEN
               WRITE(IDAT,100) QUERY2
               CONTINUE
            ELSE
               GO TO 9
            END IF
         ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
            WRITE(IDAT,100) QUERY
            CONTINUE
         ELSE
            GO TO 8
         END IF
      END IF
C
C***********************************************************************
C        PRINT SUMMARY OF RESULTS
C*********************************************************************** 
C
4     CONTINUE
C
C      WRITE(IPRT,900)
      WRITE(IOUT2,900)
900   FORMAT(/,6X,
     &   '***************************************',/,6X,
     &   '*** SUMMARY OF SCREEN MODEL RESULTS ***',/,6X,
     &   '***************************************')
      IF (LDEP) THEN
C       WRITE(IPRT,911)
       WRITE(IOUT2,911)
911    FORMAT(/2X,'CALCULATION',6X,'MAX CONC',3X,'DIST TO',2X,'TERRAIN',
     &                         5X,'MAX DEPOS',3X,'DIST TO',2X,'TERRAIN',
     &    /,3X,'PROCEDURE',6X,'(UG/M**3)',3X,'MAX (M)',3X,'HT (M)',
     &                     4X,'(G/M**2-HR)',2X,'MAX (M)',3X,'HT (M)',
     &    /,1X,'--------------  -----------  -------  -------',
     &                      4X,'-----------  -------  -------')
       IF (CMAXST .GT. 0.0 .OR. DMAXST .GT. 0.0) THEN
C          WRITE(IPRT,921) CMAXST,XMAXST,TMAXST,DMAXST,XMXDST,TMXDST
          WRITE(IOUT2,921) CMAXST,XMAXST,TMAXST,DMAXST,XMXDST,TMXDST
921       FORMAT(1X,'SIMPLE TERRAIN',3X,G10.4,2X,F7.0,4X,F5.0,
     &                               5X,G10.4,2X,F7.0,4X,F5.0,/)
       END IF

      ELSE
C       WRITE(IPRT,910)
       WRITE(IOUT2,910)
910    FORMAT(/2X,'CALCULATION',6X,'MAX CONC',3X,'DIST TO',2X,'TERRAIN',
     &    /,3X,'PROCEDURE',6X,'(UG/M**3)',3X,'MAX (M)',3X,'HT (M)',
     &    /,1X,'--------------  -----------  -------  -------')
       IF (CMAXST .GT. 0.0) THEN
C          WRITE(IPRT,920) CMAXST,XMAXST,TMAXST
          WRITE(IOUT2,920) CMAXST,XMAXST,TMAXST
920       FORMAT(1X,'SIMPLE TERRAIN',3X,G10.4,2X,F7.0,4X,F5.0,/)
       END IF
      END IF
      IF (CMAXCT .GT. 0.0) THEN
C         WRITE(IPRT,930) CMAXCT,XMAXCT,TMAXCT
         WRITE(IOUT2,930) CMAXCT,XMAXCT,TMAXCT
930      FORMAT(1X,'COMPLEX TERRAIN',2X,G10.4,2X,F7.0,4X,F5.0,
     &          ' (24-HR CONC)',/)
      END IF
      IF (CAVCHI(1) .GT. 0.0 .OR. CAVCHI(2) .GT. 0.0) THEN
C         WRITE(IPRT,940) (I,CAVCHI(I),XR(I),I=1,2)
         WRITE(IOUT2,940) (I,CAVCHI(I),XR(I),I=1,2)
940      FORMAT(1X,'BLDG. CAVITY-',I1,3X,G10.4,2X,F7.0,6X,'--',
     &          '  (DIST = CAVITY LENGTH)')
C         WRITE(IPRT,*) ' '
         WRITE(IOUT2,*) ' '
      END IF
      IF (CMAXIF .GT. 0.0) THEN
C         WRITE(IPRT,950) CMAXIF,XMAXIF
         WRITE(IOUT2,950) CMAXIF,XMAXIF
950      FORMAT(1X,'INV BREAKUP FUMI',1X,G10.4,2X,F7.0,6X,'--',/)
      END IF
      IF (CMAXSF .GT. 0.0) THEN
C         WRITE(IPRT,960) CMAXSF,XMAXSF
         WRITE(IOUT2,960) CMAXSF,XMAXSF
960      FORMAT(1X,'SHORELINE FUMI',3X,G10.4,2X,F7.0,6X,'--')
      END IF
C
C      WRITE(IPRT,990)
      WRITE(IOUT2,990)
990   FORMAT(/1X,'***************************************************',
     &       /1X,'** REMEMBER TO INCLUDE BACKGROUND CONCENTRATIONS **',
     &       /1X,'***************************************************'/)
C
CCC PES ADDED CODE BEGINS
      WRITE(IPLT,553) CMAXST
553   FORMAT(G12.4)
C
      REWIND IOUT1
      REWIND IOUT2
      REWIND IOUT3
991   READ(IOUT1,888,END=777) BUF80
888   FORMAT(A80)
      WRITE(IOUT,888) BUF80
      GOTO 991
777   READ(IOUT2,888,END=666) BUF80
      WRITE(IOUT,888) BUF80
      GOTO 777
666   READ(IOUT3,888,END=555) BUF80
      WRITE(IOUT,888) BUF80
      GOTO 666
555   CONTINUE
CCC PES ADDED CODE ENDS

C11    WRITE(IPRT,*) 'DO YOU WANT TO PRINT A HARDCOPY OF THE RESULTS?',
C     &           '  ENTER Y OR N:'
      QVAR = 'HARDCOPY QUERY'
11    READ(IRD,100,ERR=999) QUERY
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,100) QUERY
         CALL PRTOUT(IOUT)
C         WRITE(IPRT,1000) OUTFIL
1000     FORMAT(' THE OUTPUT FILE, "',A12,'", HAS BEEN PRINTED.')
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,100) QUERY
C         WRITE(IPRT,1001) OUTFIL
1001     FORMAT(' THE RESULTS OF THIS RUN ARE IN FILE, "',A12,'".')
      ELSE
         GO TO 11
      END IF

C      STOP
C PES ADDED CODE BEGINS
      GO TO 998
999   WRITE(IPRT,*) 'ERROR READING: ', QVAR
      STOP
998   CLOSE (IERR, STATUS = 'DELETE')
      END
C PES ADDED CODE ENDS

      SUBROUTINE INPUTP
C
C        DATA ENTRY ROUTINE FOR POINT SOURCES.
C
      INCLUDE 'MAIN.INC'
      CHARACTER*1 FFEED
      CHARACTER*30 QVAR
      NPD = 0

      STP = .FALSE.
C10    WRITE(IPRT,*) 'ENTER EMISSION RATE (G/S): '
      QVAR = 'Q'
10    READ(IRD,*,ERR=99) Q
      WRITE(IDAT,100) Q
      IF (Q  .LE. 0.) GO TO 90
100   FORMAT(G14.6)
C20    WRITE(IPRT,*) 'ENTER STACK HEIGHT (M): '
      QVAR = 'HS'
20    READ(IRD,*,ERR=99) HS
      WRITE(IDAT,100) HS
      IF (HS .LT. 0.) GO TO 90
C30    WRITE(IPRT,*) 'ENTER STACK INSIDE DIAMETER (M): '
      QVAR = 'DS'
30    READ(IRD,*,ERR=99) DS
      WRITE(IDAT,100) DS
      IF (DS .LT. 0.) GO TO 90
C*==========
C  401 WRITE(IPRT,*) 'ENTER STACK GAS EXIT VELOCITY OR FLOW RATE:'
C      WRITE(IPRT,41)
C   41 FORMAT(' OPTION 1 : EXIT VELOCITY (M/S):',
C     &     /,'  DEFAULT - ENTER NUMBER ONLY   ')
C      WRITE(IPRT,42)
C   42 FORMAT(' OPTION 2 : VOLUME FLOW RATE (M**3/S):',
C     &     /,'            EXAMPLE "VM=20.00"      ')
C      WRITE(IPRT,43)
C   43 FORMAT(' OPTION 3 : VOLUME FLOW RATE (ACFM):',
C     &     /,'            EXAMPLE "VF=1000.00"     ')
      QVAR = 'VS'
  401 READ(IRD,9044) OPTG
 9044 FORMAT(A80)

C     Convert Lower Case to Upper Case
      CALL LWRUPR
C
      IF (OPTG(1:3) .EQ. 'VM=') THEN
         READ(OPTG(4:),'(F20.0)',ERR=99) VM
         IF (VM .LT. 0.) GO TO 90
         WRITE(IDAT,9044) OPTG
         VS = 4.0*VM/(PI*DS**2)
      ELSE IF (OPTG(1:3) .EQ. 'VF=') THEN
         READ(OPTG(4:),'(F20.0)',ERR=99) VF
         IF (VF.LT.0.) GO TO 90
         WRITE(IDAT,9044) OPTG
         VS = (0.3048**3)*VF/(15.0*PI*DS**2)
      ELSE
         READ(OPTG,'(F20.0)',ERR=99) VS
         WRITE(IDAT,100) VS
      END IF

      GO TO 50
C   48 WRITE(IPRT,999)
C 999  FORMAT(15X,'*************************************',
C     &     /,15X,'*  THE OPTION CAN NOT BE PROCESSED  *',
C     &     /,15X,'*    PLEASE RE-ENTER YOUR OPTION    *',
C     &     /,15X,'*************************************')
      GO TO 401
C*==========
C
C50    WRITE(IPRT,*) 'ENTER STACK GAS EXIT TEMPERATURE (K): '
      QVAR = 'TS'
50    READ(IRD,*,ERR=99) TS
      WRITE(IDAT,100) TS
      IF (TS .LT. 0.) GO TO 90
C60    WRITE(IPRT,*) 'ENTER AMBIENT AIR TEMPERATURE (USE 293 FOR ',
C     &              'DEFAULT) (K): '
      QVAR = 'TA'
60    READ(IRD,*,ERR=99) TA
      WRITE(IDAT,100) TA
      IF (TA .LT. 0.) GO TO 90
C70    WRITE(IPRT,*) 'ENTER RECEPTOR HEIGHT ABOVE GROUND (FOR',
C     &              ' FLAGPOLE RECEPTOR) (M): '
      QVAR = 'ZR'
70    READ(IRD,*,ERR=99) ZR
      WRITE(IDAT,100) ZR
      IF (ZR .LT. 0.) GO TO 90
C80    WRITE(IPRT,*) 'ENTER URBAN/RURAL OPTION (U=URBAN, R=RURAL): '
C     Read Input as Character String - First Check for Old IOPT = 1 or 2
C     Then Check for 'U' or 'R'
      QVAR = 'IOPT'
80    READ(IRD,9044) OPTU
      READ(OPTU,'(I20)',ERR=85) IOPT
      WRITE(IDAT,*) IOPT
      IF (IOPT .EQ. 1) THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (IOPT .EQ. 2) THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 80
      END IF
      GO TO 33
85    CONTINUE
      READ(OPTU,200) KOPT
      IF (KOPT.EQ.'1' .OR. KOPT.EQ.'U' .OR. KOPT.EQ.'u') THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (KOPT.EQ.'2' .OR. KOPT.EQ.'R' .OR. KOPT.EQ.'r') THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 80
      END IF
      WRITE(IDAT,200) KOPT

33    CONTINUE
C3     WRITE(IPRT,*)'CONSIDER BUILDING DOWNWASH IN CALCS?  ENTER Y OR N:'
      QVAR = 'BUILD DOWNWASH IN POINT QUERY'
3     READ(IRD,200,ERR=99) QUERY
200   FORMAT(A1)
      IF(QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
C110      WRITE(IPRT,*) 'ENTER BUILDING HEIGHT (M):'
         QVAR = 'HB'
110      READ(IRD,*,ERR=99) HB
         WRITE(IDAT,100) HB
         IF(HB .LT. 0.) GO TO 90
C120      WRITE(IPRT,*) 'ENTER MINIMUM HORIZ BLDG DIMENSION (M):'
         QVAR = 'HL'
120      READ(IRD,*,ERR=99) HL
         WRITE(IDAT,100) HL
         IF(HL .LT. 0.) GO TO 90
C130      WRITE(IPRT,*) 'ENTER MAXIMUM HORIZ BLDG DIMENSION (M):'
         QVAR = 'HW'
130      READ(IRD,*,ERR=99) HW
         WRITE(IDAT,100) HW
         IF(HW .LT. 0.) GO TO 90
         IF(HL .GT. HW) THEN
            HLSAV = HL
            HL = HW
            HW = HLSAV
         ENDIF
         HWP = SQRT(HL*HL + HW*HW)
      ELSEIF(QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         CONTINUE
      ELSE
         GO TO 3
      ENDIF

      GO TO 98
99    WRITE(IPRT,*) 'ERROR READING: ', QVAR
      STOP
98    CONTINUE

C***********************************************************************
C        CHECK FOR COMPLEX TERRAIN SCREENING OPTION
C***********************************************************************
C4     WRITE(IPRT,*) 'USE COMPLEX TERRAIN SCREEN FOR ',
C     &   'TERRAIN ABOVE STACK HEIGHT?'
C      WRITE(IPRT,*) 'ENTER Y OR N:'
      QVAR = 'COMPLEX TERRAIN IN POINT QUERY'
4     READ(IRD,200,ERR=99) QUERY
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
         CALL VALLEY
         IF (STP) RETURN
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         CONTINUE
      ELSE
         GO TO 4
      END IF
C
C        WRITE DATE, TIME, AND INPUT VALUES TO OUTPUT FILE
C
C     Assign ASCII Form Feed Character to Variable FFEED
      FFEED = CHAR(12)
      WRITE(IOUT1,101) FFEED
      WRITE(IOUT1,102) RUNDAT, RUNTIM
101   FORMAT(1X,A1)
C102   FORMAT(70X,A8/70X,A8)
102   FORMAT(67X,A8/67X,A8)

      WRITE(IOUT1,103) VERSN, TITLE, Q, HS, DS, VS, TS, TA, ZR, KPRT,
     &                 HB, HL, HW
103   FORMAT(' ',1X,'***  SCREEN3 MODEL RUN  ***',
     &         /,2X,'*** VERSION DATED ',A5,' ***',//,1X,A79,//,
     &       1X,'SIMPLE TERRAIN INPUTS:',/,
     &       1X,'   SOURCE TYPE            =        POINT',/,
     &       1X,'   EMISSION RATE (G/S)    = ',G16.6,/,
     &       1X,'   STACK HEIGHT (M)       = ',F12.4,/,
     &       1X,'   STK INSIDE DIAM (M)    = ',F12.4,/,
     &       1X,'   STK EXIT VELOCITY (M/S)= ',F12.4,/,
     &       1X,'   STK GAS EXIT TEMP (K)  = ',F12.4,/,
     &       1X,'   AMBIENT AIR TEMP (K)   = ',F12.4,/,
     &       1X,'   RECEPTOR HEIGHT (M)    = ',F12.4,/,
     &       1X,'   URBAN/RURAL OPTION     = ',7X,A5,/,
     &       1X,'   BUILDING HEIGHT (M)    = ',F12.4,/,
     &       1X,'   MIN HORIZ BLDG DIM (M) = ',F12.4,/,
     &       1X,'   MAX HORIZ BLDG DIM (M) = ',F12.4,/)
C*=====
      IF (OPTG(1:3) .EQ. 'VM=') THEN
         WRITE(IOUT1,201) VM
  201    FORMAT(1X,'   STACK EXIT VELOCITY WAS CALCULATED FROM',
     &        /,1X,'   VOLUME FLOW RATE =',G16.8,' (M**3/S) ')
      ELSE IF (OPTG(1:3) .EQ. 'VF=') THEN
         WRITE(IOUT1,202) VF
  202    FORMAT(1X,'   STACK EXIT VELOCITY WAS CALCULATED FROM',
     &        /,1X,'   VOLUME FLOW RATE =',G16.8,' (ACFM) ')
      END IF
C*=====
C

C
C        FOR SMALL VS, DS, TS, AND TA SET=1.0E-05 TO AVOID ZERO DIVIDE
C        ERROR AND UNDERFLOW
C
      IF (VS .LT. 1.0E-05) VS=1.0E-05
      IF (DS .LT. 1.0E-05) DS=1.0E-05
      IF (TS .LT. 1.0E-05) TS=1.0E-05
      IF (TA .LT. 1.0E-05) TA=1.0E-05
C
      RETURN
C90    WRITE(IPRT,*) 'YOU HAVE ENTERED AN UNACCEPTABLE VALUE.  START',
C     &              ' OVER.'
90    GO TO 10

      END

      SUBROUTINE INPUTF
C
C        DATA ENTRY ROUTINE FOR FLARES.  CALCULATES
C        EFFECTIVE STACK DIAMETER ASSUMING VS=20.0, TS=1273.
C        ALSO CALCULATES EFFECTIVE RELEASE HEIGHT BASED ON THE
C        LENGTH OF THE FLAME.
C
      INCLUDE 'MAIN.INC'
      CHARACTER*1 FFEED
      CHARACTER*30 QVAR
      NPD = 0

      STP = .FALSE.
C10    WRITE(IPRT,*) 'ENTER EMISSION RATE (G/S): '
      QVAR = 'Q'
10    READ(IRD,*,ERR=99) Q
      WRITE(IDAT,100) Q
      IF (Q  .LE. 0.) GO TO 90
100   FORMAT(1X,G11.4)
C20    WRITE(IPRT,*) 'ENTER FLARE STACK HEIGHT (M): '
      QVAR = 'HSTK'
20    READ(IRD,*,ERR=99) HSTK
      WRITE(IDAT,100) HSTK
      IF (HSTK .LT. 0.) GO TO 90
C30    WRITE(IPRT,*) 'ENTER TOTAL HEAT RELEASE RATE (CAL/S):'
      QVAR = 'H'
30    READ(IRD,*,ERR=99) H
      WRITE(IDAT,100) H
      IF (H  .LT. 0.) GO TO 90
C40    WRITE(IPRT,*) 'ENTER RECEPTOR HEIGHT ABOVE GROUND (FOR',
C     &              ' FLAGPOLE RECEPTOR) (M): '
      QVAR = 'ZR'
40    READ(IRD,*,ERR=99) ZR
      WRITE(IDAT,100) ZR
      IF (ZR .LT. 0.) GO TO 90
C50    WRITE(IPRT,*) 'ENTER URBAN/RURAL OPTION (U=URBAN, R=RURAL): '
C     Read Input as Character String - First Check for Old IOPT = 1 or 2
C     Then Check for 'U' or 'R'
      QVAR = 'IOPT'
50    READ(IRD,9044) OPTU
 9044 FORMAT(A80)
      READ(OPTU,'(I20)',ERR=55) IOPT
      WRITE(IDAT,*) IOPT
      IF (IOPT .EQ. 1) THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (IOPT .EQ. 2) THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 50
      END IF
      GO TO 33
55    CONTINUE
      READ(OPTU,200) KOPT
      IF (KOPT.EQ.'1' .OR. KOPT.EQ.'U' .OR. KOPT.EQ.'u') THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (KOPT.EQ.'2' .OR. KOPT.EQ.'R' .OR. KOPT.EQ.'r') THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 50
      END IF
      WRITE(IDAT,200) KOPT

33    CONTINUE
C
C        SET EFFECTIVE STACK PARAMETERS
C
      VS = 20.0
      TS = 1273.
      TA = 293.
      DS = 9.88E-04*(0.45*H)**0.5
      IF (DS .LT. 1E-05) DS=1.0E-05
      HS = HSTK + 4.56E-03 * H**0.478
C      WRITE(IPRT,*) 'EFFECTIVE RELEASE HEIGHT =',HS
C
C3     WRITE(IPRT,*)'CONSIDER BUILDING DOWNWASH IN CALCS?  ENTER Y OR N:'
      QVAR = 'BUILD DOWNWASH IN FLARE QUERY'
3     READ(IRD,200) QUERY
      IF(QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
C60       WRITE(IPRT,*) 'ENTER BUILDING HEIGHT (M):'
         QVAR = 'HB'
60       READ(IRD,*,ERR=99) HB
         WRITE(IDAT,100) HB
         IF(HB  .LT. 0.) GO TO 90
C70       WRITE(IPRT,*) 'ENTER MINIMUM HORIZ BLDG DIMENSION (M):'
         QVAR = 'HL'
70       READ(IRD,*,ERR=99) HL
         WRITE(IDAT,100) HL
         IF(HL  .LT. 0.) GO TO 90
C80       WRITE(IPRT,*) 'ENTER MAXIMUM HORIZ BLDG DIMENSION (M):'
         QVAR = 'HW'
80       READ(IRD,*,ERR=99) HW
         WRITE(IDAT,100) HW
         IF(HW  .LT. 0.) GO TO 90
         IF(HL .GT. HW) THEN
            HLSAV = HL
            HL = HW
            HW = HLSAV
         ENDIF
         HWP = SQRT(HL*HL + HW*HW)
      ELSEIF(QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         CONTINUE
      ELSE
         GO TO 3
      ENDIF

      GO TO 98
99    WRITE(IPRT,*) 'ERROR READING: ', QVAR
      STOP
98    CONTINUE


C***********************************************************************
C        CHECK FOR COMPLEX TERRAIN SCREENING OPTION
C***********************************************************************
C4     WRITE(IPRT,*) 'USE COMPLEX TERRAIN SCREEN FOR TERRAIN ABOVE',
C     &   ' STACK HEIGHT?'
C      WRITE(IPRT,*) 'ENTER Y OR N:'
      QVAR = 'COMPLEX TERRAIN IN FLARE QUERY'
4     READ(IRD,200,ERR=99) QUERY
200   FORMAT(A1)
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
         CALL VALLEY
         IF (STP) RETURN
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         CONTINUE
      ELSE
         GO TO 4
      END IF
C
C        WRITE DATE, TIME, AND INPUT VALUES TO OUTPUT FILE
C
C     Assign ASCII Form Feed Character to Variable FFEED
      FFEED = CHAR(12)
      WRITE(IOUT1,101) FFEED
      WRITE(IOUT1,102) RUNDAT, RUNTIM
101   FORMAT(1X,A1)
C102   FORMAT(70X,A8/70X,A8)
102   FORMAT(67X,A8/67X,A8)
      WRITE(IOUT1,103) VERSN, TITLE, Q, HSTK, H, ZR, KPRT, HS, HB, HL, HW
103   FORMAT(' ',1X,'***  SCREEN3 MODEL RUN  ***',
     &         /,2X,'*** VERSION DATED ',A5,' ***',//,1X,A79,//,
     &       1X,'SIMPLE TERRAIN INPUTS:',/,
     &       1X,'   SOURCE TYPE            =        FLARE',/,
     &       1X,'   EMISSION RATE (G/S)    = ',G16.6,/,
     &       1X,'   FLARE STACK HEIGHT (M) = ',F12.4,/,
     &       1X,'   TOT HEAT RLS (CAL/S)   = ',G16.6,/,
     &       1X,'   RECEPTOR HEIGHT (M)    = ',F12.4,/,
     &       1X,'   URBAN/RURAL OPTION     = ',7X,A5,/,
     &       1X,'   EFF RELEASE HEIGHT (M) = ',F12.4,/,
     &       1X,'   BUILDING HEIGHT (M)    = ',F12.4,/,
     &       1X,'   MIN HORIZ BLDG DIM (M) = ',F12.4,/,
     &       1X,'   MAX HORIZ BLDG DIM (M) = ',F12.4,/)
C

      RETURN
C90    WRITE(IPRT,*) 'YOU HAVE ENTERED AN UNACCEPTABLE VALUE.  START',
C     &              ' OVER.'
90    GO TO 10
      END

      SUBROUTINE INPUTA
C
C        DATA ENTRY ROUTINE FOR AREA SOURCES.  CALCULATES
C        CONCENTRATIONS USING NUMERICAL INTEGRATION APPROACH.
C 
      INCLUDE 'MAIN.INC'
      CHARACTER*1 FFEED
      CHARACTER*30 QVAR
      NPD = 0

      FSTCAL = .TRUE.
      STP = .FALSE.
      VS = 1.0E-05
      DS = 1.0E-05
      TS = 293.
      TA = 293.
C10    WRITE(IPRT,*) 'ENTER EMISSION RATE (G/(S-M**2)): '
      QVAR = 'Q'
10    READ(IRD,*,ERR=99) Q
      WRITE(IDAT,100) Q
      IF (Q  .LE. 0.) GO TO 90
100   FORMAT(1X,G11.4)
C20    WRITE(IPRT,*) 'ENTER SOURCE RELEASE HEIGHT (M): '
      QVAR = 'HS'
20    READ(IRD,*,ERR=99) HS
      WRITE(IDAT,100) HS
      IF (HS .LT. 0.) GO TO 90
C30    WRITE(IPRT,*) 'ENTER LENGTH OF LARGER SIDE FOR AREA (M):'
      QVAR = 'XINIT'
30    READ(IRD,*,ERR=99) XINIT
      WRITE(IDAT,100) XINIT
      IF (XINIT .LT. 0.) GO TO 90
C35    WRITE(IPRT,*) 'ENTER LENGTH OF SMALLER SIDE FOR AREA (M):'
      QVAR = 'YINIT'
35    READ(IRD,*,ERR=99) YINIT
      WRITE(IDAT,100) YINIT
      IF (YINIT .LT. 0.) GO TO 90
      IF (XINIT .LT. YINIT) THEN
         XSAV = XINIT
         XINIT = YINIT
         YINIT = XSAV
      END IF
      ASPECT = XINIT/YINIT
      IF (ASPECT .GT. 10.0) THEN
         WRITE(IPRT,*) 'ASPECT RATIO EXCEEDS 10.  SUBDIVIDE AREA AND',
     &                 ' ENTER DIMENSIONS AGAIN!'
         GO TO 30
      END IF
C40    WRITE(IPRT,*) 'ENTER RECEPTOR HEIGHT ABOVE GROUND (FOR',
C     &              ' FLAGPOLE RECEPTOR) (M): '
      QVAR = 'ZR'
40    READ(IRD,*,ERR=99) ZR
      WRITE(IDAT,100) ZR
      IF (ZR .LT. 0.) GO TO 90
C50    WRITE(IPRT,*) 'ENTER URBAN/RURAL OPTION (U=URBAN, R=RURAL): '
C     Read Input as Character String - First Check for Old IOPT = 1 or 2
C     Then Check for 'U' or 'R'
      QVAR = 'IOPT'
50    READ(IRD,9044,ERR=99) OPTU
 9044 FORMAT(A80)
      READ(OPTU,'(I20)',ERR=55) IOPT
      WRITE(IDAT,*) IOPT
      IF (IOPT .EQ. 1) THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (IOPT .EQ. 2) THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 50
      END IF
      GO TO 33
55    CONTINUE
      READ(OPTU,200) KOPT
200   FORMAT(A1)
      IF (KOPT.EQ.'1' .OR. KOPT.EQ.'U' .OR. KOPT.EQ.'u') THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (KOPT.EQ.'2' .OR. KOPT.EQ.'R' .OR. KOPT.EQ.'r') THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 50
      END IF
      WRITE(IDAT,200) KOPT

33    CONTINUE

C4     WRITE(IPRT,*) 'SEARCH THROUGH RANGE OF DIRECTIONS TO FIND',
C     &   ' THE MAXIMUM? '
C      WRITE(IPRT,*) 'ENTER Y OR N:'
      QVAR = 'WIND DIRECTION SEARCH QUERY'
4     READ(IRD,200,ERR=99) QUERY
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
         MAXWD = .TRUE.
         WDIR = 270.
         ANGLE = 0.0
         ANGRAD = 0.0
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         MAXWD = .FALSE.
C65       WRITE(IPRT,*) 'ENTER DIRECTION RELATIVE TO THE DIRECTION',
C     &      ' PERPENDICULAR TO THE SMALLER SIDE: '
         QVAR = 'ANGLE'
65       READ(IRD,*,ERR=99) ANGLE
         WRITE(IDAT,100) ANGLE
         WDMAX = ANGLE
         ANGRAD = -1.0 * ANGLE * DTORAD
         WDIR = 270.
      ELSE
         GO TO 4
      END IF
C
C     Set Vertices (in km) for Rectangular Area with Center at (0,0).
C     Rotate Area About the Center to Accommodate User-Input Direction.
      NVERT = 4
      AXVERT(1) =  (0.5*YINIT*SIN(ANGRAD)-0.5*XINIT*COS(ANGRAD))/1000.
      AYVERT(1) = (-0.5*YINIT*COS(ANGRAD)-0.5*XINIT*SIN(ANGRAD))/1000.
      AXVERT(2) = (-0.5*YINIT*SIN(ANGRAD)-0.5*XINIT*COS(ANGRAD))/1000.
      AYVERT(2) =  (0.5*YINIT*COS(ANGRAD)-0.5*XINIT*SIN(ANGRAD))/1000.
      AXVERT(3) = (-0.5*YINIT*SIN(ANGRAD)+0.5*XINIT*COS(ANGRAD))/1000.
      AYVERT(3) =  (0.5*YINIT*COS(ANGRAD)+0.5*XINIT*SIN(ANGRAD))/1000.
      AXVERT(4) =  (0.5*YINIT*SIN(ANGRAD)+0.5*XINIT*COS(ANGRAD))/1000.
      AYVERT(4) = (-0.5*YINIT*COS(ANGRAD)+0.5*XINIT*SIN(ANGRAD))/1000.
      AXVERT(5) = AXVERT(1)
      AYVERT(5) = AYVERT(1)

C     Determine SIN and COS of WDIR
      WDRAD = WDIR * DTORAD
      WDSIN = SIN(WDRAD)
      WDCOS = COS(WDRAD)

      GO TO 98
99    WRITE(IPRT,*) 'ERROR READING: ', QVAR
      STOP
98    CONTINUE

C     Assign ASCII Form Feed Character to Variable FFEED
      FFEED = CHAR(12)
      WRITE(IOUT1,101) FFEED
      WRITE(IOUT1,102) RUNDAT, RUNTIM
101   FORMAT(1X,A1)
C102   FORMAT(70X,A8/70X,A8)
102   FORMAT(67X,A8/67X,A8)
      WRITE(IOUT1,103) VERSN, TITLE, Q, HS, XINIT, YINIT, ZR, KPRT
103   FORMAT(' ',1X,'***  SCREEN3 MODEL RUN  ***',
     &         /,2X,'*** VERSION DATED ',A5,' ***',//,1X,A79,//,
     &       1X,'SIMPLE TERRAIN INPUTS:',/,
     &       1X,'   SOURCE TYPE                 =         AREA',/,
     &       1X,'   EMISSION RATE (G/(S-M**2))  = ',G16.6,/,
     &       1X,'   SOURCE HEIGHT (M)           = ',F12.4,/,
     &       1X,'   LENGTH OF LARGER SIDE (M)   = ',F12.4,/,
     &       1X,'   LENGTH OF SMALLER SIDE (M)  = ',F12.4,/,
     &       1X,'   RECEPTOR HEIGHT (M)         = ',F12.4,/,
     &       1X,'   URBAN/RURAL OPTION          = ',7X,A5)
      IF (MAXWD) THEN
         WRITE(IOUT1,104)
104      FORMAT('    MODEL ESTIMATES DIRECTION TO MAX CONCENTRATION',/)
      ELSE
         WRITE(IOUT1,105) ANGLE
105      FORMAT('    ANGLE RELATIVE TO LONG AXIS = ',F12.4,/)
      END IF

      RETURN
C90    WRITE(IPRT,*) 'YOU HAVE ENTERED AN UNACCEPTABLE VALUE.  START',
C     &              ' OVER.'
90    GO TO 10
      END

      SUBROUTINE INPUTV
C
C        DATA ENTRY ROUTINE FOR VOLUME SOURCES.  CALCULATES
C        CONCENTRATIONS USING A VIRTUAL POINT SOURCE ALGORITHM.
C 
      INCLUDE 'MAIN.INC'
      CHARACTER*1 FFEED
      NPD = 0

      STP = .FALSE.
      VS = 1.0E-05
      DS = 1.0E-05
      TS = 293.
      TA = 293.
C10    WRITE(IPRT,*) 'ENTER EMISSION RATE (G/S): '
      QVAR = 'Q'
10    READ(IRD,*,ERR=99) Q
      WRITE(IDAT,100) Q
      IF (Q  .LE. 0.) GO TO 90
100   FORMAT(1X,G11.4)
C20    WRITE(IPRT,*) 'ENTER SOURCE RELEASE HEIGHT (M): '
      QVAR = 'HS'
20    READ(IRD,*,ERR=99) HS
      WRITE(IDAT,100) HS
      IF (HS .LT. 0.) GO TO 90
C30    WRITE(IPRT,*) 'ENTER INITIAL LATERAL DIMENSION OF VOLUME ',
C     &              'SOURCE (M):'
      QVAR = 'SYINIT'
30    READ(IRD,*,ERR=99) SYINIT
      WRITE(IDAT,100) SYINIT
      IF (SYINIT .LT. 0.) GO TO 90
C35    WRITE(IPRT,*) 'ENTER INITIAL VERTICAL DIMENSION OF VOLUME ',
C     &              'SOURCE (M):'
      QVAR = 'SZINIT'
35    READ(IRD,*,ERR=99) SZINIT
      WRITE(IDAT,100) SZINIT
      IF (SZINIT .LT. 0.) GO TO 90
C40    WRITE(IPRT,*) 'ENTER RECEPTOR HEIGHT ABOVE GROUND (FOR',
C     &              ' FLAGPOLE RECEPTOR) (M): '
      QVAR = 'ZR'
40    READ(IRD,*,ERR=99) ZR
      WRITE(IDAT,100) ZR
      IF (ZR .LT. 0.) GO TO 90
C50    WRITE(IPRT,*) 'ENTER URBAN/RURAL OPTION (U=URBAN, R=RURAL): '
C     Read Input as Character String - First Check for Old IOPT = 1 or 2
C     Then Check for 'U' or 'R'
      QVAR = 'IOPT'
50    READ(IRD,9044) OPTU
 9044 FORMAT(A80)
      READ(OPTU,'(I20)',ERR=55) IOPT
      WRITE(IDAT,*) IOPT
      IF (IOPT .EQ. 1) THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (IOPT .EQ. 2) THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 50
      END IF
      GO TO 33
55    CONTINUE
      READ(OPTU,200) KOPT
200   FORMAT(A1)
      IF (KOPT.EQ.'1' .OR. KOPT.EQ.'U' .OR. KOPT.EQ.'u') THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (KOPT.EQ.'2' .OR. KOPT.EQ.'R' .OR. KOPT.EQ.'r') THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 50
      END IF
      WRITE(IDAT,200) KOPT

      GO TO 98
99    WRITE(IPRT,*) 'ERROR READING: ', QVAR
      STOP
98    CONTINUE

33    CONTINUE

C     Assign ASCII Form Feed Character to Variable FFEED
      FFEED = CHAR(12)
      WRITE(IOUT1,101) FFEED
      WRITE(IOUT1,102) RUNDAT, RUNTIM
101   FORMAT(1X,A1)
C102   FORMAT(70X,A8/70X,A8)
102   FORMAT(67X,A8/67X,A8)
      WRITE(IOUT1,103) VERSN, TITLE, Q, HS, SYINIT, SZINIT, ZR, KPRT
103   FORMAT(' ',1X,'***  SCREEN3 MODEL RUN  ***',
     &         /,2X,'*** VERSION DATED ',A5,' ***',//,1X,A79,//,
     &       1X,'SIMPLE TERRAIN INPUTS:',/,
     &       1X,'   SOURCE TYPE              =       VOLUME',/,
     &       1X,'   EMISSION RATE (G/S)      = ',G16.6,/,
     &       1X,'   SOURCE HEIGHT (M)        = ',F12.4,/,
     &       1X,'   INIT. LATERAL DIMEN (M)  = ',F12.4,/,
     &       1X,'   INIT. VERTICAL DIMEN (M) = ',F12.4,/,
     &       1X,'   RECEPTOR HEIGHT (M)      = ',F12.4,/,
     &       1X,'   URBAN/RURAL OPTION       = ',7X,A5,/)

      RETURN
C90    WRITE(IPRT,*) 'YOU HAVE ENTERED AN UNACCEPTABLE VALUE.  START',
C     &              ' OVER.'
90    GO TO 10
      END

      SUBROUTINE INPDEP
C
C        DATA ENTRY ROUTINE FOR POINT SOURCES WITH DEPOSITION
C
      INCLUDE 'MAIN.INC'
      CHARACTER*1 FFEED

      STP = .FALSE.
10    WRITE(IPRT,*) 'ENTER EMISSION RATE (G/S): '
      READ(IRD,*,ERR=10) Q
      WRITE(IDAT,100) Q
      IF (Q  .LE. 0.) GO TO 90
100   FORMAT(G14.6)
20    WRITE(IPRT,*) 'ENTER STACK HEIGHT (M): '
      READ(IRD,*,ERR=20) HS
      WRITE(IDAT,100) HS
      IF (HS .LT. 0.) GO TO 90
30    WRITE(IPRT,*) 'ENTER STACK INSIDE DIAMETER (M): '
      READ(IRD,*,ERR=30) DS
      WRITE(IDAT,100) DS
      IF (DS .LT. 0.) GO TO 90
C*==========
  401 WRITE(IPRT,*) 'ENTER STACK GAS EXIT VELOCITY OR FLOW RATE:'
      WRITE(IPRT,41)
   41 FORMAT(' OPTION 1 : EXIT VELOCITY (M/S):',
     &     /,'  DEFAULT - ENTER NUMBER ONLY   ')
      WRITE(IPRT,42)
   42 FORMAT(' OPTION 2 : VOLUME FLOW RATE (M**3/S):',
     &     /,'            EXAMPLE "VM=20.00"      ')
      WRITE(IPRT,43)
   43 FORMAT(' OPTION 3 : VOLUME FLOW RATE (ACFM):',
     &     /,'            EXAMPLE "VF=1000.00"     ')
  402 READ(IRD,9044) OPTG
 9044 FORMAT(A80)

C     Convert Lower Case to Upper Case
      CALL LWRUPR
C
      IF (OPTG(1:3) .EQ. 'VM=') THEN
         READ(OPTG(4:),'(F20.0)',ERR=48) VM
         IF (VM .LT. 0.) GO TO 90
         WRITE(IDAT,9044) OPTG
         VS = 4.0*VM/(PI*DS**2)
      ELSE IF (OPTG(1:3) .EQ. 'VF=') THEN
         READ(OPTG(4:),'(F20.0)',ERR=48) VF
         IF (VF.LT.0.) GO TO 90
         WRITE(IDAT,9044) OPTG
         VS = (0.3048**3)*VF/(15.0*PI*DS**2)
      ELSE
         READ(OPTG,'(F20.0)',ERR=48) VS
         WRITE(IDAT,100) VS
      END IF

      GO TO 50
   48 WRITE(IPRT,999)
 999  FORMAT(15X,'*************************************',
     &     /,15X,'*  THE OPTION CAN NOT BE PROCESSED  *',
     &     /,15X,'*    PLEASE RE-ENTER YOUR OPTION    *',
     &     /,15X,'*************************************')
      GO TO 401
C*==========
C
50    WRITE(IPRT,*) 'ENTER STACK GAS EXIT TEMPERATURE (K): '
      READ(IRD,*,ERR=50) TS
      WRITE(IDAT,100) TS
      IF (TS .LT. 0.) GO TO 90
60    WRITE(IPRT,*) 'ENTER AMBIENT AIR TEMPERATURE (USE 293 FOR ',
     &              'DEFAULT) (K): '
      READ(IRD,*,ERR=60) TA
      WRITE(IDAT,100) TA
      IF (TA .LT. 0.) GO TO 90
70    WRITE(IPRT,*) 'ENTER RECEPTOR HEIGHT ABOVE GROUND (FOR',
     &              ' FLAGPOLE RECEPTOR) (M): '
      READ(IRD,*,ERR=70) ZR
      WRITE(IDAT,100) ZR
      IF (ZR .LT. 0.) GO TO 90
80    WRITE(IPRT,*) 'ENTER URBAN/RURAL OPTION (U=URBAN, R=RURAL): '
C     Read Input as Character String - First Check for Old IOPT = 1 or 2
C     Then Check for 'U' or 'R'
      READ(IRD,9044) OPTU
      READ(OPTU,'(I20)',ERR=85) IOPT
      WRITE(IDAT,*) IOPT
      IF (IOPT .EQ. 1) THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (IOPT .EQ. 2) THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 80
      END IF
      GO TO 33
85    CONTINUE
      READ(OPTU,200) KOPT
      IF (KOPT.EQ.'1' .OR. KOPT.EQ.'U' .OR. KOPT.EQ.'u') THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (KOPT.EQ.'2' .OR. KOPT.EQ.'R' .OR. KOPT.EQ.'r') THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 80
      END IF
      WRITE(IDAT,200) KOPT

33    CONTINUE

      IF (RURAL) THEN
         WRITE(IPRT,*) 'ENTER SURFACE ROUGHNESS LENGTH (USE 0.3 FOR ',
     &                 'DEFAULT) (M): '
      ELSE IF (URBAN) THEN
         WRITE(IPRT,*) 'ENTER SURFACE ROUGHNESS LENGTH (USE 1.0 FOR ',
     &                 'DEFAULT) (M): '
      END IF
      READ(IRD,*,ERR=33) ZROUGH
      WRITE(IDAT,100) ZROUGH
      IF (ZROUGH .GT. 10.) GO TO 33
      IF (ZROUGH .LT. 0.) GO TO 90
      Z0M = ZROUGH

3     WRITE(IPRT,*)'CONSIDER BUILDING DOWNWASH IN CALCS?  ENTER Y OR N:'
      READ(IRD,200) QUERY
200   FORMAT(A1)
      IF(QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
110      WRITE(IPRT,*) 'ENTER BUILDING HEIGHT (M):'
         READ(IRD,*,ERR=110) HB
         WRITE(IDAT,100) HB
         IF(HB .LT. 0.) GO TO 90
120      WRITE(IPRT,*) 'ENTER MINIMUM HORIZ BLDG DIMENSION (M):'
         READ(IRD,*,ERR=120) HL
         WRITE(IDAT,100) HL
         IF(HL .LT. 0.) GO TO 90
130      WRITE(IPRT,*) 'ENTER MAXIMUM HORIZ BLDG DIMENSION (M):'
         READ(IRD,*,ERR=130) HW
         WRITE(IDAT,100) HW
         IF(HW .LT. 0.) GO TO 90
         IF(HL .GT. HW) THEN
            HLSAV = HL
            HL = HW
            HW = HLSAV
         ENDIF
         HWP = SQRT(HL*HL + HW*HW)
      ELSEIF(QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         CONTINUE
      ELSE
         GO TO 3
      ENDIF

C***********************************************************************
C        ENTER DEPOSITION PARAMETERS
C***********************************************************************
39    WRITE(IPRT,*)'CONSIDER PLUME DEPLETION EFFECTS?  ENTER Y OR N:'
      READ(IRD,200) QUERY
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
         DPLETE = .TRUE.
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         DPLETE = .FALSE.
      ELSE
         GO TO 39
      END IF

150   WRITE(IPRT,*) 'ENTER PARTICLE DENSITY (USE 1.0 FOR ',
     &              'DEFAULT) (G/CM**3) : '
      READ(IRD,*,ERR=150) PARDEN
      WRITE(IDAT,100) PARDEN
      IF (PARDEN .LT. 0.) GO TO 90
155   WRITE(IPRT,*) 'ENTER NUMBER OF PARTICLE SIZE CATEGORIES (<= 20): '
      READ(IRD,*,ERR=155) NPD
      WRITE(IDAT,*) NPD
      IF (NPD .GT. 20) GO TO 155
      IF (NPD .LT. 0) GO TO 90
160   WRITE(IPRT,*) 'ENTER PARTICLE DIAMETER FOR EACH CATEGORY ',
     &              '(MICRONS): '
      READ(IRD,*,ERR=160) (PDIAM(I), I=1,NPD)
      WRITE(IDAT,*) (PDIAM(I), I=1,NPD)
170   WRITE(IPRT,*) 'ENTER MASS FRACTION FOR EACH CATEGORY ',
     &              '(MUST SUM TO 1.0): '
      READ(IRD,*,ERR=170) (PHI(I), I=1,NPD)
      WRITE(IDAT,*) (PHI(I), I=1,NPD)
      PHISUM = 0.0
      DO 176 I = 1, NPD
         PHISUM = PHISUM + PHI(I)
176   CONTINUE
      IF (PHISUM .LT. 0.98 .OR. PHISUM .GT. 1.02) GO TO 170
C     Assign Particle Density to Each Category
      DO 177 I = 1, NPD
         PDENS(I) = PARDEN
177   CONTINUE

C***********************************************************************
C        CHECK FOR COMPLEX TERRAIN SCREENING OPTION
C***********************************************************************
4     WRITE(IPRT,*) 'USE COMPLEX TERRAIN SCREEN FOR ',
     &   'TERRAIN ABOVE STACK HEIGHT?'
      WRITE(IPRT,*) 'ENTER Y OR N:'
      READ(IRD,200) QUERY
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
         CALL VALLEY
         IF (STP) RETURN
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         CONTINUE
      ELSE
         GO TO 4
      END IF
C
C        WRITE DATE, TIME, AND INPUT VALUES TO OUTPUT FILE
C
C     Assign ASCII Form Feed Character to Variable FFEED
      FFEED = CHAR(12)
      WRITE(IOUT1,101) FFEED
      WRITE(IOUT1,102) RUNDAT, RUNTIM
101   FORMAT(1X,A1)
102   FORMAT(70X,A8/70X,A8)

      WRITE(IOUT1,103) VERSN, TITLE, Q, HS, DS, VS, TS, TA, ZR, KPRT,
     &                ZROUGH, HB, HL, HW
103   FORMAT(' ',1X,'***  SCREEN3 MODEL RUN  ***',
     &         /,2X,'*** VERSION DATED ',A5,' ***',//,1X,A79,//,
     &       1X,'SIMPLE TERRAIN INPUTS:',/,
     &       1X,'   SOURCE TYPE                  =        POINT ',
     &                                           'w/ DRY DEPOSITION',/,
     &       1X,'   EMISSION RATE (G/S)          = ',G16.6,/,
     &       1X,'   STACK HEIGHT (M)             = ',F12.4,/,
     &       1X,'   STK INSIDE DIAM (M)          = ',F12.4,/,
     &       1X,'   STK EXIT VELOCITY (M/S)      = ',F12.4,/,
     &       1X,'   STK GAS EXIT TEMP (K)        = ',F12.4,/,
     &       1X,'   AMBIENT AIR TEMP (K)         = ',F12.4,/,
     &       1X,'   RECEPTOR HEIGHT (M)          = ',F12.4,/,
     &       1X,'   URBAN/RURAL OPTION           = ',7X,A5,/,
     &       1X,'   SURFACE ROUGHNESS LENGTH (M) = ',F12.4,/,
     &       1X,'   BUILDING HEIGHT (M)          = ',F12.4,/,
     &       1X,'   MIN HORIZ BLDG DIM (M)       = ',F12.4,/,
     &       1X,'   MAX HORIZ BLDG DIM (M)       = ',F12.4,)
      IF (DPLETE) THEN
         WRITE(IOUT,113)
113      FORMAT(1X,'   PLUME DEPLETION OPTION       =           ON',/)
      ELSE
         WRITE(IOUT,114)
114      FORMAT(1X,'   PLUME DEPLETION OPTION       =          OFF',/)
      END IF

      WRITE(IOUT,109) PARDEN
109   FORMAT(1X,'   PARTICLE DENSITY (G/CM**3)   = ',F12.4)
      WRITE(IOUT,111) (PDIAM(I),PHI(I),I=1,NPD)
111   FORMAT(1X,'   PARTICLE DIAMETERS (MICRONS)      MASS FRACTIONS',/
     &         '    ----------------------------      --------------',/
     &      (10X,F12.4,13X,F12.4))

C*=====
      IF (OPTG(1:3) .EQ. 'VM=') THEN
         WRITE(IOUT,201) VM
  201    FORMAT(1X,'   STACK EXIT VELOCITY WAS CALCULATED FROM',
     &        /,1X,'   VOLUME FLOW RATE =',G16.8,' (M**3/S) ')
      ELSE IF (OPTG(1:3) .EQ. 'VF=') THEN
         WRITE(IOUT,202) VF
  202    FORMAT(1X,'   STACK EXIT VELOCITY WAS CALCULATED FROM',
     &        /,1X,'   VOLUME FLOW RATE =',G16.8,' (ACFM) ')
      END IF
C*=====
C

C
C        FOR SMALL VS, DS, TS, AND TA SET=1.0E-05 TO AVOID ZERO DIVIDE
C        ERROR AND UNDERFLOW
C
      IF (VS .LT. 1.0E-05) VS=1.0E-05
      IF (DS .LT. 1.0E-05) DS=1.0E-05
      IF (TS .LT. 1.0E-05) TS=1.0E-05
      IF (TA .LT. 1.0E-05) TA=1.0E-05
C
      RETURN
90    WRITE(IPRT,*) 'YOU HAVE ENTERED AN UNACCEPTABLE VALUE.  START',
     &              ' OVER.'
      GO TO 10

      END

      SUBROUTINE INFDEP
C
C        DATA ENTRY ROUTINE FOR FLARES WITH DEPOSITION.  CALCULATES
C        EFFECTIVE STACK DIAMETER ASSUMING VS=20.0, TS=1273.
C        ALSO CALCULATES EFFECTIVE RELEASE HEIGHT BASED ON THE
C        LENGTH OF THE FLAME.
C
      INCLUDE 'MAIN.INC'
      CHARACTER*1 FFEED

      STP = .FALSE.
10    WRITE(IPRT,*) 'ENTER EMISSION RATE (G/S): '
      READ(IRD,*,ERR=10) Q
      WRITE(IDAT,100) Q
      IF (Q  .LE. 0.) GO TO 90
100   FORMAT(1X,G11.4)
20    WRITE(IPRT,*) 'ENTER FLARE STACK HEIGHT (M): '
      READ(IRD,*,ERR=20) HSTK
      WRITE(IDAT,100) HSTK
      IF (HSTK .LT. 0.) GO TO 90
30    WRITE(IPRT,*) 'ENTER TOTAL HEAT RELEASE RATE (CAL/S):'
      READ(IRD,*,ERR=30) H
      WRITE(IDAT,100) H
      IF (H  .LT. 0.) GO TO 90
40    WRITE(IPRT,*) 'ENTER RECEPTOR HEIGHT ABOVE GROUND (FOR',
     &              ' FLAGPOLE RECEPTOR) (M): '
      READ(IRD,*,ERR=40) ZR
      WRITE(IDAT,100) ZR
      IF (ZR .LT. 0.) GO TO 90
50    WRITE(IPRT,*) 'ENTER URBAN/RURAL OPTION (U=URBAN, R=RURAL): '
C     Read Input as Character String - First Check for Old IOPT = 1 or 2
C     Then Check for 'U' or 'R'
      READ(IRD,9044) OPTU
 9044 FORMAT(A80)
      READ(OPTU,'(I20)',ERR=55) IOPT
      WRITE(IDAT,*) IOPT
      IF (IOPT .EQ. 1) THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (IOPT .EQ. 2) THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 50
      END IF
      GO TO 33
55    CONTINUE
      READ(OPTU,200) KOPT
      IF (KOPT.EQ.'1' .OR. KOPT.EQ.'U' .OR. KOPT.EQ.'u') THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (KOPT.EQ.'2' .OR. KOPT.EQ.'R' .OR. KOPT.EQ.'r') THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 50
      END IF
      WRITE(IDAT,200) KOPT

33    CONTINUE

      IF (RURAL) THEN
         WRITE(IPRT,*) 'ENTER SURFACE ROUGHNESS LENGTH (USE 0.3 FOR ',
     &                 'DEFAULT) (M): '
      ELSE IF (URBAN) THEN
         WRITE(IPRT,*) 'ENTER SURFACE ROUGHNESS LENGTH (USE 1.0 FOR ',
     &                 'DEFAULT) (M): '
      END IF
      READ(IRD,*,ERR=33) ZROUGH
      WRITE(IDAT,100) ZROUGH
      IF (ZROUGH .GT. 10.) GO TO 33
      IF (ZROUGH .LT. 0.) GO TO 90
      Z0M = ZROUGH

C
C        SET EFFECTIVE STACK PARAMETERS
C
      VS = 20.0
      TS = 1273.
      TA = 293.
      DS = 9.88E-04*(0.45*H)**0.5
      IF (DS .LT. 1E-05) DS=1.0E-05
      HS = HSTK + 4.56E-03 * H**0.478
      WRITE(IPRT,*) 'EFFECTIVE RELEASE HEIGHT =',HS
C
3     WRITE(IPRT,*)'CONSIDER BUILDING DOWNWASH IN CALCS?  ENTER Y OR N:'
      READ(IRD,200) QUERY
      IF(QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
60       WRITE(IPRT,*) 'ENTER BUILDING HEIGHT (M):'
         READ(IRD,*,ERR=60) HB
         WRITE(IDAT,100) HB
         IF(HB  .LT. 0.) GO TO 90
70       WRITE(IPRT,*) 'ENTER MINIMUM HORIZ BLDG DIMENSION (M):'
         READ(IRD,*,ERR=70) HL
         WRITE(IDAT,100) HL
         IF(HL  .LT. 0.) GO TO 90
80       WRITE(IPRT,*) 'ENTER MAXIMUM HORIZ BLDG DIMENSION (M):'
         READ(IRD,*,ERR=80) HW
         WRITE(IDAT,100) HW
         IF(HW  .LT. 0.) GO TO 90
         IF(HL .GT. HW) THEN
            HLSAV = HL
            HL = HW
            HW = HLSAV
         ENDIF
         HWP = SQRT(HL*HL + HW*HW)
      ELSEIF(QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         CONTINUE
      ELSE
         GO TO 3
      ENDIF

C***********************************************************************
C        ENTER DEPOSITION PARAMETERS
C***********************************************************************
39    WRITE(IPRT,*)'CONSIDER PLUME DEPLETION EFFECTS?  ENTER Y OR N:'
      READ(IRD,200) QUERY
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
         DPLETE = .TRUE.
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         DPLETE = .FALSE.
      ELSE
         GO TO 39
      END IF

150   WRITE(IPRT,*) 'ENTER PARTICLE DENSITY (USE 1.0 FOR ',
     &              'DEFAULT) (G/CM**3) : '
      READ(IRD,*,ERR=150) PARDEN
      WRITE(IDAT,100) PARDEN
      IF (PARDEN .LT. 0.) GO TO 90
155   WRITE(IPRT,*) 'ENTER NUMBER OF PARTICLE SIZE CATEGORIES (<= 20): '
      READ(IRD,*,ERR=155) NPD
      WRITE(IDAT,*) NPD
      IF (NPD .GT. 20) GO TO 155
      IF (NPD .LT. 0) GO TO 90
160   WRITE(IPRT,*) 'ENTER PARTICLE DIAMETER FOR EACH CATEGORY ',
     &              '(MICRONS): '
      READ(IRD,*,ERR=160) (PDIAM(I), I=1,NPD)
      WRITE(IDAT,*) (PDIAM(I), I=1,NPD)
170   WRITE(IPRT,*) 'ENTER MASS FRACTION FOR EACH CATEGORY ',
     &              '(MUST SUM TO 1.0): '
      READ(IRD,*,ERR=170) (PHI(I), I=1,NPD)
      WRITE(IDAT,*) (PHI(I), I=1,NPD)
      PHISUM = 0.0
      DO 176 I = 1, NPD
         PHISUM = PHISUM + PHI(I)
176   CONTINUE
      IF (PHISUM .LT. 0.98 .OR. PHISUM .GT. 1.02) GO TO 170
C     Assign Particle Density to Each Category
      DO 177 I = 1, NPD
         PDENS(I) = PARDEN
177   CONTINUE

C***********************************************************************
C        CHECK FOR COMPLEX TERRAIN SCREENING OPTION
C***********************************************************************
4     WRITE(IPRT,*) 'USE COMPLEX TERRAIN SCREEN FOR TERRAIN ABOVE',
     &   ' STACK HEIGHT?'
      WRITE(IPRT,*) 'ENTER Y OR N:'
      READ(IRD,200) QUERY
200   FORMAT(A1)
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
         CALL VALLEY
         IF (STP) RETURN
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         CONTINUE
      ELSE
         GO TO 4
      END IF
C
C        WRITE DATE, TIME, AND INPUT VALUES TO OUTPUT FILE
C
C     Assign ASCII Form Feed Character to Variable FFEED
      FFEED = CHAR(12)
      WRITE(IOUT,101) FFEED
      WRITE(IOUT,102) RUNDAT, RUNTIM
101   FORMAT(1X,A1)
102   FORMAT(70X,A8/70X,A8)
      WRITE(IOUT,103) VERSN, TITLE, Q, HSTK, H, ZR, KPRT, ZROUGH,
     &                HS, HB, HL, HW
103   FORMAT(' ',1X,'***  SCREEN3 MODEL RUN  ***',
     &         /,2X,'*** VERSION DATED ',A5,' ***',//,1X,A79,//,
     &       1X,'SIMPLE TERRAIN INPUTS:',/,
     &       1X,'   SOURCE TYPE                  =        FLARE ',
     &                                           'w/ DRY DEPOSITION',/,
     &       1X,'   EMISSION RATE (G/S)          = ',G16.6,/,
     &       1X,'   FLARE STACK HEIGHT (M)       = ',F12.4,/,
     &       1X,'   TOT HEAT RLS (CAL/S)         = ',G16.6,/,
     &       1X,'   RECEPTOR HEIGHT (M)          = ',F12.4,/,
     &       1X,'   URBAN/RURAL OPTION           = ',7X,A5,/,
     &       1X,'   SURFACE ROUGHNESS LENGTH (M) = ',F12.4,/,
     &       1X,'   EFF RELEASE HEIGHT (M)       = ',F12.4,/,
     &       1X,'   BUILDING HEIGHT (M)          = ',F12.4,/,
     &       1X,'   MIN HORIZ BLDG DIM (M)       = ',F12.4,/,
     &       1X,'   MAX HORIZ BLDG DIM (M)       = ',F12.4,/)
      IF (DPLETE) THEN
         WRITE(IOUT,113)
113      FORMAT(1X,'   PLUME DEPLETION OPTION       =           ON',/)
      ELSE
         WRITE(IOUT,114)
114      FORMAT(1X,'   PLUME DEPLETION OPTION       =          OFF',/)
      END IF
      WRITE(IOUT,109) PARDEN
109   FORMAT(1X,'   PARTICLE DENSITY (G/CM**3)   = ',F12.4)
      WRITE(IOUT,111) (PDIAM(I),PHI(I),I=1,NPD)
111   FORMAT(1X,'   PARTICLE DIAMETERS (MICRONS)      MASS FRACTIONS',/
     &         '    ----------------------------      --------------',/
     &      (10X,F12.4,13X,F12.4))

C

      RETURN
90    WRITE(IPRT,*) 'YOU HAVE ENTERED AN UNACCEPTABLE VALUE.  START',
     &              ' OVER.'
      GO TO 10
      END

      SUBROUTINE INADEP
C
C        DATA ENTRY ROUTINE FOR AREA SOURCES WITH DEPOSITION.
C        CALCULATES CONCENTRATIONS USING NUMERICAL INTEGRATION APPROACH.
C 
      INCLUDE 'MAIN.INC'
      CHARACTER*1 FFEED

      FSTCAL = .TRUE.
      STP = .FALSE.
      VS = 1.0E-05
      DS = 1.0E-05
      TS = 293.
      TA = 293.
10    WRITE(IPRT,*) 'ENTER EMISSION RATE (G/(S-M**2)): '
      READ(IRD,*,ERR=10) Q
      WRITE(IDAT,100) Q
      IF (Q  .LE. 0.) GO TO 90
100   FORMAT(1X,G11.4)
20    WRITE(IPRT,*) 'ENTER SOURCE RELEASE HEIGHT (M): '
      READ(IRD,*,ERR=20) HS
      WRITE(IDAT,100) HS
      IF (HS .LT. 0.) GO TO 90
30    WRITE(IPRT,*) 'ENTER LENGTH OF LARGER SIDE FOR AREA (M):'
      READ(IRD,*,ERR=30) XINIT
      WRITE(IDAT,100) XINIT
      IF (XINIT .LE. 0.) GO TO 90
35    WRITE(IPRT,*) 'ENTER LENGTH OF SMALLER SIDE FOR AREA (M):'
      READ(IRD,*,ERR=35) YINIT
      WRITE(IDAT,100) YINIT
      IF (YINIT .LE. 0.) GO TO 90
      IF (XINIT .LT. YINIT) THEN
         XSAV = XINIT
         XINIT = YINIT
         YINIT = XSAV
      END IF
      ASPECT = XINIT/YINIT
      IF (ASPECT .GT. 10.0) THEN
         WRITE(IPRT,*) 'ASPECT RATIO EXCEEDS 10.  SUBDIVIDE AREA AND',
     &                 ' ENTER DIMENSIONS AGAIN!'
         GO TO 30
      END IF
40    WRITE(IPRT,*) 'ENTER RECEPTOR HEIGHT ABOVE GROUND (FOR',
     &              ' FLAGPOLE RECEPTOR) (M): '
      READ(IRD,*,ERR=40) ZR
      WRITE(IDAT,100) ZR
      IF (ZR .LT. 0.) GO TO 90
50    WRITE(IPRT,*) 'ENTER URBAN/RURAL OPTION (U=URBAN, R=RURAL): '
C     Read Input as Character String - First Check for Old IOPT = 1 or 2
C     Then Check for 'U' or 'R'
      READ(IRD,9044) OPTU
 9044 FORMAT(A80)
      READ(OPTU,'(I20)',ERR=55) IOPT
      WRITE(IDAT,*) IOPT
      IF (IOPT .EQ. 1) THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (IOPT .EQ. 2) THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 50
      END IF
      GO TO 33
55    CONTINUE
      READ(OPTU,200) KOPT
200   FORMAT(A1)
      IF (KOPT.EQ.'1' .OR. KOPT.EQ.'U' .OR. KOPT.EQ.'u') THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (KOPT.EQ.'2' .OR. KOPT.EQ.'R' .OR. KOPT.EQ.'r') THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 50
      END IF
      WRITE(IDAT,200) KOPT

33    CONTINUE

      IF (RURAL) THEN
         WRITE(IPRT,*) 'ENTER SURFACE ROUGHNESS LENGTH (USE 0.3 FOR ',
     &                 'DEFAULT) (M): '
      ELSE IF (URBAN) THEN
         WRITE(IPRT,*) 'ENTER SURFACE ROUGHNESS LENGTH (USE 1.0 FOR ',
     &                 'DEFAULT) (M): '
      END IF
      READ(IRD,*,ERR=33) ZROUGH
      WRITE(IDAT,100) ZROUGH
      IF (ZROUGH .GT. 10.) GO TO 33
      IF (ZROUGH .LT. 0.) GO TO 90
      Z0M = ZROUGH

4     WRITE(IPRT,*) 'SEARCH THROUGH RANGE OF DIRECTIONS TO FIND',
     &   ' THE MAXIMUM? '
      WRITE(IPRT,*) 'ENTER Y OR N:'
      READ(IRD,200) QUERY
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
         MAXWD = .TRUE.
         WDIR = 270.
         ANGLE = 0.0
         ANGRAD = 0.0
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         MAXWD = .FALSE.
65       WRITE(IPRT,*) 'ENTER DIRECTION RELATIVE TO THE DIRECTION',
     &      ' PERPENDICULAR TO THE SMALLER SIDE: '
         READ(IRD,*,ERR=65) ANGLE
         WRITE(IDAT,100) ANGLE
         WDMAX = ANGLE
         ANGRAD = -1.0 * ANGLE * DTORAD
         WDIR = 270.
      ELSE
         GO TO 4
      END IF
C
C     Set Vertices (in km) for Rectangular Area with Center at (0,0).
C     Rotate Area About the Center to Accommodate User-Input Direction.
      NVERT = 4
      AXVERT(1) =  (0.5*YINIT*SIN(ANGRAD)-0.5*XINIT*COS(ANGRAD))/1000.
      AYVERT(1) = (-0.5*YINIT*COS(ANGRAD)-0.5*XINIT*SIN(ANGRAD))/1000.
      AXVERT(2) = (-0.5*YINIT*SIN(ANGRAD)-0.5*XINIT*COS(ANGRAD))/1000.
      AYVERT(2) =  (0.5*YINIT*COS(ANGRAD)-0.5*XINIT*SIN(ANGRAD))/1000.
      AXVERT(3) = (-0.5*YINIT*SIN(ANGRAD)+0.5*XINIT*COS(ANGRAD))/1000.
      AYVERT(3) =  (0.5*YINIT*COS(ANGRAD)+0.5*XINIT*SIN(ANGRAD))/1000.
      AXVERT(4) =  (0.5*YINIT*SIN(ANGRAD)+0.5*XINIT*COS(ANGRAD))/1000.
      AYVERT(4) = (-0.5*YINIT*COS(ANGRAD)+0.5*XINIT*SIN(ANGRAD))/1000.
      AXVERT(5) = AXVERT(1)
      AYVERT(5) = AYVERT(1)

C     Determine SIN and COS of WDIR
      WDRAD = WDIR * DTORAD
      WDSIN = SIN(WDRAD)
      WDCOS = COS(WDRAD)

C***********************************************************************
C        ENTER DEPOSITION PARAMETERS
C***********************************************************************
39    WRITE(IPRT,*)'CONSIDER PLUME DEPLETION EFFECTS?  ENTER Y OR N:'
      READ(IRD,200) QUERY
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
         DPLETE = .TRUE.
C        Write caution about long runtime for AREA source w/ depletion
         WRITE(IPRT,*) '********************************************'
         WRITE(IPRT,*) 'YOU HAVE SELECTED THE PLUME DEPLETION OPTION'
         WRITE(IPRT,*) 'FOR AN AREA SOURCE.  THIS OPTION MAY TAKE A '
         WRITE(IPRT,*) 'VERY LONG TIME TO EXECUTE.  FOR A FASTER AND'
         WRITE(IPRT,*) 'MORE CONSERVATIVE ANSWER, CONSIDER PRESSING '
         WRITE(IPRT,*) 'CTRL+BREAK TO EXIT AND RERUN WITHOUT USING  '
         WRITE(IPRT,*) 'THE DEPLETION OPTION.                       '
         WRITE(IPRT,*) '********************************************'
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         DPLETE = .FALSE.
      ELSE
         GO TO 39
      END IF

150   WRITE(IPRT,*) 'ENTER PARTICLE DENSITY (USE 1.0 FOR ',
     &              'DEFAULT) (G/CM**3) : '
      READ(IRD,*,ERR=150) PARDEN
      WRITE(IDAT,100) PARDEN
      IF (PARDEN .LT. 0.) GO TO 90
155   WRITE(IPRT,*) 'ENTER NUMBER OF PARTICLE SIZE CATEGORIES (<= 20): '
      READ(IRD,*,ERR=155) NPD
      WRITE(IDAT,*) NPD
      IF (NPD .GT. 20) GO TO 155
      IF (NPD .LT. 0) GO TO 90
160   WRITE(IPRT,*) 'ENTER PARTICLE DIAMETER FOR EACH CATEGORY ',
     &              '(MICRONS): '
      READ(IRD,*,ERR=160) (PDIAM(I), I=1,NPD)
      WRITE(IDAT,*) (PDIAM(I), I=1,NPD)
170   WRITE(IPRT,*) 'ENTER MASS FRACTION FOR EACH CATEGORY ',
     &              '(MUST SUM TO 1.0): '
      READ(IRD,*,ERR=170) (PHI(I), I=1,NPD)
      WRITE(IDAT,*) (PHI(I), I=1,NPD)
      PHISUM = 0.0
      DO 176 I = 1, NPD
         PHISUM = PHISUM + PHI(I)
176   CONTINUE
      IF (PHISUM .LT. 0.98 .OR. PHISUM .GT. 1.02) GO TO 170
C     Assign Particle Density to Each Category
      DO 177 I = 1, NPD
         PDENS(I) = PARDEN
177   CONTINUE

C     Assign ASCII Form Feed Character to Variable FFEED
      FFEED = CHAR(12)
      WRITE(IOUT,101) FFEED
      WRITE(IOUT,102) RUNDAT, RUNTIM
101   FORMAT(1X,A1)
102   FORMAT(70X,A8/70X,A8)
      WRITE(IOUT,103) VERSN, TITLE, Q, HS, XINIT, YINIT, ZR, KPRT,
     &                ZROUGH
103   FORMAT(' ',1X,'***  SCREEN3 MODEL RUN  ***',
     &         /,2X,'*** VERSION DATED ',A5,' ***',//,1X,A79,//,
     &       1X,'SIMPLE TERRAIN INPUTS:',/,
     &       1X,'   SOURCE TYPE                  =         AREA ',
     &                                           'w/ DRY DEPOSITION',/,
     &       1X,'   EMISSION RATE (G/(S-M**2))   = ',G16.6,/,
     &       1X,'   SOURCE HEIGHT (M)            = ',F12.4,/,
     &       1X,'   LENGTH OF LARGER SIDE (M)    = ',F12.4,/,
     &       1X,'   LENGTH OF SMALLER SIDE (M)   = ',F12.4,/,
     &       1X,'   RECEPTOR HEIGHT (M)          = ',F12.4,/,
     &       1X,'   URBAN/RURAL OPTION           = ',7X,A5,/,
     &       1X,'   SURFACE ROUGHNESS LENGTH (M) = ',F12.4)
      IF (MAXWD) THEN
         WRITE(IOUT,104)
104      FORMAT('    MODEL ESTIMATES DIRECTION TO MAX CONCENTRATION')
      ELSE
         WRITE(IOUT,105) ANGLE
105      FORMAT(1X,'   ANGLE RELATIVE TO LONG AXIS  = ',F12.4)
      END IF

      IF (DPLETE) THEN
         WRITE(IOUT,113)
113      FORMAT(1X,'   PLUME DEPLETION OPTION       =           ON',/)
      ELSE
         WRITE(IOUT,114)
114      FORMAT(1X,'   PLUME DEPLETION OPTION       =          OFF',/)
      END IF
      WRITE(IOUT,109) PARDEN
109   FORMAT(1X,'   PARTICLE DENSITY (G/CM**3)   = ',F12.4)
      WRITE(IOUT,111) (PDIAM(I),PHI(I),I=1,NPD)
111   FORMAT(1X,'   PARTICLE DIAMETERS (MICRONS)      MASS FRACTIONS',/
     &         '    ----------------------------      --------------',/
     &      (10X,F12.4,13X,F12.4))

      RETURN
90    WRITE(IPRT,*) 'YOU HAVE ENTERED AN UNACCEPTABLE VALUE.  START',
     &              ' OVER.'
      GO TO 10
      END

      SUBROUTINE INVDEP
C
C        DATA ENTRY ROUTINE FOR VOLUME SOURCES WITH DEPOSITION.
C        CALCULATES CONCENTRATIONS USING A VIRTUAL POINT SOURCE ALGORITHM.
C 
      INCLUDE 'MAIN.INC'
      CHARACTER*1 FFEED

      STP = .FALSE.
      VS = 1.0E-05
      DS = 1.0E-05
      TS = 293.
      TA = 293.
10    WRITE(IPRT,*) 'ENTER EMISSION RATE (G/S): '
      READ(IRD,*,ERR=10) Q
      WRITE(IDAT,100) Q
      IF (Q  .LE. 0.) GO TO 90
100   FORMAT(1X,G11.4)
20    WRITE(IPRT,*) 'ENTER SOURCE RELEASE HEIGHT (M): '
      READ(IRD,*,ERR=20) HS
      WRITE(IDAT,100) HS
      IF (HS .LT. 0.) GO TO 90
30    WRITE(IPRT,*) 'ENTER INITIAL LATERAL DIMENSION OF VOLUME ',
     &              'SOURCE (M):'
      READ(IRD,*,ERR=30) SYINIT
      WRITE(IDAT,100) SYINIT
      IF (SYINIT .LT. 0.) GO TO 90
35    WRITE(IPRT,*) 'ENTER INITIAL VERTICAL DIMENSION OF VOLUME ',
     &              'SOURCE (M):'
      READ(IRD,*,ERR=35) SZINIT
      WRITE(IDAT,100) SZINIT
      IF (SZINIT .LT. 0.) GO TO 90
40    WRITE(IPRT,*) 'ENTER RECEPTOR HEIGHT ABOVE GROUND (FOR',
     &              ' FLAGPOLE RECEPTOR) (M): '
      READ(IRD,*,ERR=40) ZR
      WRITE(IDAT,100) ZR
      IF (ZR .LT. 0.) GO TO 90
50    WRITE(IPRT,*) 'ENTER URBAN/RURAL OPTION (U=URBAN, R=RURAL): '
C     Read Input as Character String - First Check for Old IOPT = 1 or 2
C     Then Check for 'U' or 'R'
      READ(IRD,9044) OPTU
 9044 FORMAT(A80)
      READ(OPTU,'(I20)',ERR=55) IOPT
      WRITE(IDAT,*) IOPT
      IF (IOPT .EQ. 1) THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (IOPT .EQ. 2) THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 50
      END IF
      GO TO 33
55    CONTINUE
      READ(OPTU,200) KOPT
200   FORMAT(A1)
      IF (KOPT.EQ.'1' .OR. KOPT.EQ.'U' .OR. KOPT.EQ.'u') THEN
         KOPT = 'U'
         KPRT = 'URBAN'
         URBAN = .TRUE.
         RURAL = .FALSE.
      ELSE IF (KOPT.EQ.'2' .OR. KOPT.EQ.'R' .OR. KOPT.EQ.'r') THEN
         KOPT = 'R'
         KPRT = 'RURAL'
         RURAL = .TRUE.
         URBAN = .FALSE.
      ELSE
         GO TO 50
      END IF
      WRITE(IDAT,200) KOPT

33    CONTINUE

      IF (RURAL) THEN
         WRITE(IPRT,*) 'ENTER SURFACE ROUGHNESS LENGTH (USE 0.3 FOR ',
     &                 'DEFAULT) (M): '
      ELSE IF (URBAN) THEN
         WRITE(IPRT,*) 'ENTER SURFACE ROUGHNESS LENGTH (USE 1.0 FOR ',
     &                 'DEFAULT) (M): '
      END IF
      READ(IRD,*,ERR=33) ZROUGH
      WRITE(IDAT,100) ZROUGH
      IF (ZROUGH .GT. 10.) GO TO 33
      IF (ZROUGH .LT. 0.) GO TO 90
      Z0M = ZROUGH

C***********************************************************************
C        ENTER DEPOSITION PARAMETERS
C***********************************************************************
39    WRITE(IPRT,*)'CONSIDER PLUME DEPLETION EFFECTS?  ENTER Y OR N:'
      READ(IRD,200) QUERY
      IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
         WRITE(IDAT,200) QUERY
         DPLETE = .TRUE.
      ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
         WRITE(IDAT,200) QUERY
         DPLETE = .FALSE.
      ELSE
         GO TO 39
      END IF

150   WRITE(IPRT,*) 'ENTER PARTICLE DENSITY (USE 1.0 FOR ',
     &              'DEFAULT) (G/CM**3) : '
      READ(IRD,*,ERR=150) PARDEN
      WRITE(IDAT,100) PARDEN
      IF (PARDEN .LT. 0.) GO TO 90
155   WRITE(IPRT,*) 'ENTER NUMBER OF PARTICLE SIZE CATEGORIES (<= 20): '
      READ(IRD,*,ERR=155) NPD
      WRITE(IDAT,*) NPD
      IF (NPD .GT. 20) GO TO 155
      IF (NPD .LT. 0) GO TO 90
160   WRITE(IPRT,*) 'ENTER PARTICLE DIAMETER FOR EACH CATEGORY ',
     &              '(MICRONS): '
      READ(IRD,*,ERR=160) (PDIAM(I), I=1,NPD)
      WRITE(IDAT,*) (PDIAM(I), I=1,NPD)
170   WRITE(IPRT,*) 'ENTER MASS FRACTION FOR EACH CATEGORY ',
     &              '(MUST SUM TO 1.0): '
      READ(IRD,*,ERR=170) (PHI(I), I=1,NPD)
      WRITE(IDAT,*) (PHI(I), I=1,NPD)
      PHISUM = 0.0
      DO 176 I = 1, NPD
         PHISUM = PHISUM + PHI(I)
176   CONTINUE
      IF (PHISUM .LT. 0.98 .OR. PHISUM .GT. 1.02) GO TO 170
C     Assign Particle Density to Each Category
      DO 177 I = 1, NPD
         PDENS(I) = PARDEN
177   CONTINUE

C     Assign ASCII Form Feed Character to Variable FFEED
      FFEED = CHAR(12)
      WRITE(IOUT,101) FFEED
      WRITE(IOUT,102) RUNDAT, RUNTIM
101   FORMAT(1X,A1)
102   FORMAT(70X,A8/70X,A8)
      WRITE(IOUT,103) VERSN, TITLE, Q, HS, SYINIT, SZINIT, ZR, KPRT,
     &                ZROUGH
103   FORMAT(' ',1X,'***  SCREEN3 MODEL RUN  ***',
     &         /,2X,'*** VERSION DATED ',A5,' ***',//,1X,A79,//,
     &       1X,'SIMPLE TERRAIN INPUTS:',/,
     &       1X,'   SOURCE TYPE                  =       VOLUME ',
     &                                           'w/ DRY DEPOSITION',/,
     &       1X,'   EMISSION RATE (G/S)          = ',G16.6,/,
     &       1X,'   SOURCE HEIGHT (M)            = ',F12.4,/,
     &       1X,'   INIT. LATERAL DIMEN (M)      = ',F12.4,/,
     &       1X,'   INIT. VERTICAL DIMEN (M)     = ',F12.4,/,
     &       1X,'   RECEPTOR HEIGHT (M)          = ',F12.4,/,
     &       1X,'   URBAN/RURAL OPTION           = ',7X,A5,/,
     &       1X,'   SURFACE ROUGHNESS LENGTH (M) = ',F12.4)
      IF (DPLETE) THEN
         WRITE(IOUT,113)
113      FORMAT(1X,'   PLUME DEPLETION OPTION       =           ON',/)
      ELSE
         WRITE(IOUT,114)
114      FORMAT(1X,'   PLUME DEPLETION OPTION       =          OFF',/)
      END IF
      WRITE(IOUT,109) PARDEN
109   FORMAT(1X,'   PARTICLE DENSITY (G/CM**3)   = ',F12.4)
      WRITE(IOUT,111) (PDIAM(I),PHI(I),I=1,NPD)
111   FORMAT(1X,'   PARTICLE DIAMETERS (MICRONS)      MASS FRACTIONS',/
     &         '    ----------------------------      --------------',/
     &      (10X,F12.4,13X,F12.4))

      RETURN
90    WRITE(IPRT,*) 'YOU HAVE ENTERED AN UNACCEPTABLE VALUE.  START',
     &              ' OVER.'
      GO TO 10
      END

c----------------------------------------------------------------------
      subroutine vdp1
c----------------------------------------------------------------------
c
c --- ISC2LT     Version:  1.0     Level:  930215                  VDP1
c                J. Scire, SRC
c
c --- PURPOSE:  Setup routine for PARTICLE dry deposition.
c               Completes particle common block /SOURC4/.  Performs
c               initialization and time-invariant calculations.
c
c --- INPUTS:
c     Common block /SOURC4/ variables:
c              INPD - integer    - Number of particle size categories
c            APDIAM - real array - Mean diameter (microns) of each
c                                  particle size category
c              APHI - real array - Mass fraction in each size category
c            APDENS - real       - Particle density (g/cm**3)
c
c --- OUTPUT:
c     Common block /SOURC4/ variables:
c               ASC - real array - Schmidt number
c            AVGRAV - real array - Gravitational settling velocity (m/s)
c            ATSTOP - real array - Stopping time (s)
c            VAIRMS - real       - Viscosity of air (m**2/s)
c             ZRDEP - real       - Reference height (m) for Deposition
c            VDPHOR - real       - Phoretic effects term (m/s)
c
c --- VDP1 called by:  SOCARD
c --- VDP1 calls:      none
c----------------------------------------------------------------------
c
      INCLUDE 'MAIN.INC'

      data a1/1.257/,a2/0.4/,a3/0.55/,xmfp/6.5e-6/
      data vcon/1.81e-4/,xk/1.38e-16/
      data vair/0.15/,gcgs/981./,rhoair/1.2e-3/,tair/293.15/
c
cxxx      IDBG=iounit
c ***
cxxx      if(DEBUG)then
cxxx         write(IDBG,*)
cxxx         write(IDBG,*)'SUBR. VDP1 -- INPUTS'
cxxx         write(IDBG,*)
cxxx         do 5 i=1,numsrc
cxxx         write(IDBG,*)'SOURCE          = ',i
cxxx         write(IDBG,*)'INPD            = ',inpd(i)
cxxx         write(IDBG,*)'APDIAM (um)     = ',(apdiam(n,i),n=1,inpd(i))
cxxx         write(IDBG,*)'APDIAM (um)     = ',(apdiam(n,i),n=1,inpd(i))
cxxx         write(IDBG,*)'APHI            = ',(aphi(n,i),n=1,inpd(i))
cxxx         write(IDBG,*)'APDENS(g/cm**3) = ',(apdens(n,i),n=1,inpd(i))
cxxx         write(IDBG,*)
cxxx5        continue
cxxx      endif
c ***
c
c --- Convert viscosity of air (at 20 deg C) from cm**2/s to m**2/s
      vairms=1.e-4*vair
c
c --- Set reference height for aerodynamic resistance calculation
      zrdep=1.0
c
c --- Define phoretic effects term (m/s)
      vdphor=0.0001
c
cxxxc --  LOOP over sources
cxxx      do 25 j=1,numsrc
c
cxxxc --- LOOP over "INPD" size intervals if non-zero
cxxx         if(inpd(j) .LE. 0) goto 25
cxxx         do 20 i=1,inpd(j)
         do 20 i=1,npd
c
c ---       Slip correction factor
            diamcm=1.e-4*pdiam(i)
            scf=1.+2.0*xmfp*(a1+a2*exp(-a3*diamcm/xmfp))/diamcm
c
c ---       Stokes friction coefficient
            sfc=3.*pi*vcon*diamcm/scf
c
c ---       Diffusivity (cm**2/s)
            diff=xk*tair/sfc
c ***
            if(DEBUG)then
               write(IDBG,*)'i = ',i,' diamcm = ',diamcm,' scf = ',scf,
     1         ' sfc = ',sfc,' diff = ',diff
            endif
c ***
c
c ---       Schmidt number
c ---       (vair = viscosity of air at 20 deg. c = 0.15 cm**2/s)
            sc(i)=vair/diff
c
c ---       Gravitational settling velocity (m/s)
c ---       (rhoair is approx. density of air -- 1.2e-3 g/cm**3)
            vgrav(i)=0.01*(pdens(i)-rhoair)*gcgs*diamcm**2
     1                     *scf/(18.*vcon)
c
c ---       Stopping times
            tstop(i)=vgrav(i)/(0.01*gcgs)
20       continue
cxxx25    continue
c ***
      if(DEBUG)then
         write(IDBG,*)
         write(IDBG,*)'SUBR. VDP1 -- Outputs'
         write(IDBG,*)
cxxx         do 30 i=1,numsrc
cxxx         write(IDBG,*)'SOURCE          = ',i
         write(IDBG,*)'ASC             = ',(sc(n),n=1,npd)
         write(IDBG,*)'AVGRAV (m/s)    = ',(vgrav(n),n=1,npd)
         write(IDBG,*)'ATSTOP (s)      = ',(tstop(n),n=1,npd)
         write(IDBG,*)'VAIRMS (m**2/s) = ',vairms
         write(IDBG,*)'ZRDEP (m)       = ',zrdep
         write(IDBG,*)'VDPHOR (m/s)    = ',vdphor
         write(IDBG,*)
cxxx30       continue
      endif
c ***
c
      return
      end

      SUBROUTINE LWRUPR
C***********************************************************************
C                 LWRUPR Module of SCREEN2 Model
C
C        PURPOSE: Transfer All Characters From Lower Case To
C                 Upper Case (Using INDEX Intrinsic Function)
C
C        PROGRAMMER: Roger Brode, Kevin Stroupe
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Option String (80 Characters)
C
C        OUTPUTS: Option String in Uppercase
C
C        CALLED FROM:   INPUTP
C***********************************************************************
C
C     Variable Declarations
      INCLUDE 'MAIN.INC'
      CHARACTER UPCASE*26
      CHARACTER LWCASE*26

C     Variable Initializations
      DATA UPCASE/'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
      DATA LWCASE/'abcdefghijklmnopqrstuvwxyz'/
CISC2      MODNAM = 'LWRUPR'

      DO 20 I = 1, 80
         IF (OPTG(I:I) .NE. ' ') THEN
            INDCHK = INDEX(LWCASE,OPTG(I:I))
            IF (INDCHK .NE. 0) THEN
               OPTG(I:I) = UPCASE(INDCHK:INDCHK)
            END IF
         END IF
 20   CONTINUE

      RETURN
      END

      SUBROUTINE CHOICE(IMET)
C
C     SUBROUTINE CHOICE SETS PARAMETERS TO CONTROL RANGE OF 
C     METEOROLOGICAL CONDITIONS EXAMINED BASED ON USER SUPPLIED
C     CHOICE OF METEOROLOGY
C
C     INPUT:
C             IMET  - CHOICE OF METEOROLOGY:
C                     1 - FULL METEOROLOGY
C                     2 - INPUT SINGLE STABILITY CLASS
C                     3 - INPUT SINGLE STAB CLASS AND WIND SPEED
C
C     OUTPUT:
C             KMAX  - NUMBER OF STABILITY CLASSES TO EXAMINE
C             IST   - ARRAY OF STABILITY CLASSES TO EXAMINE
C             UINP  - USER SUPPLIED 10M WIND SPEED FOR IMET = 3
C             WSINP - LOGICAL VARIABLE FOR USER SUPPLIED WS
C
      INCLUDE 'MAIN.INC'
      CHARACTER*6 QVAR
      REAL UINMAX(6)
      DATA UINMAX/3.,5.,10.,20.,5.,4./
C
      KSTINP = .FALSE.
      WSINP = .FALSE.
      UINP  = 1.0
C      
      IF (IMET .EQ. 1) THEN
C***********************************************************************
C        FULL METEOROLOGY
C***********************************************************************
         WRITE(IDAT,*) IMET
         WRITE(IOUT3,*) '*** FULL METEOROLOGY ***'
         KMAX = 6
         DO 20 I=1,KMAX
            IST(I) = I
20       CONTINUE
C
      ELSE IF (IMET .EQ. 2) THEN
C***********************************************************************
C        INPUT SINGLE STABILITY CLASS
C***********************************************************************
         WRITE(IDAT,*) IMET
         KMAX = 1
         KSTINP = .TRUE.
C31       WRITE(IPRT,*) 'ENTER STABILITY CLASS, 1(=A) TO 6(=F):'
         QVAR = 'IST'
31       READ(IRD,*,ERR=99) IST(1)
         IF (IST(1) .LT. 1 .OR. IST(1) .GT. 6) THEN
C            WRITE(IPRT,*) 'NOT A VALID STABILITY CLASS! TRY AGAIN.'
            GO TO 31
         END IF
         WRITE(IDAT,*) IST(1)
         WRITE(IOUT3,120) IST(1)
120      FORMAT(1X,'*** STABILITY CLASS ',I2,' ONLY ***')
C
      ELSE IF (IMET .EQ. 3) THEN
C***********************************************************************
C        INPUT SINGLE STABILITY CLASS AND 10-METER WIND SPEED
C***********************************************************************
         WRITE(IDAT,*) IMET
         KMAX = 1
         KSTINP = .TRUE.
         WSINP = .TRUE.
C33       WRITE(IPRT,*) 'ENTER STABILITY CLASS, 1(=A) TO 6(=F):'
         QVAR = 'IST'
33       READ(IRD,*,ERR=99) IST(1)
         IF (IST(1) .LT. 1 .OR. IST(1) .GT. 6) THEN
C            WRITE(IPRT,*) 'NOT A VALID STABILITY CLASS!  TRY AGAIN.'
            GO TO 33
         END IF
         WRITE(IDAT,*) IST(1)
         WRITE(IOUT3,125) IST(1)
125      FORMAT(1X,'*** STABILITY CLASS ',I2,' ONLY ***')
C34       WRITE(IPRT,*) 'ENTER 10-METER WIND SPEED (M/S):'
         QVAR = 'UINP'
34       READ(IRD,*,ERR=99) UINP
         IND = IST(1)
         IF (UINP .LT. 1.0 .OR. UINP .GT. UINMAX(IND)) THEN
C            WRITE(IPRT,*) 'NOT A VALID WIND SPEED!  TRY AGAIN.'
            GO TO 34
         END IF
         WRITE(IDAT,*) UINP
         WRITE(IOUT3,130) UINP
130      FORMAT(1X,'*** 10-METER WIND SPEED OF ',F6.2,' M/S ONLY ***')
C
      END IF

      IF (.NOT.LDEP .AND. AREA .AND. HS.LE.2.0 .AND. .NOT.KSTINP) THEN
C        Limit Stability Loop to Stable Classes for Low-level AREA Sources
         IF (RURAL) THEN
            KMAX = 2
            IST(1) = 5
            IST(2) = 6
         ELSE IF (URBAN) THEN
            KMAX = 1
            IST(1) = 6
         END IF
      END IF
C
      GO TO 98
99    WRITE(IPRT,*) 'ERROR READING: ',QVAR
      STOP
98    RETURN
      END

      SUBROUTINE AUTOX(IT,CMAXST,XMAXST,TMAXST,DMAXST,XMXDST,TMXDST)
C
C     SUBROUTINE AUTOX EXERCISES THE AUTOMATED DISTANCE OPTION TO
C     CALCULATE THE MAXIMUM GROUND LEVEL CONCENTRATION AS A FUNCTION
C     OF DISTANCE, AND TO DETERMINE THE OVERALL MAXIMUM CONCENTRATION
C
C     INPUT:
C            KMAX,IST,UINP,WSINP - PARAMETERS TO CONTROL THE RANGE OF
C                                  METEOROLOGY TO EXAMINE, SPECIFIED
C                                  BY SUBROUTINE CHOICE
C            FLAT    -  LOGICAL VARIABLE TO INDICATE FLAT OR ELEVATED
C                          TERRAIN
C
C     OUTPUT:
C            CMAXST  -  OVERALL MAXIMUM GROUND LEVEL CONCENTRATION
C            XMAXST  -  DOWNWIND DISTANCE ASSOCIATED WITH CMAXST
C            TMAXST  -  TERRAIN ELEVATION ABOVE STACK BASE ASSOCITATED
C                          WITH CMAXST AND XMAXST
C
      INCLUDE 'MAIN.INC'
C PES ADDED CODE BEGINS
      REAL PERCENT,XNUMAUTO,XFEN
      CHARACTER*30 QVAR
CTMP      COMMON /PLOT/ XNUM,DISTX(76),CHIX(76)
CTMP      COMMON /DISCR/ XNUMDIS,XTOT,XCOUNT,XNUMHT
C PES ADDED CODE ENDS
      CONTIN = .FALSE.
      XNUM = 0
      IPLT = 12

      DO 19 I = 1,1
         WRITE(*,*)
19    CONTINUE
      WRITE(*,*)
      XCOUNT = 0
      XNUMAUTO = 0
C
14    CONTINUE
C
      KSTSAV = 0
      KSTSVD = 0

      IF (FLAT) THEN
         HTER = 0.0
      ELSE
C15       WRITE(IPRT,*)'ENTER TERRAIN HEIGHT ABOVE STACK BASE (M):'
         QVAR = 'HTER'
15       READ(IRD,*,ERR=99) HTER
         IF (CONTIN .AND. HTER .LT. HTRLST) THEN
C            WRITE(IPRT,*) 'NEW HEIGHT < PREVIOUS HEIGHT.  TRY AGAIN.'
            GO TO 15
         END IF
         IF (HTER .GT. HS) THEN
C            WRITE(IPRT,*)'TERRAIN HEIGHT > STACK HEIGHT!'
C            WRITE(IPRT,*)'  TERRAIN HEIGHT HAS BEEN SET = STACK',
C     &                   ' HEIGHT.'
C            WRITE(IPRT,*)'  USE COMPLEX TERRAIN SCREENING PROCEDURE'
C            WRITE(IPRT,*)'  FOR TERRAIN ABOVE STACK HEIGHT.'
            HTER = HS
         END IF
         IF (HTER .LT. 0.0) THEN
C            WRITE(IPRT,*)'TERRAIN HEIGHT < 0.0!  TRY AGAIN.'
            GO TO 15
         END IF
         WRITE(IDAT,*) HTER
      END IF
C 
C40    WRITE(IPRT,*) 'ENTER MIN AND MAX DISTANCES TO USE (M):'
      QVAR = 'XMIN'
40    READ(IRD,*,ERR=99) XMIN,XMAX
      IF (XMIN .LT. 1.0) XMIN = 1.0
      IF (CONTIN .AND. XMIN .LT. XMXLST) THEN
C         WRITE(IPRT,*) ' MIN DISTANCE < PREVIOUS MAX.  RANGES'
C         WRITE(IPRT,*) ' SHOULD NOT OVERLAP.  TRY AGAIN. '
         GO TO 40
      END IF
      WRITE(IDAT,44) XMIN,XMAX
44    FORMAT(1X,F8.2,',',F8.2)
C
      IF (XNUMAUTO .EQ. 0) THEN
         XNUMAUTO = 52
         DO 2 I = 1,51
            IF (XMIN.GE. XAUTO(I)) THEN
               XNUMAUTO = XNUMAUTO - 1
            ELSE
               GO TO 18
            ENDIF
2        CONTINUE
      ENDIF
18    XTOT = XNUMAUTO + XNUMDIS + XNUMHT
C
C        INITIALIZE -CNT VARIABLES ASSOCIATED WITH MAX FROM AUTO ARRAY,
C        AND STORE TERRAIN HT AND DISTANCE RANGE FOR LATER SUMMARY
C
      CHICNT = 0.
      XCNT   = 1.
      UCNT   = 0.
      USCNT  = 0.
      HECNT  = 0.
      ZICNT  = 0.
      KSTCNT = 0
      SYCNT  = 0.
      SZCNT  = 0.
      WDCNT  = 0.
      IFGCNT = 5
      DEPCNT = 0.
      XCNTD  = 1.
      UCNTD  = 0.
      USCNTD = 0.
      HECNTD = 0.
      ZICNTD = 0.
      KSTCTD = 0
      SYCNTD = 0.
      SZCNTD = 0.
      WDCNTD = 0.
      IFGCTD = 5
      IT = IT + 1
      HT(IT) = HTER
      RMIN(IT) = XMIN
      RMAX(IT) = XMAX
C
C      WRITE(IPRT,200)
      WRITE(IOUT3,200)
200   FORMAT(/1X,'**********************************',/,
     &        1X,'*** SCREEN AUTOMATED DISTANCES ***',/,
     &        1X,'**********************************',/)
C      WRITE(IPRT,210) HTER
      WRITE(IOUT3,210) HTER
210   FORMAT(1X,'*** TERRAIN HEIGHT OF ',F5.0,' M ABOVE STACK BASE',
     &          ' USED FOR FOLLOWING DISTANCES ***',/)
      IF (LDEP) THEN
C         WRITE(IPRT,317)
         WRITE(IOUT3,317)
317      FORMAT(23X,'DEPOS AT ',28X,'CONC AT  ',/
     &          3X,'DIST',4X,'MAX CONC',4X,'MAX CONC ',7X,'U10M',
     &                    4X,'MAX DEPOS',4X,'MAX DEPOS',7X,'U10M',/
     &   4X,'(M)',3X,'(UG/M**3)',2X,'(G/M**2-HR)',1X,'STAB',1X,'(M/S)',
     &            3X,'(G/M**2-HR)',2X,'(UG/M**3)',2X,'STAB',1X,'(M/S)',
     &          /,1X,'-------',2X,'----------',2X,'----------',1X,
     &               '----',1X,'-----',4X,'----------',2X,'----------',
     &               1X,'----',1X,'-----')
      ELSE IF (AREA) THEN
C         WRITE(IPRT,319)
         WRITE(IOUT3,319)
319      FORMAT(3X,'DIST',5X,'CONC',13X,'U10M',3X,'USTK',2X,'MIX HT',
     &          3X,'PLUME',2X,'MAX DIR',/,4X,'(M)',3X,
     &          '(UG/M**3)',3X,'STAB',2X,'(M/S)',2X,'(M/S)',4X,'(M)',3X,
     &          'HT (M)',3X,'(DEG)',/,1X,
     &          '-------',2X,'----------',2X,'----',2X,'-----',2X,
     &          '-----',2X,'------',2X,'------',2X,
     &          '-------')
      ELSE
C         WRITE(IPRT,300)
         WRITE(IOUT3,300)
300      FORMAT(3X,'DIST',5X,'CONC',13X,'U10M',3X,'USTK',2X,'MIX HT',
     &          3X,'PLUME',3X,'SIGMA',3X,'SIGMA',/,4X,'(M)',3X,
     &          '(UG/M**3)',3X,'STAB',2X,'(M/S)',2X,'(M/S)',4X,'(M)',3X,
     &          'HT (M)',3X,'Y (M)',3X,'Z (M)',2X,'DWASH',/,1X,
     &          '-------',2X,'----------',2X,'----',2X,'-----',2X,
     &          '-----',2X,'------',2X,'------',2X,'------',2X,
     &          '------',2X,'-----')
      END IF
C
C        LOOP THROUGH AUTOMATED DISTANCE ARRAY FROM XMIN OUT TO XMAX
C
      DO 10 IX = 1,51
         IF (IX.EQ.1) THEN
            X = AMAX1(XAUTO(1),XMIN)
         ELSE IF (XAUTO(IX).GT.XMIN.AND.XAUTO(IX).LE.XMAX) THEN
            X = XAUTO(IX)
         ELSE
            GO TO 10
         END IF

         CALL USERX

C PES ADDED CODE BEGINS
         XCOUNT = XCOUNT + 1
         PERCENT = XCOUNT/XTOT*100
         IF (PERCENT .GE. 100) THEN
            PERCENT = 100
         ENDIF
         IPERCENT = NINT(PERCENT)

         WRITE(IPRT,101) IPERCENT
101      FORMAT('+',30X,I3,' % Complete')
         XNUM = XNUM + 1
         CHIX(XNUM) = CHIMAX
         DISTX(XNUM) = X
C PES ADDED CODE ENDS

         IF (LDEP) THEN
            CALL MAXX(KSTMAX,UMAX)
            CALL MAXXD(KSTMXD,UMAXD)
C            WRITE(IPRT,519) X,CHIMAX,DEPSEC,KSTMAX,UMAX,
C     &                        DEPMAX,CONSEC,KSTMXD,UMAXD
            WRITE(IOUT3,519) X,CHIMAX,DEPSEC,KSTMAX,UMAX,
     &                        DEPMAX,CONSEC,KSTMXD,UMAXD

         ELSE IF (AREA) THEN
C            WRITE(IPRT,419) X,CHIMAX,KSTMAX,UMAX,USMAX,ZIMAX,HEMAX,
C     &                      WDMAX
            WRITE(IOUT3,419) X,CHIMAX,KSTMAX,UMAX,USMAX,ZIMAX,HEMAX,
     &                      WDMAX
         ELSE
C            WRITE(IPRT,400) X,CHIMAX,KSTMAX,UMAX,USMAX,ZIMAX,HEMAX,
C     &                      SYMAX,SZMAX,DWASH(IFGMAX)
            WRITE(IOUT3,400) X,CHIMAX,KSTMAX,UMAX,USMAX,ZIMAX,HEMAX,
     &                      SYMAX,SZMAX,DWASH(IFGMAX)
CXXX            IF (LDEP) THEN
CXXX               WRITE(IPRT,400) X,DEPMAX,KSTMXD,UMAXD,USMAXD,ZIMAXD,
CXXX     &                         HEMAXD,SYMAXD,SZMAXD,DWASH(IFGMXD)
CXXX               WRITE(IOUT,400) X,DEPMAX,KSTMXD,UMAXD,USMAXD,ZIMAXD,
CXXX     &                         HEMAXD,SYMAXD,SZMAXD,DWASH(IFGMXD)
CXXX               WRITE(IOUT,*) ' '
CXXX            END IF
         END IF

400      FORMAT(1X,F7.0,2X,G10.4,4X,I1,4X,F4.1,3X,F4.1,1X,F7.1,
     &          3(1X,F7.2),4X,A2)
419      FORMAT(1X,F7.0,2X,G10.4,4X,I1,4X,F4.1,3X,F4.1,1X,F7.1,
     &          1X,F7.2,4X,F4.0)
519      FORMAT(1X,F7.0,2(2X,G10.4),3X,I1,3X,F4.1,2X,
     &                  2(2X,G10.4),3X,I1,3X,F4.1)
         IF (CHIMAX .GT. CHICNT) THEN
            CHICNT = CHIMAX
            XCNT   = X
            UCNT   = UMAX
            USCNT  = USMAX
            HECNT  = HEMAX
            ZICNT  = ZIMAX
            KSTCNT = KSTMAX
            SYCNT  = SYMAX
            SZCNT  = SZMAX
            WDCNT  = WDMAX
            IFGCNT = IFGMAX
         END IF
         IF (DEPMAX .GT. DEPCNT) THEN
            DEPCNT = DEPMAX
            XCNTD  = X
            UCNTD  = UMAXD
            USCNTD = USMAXD
            HECNTD = HEMAXD
            ZICNTD = ZIMAXD
            KSTCTD = KSTMXD
            SYCNTD = SYMAXD
            SZCNTD = SZMAXD
            WDCNTD = WDMAXD
            IFGCTD = IFGMXD
         END IF
10    CONTINUE
C
C        ITERATE TO FIND MAXIMUM CONCENTRATION BEYOND XMIN.
C        DO NOT LET CPEAK BE < CHICNT.
C
C      WRITE(IPRT,*) 'ITERATING TO FIND MAXIMUM CONCENTRATION . . .'
      IF (AREA) THEN
         CALL TPMXA(XCNT,CPEAK,XPEAK,XMIN)
      ELSE
         CALL TPMX(XCNT,CPEAK,XPEAK,XMIN)
      END IF
      KPEAK = KSTMAX
      UPEAK = UMAX
      USPEAK = USMAX
      ZIPEAK = ZIMAX
      HEPEAK = HEMAX
      SYPEAK = SYMAX
      SZPEAK = SZMAX
C      WRITE(IPRT,440) XMIN
      WRITE(IOUT3,440) XMIN
440   FORMAT(/1X,'MAXIMUM 1-HR CONCENTRATION AT OR BEYOND ',F6.0,
     &        ' M:')
      IF (CHICNT .GE. CPEAK) THEN
         IF (LDEP) THEN
            CALL MAXX(KSTMAX,UMAX)
C            WRITE(IPRT,517) XPEAK,CPEAK,DEPSEC,KPEAK,UPEAK
            WRITE(IOUT3,517) XPEAK,CPEAK,DEPSEC,KPEAK,UPEAK
517         FORMAT(1X,F7.0,2(2X,G10.4),3X,I1,3X,F4.1,1X,
     &                     2(5X,'----',3X),3X,'--',4X,'---')
C            WRITE(IPRT,*)
C            WRITE(IPRT,*) 'ITERATING TO FIND MAXIMUM ',
C     &                    'DRY DEPOSITION . . .'
            IF (AREA) THEN
               CALL TPMXAD(XCNTD,DPEAK,XPEAKD,XMIN)
            ELSE
               CALL TPMXD(XCNTD,DPEAK,XPEAKD,XMIN)
            END IF
            UPEAKD = UMAXD
            KPEAKD = KSTMXD
            CALL MAXXD(KSTMXD,UMAXD)
C            WRITE(IPRT,445) XMIN
            WRITE(IOUT3,445) XMIN
445         FORMAT(/1X,'MAXIMUM 1-HR DRY DEPOSITION AT OR BEYOND ',F6.0,
     &             ' M:')
C            WRITE(IPRT,518) XPEAKD,DPEAK,CONSEC,KPEAKD,UPEAKD
            WRITE(IOUT3,518) XPEAKD,DPEAK,CONSEC,KPEAKD,UPEAKD
518         FORMAT(1X,F7.0,2(4X,'----',4X),2X,'--',4X,'---',2X,
     &                     2(2X,G10.4),3X,I1,3X,F4.1)

         ELSE IF (AREA) THEN
C            WRITE(IPRT,419) XCNT,CHICNT,KSTCNT,UCNT,USCNT,ZICNT,
C     &            HECNT,WDCNT
            WRITE(IOUT3,419) XCNT,CHICNT,KSTCNT,UCNT,USCNT,ZICNT,
     &            HECNT,WDCNT
         ELSE
C            WRITE(IPRT,400) XCNT,CHICNT,KSTCNT,UCNT,USCNT,ZICNT,
C     &            HECNT,SYCNT,SZCNT,DWASH(IFGCNT)
            WRITE(IOUT3,400) XCNT,CHICNT,KSTCNT,UCNT,USCNT,ZICNT,
     &            HECNT,SYCNT,SZCNT,DWASH(IFGCNT)
         END IF
         IF (CHICNT .GT. CMAXST) THEN
            CMAXST = CHICNT
            XMAXST = XCNT
            TMAXST = HTER
         END IF
         IF (DEPCNT .GT. DMAXST) THEN
            DMAXST = DEPCNT
            XMXDST = XCNTD
            TMXDST = HTER
         END IF
      ELSE
         IF (LDEP) THEN
            CALL MAXX(KSTMAX,UMAX)
C            WRITE(IPRT,517) XPEAK,CPEAK,DEPSEC,KPEAK,UPEAK
            WRITE(IOUT3,517) XPEAK,CPEAK,DEPSEC,KPEAK,UPEAK
C            WRITE(IPRT,*)
C            WRITE(IPRT,*) 'ITERATING TO FIND MAXIMUM ',
C     &                    'DRY DEPOSITION . . .'
            IF (AREA) THEN
               CALL TPMXAD(XCNTD,DPEAK,XPEAKD,XMIN)
            ELSE
               CALL TPMXD(XCNTD,DPEAK,XPEAKD,XMIN)
            END IF
            UPEAKD = UMAXD
            KPEAKD = KSTMXD
            CALL MAXXD(KSTMXD,UMAXD)
C            WRITE(IPRT,445) XMIN
            WRITE(IOUT3,445) XMIN
C            WRITE(IPRT,518) XPEAKD,DPEAK,CONSEC,KPEAKD,UPEAKD
            WRITE(IOUT3,518) XPEAKD,DPEAK,CONSEC,KPEAKD,UPEAKD

         ELSE IF (AREA) THEN
C            WRITE(IPRT,419) XPEAK,CPEAK,KSTMAX,UPEAK,USPEAK,ZIPEAK,
C     &            HEPEAK,WDMAX
            WRITE(IOUT3,419) XPEAK,CPEAK,KSTMAX,UPEAK,USPEAK,ZIPEAK,
     &            HEPEAK,WDMAX
         ELSE
C            WRITE(IPRT,400) XPEAK,CPEAK,KSTMAX,UPEAK,USPEAK,ZIPEAK,
C     &            HEPEAK,SYPEAK,SZPEAK,DWASH(IFGMAX)
            WRITE(IOUT3,400) XPEAK,CPEAK,KSTMAX,UPEAK,USPEAK,ZIPEAK,
     &            HEPEAK,SYPEAK,SZPEAK,DWASH(IFGMAX)
         END IF
         IF (CPEAK .GT. CMAXST) THEN
            CMAXST = CPEAK
            XMAXST = XPEAK
            TMAXST = HTER
         END IF
         IF (DPEAK .GT. DMAXST) THEN
            DMAXST = DPEAK
            XMXDST = XPEAKD
            TMXDST = HTER
         END IF
      END IF
C PES ADDED CODE BEGINS
            XNUM = XNUM + 1
            CHIX(XNUM) = CMAXST
            DISTX(XNUM) = XMAXST
C PES ADDED CODE ENDS
      IF (.NOT.FLAT) THEN
C         WRITE(IPRT,*) ' '
C13       WRITE(IPRT,*) 'CONTINUE SIMPLE TERRAIN AUTOMATED CALCS',
C     &                 ' WITH NEW TERRAIN HEIGHT?'
C         WRITE(IPRT,*) 'ENTER Y OR N:'
         QVAR = 'SIMP TERRAIN IN AUTOX QUERY'
13       READ(IRD,100,ERR=99) QUERY
100      FORMAT(A1)
         IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
            WRITE(IDAT,100) QUERY
            CONTIN = .TRUE.
            HTRLST = HTER
            XMXLST = XMAX
            GO TO 14
         ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
            WRITE(IDAT,100) QUERY
C            WRITE(IPRT,*) ' '
            CONTINUE
         ELSE 
            GO TO 13
         END IF
      END IF
C
CPES ADDED CODE BEGINS
      XFEN = DISTX(1)
      WRITE(IPLT,70) TITLE
C70    FORMAT(79A1)
70    FORMAT(A79)
      NUM = INT(XNUM)
C
C ****** SORT ******
      N1 = NUM - 1
      DO 700 I = 1, N1
         I1 = I + 1
         DO 600 J = I1, NUM
            IF (DISTX(I) .LE. DISTX(J)) GOTO 600
            HOLD = DISTX(I)
            DISTX(I) = DISTX(J)
            DISTX(J) = HOLD
            HOLD = CHIX(I)
            CHIX(I) = CHIX(J)
            CHIX(J) = HOLD
600      CONTINUE
700   CONTINUE
C ******************
C
      WRITE(IPLT,500) XNUM,XFEN,CMAXST,XMAXST,
     &     (CHIX(I),DISTX(I),I = 1,NUM)
500   FORMAT(G12.4)
CPES ADDED CODE ENDS
C
C
      IF (AREA) THEN
      WRITE(IOUT3,502)
502   FORMAT(/,1X,' DIST    = DISTANCE FROM CENTER OF THE AREA SOURCE',
     &       /,1X,' CONC    = MAXIMUM GROUND LEVEL CONCENTRATION',
     &       /,1X,' STAB    = ATMOSPHERIC STABILITY CLASS (1=A, 2=B,',
     &                                          ' 3=C, 4=D, 5=E, 6=F)',
     &       /,1X,' U10M    = WIND SPEED AT THE 10-M LEVEL',
     &       /,1X,' USTK    = WIND SPEED AT STACK HEIGHT',
     &       /,1X,' MIX HT  = MIXING HEIGHT',
     &       /,1X,' PLUME HT= PLUME CENTERLINE HEIGHT',
     &       /,1X,' MAX DIR = WIND DIRECTION RELATIVE TO LONG AXIS FOR',
     &       /,1X,'           MAXIMUM CONCENTRATION')
C
      ELSE
      WRITE(IOUT3,501)
501   FORMAT(/,1X,' DIST    = DISTANCE FROM THE SOURCE',
     &       /,1X,' CONC    = MAXIMUM GROUND LEVEL CONCENTRATION',
     &       /,1X,' STAB    = ATMOSPHERIC STABILITY CLASS (1=A, 2=B, 3=C
     &, 4=D, 5=E, 6=F)',
     &       /,1X,' U10M    = WIND SPEED AT THE 10-M LEVEL',
     &       /,1X,' USTK    = WIND SPEED AT STACK HEIGHT',
     &       /,1X,' MIX HT  = MIXING HEIGHT',
     &       /,1X,' PLUME HT= PLUME CENTERLINE HEIGHT',
     &       /,1X,' SIGMA Y = LATERAL DISPERSION PARAMETER',
     &       /,1X,' SIGMA Z = VERTICAL DISPERSION PARAMETER',
     &       /,1X,' DWASH   = BUILDING DOWNWASH:')
C
      WRITE(IOUT3,450)
450   FORMAT(11X,' DWASH=   MEANS NO CALC MADE (CONC = 0.0)',
     &       /,11X,' DWASH=NO MEANS NO BUILDING DOWNWASH USED',
     &       /,11X,' DWASH=HS MEANS HUBER-SNYDER DOWNWASH USED',
     &       /,11X,' DWASH=SS MEANS SCHULMAN-SCIRE DOWNWASH USED',
     &       /,11X,' DWASH=NA MEANS DOWNWASH NOT APPLICABLE, X<3*LB')
      END IF
C      IF (.NOT.AREA .AND. .NOT.LDEP) THEN
C         WRITE(IOUT3,450)
C450      FORMAT(/,1X,' DWASH=   MEANS NO CALC MADE (CONC = 0.0)',
C     &          /,1X,' DWASH=NO MEANS NO BUILDING DOWNWASH USED',
C     &          /,1X,' DWASH=HS MEANS HUBER-SNYDER DOWNWASH USED',
C     &          /,1X,' DWASH=SS MEANS SCHULMAN-SCIRE DOWNWASH USED',
C     &          /,1X,' DWASH=NA MEANS DOWNWASH NOT APPLICABLE, X<3*LB')
C      END IF
C
      GO TO 98
99    WRITE(IPRT,*) 'ERROR READING: ',QVAR
      STOP
98    RETURN
      END

      SUBROUTINE DISCX(IT,CMAXST,XMAXST,TMAXST,DMAXST,XMXDST,TMXDST)
C
C     SUBROUTINE DISCX EXERCISES THE DISCRETE DISTANCE OPTION TO
C     CALCULATE THE MAXIMUM GROUND LEVEL CONCENTRATION AS A FUNCTION
C     OF USER-SPECIFIED DISTANCE.
C
C     INPUT:
C            KMAX,IST,UINP,WSINP - PARAMETERS TO CONTROL THE RANGE OF
C                                  METEOROLOGY TO EXAMINE, SPECIFIED
C                                  BY SUBROUTINE CHOICE
C            FLAT    -  LOGICAL VARIABLE TO INDICATE FLAT OR ELEVATED
C                          TERRAIN
C
C     OUTPUT:
C            CMAXST  -  OVERALL MAXIMUM GROUND LEVEL CONCENTRATION
C            XMAXST  -  DOWNWIND DISTANCE ASSOCIATED WITH CMAXST
C            TMAXST  -  TERRAIN ELEVATION ABOVE STACK BASE ASSOCITATED
C                          WITH CMAXST AND XMAXST
C
      INCLUDE 'MAIN.INC'
      REAL PERCENT
      CHARACTER*30 QVAR
CTMP       COMMON /DISCR/ XNUMDIS,XTOT,XCOUNT,XNUMHT
C
C      WRITE(IPRT,*) 'TO CEASE, ENTER A DISTANCE OF ZERO (0).'
C      WRITE(IPRT,500)
C
24    CONTINUE
C
      IF (FLAT) THEN
         HTER = 0.0
      ELSE
C115      WRITE(IPRT,*)'ENTER TERRAIN HEIGHT ABOVE STACK BASE (M):'
         QVAR = 'HTER'
115      READ(IRD,*,ERR=99) HTER
         IF (HTER .GT. HS) THEN
C            WRITE(IPRT,*)'TERRAIN HEIGHT > STACK HEIGHT!'
C            WRITE(IPRT,*)'  TERRAIN HEIGHT HAS BEEN SET = STACK',
C     &                   ' HEIGHT.'
C            WRITE(IPRT,*)'  USE COMPLEX TERRAIN SCREENING PROCEDURE'
C            WRITE(IPRT,*)'  FOR TERRAIN ABOVE STACK HEIGHT.'
            HTER = HS
         END IF
         IF (HTER .LT. 0.0) THEN
C            WRITE(IPRT,*)'TERRAIN HEIGHT < 0.0!  TRY AGAIN.'
            GO TO 115
         END IF
         WRITE(IDAT,*) HTER
      END IF
C
      WRITE(IOUT3,500)
500   FORMAT(/1X,'*********************************',/,
     &        1X,'*** SCREEN DISCRETE DISTANCES ***',/,
     &        1X,'*********************************',/)
C      WRITE(IPRT,210) HTER
      WRITE(IOUT3,210) HTER
210   FORMAT(1X,'*** TERRAIN HEIGHT OF ',F5.0,' M ABOVE STACK BASE',
     &          ' USED FOR FOLLOWING DISTANCES ***',/)
      IF (LDEP) THEN
C         WRITE(IPRT,317)
         WRITE(IOUT3,317)
317      FORMAT(23X,'DEPOS AT ',28X,'CONC AT  ',/
     &          3X,'DIST',4X,'MAX CONC',4X,'MAX CONC ',7X,'U10M',
     &                    4X,'MAX DEPOS',4X,'MAX DEPOS',7X,'U10M',/
     &   4X,'(M)',3X,'(UG/M**3)',2X,'(G/M**2-HR)',1X,'STAB',1X,'(M/S)',
     &            3X,'(G/M**2-HR)',2X,'(UG/M**3)',2X,'STAB',1X,'(M/S)',
     &          /,1X,'-------',2X,'----------',2X,'----------',1X,
     &               '----',1X,'-----',4X,'----------',2X,'----------',
     &               1X,'----',1X,'-----')
      ELSE IF (AREA) THEN
C         WRITE(IPRT,319)
         WRITE(IOUT3,319)
319      FORMAT(3X,'DIST',5X,'CONC',13X,'U10M',3X,'USTK',2X,'MIX HT',
     &          3X,'PLUME',2X,'MAX DIR',/,4X,'(M)',3X,
     &          '(UG/M**3)',3X,'STAB',2X,'(M/S)',2X,'(M/S)',4X,'(M)',3X,
     &          'HT (M)',3X,'(DEG)',/,1X,
     &          '-------',2X,'----------',2X,'----',2X,'-----',2X,
     &          '-----',2X,'------',2X,'------',2X,
     &          '-------')
      ELSE
C         WRITE(IPRT,300)
         WRITE(IOUT3,300)
300      FORMAT(3X,'DIST',5X,'CONC',13X,'U10M',3X,'USTK',2X,'MIX HT',
     &          3X,'PLUME',3X,'SIGMA',3X,'SIGMA',/,4X,'(M)',3X,
     &          '(UG/M**3)',3X,'STAB',2X,'(M/S)',2X,'(M/S)',4X,'(M)',3X,
     &          'HT (M)',3X,'Y (M)',3X,'Z (M)',2X,'DWASH',/,1X,
     &          '-------',2X,'----------',2X,'----',2X,'-----',2X,
     &          '-----',2X,'------',2X,'------',2X,'------',2X,
     &          '------',2X,'-----')
      END IF
      N = 0
C1     WRITE(IPRT,*) 'ENTER DISTANCE (M) (0 TO EXIT): '
      QVAR = 'X'
1     READ(IRD,*,ERR=99) X
      IF (X .GT. 100000.) THEN
C         WRITE(IPRT,*) 'DISTANCE IS > 100 KM!  TRY AGAIN.'
         GO TO 1
      END IF
      WRITE(IDAT,*) X
C
      IF (X .GE. 1. .OR. (AREA .AND. X.GT.0.0)) THEN
         N = N + 1
         IT = IT + 1
         HT(IT) = HTER
         RMIN(IT) = X
         CALL USERX
C PES ADDED CODE BEGINS
         XCOUNT = XCOUNT + 1
         PERCENT = (XCOUNT/XTOT)*100
         IF (PERCENT .GE. 100) THEN
c            PERCENT = 99
            PERCENT = 100
         ENDIF
         IPERCENT = NINT(PERCENT)
         WRITE(IPRT,101) IPERCENT
101      FORMAT('+',30X,I3,' % Complete')
C PES ADDED CODE ENDS
C         IF (N.EQ.8.OR.N.EQ.15.OR.N.EQ.22.OR.N.EQ.29) WRITE(IPRT,300)
         IF (LDEP) THEN
            CALL MAXX(KSTMAX,UMAX)
            CALL MAXXD(KSTMXD,UMAXD)
C            WRITE(IPRT,519) X,CHIMAX,DEPSEC,KSTMAX,UMAX,
C     &                        DEPMAX,CONSEC,KSTMXD,UMAXD
            WRITE(IOUT3,519) X,CHIMAX,DEPSEC,KSTMAX,UMAX,
     &                        DEPMAX,CONSEC,KSTMXD,UMAXD

         ELSE IF (AREA) THEN
C            WRITE(IPRT,419) X,CHIMAX,KSTMAX,UMAX,USMAX,ZIMAX,HEMAX,
C     &                      WDMAX
            WRITE(IOUT3,419) X,CHIMAX,KSTMAX,UMAX,USMAX,ZIMAX,HEMAX,
     &                      WDMAX
         ELSE
C            WRITE(IPRT,400) X,CHIMAX,KSTMAX,UMAX,USMAX,ZIMAX,HEMAX,
C     &                      SYMAX,SZMAX,DWASH(IFGMAX)
            WRITE(IOUT3,400) X,CHIMAX,KSTMAX,UMAX,USMAX,ZIMAX,HEMAX,
     &                      SYMAX,SZMAX,DWASH(IFGMAX)
CXXX            IF (LDEP) THEN
CXXX               WRITE(IPRT,400) X,DEPMAX,KSTMXD,UMAXD,USMAXD,ZIMAXD,
CXXX     &                         HEMAXD,SYMAXD,SZMAXD,DWASH(IFGMXD)
CXXX               WRITE(IOUT,400) X,DEPMAX,KSTMXD,UMAXD,USMAXD,ZIMAXD,
CXXX     &                         HEMAXD,SYMAXD,SZMAXD,DWASH(IFGMXD)
CXXX               WRITE(IOUT,*) ' '
CXXX            END IF
         END IF

400      FORMAT(1X,F7.0,2X,G10.4,4X,I1,4X,F4.1,3X,F4.1,1X,F7.1,
     &          3(1X,F7.2),4X,A2)
419      FORMAT(1X,F7.0,2X,G10.4,4X,I1,4X,F4.1,3X,F4.1,1X,F7.1,
     &          1X,F7.2,4X,F4.0)
519      FORMAT(1X,F7.0,2(2X,G10.4),3X,I1,3X,F4.1,2X,
     &                  2(2X,G10.4),3X,I1,3X,F4.1)
         IF (CHIMAX .GT. CMAXST) THEN
            CMAXST = CHIMAX
            XMAXST = X
            TMAXST = HTER
         END IF
         IF (DEPMAX .GT. DMAXST) THEN
            DMAXST = DEPMAX
            XMXDST = X
            TMXDST = HTER
         END IF
         GO TO 1
      END IF
C
      IF (.NOT.FLAT) THEN
C         WRITE(IPRT,*) ' '
C23       WRITE(IPRT,*) 'CONTINUE SIMPLE TERRAIN DISCRETE CALCS',
C     &                 ' WITH NEW TERRAIN HEIGHT?'
C         WRITE(IPRT,*) 'ENTER Y OR N:'
         QVAR = 'SIMP TERRAIN IN DISCX QUERY'
23       READ(IRD,100,ERR=99) QUERY
100	 FORMAT(A1)
         IF (QUERY .EQ. 'Y' .OR. QUERY .EQ. 'y') THEN
            WRITE(IDAT,100) QUERY
            GO TO 24
         ELSE IF (QUERY .EQ. 'N' .OR. QUERY .EQ. 'n') THEN
            WRITE(IDAT,100) QUERY
C            WRITE(IPRT,*) ' '
            CONTINUE
         ELSE 
            GO TO 23
         END IF
      END IF
C
      IF (PERCENT .NE. 100) THEN
         IPERCENT = 100
         WRITE(IPRT,449) IPERCENT
449      FORMAT('+',30X,I3,' % Complete')
      ENDIF
      IF (AREA) THEN
      WRITE(IOUT3,502)
502   FORMAT(/,1X,' DIST    = DISTANCE FROM CENTER OF THE AREA SOURCE',
     &       /,1X,' CONC    = MAXIMUM GROUND LEVEL CONCENTRATION',
     &       /,1X,' STAB    = ATMOSPHERIC STABILITY CLASS (1=A, 2=B,',
     &                                          ' 3=C, 4=D, 5=E, 6=F)',
     &       /,1X,' U10M    = WIND SPEED AT THE 10-M LEVEL',
     &       /,1X,' USTK    = WIND SPEED AT STACK HEIGHT',
     &       /,1X,' MIX HT  = MIXING HEIGHT',
     &       /,1X,' PLUME HT= PLUME CENTERLINE HEIGHT',
     &       /,1X,' MAX DIR = WIND DIRECTION RELATIVE TO LONG AXIS FOR',
     &       /,1X,'           MAXIMUM CONCENTRATION')
C
      ELSE
      WRITE(IOUT3,450)
450   FORMAT(/,1X,' DWASH=   MEANS NO CALC MADE (CONC = 0.0)',
     &       /,1X,' DWASH=NO MEANS NO BUILDING DOWNWASH USED',
     &       /,1X,' DWASH=HS MEANS HUBER-SNYDER DOWNWASH USED',
     &       /,1X,' DWASH=SS MEANS SCHULMAN-SCIRE DOWNWASH USED',
     &       /,1X,' DWASH=NA MEANS DOWNWASH NOT APPLICABLE, X<3*LB')
      END IF
C      IF (.NOT.AREA .AND. .NOT.LDEP) THEN
C         WRITE(IOUT,450)
C450      FORMAT(/,1X,' DWASH=   MEANS NO CALC MADE (CONC = 0.0)',
C     &          /,1X,' DWASH=NO MEANS NO BUILDING DOWNWASH USED',
C     &          /,1X,' DWASH=HS MEANS HUBER-SNYDER DOWNWASH USED',
C     &          /,1X,' DWASH=SS MEANS SCHULMAN-SCIRE DOWNWASH USED',
C     &          /,1X,' DWASH=NA MEANS DOWNWASH NOT APPLICABLE, X<3*LB')
C      END IF
C
      GO TO 98
99    WRITE(IPRT,*) 'ERROR READING: ',QVAR
      STOP
98    RETURN
      END

      SUBROUTINE USERX
C
C        DESIGNED FOR ONE USER-SPECIFIED DISTANCE AT A TIME.
C        ROUTINE COMPUTES THE MAXIMUM CONC (AND DEPOS) FOR THAT DISTANCE
C        FROM A RANGE OF METEOROLOGICAL CONDITIONS.
C
C        INPUTS:
C           FB    BUOYANCY FLUX PARAMETER (M**4/S**3)
C           FM    MOMENTUM FLUX PARAMETER (M**4/S**2)
C           Q     EMISSION RATE (G/S)
C           HS    STACK HT (M)
C           DS    STACK DIAMETER (M)
C           VS    EXIT VELOCITY (M/S)
C           TS    STACK TEMPERATURE (K)
C           TA    AMBIENT TEMPERATURE (K)
C           HB    BLDG HT (M)
C           HL    BLDG LENGTH (MIN HORIZ DIMENSION) (M)
C           HW    BLDG WIDTH (MAX HORIZ DIMENSION) (M)
C           ZR    RECEPTOR HT ABOVE GROUND (M)
C           IOPT  URBAN/RURAL OPTION (U = URBAN, R = RURAL)
C           X     DOWNWIND DISTANCE (M)
C           WSINP WIND SPEED INPUT OPTION FLAG (T OR F)
C           UINP  WIND SPEED INPUT BY USER IF WSINP = .TRUE.
C
C        ROUTINES USED:
C           DELH    COMPUTES FINAL PLUME RISE FOR NO DOWNWASH SCENARIO
C           SIGY    COMPUTES RURAL OR URBAN SIGMA-Y
C           SIGZ    COMPUTES RURAL OR URBAN SIGMA-Z
C           SYSS    COMPUTES SIGMA-Y DURING DOWNWASH SCENARIOS
C           SZSS    COMPUTES SIGMA-Z DURING DOWNWASH SCENARIOS
C           HM      COMPUTES MOMENTUM PLUME RISE
C           DHHS    COMPUTES PLUME RISE FOR HUBER-SNYDER SCENARIO
C           DHSS    COMPUTES PLUME RISE FOR SCHULMAN-SCIRE SCENARIO
C           CONC    COMPUTES GAUSSIAN PLUME GROUND-LEVEL CONCENTRATION
C           HSPRM   COMPUTES STACK HEIGHT WITH STACK TIP DOWNWASH
C
C        OUTPUTS
C          (ALL ASSOCIATED WITH MAX CONC):
C           CHIMAX  MAXIMUM CONC (UG/M**3)
C           UMAX    10M WIND SPEED (M/S)
C           USMAX   STACK TOP WIND SPEED (M/S)
C           HEMAX   EFFECTIVE PLUME HT (M)
C           ZIMAX   MIXING HEIGHT (M)
C           KSTMAX  STABILITY CLASS
C           SYMAX   HORIZONTAL DISPERSION (M)
C           SZMAX   VERTICAL DISPERSION (M)
C           IFGMAX  FLAG TO IDENTIFY DOWNWASH SCENARIO
C          (ALL ASSOCIATED WITH MAX DEPOS):
C           DEPMAX  MAXIMUM DEPOS (G/(M**2-HR))
C           UMAXD   10M WIND SPEED (M/S)
C           USMAXD  STACK TOP WIND SPEED (M/S)
C           HEMAXD  EFFECTIVE PLUME HT (M)
C           ZIMAXD  MIXING HEIGHT (M)
C           KSTMXD  STABILITY CLASS
C           SYMAXD  HORIZONTAL DISPERSION (M)
C           SZMAXD  VERTICAL DISPERSION (M)
C           IFGMXD  FLAG TO IDENTIFY DOWNWASH SCENARIO
C
      INCLUDE 'MAIN.INC'
      REAL    U(13), PURBAN(6), PRURAL(6), ADTDZ(6)
      INTEGER IUHI(6)
      DATA    U /1.0,1.5,2.0,2.5,3.0,3.5,4.0,4.5,5.0,8.,10.,15.,20./
      DATA    PURBAN /0.15,0.15,0.20,0.25,0.30,0.30/
      DATA    PRURAL /0.07,0.07,0.10,0.15,0.35,0.55/
      DATA    IUHI /5,9,11,13,9,7/
      DATA    ADTDZ /0.0, 0.0, 0.0, 0.0, 0.02, 0.035/
C
C        INITIALIZATIONS
C
      IOUNIT = IDBG
      WAKE   = .FALSE.
      WAKESS = .FALSE.
      Y = 0.0
      ZLB  = AMIN1(HB,HWP)
      CHIMAX = -999.
      UMAX   = 0.
      USMAX  = 0.
      HEMAX  = 0.
      ZIMAX  = 0.
      KSTMAX = 0
      SYMAX  = 0.
      SZMAX  = 0.
      WDMAX  = 0.
      IFGMAX = 5
      DEPMAX = -999.
      UMAXD  = 0.
      USMAXD = 0.
      HEMAXD = 0.
      ZIMAXD = 0.
      KSTMXD = 0
      SYMAXD = 0.
      SZMAXD = 0.
      WDMAXD = 0.
      IFGMXD = 5
C
C        LOOP ON METEOROLOGICAL CONDITIONS
C
C     Begin LOOP on Stability Classes
      DO 10 K = 1, KMAX
         KST = IST(K)
C        Optimize by skipping KST <= controlling KST for previous distance
C        assuming the distances are increasing (DX >= 0) for AREAs and VOLUMEs.
         IF (.NOT.DISC .AND. (AREA.OR.VOLUME)) THEN
            IF (.NOT.LDEP .AND. DX.GE.0.0 .AND. KST.LT.KSTSAV) THEN
C              Skip to next stability class
               GO TO 10
            ELSE IF (LDEP .AND. DX.GE.0.0 .AND. KST.LT.KSTSAV .AND.
     &                                          KST.LT.KSTSVD) THEN
C              Skip to next stability class
               GO TO 10
            END IF
         END IF
         IF (WSINP .OR. (.NOT.LDEP .AND. (AREA .OR. VOLUME)) ) THEN
C           Limit Search for Area and Volume Sources to Single Wind Speed (1m/s)
            IMAX = 1
         ELSE
            IMAX = IUHI(KST)
         END IF
         UNSTAB = .FALSE.
         NEUTRL = .FALSE.
         STABLE = .FALSE.
         IF (KST .LT. 4) THEN
            UNSTAB = .TRUE.
         ELSE IF (KST .EQ. 4) THEN
            NEUTRL = .TRUE.
         ELSE IF (KST .GT. 4) THEN
            STABLE = .TRUE.
         END IF

         DTDZ = ADTDZ(KST)
         IF (DTDZ .GT. 0.0 .AND. TA .NE. 0.0) THEN
            S = G*DTDZ/TA
            RTOFS = SQRT(S)
         ELSE
            S = 1.0E-10
            RTOFS = 1.0E-10
         END IF

C        Begin LOOP on Wind Speeds
         DO 20 IU = 1,IMAX
C           Reset value of KST
            KST = IST(K)
            IF (WSINP .OR. (.NOT.LDEP .AND. (AREA .OR. VOLUME)) ) THEN
               UREF = UINP
            ELSE
               UREF = U(IU)
            END IF
C
            IF (X .GT. 50000. .AND. UREF .LT. 2.0) THEN
               UREF = 2.0
            END IF
C
C
C           ADJUST WIND SPEED FROM REFERENCE (ANEMOMETER) HEIGHT, ZREF,
C           OF 10-METERS, TO STACK HEIGHT
C
            ZREF = 10.0
            IF (RURAL) THEN
               P = PRURAL(KST)
            ELSE IF (URBAN) THEN
               P = PURBAN(KST)
            END IF
            CALL WSADJ

C           Calculate Monin-Obukhov Length, Friction Velocity, and
C           Deposition Velocities for this Source
            IF (LDEP) THEN
               CALL OBUKHOV
               CALL U_STAR
               CALL VDP
            ENDIF

            IF (POINT .OR. FLARE) THEN
C              Calculate Distance to Final Rise
               CALL DISTF
C
C        DETERMINE TYPE OF DOWNWASH SCENARIO, IF ANY
C
               DSBH = HB
               DSBW = HWP
               WAKE   = .FALSE.
               WAKESS = .FALSE.
C              Determine Wake Flags
               CALL WAKFLG
               FSTREC = .TRUE.
               NOBID  = .FALSE.
               NOSTD  = .FALSE.
               GRDRIS = .FALSE.
C              Calculate Effective Plume Height
               CALL PHEFF
C              Set HEFLAT = HE to avoid plume above ZI in PCHI
               HEFLAT = HE
C              Calculate Dispersion Parameters
               CALL PDIS
               IF (.NOT. WAKE) THEN
                  IFLG = 1
               ELSE IF (WAKE .AND. X .LT. 3.*ZLB) THEN
                  HRVAL = 0.0
                  UREF  = 0.0
                  US    = 0.0
                  HE    = 0.0
                  ZI    = 0.0
                  KST   = 0
                  SY    = 0.0
                  SZ    = 0.0
                  IFLG  = 4
                  IF (HRVAL .GT. CHIMAX) THEN
                     CHIMAX = HRVAL
                     UMAX   = UREF
                     USMAX  = US
                     HEMAX  = HE
                     ZIMAX  = ZI
                     KSTMAX = KST
                     SYMAX  = SY
                     SZMAX  = SZ
                     IFGMAX = IFLG
                  END IF
                  IF (LDEP) THEN
                     IF (HRVAL .GT. DEPMAX) THEN
                        DEPMAX = HRVAL
                        UMAXD  = UREF
                        USMAXD = US
                        HEMAXD = HE
                        ZIMAXD = ZI
                        KSTMXD = KST
                        SYMAXD = SY
                        SZMAXD = SZ
                        IFGMXD = IFLG
                     END IF
                  END IF
                  GO TO 100
               ELSE IF (WAKE .AND. WAKESS) THEN
                  IFLG = 2
               ELSE IF (WAKE) THEN
                  IFLG = 3
               END IF

            ELSE IF (VOLUME) THEN
C              Calculate Effective Radius
               XRAD = 2.15*SYINIT
C              Initialize SBID to 0.0 for call to DEPCOR
               SBID = 0.0
               IF ((X-XRAD) .LT. 0.99) THEN
C                 Receptor Upwind of Downwind Edge
                  HRVAL = 0.0
                  UREF  = 0.0
                  US    = 0.0
                  HE    = 0.0
                  ZI    = 0.0
                  KST   = 0
                  SY    = 0.0
                  SZ    = 0.0
                  IFLG  = 5
                  IF (HRVAL .GT. CHIMAX) THEN
                     CHIMAX = HRVAL
                     UMAX   = UREF
                     USMAX  = US
                     HEMAX  = HE
                     ZIMAX  = ZI
                     KSTMAX = KST
                     SYMAX  = SY
                     SZMAX  = SZ
                     IFGMAX = IFLG
                  END IF
                  IF (LDEP) THEN
                     IF (HRVAL .GT. DEPMAX) THEN
                        DEPMAX = HRVAL
                        UMAXD  = UREF
                        USMAXD = US
                        HEMAXD = HE
                        ZIMAXD = ZI
                        KSTMXD = KST
                        SYMAXD = SY
                        SZMAXD = SZ
                        IFGMXD = IFLG
                     END IF
                  END IF
                  GO TO 100
               ELSE
C                 Calculate Effective Plume Height
                  CALL VHEFF
C                 Set HEFLAT = HE to avoid plume above ZI in PCHI
                  HEFLAT = HE
C                 Calculate Dispersion Parameters
                  CALL VDIS
                  IFLG = 1
               END IF

            ELSE IF (AREA) THEN
C              Set Effective Source Height
               HE = HS
C              Initialize XZ, XY, and SBID for call to DEPCOR
               XY = 0.0
               XZ = 0.0
               SBID = 0.0
               IFLG = 1
            END IF
C
C        THE MINIMUM MIXING HEIGHT DUE TO MECHANICAL MIXING IS
C        FOUND BY SETTING ZI EQUAL TO 0.3 * USTAR / F WHERE F IS
C        THE CORIOLIS PARAMETER.  FOR THIS ALGORITHM, USTAR IS 
C        ASSUMED TO BE EQUAL TO 0.1 * U10M.  TO BE CONSERVATIVE, IF
C        THIS ZI IS BELOW HE (NO CONTRIBUTION CASE), THEN ZI IS SET
C        EQUAL TO HE + 1 IN ORDER TO SET UP MAXIMUM REFLECTION.
C
            ZI = 320. * UREF
            IF (ZI .GT. 10000.) ZI = 10000.
            IF (ZI .LT. HE+1.)  ZI = HE + 1.
C
C        MIXING HTS ARE NOT USED IN COMPUTING CONCENTRATIONS 
C        DURING STABLE CONDITIONS.  SET TO 10000 M FOR E AND F.
C
            IF (KST .GT. 4 ) ZI = 10000.
            IF (HE .LT. 1.0E-10) HE = 0.0
            QTK = Q * 1.0E06
            ZFLAG = ZR

            IF (POINT .OR. FLARE .OR. VOLUME) THEN
C              Determine deposition correction factors   ---   CALL DEPCOR
               IF (LDEP) THEN
C                 Loop over particle sizes
                  DO 150 I = 1, NPD
                     IF (DPLETE) THEN
                        CALL DEPCOR(VDEP(I),VGRAV(I),ZRDEP,ZFLAG,X,
     &                       XZ,HE,ZI,US,RURAL,URBAN,KST,SZ,SBID,
     &                       DEBUG,IOUNIT,QCOR(I),PCORZR(I),
     &                       PCORZD(I))
                     ELSE
                        QCOR(I) = 1.
                        PCORZR(I) = 1.
                        PCORZD(I) = 1.
                     END IF
150               CONTINUE
               END IF

               CONC  = .TRUE.
               DEPOS = .FALSE.
               QTK = Q * 1.0E06
               CALL PCHI
               IF (HRVAL .GT. CHIMAX) THEN
                  CHIMAX = HRVAL
                  UMAX   = UREF
                  USMAX  = US
                  HEMAX  = HE
                  ZIMAX  = ZI
                  KSTMAX = KST
                  SYMAX  = SY
                  SZMAX  = SZ
                  IFGMAX = IFLG
               END IF
               IF (LDEP) THEN
                  CONC  = .FALSE.
                  DEPOS = .TRUE.
                  QTK = Q * 3600.
                  CALL PDEP
                  IF (HRVAL .GT. DEPMAX) THEN
                     DEPMAX = HRVAL
                     UMAXD  = UREF
                     USMAXD = US
                     HEMAXD = HE
                     ZIMAXD = ZI
                     KSTMXD = KST
                     SYMAXD = SY
                     SZMAXD = SZ
                     IFGMXD = IFLG
                  END IF
               END IF

            ELSE IF (AREA) THEN
               IF (MAXWD .AND. IU.EQ.1) THEN
C                 Option to search for Maximum Wind Direction selected.
C                 Calculate normalized distance, XNORM, and get range
C                 of wind directions to search from SUB. FINDMX.
                  XNORM = X/(0.5*XINIT)
                  CALL FINDMX(XNORM)
C                 Find direction to maximum concentration from arrays
                  DO 919 IWD = MINDIR, MAXDIR
C                    Loop through range of degrees from MINDIR to MAXDIR
                     ANGRAD = -1.0 * IWD * DTORAD
                     AXVERT(1) =  (0.5*YINIT*SIN(ANGRAD)-
     &                             0.5*XINIT*COS(ANGRAD))/1000.
                     AYVERT(1) = (-0.5*YINIT*COS(ANGRAD)-
     &                             0.5*XINIT*SIN(ANGRAD))/1000.
                     AXVERT(2) = (-0.5*YINIT*SIN(ANGRAD)-
     &                             0.5*XINIT*COS(ANGRAD))/1000.
                     AYVERT(2) =  (0.5*YINIT*COS(ANGRAD)-
     &                             0.5*XINIT*SIN(ANGRAD))/1000.
                     AXVERT(3) = (-0.5*YINIT*SIN(ANGRAD)+
     &                             0.5*XINIT*COS(ANGRAD))/1000.
                     AYVERT(3) =  (0.5*YINIT*COS(ANGRAD)+
     &                             0.5*XINIT*SIN(ANGRAD))/1000.
                     AXVERT(4) =  (0.5*YINIT*SIN(ANGRAD)+
     &                             0.5*XINIT*COS(ANGRAD))/1000.
                     AYVERT(4) = (-0.5*YINIT*COS(ANGRAD)+
     &                             0.5*XINIT*SIN(ANGRAD))/1000.
                     AXVERT(5) = AXVERT(1)
                     AYVERT(5) = AYVERT(1)

C                    Determine Coordinates of Vertices in WDIR Coord. System
                     CALL AVERTS
                     CONC  = .TRUE.
                     DEPOS = .FALSE.
                     QTK = Q * 1.0E06
C                    Calculate Area Source Integral
                     CALL AREAIN
                     IF (HRVAL .GT. CHIMAX) THEN
                        CHIMAX = HRVAL
                        UMAX   = UREF
                        USMAX  = US
                        HEMAX  = HE
                        ZIMAX  = ZI
                        KSTMAX = KST
                        SYMAX  = SY
                        SZMAX  = SZ
                        IFGMAX = IFLG
                        WDMAX  = IWD
                     END IF
919               CONTINUE
                  IWD = WDMAX
                  ANGRAD = -1.0 * IWD * DTORAD
                  AXVERT(1) =  (0.5*YINIT*SIN(ANGRAD)-
     &                          0.5*XINIT*COS(ANGRAD))/1000.
                  AYVERT(1) = (-0.5*YINIT*COS(ANGRAD)-
     &                          0.5*XINIT*SIN(ANGRAD))/1000.
                  AXVERT(2) = (-0.5*YINIT*SIN(ANGRAD)-
     &                          0.5*XINIT*COS(ANGRAD))/1000.
                  AYVERT(2) =  (0.5*YINIT*COS(ANGRAD)-
     &                          0.5*XINIT*SIN(ANGRAD))/1000.
                  AXVERT(3) = (-0.5*YINIT*SIN(ANGRAD)+
     &                          0.5*XINIT*COS(ANGRAD))/1000.
                  AYVERT(3) =  (0.5*YINIT*COS(ANGRAD)+
     &                          0.5*XINIT*SIN(ANGRAD))/1000.
                  AXVERT(4) =  (0.5*YINIT*SIN(ANGRAD)+
     &                          0.5*XINIT*COS(ANGRAD))/1000.
                  AYVERT(4) = (-0.5*YINIT*COS(ANGRAD)+
     &                          0.5*XINIT*SIN(ANGRAD))/1000.
                  AXVERT(5) = AXVERT(1)
                  AYVERT(5) = AYVERT(1)

C                 Determine Coordinates of Vertices in WDIR Coord. System
                  CALL AVERTS
                  IF (LDEP) THEN
                     CONC  = .FALSE.
                     DEPOS = .TRUE.
                     QTK = Q * 3600.
                     CALL AREAIN
                     IF (HRVAL .GT. DEPMAX) THEN
                        DEPMAX = HRVAL
                        UMAXD  = UREF
                        USMAXD = US
                        HEMAXD = HE
                        ZIMAXD = ZI
                        KSTMXD = KST
                        SYMAXD = SY
                        SZMAXD = SZ
                        IFGMXD = IFLG
                        WDMAXD = IWD
                     END IF
                  END IF
c                  if (wdmax .ne. wdmaxd) then
c                     write(iprt,927) WDMAX, WDMAXD
c927                  format(1x,' WDMAX = ',f4.0,';     WDMAXD = ',f4.0)
c                     write(iout,927) WDMAX, WDMAXD
c                  end if
               ELSE IF (MAXWD) THEN
                  IF (LDEP) THEN
                     IWD = WDMAX
                     ANGRAD = -1.0 * IWD * DTORAD
                     AXVERT(1) =  (0.5*YINIT*SIN(ANGRAD)-
     &                             0.5*XINIT*COS(ANGRAD))/1000.
                     AYVERT(1) = (-0.5*YINIT*COS(ANGRAD)-
     &                             0.5*XINIT*SIN(ANGRAD))/1000.
                     AXVERT(2) = (-0.5*YINIT*SIN(ANGRAD)-
     &                             0.5*XINIT*COS(ANGRAD))/1000.
                     AYVERT(2) =  (0.5*YINIT*COS(ANGRAD)-
     &                             0.5*XINIT*SIN(ANGRAD))/1000.
                     AXVERT(3) = (-0.5*YINIT*SIN(ANGRAD)+
     &                             0.5*XINIT*COS(ANGRAD))/1000.
                     AYVERT(3) =  (0.5*YINIT*COS(ANGRAD)+
     &                             0.5*XINIT*SIN(ANGRAD))/1000.
                     AXVERT(4) =  (0.5*YINIT*SIN(ANGRAD)+
     &                             0.5*XINIT*COS(ANGRAD))/1000.
                     AYVERT(4) = (-0.5*YINIT*COS(ANGRAD)+
     &                             0.5*XINIT*SIN(ANGRAD))/1000.
                     AXVERT(5) = AXVERT(1)
                     AYVERT(5) = AYVERT(1)

C                    Determine Coordinates of Vertices in WDIR Coord. System
                     CALL AVERTS
                     CONC  = .FALSE.
                     DEPOS = .TRUE.
                     QTK = Q * 3600.
                     CALL AREAIN
                     IF (HRVAL .GT. DEPMAX) THEN
                        DEPMAX = HRVAL
                        UMAXD  = UREF
                        USMAXD = US
                        HEMAXD = HE
                        ZIMAXD = ZI
                        KSTMXD = KST
                        SYMAXD = SY
                        SZMAXD = SZ
                        IFGMXD = IFLG
C                        WDMAXD = IWD
                     END IF
                  END IF
               ELSE
C                 Option to specify wind direction orientation (ANGLE) selected.
                  IF (WSINP .OR. UREF.EQ.1.0) THEN
C                    Determine Coordinates of Vertices in WDIR Coord. System
                     CALL AVERTS
C                    Calculate Area Source Integral
                     CONC  = .TRUE.
                     DEPOS = .FALSE.
                     QTK = Q * 1.0E06
                     CALL AREAIN
                     WDMAX = ANGLE
                     IF (HRVAL .GT. CHIMAX) THEN
                        CHIMAX = HRVAL
                        UMAX   = UREF
                        USMAX  = US
                        HEMAX  = HE
                        ZIMAX  = ZI
                        KSTMAX = KST
                        SYMAX  = SY
                        SZMAX  = SZ
                        IFGMAX = IFLG
C                        WDMAX  = IWD
                     END IF
                  END IF
                  IF (LDEP) THEN
                     CONC  = .FALSE.
                     DEPOS = .TRUE.
                     QTK = Q * 3600.
                     CALL AREAIN
                     IF (HRVAL .GT. DEPMAX) THEN
                        DEPMAX = HRVAL
                        UMAXD  = UREF
                        USMAXD = US
                        HEMAXD = HE
                        ZIMAXD = ZI
                        KSTMXD = KST
                        SYMAXD = SY
                        SZMAXD = SZ
                        IFGMXD = IFLG
C                        WDMAXD = IWD
                     END IF
                  END IF
               END IF
C               IF (HRVAL .GT. CHIMAX) THEN
C                  CHIMAX = HRVAL
C                  UMAX   = UREF
C                  USMAX  = US
C                  HEMAX  = HE
C                  ZIMAX  = ZI
C                  KSTMAX = KST
C                  SYMAX  = SY
C                  SZMAX  = SZ
C                  IFGMAX = IFLG
C               END IF
            END IF

 100        CONTINUE

20       CONTINUE
C        End LOOP on Wind Speeds

10    CONTINUE
C     End LOOP on Stability Classes

C     Save controlling stability class(es) for this distance
      KSTSAV = KSTMAX
      KSTSVD = KSTMXD

      RETURN
      END

      SUBROUTINE MAXX(KSTIN,UREFIN)
C
C        CALCULATES DEPOSITION (DEPSEC) FOR MET CONDITIONS ASSOCIATED
C        WITH THE MAXIMUM CONCENTRATION VALUE AT A GIVEN DISTANCE.
C
C        INPUTS:
C           KST   STABILITY CLASS FOR MAX DEPOSITION
C           UREF  10-METER WIND SPEED FOR MAX DEPOSITION
C
C        ROUTINES USED:
C           DELH    COMPUTES FINAL PLUME RISE FOR NO DOWNWASH SCENARIO
C           SIGY    COMPUTES RURAL OR URBAN SIGMA-Y
C           SIGZ    COMPUTES RURAL OR URBAN SIGMA-Z
C           SYSS    COMPUTES SIGMA-Y DURING DOWNWASH SCENARIOS
C           SZSS    COMPUTES SIGMA-Z DURING DOWNWASH SCENARIOS
C           HM      COMPUTES MOMENTUM PLUME RISE
C           DHHS    COMPUTES PLUME RISE FOR HUBER-SNYDER SCENARIO
C           DHSS    COMPUTES PLUME RISE FOR SCHULMAN-SCIRE SCENARIO
C           CONC    COMPUTES GAUSSIAN PLUME GROUND-LEVEL CONCENTRATION
C           HSPRM   COMPUTES STACK HEIGHT WITH STACK TIP DOWNWASH
C
C        OUTPUT:
C           DEPSEC  SECONDARY DEPOSITION (UG/M**3)
C
      INCLUDE 'MAIN.INC'
      REAL    PURBAN(6), PRURAL(6), ADTDZ(6)
      DATA    PURBAN /0.15,0.15,0.20,0.25,0.30,0.30/
      DATA    PRURAL /0.07,0.07,0.10,0.15,0.35,0.55/
      DATA    ADTDZ /0.0, 0.0, 0.0, 0.0, 0.02, 0.035/
C
C        INITIALIZATIONS
C
      KST = KSTIN
      UREF = UREFIN
      IF (KST .EQ. 0) RETURN
      WAKE   = .FALSE.
      WAKESS = .FALSE.
      Y = 0.0
      ZLB  = AMIN1(HB,HWP)
C
      UNSTAB = .FALSE.
      NEUTRL = .FALSE.
      STABLE = .FALSE.
      IF (KST .LT. 4) THEN
         UNSTAB = .TRUE.
      ELSE IF (KST .EQ. 4) THEN
         NEUTRL = .TRUE.
      ELSE IF (KST .GT. 4) THEN
         STABLE = .TRUE.
      END IF

      DTDZ = ADTDZ(KST)
      IF (DTDZ .GT. 0.0 .AND. TA .NE. 0.0) THEN
         S = G*DTDZ/TA
         RTOFS = SQRT(S)
      ELSE
         S = 1.0E-10
         RTOFS = 1.0E-10
      END IF

C
      IF (X .GT. 50000. .AND. UREF .LT. 2.0) THEN
         UREF = 2.0
      END IF
C
C
C     ADJUST WIND SPEED FROM REFERENCE (ANEMOMETER) HEIGHT, ZREF,
C     OF 10-METERS, TO STACK HEIGHT
C
      ZREF = 10.0
      IF (RURAL) THEN
         P = PRURAL(KST)
      ELSE IF (URBAN) THEN
         P = PURBAN(KST)
      END IF
      CALL WSADJ

C     Calculate Deposition Velocities for this Source
      IF (LDEP) THEN
         CALL OBUKHOV
         CALL U_STAR
         CALL VDP
      ENDIF

      IF (POINT .OR. FLARE) THEN
C        Calculate Distance to Final Rise
         CALL DISTF
C
C     DETERMINE TYPE OF DOWNWASH SCENARIO, IF ANY
C
         DSBH = HB
         DSBW = HWP
         WAKE   = .FALSE.
         WAKESS = .FALSE.
C        Determine Wake Flags
         CALL WAKFLG
         FSTREC = .TRUE.
         NOBID  = .FALSE.
         NOSTD  = .FALSE.
         GRDRIS = .FALSE.
C        Calculate Effective Plume Height
         CALL PHEFF
C        Set HEFLAT = HE to avoid plume above ZI in PCHI
         HEFLAT = HE
C        Calculate Dispersion Parameters
         CALL PDIS
         IF (.NOT. WAKE) THEN
            IFLG = 1
         ELSE IF (WAKE .AND. X .LT. 3.*ZLB) THEN
            HRVAL = 0.0
            UREF  = 0.0
            US    = 0.0
            HE    = 0.0
            ZI    = 0.0
            KST   = 0
            SY    = 0.0
            SZ    = 0.0
            IFLG  = 4
            GO TO 100
         ELSE IF (WAKE .AND. WAKESS) THEN
            IFLG = 2
         ELSE IF (WAKE) THEN
            IFLG = 3
         END IF

      ELSE IF (VOLUME) THEN
C        Calculate Effective Radius
         XRAD = 2.15*SYINIT
         IF ((X-XRAD) .LT. 0.99) THEN
C           Receptor Upwind of Downwind Edge
            HRVAL = 0.0
            UREF  = 0.0
            US    = 0.0
            HE    = 0.0
            ZI    = 0.0
            KST   = 0
            SY    = 0.0
            SZ    = 0.0
            IFLG  = 5
            GO TO 100
         ELSE
C           Calculate Effective Plume Height
            CALL VHEFF
C           Set HEFLAT = HE to avoid plume above ZI in PCHI
            HEFLAT = HE
C           Calculate Dispersion Parameters
            CALL VDIS
            IFLG = 1
         END IF

      ELSE IF (AREA) THEN
C        Set Effective Source Height
         HE = HS
         IFLG = 1
      END IF
C
C     THE MINIMUM MIXING HEIGHT DUE TO MECHANICAL MIXING IS
C     FOUND BY SETTING ZI EQUAL TO 0.3 * USTAR / F WHERE F IS
C     THE CORIOLIS PARAMETER.  FOR THIS ALGORITHM, USTAR IS
C     ASSUMED TO BE EQUAL TO 0.1 * U10M.  TO BE CONSERVATIVE, IF
C     THIS ZI IS BELOW HE (NO CONTRIBUTION CASE), THEN ZI IS SET
C     EQUAL TO HE + 1 IN ORDER TO SET UP MAXIMUM REFLECTION.
C
      ZI = 320. * UREF
      IF (ZI .GT. 10000.) ZI = 10000.
      IF (ZI .LT. HE+1.)  ZI = HE + 1.
C
C     MIXING HTS ARE NOT USED IN COMPUTING CONCENTRATIONS
C     DURING STABLE CONDITIONS.  SET TO 10000 M FOR E AND F.
C
      IF (KST .GT. 4 ) ZI = 10000.
      IF (HE .LT. 1.0E-10) HE = 0.0
      QTK = Q * 1.0E06
      ZFLAG = ZR

      IF (POINT .OR. FLARE .OR. VOLUME) THEN
         IF (LDEP) THEN
C           Determine deposition correction factors   ---   CALL DEPCOR
C           Loop over particle sizes
            DO 150 I=1,NPD
               IF (DPLETE) THEN
                  CALL DEPCOR( VDEP(I),VGRAV(I),ZRDEP,ZFLAG,X,
     &                 XZ,HE,ZI,US,RURAL,URBAN,KST,SZ,SBID,
     &                 DEBUG,IOUNIT,QCOR(I),PCORZR(I),
     &                 PCORZD(I))
               ELSE
                  QCOR(I) = 1.
                  PCORZR(I) = 1.
                  PCORZD(I) = 1.
               ENDIF
150         CONTINUE

            CONC  = .FALSE.
            DEPOS = .TRUE.
            QTK = Q * 3600.
            CALL PDEP
         END IF

      ELSE IF (AREA) THEN
         IF (MAXWD) THEN
            ANGRAD = -1.0 * WDMAX * DTORAD
            AXVERT(1) =  (0.5*YINIT*SIN(ANGRAD)-
     &                    0.5*XINIT*COS(ANGRAD))/1000.
            AYVERT(1) = (-0.5*YINIT*COS(ANGRAD)-
     &                    0.5*XINIT*SIN(ANGRAD))/1000.
            AXVERT(2) = (-0.5*YINIT*SIN(ANGRAD)-
     &                    0.5*XINIT*COS(ANGRAD))/1000.
            AYVERT(2) =  (0.5*YINIT*COS(ANGRAD)-
     &                    0.5*XINIT*SIN(ANGRAD))/1000.
            AXVERT(3) = (-0.5*YINIT*SIN(ANGRAD)+
     &                    0.5*XINIT*COS(ANGRAD))/1000.
            AYVERT(3) =  (0.5*YINIT*COS(ANGRAD)+
     &                    0.5*XINIT*SIN(ANGRAD))/1000.
            AXVERT(4) =  (0.5*YINIT*SIN(ANGRAD)+
     &                    0.5*XINIT*COS(ANGRAD))/1000.
            AYVERT(4) = (-0.5*YINIT*COS(ANGRAD)+
     &                    0.5*XINIT*SIN(ANGRAD))/1000.
            AXVERT(5) = AXVERT(1)
            AYVERT(5) = AYVERT(1)

C           Determine Coordinates of Vertices in WDIR Coord. System
            CALL AVERTS
            IF (LDEP) THEN
               CONC  = .FALSE.
               DEPOS = .TRUE.
               QTK = Q * 3600.
            END IF
C           Calculate Area Source Integral
            CALL AREAIN
         ELSE
C           Determine Coordinates of Vertices in WDIR Coord. System
            CALL AVERTS
            IF (LDEP) THEN
               CONC  = .FALSE.
               DEPOS = .TRUE.
               QTK = Q * 3600.
            END IF
C           Calculate Area Source Integral
            CALL AREAIN
         END IF
      END IF

 100  CONTINUE

      DEPSEC = HRVAL

CXXX      WRITE(IPRT,400) X,HRVAL,KST,UREF,US,ZI,
CXXX     &                HE,SY,SZ,DWASH(IFLG)
CXXX      WRITE(IOUT,400) X,HRVAL,KST,UREF,US,ZI,
CXXX     &                HE,SY,SZ,DWASH(IFLG)
CXXX      WRITE(IOUT,*) ' '
CTEMP400      FORMAT(1X,F7.0,2X,G10.4,4X,I1,4X,F4.1,3X,F4.1,1X,F7.1,
CTEMP     &          3(1X,F7.2),4X,A2)

      RETURN
      END

      SUBROUTINE MAXXD(KSTIN,UREFIN)
C
C        CALCULATES CONCENTRATION (CONSEC) FOR MET CONDITIONS ASSOCIATED
C        WITH THE MAXIMUM DEPOSITION VALUE AT A GIVEN DISTANCE.
C
C        INPUTS:
C           KST   STABILITY CLASS FOR MAX DEPOSITION
C           UREF  10-METER WIND SPEED FOR MAX DEPOSITION
C
C        ROUTINES USED:
C           DELH    COMPUTES FINAL PLUME RISE FOR NO DOWNWASH SCENARIO
C           SIGY    COMPUTES RURAL OR URBAN SIGMA-Y
C           SIGZ    COMPUTES RURAL OR URBAN SIGMA-Z
C           SYSS    COMPUTES SIGMA-Y DURING DOWNWASH SCENARIOS
C           SZSS    COMPUTES SIGMA-Z DURING DOWNWASH SCENARIOS
C           HM      COMPUTES MOMENTUM PLUME RISE
C           DHHS    COMPUTES PLUME RISE FOR HUBER-SNYDER SCENARIO
C           DHSS    COMPUTES PLUME RISE FOR SCHULMAN-SCIRE SCENARIO
C           CONC    COMPUTES GAUSSIAN PLUME GROUND-LEVEL CONCENTRATION
C           HSPRM   COMPUTES STACK HEIGHT WITH STACK TIP DOWNWASH
C
C        OUTPUT:
C           CONSEC  SECONDARY CONCENTRATION (UG/M**3)
C
      INCLUDE 'MAIN.INC'
      REAL    PURBAN(6), PRURAL(6), ADTDZ(6)
      DATA    PURBAN /0.15,0.15,0.20,0.25,0.30,0.30/
      DATA    PRURAL /0.07,0.07,0.10,0.15,0.35,0.55/
      DATA    ADTDZ /0.0, 0.0, 0.0, 0.0, 0.02, 0.035/
C
C        INITIALIZATIONS
C
      KST = KSTIN
      UREF = UREFIN
      IF (KST .EQ. 0) RETURN
      WAKE   = .FALSE.
      WAKESS = .FALSE.
      Y = 0.0
      ZLB  = AMIN1(HB,HWP)
C
      UNSTAB = .FALSE.
      NEUTRL = .FALSE.
      STABLE = .FALSE.
      IF (KST .LT. 4) THEN
         UNSTAB = .TRUE.
      ELSE IF (KST .EQ. 4) THEN
         NEUTRL = .TRUE.
      ELSE IF (KST .GT. 4) THEN
         STABLE = .TRUE.
      END IF

      DTDZ = ADTDZ(KST)
      IF (DTDZ .GT. 0.0 .AND. TA .NE. 0.0) THEN
         S = G*DTDZ/TA
         RTOFS = SQRT(S)
      ELSE
         S = 1.0E-10
         RTOFS = 1.0E-10
      END IF

C
      IF (X .GT. 50000. .AND. UREF .LT. 2.0) THEN
         UREF = 2.0
      END IF
C
C
C     ADJUST WIND SPEED FROM REFERENCE (ANEMOMETER) HEIGHT, ZREF,
C     OF 10-METERS, TO STACK HEIGHT
C
      ZREF = 10.0
      IF (RURAL) THEN
         P = PRURAL(KST)
      ELSE IF (URBAN) THEN
         P = PURBAN(KST)
      END IF
      CALL WSADJ

C     Calculate Deposition Velocities for this Source
      IF (LDEP) THEN
         CALL OBUKHOV
         CALL U_STAR
         CALL VDP
      ENDIF

      IF (POINT .OR. FLARE) THEN
C        Calculate Distance to Final Rise
         CALL DISTF
C
C     DETERMINE TYPE OF DOWNWASH SCENARIO, IF ANY
C
         DSBH = HB
         DSBW = HWP
         WAKE   = .FALSE.
         WAKESS = .FALSE.
C        Determine Wake Flags
         CALL WAKFLG
         FSTREC = .TRUE.
         NOBID  = .FALSE.
         NOSTD  = .FALSE.
         GRDRIS = .FALSE.
C        Calculate Effective Plume Height
         CALL PHEFF
C        Set HEFLAT = HE to avoid plume above ZI in PCHI
         HEFLAT = HE
C        Calculate Dispersion Parameters
         CALL PDIS
         IF (.NOT. WAKE) THEN
            IFLG = 1
         ELSE IF (WAKE .AND. X .LT. 3.*ZLB) THEN
            HRVAL = 0.0
            UREF  = 0.0
            US    = 0.0
            HE    = 0.0
            ZI    = 0.0
            KST   = 0
            SY    = 0.0
            SZ    = 0.0
            IFLG  = 4
            GO TO 100
         ELSE IF (WAKE .AND. WAKESS) THEN
            IFLG = 2
         ELSE IF (WAKE) THEN
            IFLG = 3
         END IF

      ELSE IF (VOLUME) THEN
C        Calculate Effective Radius
         XRAD = 2.15*SYINIT
         IF ((X-XRAD) .LT. 0.99) THEN
C           Receptor Upwind of Downwind Edge
            HRVAL = 0.0
            UREF  = 0.0
            US    = 0.0
            HE    = 0.0
            ZI    = 0.0
            KST   = 0
            SY    = 0.0
            SZ    = 0.0
            IFLG  = 5
            GO TO 100
         ELSE
C           Calculate Effective Plume Height
            CALL VHEFF
C           Set HEFLAT = HE to avoid plume above ZI in PCHI
            HEFLAT = HE
C           Calculate Dispersion Parameters
            CALL VDIS
            IFLG = 1
         END IF

      ELSE IF (AREA) THEN
C        Set Effective Source Height
         HE = HS
         IFLG = 1
      END IF
C
C     THE MINIMUM MIXING HEIGHT DUE TO MECHANICAL MIXING IS
C     FOUND BY SETTING ZI EQUAL TO 0.3 * USTAR / F WHERE F IS
C     THE CORIOLIS PARAMETER.  FOR THIS ALGORITHM, USTAR IS
C     ASSUMED TO BE EQUAL TO 0.1 * U10M.  TO BE CONSERVATIVE, IF
C     THIS ZI IS BELOW HE (NO CONTRIBUTION CASE), THEN ZI IS SET
C     EQUAL TO HE + 1 IN ORDER TO SET UP MAXIMUM REFLECTION.
C
      ZI = 320. * UREF
      IF (ZI .GT. 10000.) ZI = 10000.
      IF (ZI .LT. HE+1.)  ZI = HE + 1.
C
C     MIXING HTS ARE NOT USED IN COMPUTING CONCENTRATIONS
C     DURING STABLE CONDITIONS.  SET TO 10000 M FOR E AND F.
C
      IF (KST .GT. 4 ) ZI = 10000.
      IF (HE .LT. 1.0E-10) HE = 0.0
      QTK = Q * 1.0E06
      ZFLAG = ZR

      IF (POINT .OR. FLARE .OR. VOLUME) THEN
C        Determine deposition correction factors   ---   CALL DEPCOR
         IF (LDEP) THEN
C           Loop over particle sizes
            DO 150 I=1,NPD
               IF (DPLETE) THEN
                  CALL DEPCOR( VDEP(I),VGRAV(I),ZRDEP,ZFLAG,X,
     &                 XZ,HE,ZI,US,RURAL,URBAN,KST,SZ,SBID,
     &                 DEBUG,IOUNIT,QCOR(I),PCORZR(I),
     &                 PCORZD(I))
               ELSE
                  QCOR(I) = 1.
                  PCORZR(I) = 1.
                  PCORZD(I) = 1.
               ENDIF
150         CONTINUE
         ENDIF

         CONC  = .TRUE.
         DEPOS = .FALSE.
         QTK = Q * 1.0E06
         CALL PCHI

      ELSE IF (AREA) THEN
         IF (MAXWD) THEN
            ANGRAD = -1.0 * WDMAXD * DTORAD
            AXVERT(1) =  (0.5*YINIT*SIN(ANGRAD)-
     &                    0.5*XINIT*COS(ANGRAD))/1000.
            AYVERT(1) = (-0.5*YINIT*COS(ANGRAD)-
     &                    0.5*XINIT*SIN(ANGRAD))/1000.
            AXVERT(2) = (-0.5*YINIT*SIN(ANGRAD)-
     &                    0.5*XINIT*COS(ANGRAD))/1000.
            AYVERT(2) =  (0.5*YINIT*COS(ANGRAD)-
     &                    0.5*XINIT*SIN(ANGRAD))/1000.
            AXVERT(3) = (-0.5*YINIT*SIN(ANGRAD)+
     &                    0.5*XINIT*COS(ANGRAD))/1000.
            AYVERT(3) =  (0.5*YINIT*COS(ANGRAD)+
     &                    0.5*XINIT*SIN(ANGRAD))/1000.
            AXVERT(4) =  (0.5*YINIT*SIN(ANGRAD)+
     &                    0.5*XINIT*COS(ANGRAD))/1000.
            AYVERT(4) = (-0.5*YINIT*COS(ANGRAD)+
     &                    0.5*XINIT*SIN(ANGRAD))/1000.
            AXVERT(5) = AXVERT(1)
            AYVERT(5) = AYVERT(1)

C           Determine Coordinates of Vertices in WDIR Coord. System
            CALL AVERTS
            CONC  = .TRUE.
            DEPOS = .FALSE.
            QTK = Q * 1.0E06
C           Calculate Area Source Integral
            CALL AREAIN
         ELSE
C           Determine Coordinates of Vertices in WDIR Coord. System
            CALL AVERTS
            CONC  = .TRUE.
            DEPOS = .FALSE.
            QTK = Q * 1.0E06
C           Calculate Area Source Integral
            CALL AREAIN
         END IF
      END IF

 100  CONTINUE

      CONSEC = HRVAL

CXXX      WRITE(IPRT,400) X,HRVAL,KST,UREF,US,ZI,
CXXX     &                HE,SY,SZ,DWASH(IFLG)
CXXX      WRITE(IOUT,400) X,HRVAL,KST,UREF,US,ZI,
CXXX     &                HE,SY,SZ,DWASH(IFLG)
CTEMP400      FORMAT(1X,F7.0,2X,G10.4,4X,I1,4X,F4.1,3X,F4.1,1X,F7.1,
CTEMP     &          3(1X,F7.2),4X,A2)

      RETURN
      END

      SUBROUTINE TPMX(XCNT,CMAX,XMAX,XMIN)
C
C        SUBROUTINE TPMX LOCATES THE MAXIMUM CONCENTRATION.                
C        AN ITERATIVE PROCEDURE IS EMPLOYED TO PINPOINT THE        
C        DISTANCE TO MAX CONCENTRATION TO WITHIN ONE METER.           
C
      INCLUDE 'MAIN.INC'
      REAL FACT(25)
      DATA FACT/-0.95,-0.90,-0.85,-0.8,-0.75,-0.7,-0.65,-0.6,-0.55,-0.5,
     &          -0.45,-0.4,-0.35,-0.3,-0.25,-0.2,-0.15,-0.1,-0.05,
     &           0.05,0.1,0.2,0.3,0.4,0.5/
      IF (CHICNT .EQ. 0.0) THEN
         CMAX = 0.0
         XMAX = XCNT
         KSTMAX = KSTCNT
         RETURN
      END IF
      CLST = CHICNT
      XLST = XCNT
      KSTLST = KSTCNT
      DO 100 I = 1, 25
         IF (I .EQ. 1) THEN
C           Set DX < 0 for controlling stability check
            DX = -1.0
         ELSE
            DX = 0.0
         END IF
         X = XCNT + (XCNT * FACT(I))
         IF (X .LT. 1.0) X = 1.0
         CALL USERX
         IF (CHIMAX .GT. CLST .AND. X .GE. XMIN) THEN
            XLST = X
            CLST = CHIMAX
            KSTLST = KSTMAX
         END IF
100   CONTINUE
      X = XLST
C
      IF (X .LE. 1000.) THEN
         DX = 100.0
      ELSE IF (X .LE. 10000.) THEN
         DX = 1000.0
      ELSE
         DX = 10000.
      END IF
      IF (X .EQ. XMIN) THEN
         DX = -1.0 * DX
      END IF
C
C        THE FOLLOWING INITIAL INCREMENTS ARE USED:
C           .01 KM FOR X LESS THAN 1 KM                                 
C           0.1 KM FOR X 1 KM TO 10 KM                                  
C           1.0 KM FOR X 10 KM TO 50 KM                                
C
      N = 1
8     DX = -0.1 * DX
      IF (ABS(DX) .LT. 1.0) THEN
         IF (XMAX .LT. XMIN) THEN
            XMAX = XCNT
            CMAX = CHICNT
            KSTMAX = KSTCNT
         END IF
         RETURN
      END IF
C      
C        REVERSE DIRECTIONS, REDUCE STEPPING INCREMENT.                 
C        THE ITERATIVE PROCESS CONTINUES IN THIS MANNER                 
C        WITH CALCULATIONS GOING BACKWARDS AND FORWARDS                 
C        IN SMALLER AND SMALLER INCREMENTS UNTIL THE 
C        INCREMENT IS LESS THAN ONE METER.          
C        IF X REACHES 50 KM CEASE COMPUTATIONS FOR THIS WIND SPEED.    
C        DISTANCE TO THE MAXIMUM IS NOT ALLOWED TO BE LESS THAN THE 
C        MINIMUM DISTANCE INPUT BY THE USER, XMIN.
C
7     X=X+DX                                                            
      IF (X .LT. 1.0) X = 1.0
      IF (N .EQ. 1) THEN
         KSTSAV = 0
         KSTSVD = 0
      END IF
      CALL USERX
      N = N + 1
      IF (N .GT. 50) THEN
         IF (XMAX .LT. XMIN) THEN
            XMAX = XCNT
            CMAX = CHICNT
            KSTMAX = KSTCNT
            RETURN
         ELSE
C            WRITE(IPRT,*)'ITERATION STOPPED AT 50 - MAX NOT FOUND!!!'
            WRITE(IOUT3,*)' '
            WRITE(IOUT3,*)'ITERATION STOPPED AT 50 - MAX NOT FOUND!!!'
            RETURN
         END IF
      ELSE
         IF (CHIMAX.LT.CLST) THEN
            CMAX = CLST
            XMAX = XLST
            KSTMAX = KSTLST
            CLST = CHIMAX
            XLST = X
            KSTLST = KSTMAX
            GO TO 8
         END IF
         CMAX = CHIMAX
         XMAX = X
         KSTMAX = KSTMAX
         CLST = CHIMAX
         XLST = X
         KSTLST = KSTMAX
         IF (X .GT. 50000.) RETURN
         IF (X .EQ. 1.0) THEN
            IF (XMAX .LT. XMIN) THEN
               XMAX = XCNT
               CMAX = CHICNT
               KSTMAX = KSTCNT
            END IF
            RETURN
         END IF
         GO TO 7
      END IF

      END

      SUBROUTINE TPMXD(XCNTD,DMAX,XMAXD,XMIN)
C
C        SUBROUTINE TPMXD LOCATES THE MAXIMUM DEPOSITION.
C        AN ITERATIVE PROCEDURE IS EMPLOYED TO PINPOINT THE        
C        DISTANCE TO MAX CONCENTRATION TO WITHIN ONE METER.           
C
      INCLUDE 'MAIN.INC'
      REAL FACT(25)
      DATA FACT/-0.95,-0.90,-0.85,-0.8,-0.75,-0.7,-0.65,-0.6,-0.55,-0.5,
     &          -0.45,-0.4,-0.35,-0.3,-0.25,-0.2,-0.15,-0.1,-0.05,
     &           0.05,0.1,0.2,0.3,0.4,0.5/
      IF (DEPCNT .EQ. 0.0) THEN
         DMAX = 0.0
         XMAXD = XCNTD
         KSTMXD = KSTCTD
         RETURN
      END IF
      DLST = DEPCNT
      XLST = XCNTD
      KSTLST = KSTCTD
      DO 100 I = 1, 25
         IF (I .EQ. 1) THEN
C           Set DX < 0 for controlling stability check
            DX = -1.0
         ELSE
            DX = 0.0
         END IF
         X = XCNTD + (XCNTD * FACT(I))
         IF (X .LT. 1.0) X = 1.0
         CALL USERX
         IF (DEPMAX .GT. DLST .AND. X .GE. XMIN) THEN
            XLST = X
            DLST = DEPMAX
            KSTLST = KSTMXD
         END IF
100   CONTINUE
      X = XLST
C
      IF (X .LE. 1000.) THEN
         DX = 100.0
      ELSE IF (X .LE. 10000.) THEN
         DX = 1000.0
      ELSE
         DX = 10000.
      END IF
      IF (X .EQ. XMIN) THEN
         DX = -1.0 * DX
      END IF
C
C        THE FOLLOWING INITIAL INCREMENTS ARE USED:
C           .01 KM FOR X LESS THAN 1 KM                                 
C           0.1 KM FOR X 1 KM TO 10 KM                                  
C           1.0 KM FOR X 10 KM TO 50 KM                                
C
      N = 1
8     DX = -0.1 * DX
      IF (ABS(DX) .LT. 1.0) THEN
         IF (XMAXD .LT. XMIN) THEN
            XMAXD = XCNTD
            DMAX = DEPCNT
            KSTMXD = KSTCTD
         END IF
         RETURN
      END IF
C      
C        REVERSE DIRECTIONS, REDUCE STEPPING INCREMENT.                 
C        THE ITERATIVE PROCESS CONTINUES IN THIS MANNER                 
C        WITH CALCULATIONS GOING BACKWARDS AND FORWARDS                 
C        IN SMALLER AND SMALLER INCREMENTS UNTIL THE 
C        INCREMENT IS LESS THAN ONE METER.          
C        IF X REACHES 50 KM CEASE COMPUTATIONS FOR THIS WIND SPEED.    
C        DISTANCE TO THE MAXIMUM IS NOT ALLOWED TO BE LESS THAN THE 
C        MINIMUM DISTANCE INPUT BY THE USER, XMIN.
C
7     X=X+DX                                                            
      IF (X .LT. 1.0) X = 1.0
      IF (N .EQ. 1) THEN
         KSTSAV = 0
         KSTSVD = 0
      END IF
      CALL USERX
      N = N + 1
      IF (N .GT. 50) THEN
         IF (XMAXD .LT. XMIN) THEN
            XMAXD = XCNTD
            DMAX = DEPCNT
            KSTMXD = KSTCTD
            RETURN
         ELSE
C            WRITE(IPRT,*)'ITERATION STOPPED AT 50 - MAX NOT FOUND!!!'
            WRITE(IOUT3,*)' '
            WRITE(IOUT3,*)'ITERATION STOPPED AT 50 - MAX NOT FOUND!!!'
            RETURN
         END IF
      ELSE
         IF (DEPMAX.LT.DLST) THEN
            DMAX = DLST
            XMAXD = XLST
            KSTMXD = KSTLST
            DLST = DEPMAX
            XLST = X
            KSTLST = KSTMXD
            GO TO 8
         END IF
         DMAX = DEPMAX
         XMAXD = X
         KSTMXD = KSTMXD
         DLST = DEPMAX
         XLST = X
         KSTLST = KSTMXD
         IF (X .GT. 50000.) RETURN
         IF (X .EQ. 1.0) THEN
            IF (XMAXD .LT. XMIN) THEN
               XMAXD = XCNTD
               DMAX = DEPCNT
               KSTMXD = KSTCTD
            END IF
            RETURN
         END IF
         GO TO 7
      END IF

      END

      SUBROUTINE TPMXA(XCNT,CMAX,XMAX,XMIN)
C
C        SUBROUTINE TPMXA LOCATES THE MAXIMUM CONCENTRATION FOR AREA SOURCES.
C        AN ITERATIVE PROCEDURE IS EMPLOYED TO PINPOINT THE DISTANCE TO MAX
C        CONCENTRATION TO WITHIN ONE METER.  FOR AREA SOURCES, THE INITIAL
C        RANGE OF DISTANCES IS MODIFIED, AND ONLY 1.0 M/S WIND SPEEDS ARE USED.
C
      INCLUDE 'MAIN.INC'
      REAL FACT(12)
      DATA FACT/-0.75,-0.5,-0.25,-0.1,
     &           0.1,0.25,0.5,0.75,1.0,2.0,5.0,10.0/
      IF (CHICNT .EQ. 0.0) THEN
         CMAX = 0.0
         XMAX = XCNT
         KSTMAX = KSTCNT
         RETURN
      END IF
      CLST = CHICNT
      XLST = XCNT
      KSTLST = KSTCNT
      DO 100 I = 1, 12
         IF (I .EQ. 1) THEN
C           Set DX < 0 for controlling stability check
            DX = -1.0
         ELSE
            DX = 0.0
         END IF
         X = XCNT + (XCNT * FACT(I))
         CALL USERX
         IF (CHIMAX .GT. CLST .AND. X .GE. XMIN) THEN
            XLST = X
            CLST = CHIMAX
            KSTLST = KSTMAX
         END IF
100   CONTINUE
      X = XLST
C
      IF (X .LE. 1000.) THEN
         DX = 100.0
      ELSE IF (X .LE. 10000.) THEN
         DX = 1000.0
      ELSE
         DX = 10000.
      END IF
C      IF (X .EQ. XMIN) THEN
      IF (X .EQ. XMIN .OR. AREA) THEN
         DX = -1.0 * DX
      END IF
C
C        THE FOLLOWING INITIAL INCREMENTS ARE USED:
C           .01 KM FOR X LESS THAN 1 KM                                 
C           0.1 KM FOR X 1 KM TO 10 KM                                  
C           1.0 KM FOR X 10 KM TO 50 KM                                
C
      N = 1
8     DX = -0.1 * DX
      IF (ABS(DX) .LT. 1.0) THEN
         IF (XMAX .LT. XMIN) THEN
            XMAX = XCNT
            CMAX = CHICNT
            KSTMAX = KSTCNT
         END IF
         RETURN
      END IF
C      
C        REVERSE DIRECTIONS, REDUCE STEPPING INCREMENT.                 
C        THE ITERATIVE PROCESS CONTINUES IN THIS MANNER                 
C        WITH CALCULATIONS GOING BACKWARDS AND FORWARDS                 
C        IN SMALLER AND SMALLER INCREMENTS UNTIL THE 
C        INCREMENT IS LESS THAN ONE METER.          
C        IF X REACHES 50 KM CEASE COMPUTATIONS FOR THIS WIND SPEED.    
C        DISTANCE TO THE MAXIMUM IS NOT ALLOWED TO BE LESS THAN THE 
C        MINIMUM DISTANCE INPUT BY THE USER, XMIN.
C
7     X=X+DX

      IF (N .EQ. 1) THEN
         KSTSAV = 0
         KSTSVD = 0
      END IF
      CALL USERX
      N = N + 1
      IF (N .GT. 50) THEN
         IF (XMAX .LT. XMIN) THEN
            XMAX = XCNT
            CMAX = CHICNT
            KSTMAX = KSTCNT
            RETURN
         ELSE
C            WRITE(IPRT,*)'ITERATION STOPPED AT 50 - MAX NOT FOUND!!!'
            WRITE(IOUT3,*)' '
            WRITE(IOUT3,*)'ITERATION STOPPED AT 50 - MAX NOT FOUND!!!'
            RETURN
         END IF
      ELSE
         IF (CHIMAX.LT.CLST) THEN
            CMAX = CLST
            XMAX = XLST
            KSTMAX = KSTLST
            CLST = CHIMAX
            XLST = X
            KSTLST = KSTMAX
            GO TO 8
         END IF
         CMAX = CHIMAX
         XMAX = X
         KSTMAX = KSTMAX
         CLST = CHIMAX
         XLST = X
         KSTLST = KSTMAX
         IF (X .GT. 50000.) RETURN
         IF (X .EQ. 1.0) THEN
            IF (XMAX .LT. XMIN) THEN
               XMAX = XCNT
               CMAX = CHICNT
               KSTMAX = KSTCNT
            END IF
            RETURN
         END IF
         GO TO 7
      END IF

      END

      SUBROUTINE TPMXAD(XCNTD,DMAX,XMAXD,XMIN)
C
C        SUBROUTINE TPMXAD LOCATES THE MAXIMUM DEPOSITION FOR AREA SOURCES.
C        AN ITERATIVE PROCEDURE IS EMPLOYED TO PINPOINT THE DISTANCE TO MAX
C        CONCENTRATION TO WITHIN ONE METER.  FOR AREA SOURCES, THE INITIAL
C        RANGE OF DISTANCES IS MODIFIED, AND ONLY 1.0 M/S WIND SPEEDS ARE USED.
C
      INCLUDE 'MAIN.INC'
      REAL FACT(12)
      DATA FACT/-0.75,-0.5,-0.25,-0.1,
     &           0.1,0.25,0.5,0.75,1.0,2.0,5.0,10.0/
      IF (DEPCNT .EQ. 0.0) THEN
         DMAX = 0.0
         XMAXD = XCNTD
         KSTMXD = KSTCTD
         RETURN
      END IF
      DLST = DEPCNT
      XLST = XCNTD
      KSTLST = KSTCTD
      DO 100 I = 1, 12
         IF (I .EQ. 1) THEN
C           Set DX < 0 for controlling stability check
            DX = -1.0
         ELSE
            DX = 0.0
         END IF
         X = XCNTD + (XCNTD * FACT(I))
         CALL USERX
         IF (DEPMAX .GT. DLST .AND. X .GE. XMIN) THEN
            XLST = X
            DLST = DEPMAX
            KSTLST = KSTMXD
         END IF
100   CONTINUE
      X = XLST
C
      IF (X .LE. 1000.) THEN
         DX = 100.0
      ELSE IF (X .LE. 10000.) THEN
         DX = 1000.0
      ELSE
         DX = 10000.
      END IF
C      IF (X .EQ. XMIN) THEN
      IF (X .EQ. XMIN .OR. AREA) THEN
         DX = -1.0 * DX
      END IF
C
C        THE FOLLOWING INITIAL INCREMENTS ARE USED:
C           .01 KM FOR X LESS THAN 1 KM                                 
C           0.1 KM FOR X 1 KM TO 10 KM                                  
C           1.0 KM FOR X 10 KM TO 50 KM                                
C
      N = 1
8     DX = -0.1 * DX
      IF (ABS(DX) .LT. 1.0) THEN
         IF (XMAXD .LT. XMIN) THEN
            XMAXD = XCNTD
            DMAX = DEPCNT
            KSTMXD = KSTCTD
         END IF
         RETURN
      END IF
C      
C        REVERSE DIRECTIONS, REDUCE STEPPING INCREMENT.                 
C        THE ITERATIVE PROCESS CONTINUES IN THIS MANNER                 
C        WITH CALCULATIONS GOING BACKWARDS AND FORWARDS                 
C        IN SMALLER AND SMALLER INCREMENTS UNTIL THE 
C        INCREMENT IS LESS THAN ONE METER.          
C        IF X REACHES 50 KM CEASE COMPUTATIONS FOR THIS WIND SPEED.    
C        DISTANCE TO THE MAXIMUM IS NOT ALLOWED TO BE LESS THAN THE 
C        MINIMUM DISTANCE INPUT BY THE USER, XMIN.
C
7     X=X+DX

      IF (N .EQ. 1) THEN
         KSTSAV = 0
         KSTSVD = 0
      END IF
      CALL USERX
      N = N + 1
      IF (N .GT. 50) THEN
         IF (XMAXD .LT. XMIN) THEN
            XMAXD = XCNTD
            DMAX = DEPCNT
            KSTMXD = KSTCTD
            RETURN
         ELSE
C            WRITE(IPRT,*)'ITERATION STOPPED AT 50 - MAX NOT FOUND!!!'
            WRITE(IOUT3,*)' '
            WRITE(IOUT3,*)'ITERATION STOPPED AT 50 - MAX NOT FOUND!!!'
            RETURN
         END IF
      ELSE
         IF (DEPMAX.LT.DLST) THEN
            DMAX = DLST
            XMAXD = XLST
            KSTMXD = KSTLST
            DLST = DEPMAX
            XLST = X
            KSTLST = KSTMXD
            GO TO 8
         END IF
         DMAX = DEPMAX
         XMAXD = X
         KSTMXD = KSTMXD
         DLST = DEPMAX
         XLST = X
         KSTLST = KSTMXD
         IF (X .GT. 50000.) RETURN
         IF (X .EQ. 1.0) THEN
            IF (XMAXD .LT. XMIN) THEN
               XMAXD = XCNTD
               DMAX = DEPCNT
               KSTMXD = KSTCTD
            END IF
            RETURN
         END IF
         GO TO 7
      END IF

      END

      BLOCK DATA INIT
C
C     BLOCK DATA INIT SUBPROGRAM TO INITIALIZE DATA IN COMMON BLOCKS.
C
      INCLUDE 'MAIN.INC'

      DATA XAUTO/1.,100.,  200.,  300.,  400.,  500.,
     &              600.,  700.,  800.,  900., 1000.,
     &             1100., 1200., 1300., 1400., 1500.,
     &             1600., 1700., 1800., 1900., 2000.,
     &             2100., 2200., 2300., 2400., 2500.,
     &             2600., 2700., 2800., 2900., 3000.,
     &             3500., 4000., 4500., 5000., 5500.,
     &             6000., 6500., 7000., 7500., 8000.,
     &             8500., 9000., 9500.,10000.,15000.,
     &            20000.,25000.,30000.,40000.,50000./

      DATA DWASH/'NO','SS','HS','NA','  '/

      DATA VERSN/'95250'/

C     Initialize File Units
      DATA IRD/5/, IPRT/6/, IOUT/9/, IDAT/7/, IDBG/13/

      END
