* system : tscreen
* program : scrnasub
* author : Kevin Stroupe, PES
*modified by: roger brode, pes
*   Modified to change wording for distances to be measured from the
*   center of area source, rather than from the downwind edge.  This
*   modification is needed for the use of the SCREEN2 model (version 92245).
*   Also modified references from SCREEN model to SCREEN2 model.
*modified by: roger brode, pes, 9/12/95
*   Modified for use of new area source algorithm in SCREEN3 (version 95250).
*   Also modified references from SCREEN2 model to SCREEN3 model.

* model is now always 'ScrnA2' for new area source algorithm.
model = 'ScrnA'
source = 'A'

IF scenario = '1.2' .OR. scenario = '2.9'
   IF .NOT. GotArea       
      DO WHILE .NOT. abort
         CLEAR     
         DO ClrEL1Key 
         DO endline1
         DO EL1Keys
         edit = .F.
         prcd = .F.
         @ 0, 3 SAY 'Based on user input, SCREEN3 model has been selected.'
         @ 1, 3 SAY 'SCREEN3 MODEL INPUTS - Page 1 of 2'
         @ 3, 3 SAY 'RELEASE PARAMETERS'
         @ 4, 3 SAY '                   Release Height above Ground (Hs) -> ' + LEFT(Hs+SPACE(8),8) + ' m'
         @ 5, 3 SAY '                    Area of the Emitting Source (A) -> ' + LEFT(A+SPACE(8),8) + ' m'
         @ 7, 3 SAY 'URBAN/RURAL CLASSIFICATION'
         @ 8, 3 SAY '                    Enter U for Urban - R for Rural -> '+LEFT(Ruclass+' ',1)
         @ 10,3 SAY 'FENCELINE DISTANCE'
         @ 11,3 SAY '      Enter the minimum distance from the center of '
         @ 12,3 SAY '                  the source to the plant fenceline -> '+LEFT(Fence+SPACE(8),8)+' m'
         @ 14,3 SAY 'FLAG POLE RECEPTORS'
         @ 15,3 SAY '            Enter Receptor Height above Ground (Zr) -> '+LEFT(Zr+SPACE(8),8)+' m'
         @ 17,3 SAY 'RECEPTOR LOCATIONS'
         @ 18,3 SAY 'Do you have specific locations where you would like '
         @ 19,3 SAY '    pollutant concentrations to be calculated (Y/N) -> '+LEFT(Isd+' ',1)
             
         @ 4, 58 FILL TO 4,65 COLOR &IPColor  
         @ 5, 58 FILL TO 5,65 COLOR &IPColor  
         @ 8, 58 FILL TO 8,58 COLOR &IPColor 
         @ 12, 58 FILL TO 12,65 COLOR &IPColor          
         @ 15, 58 FILL TO 15,65 COLOR &IPColor 
         @ 19, 58 FILL TO 19,58 COLOR &IPColor  
   
         cntr = 1
         DO WHILE .NOT. abort
            DO CASE 
              CASE cntr = 1
                 @ 4,58 GET Hs PICTURE '@!' VALID Chk(Hs,2)
                 READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 1
                     CASE prev             && F9
                        model = ''
                        RETURN   
                     OTHERWISE 
                        IF VAL(Hs) > 10
                           DEFINE WINDOW msg FROM 7,10 TO 14,70 SHADOW COLOR &MesColor
                           ACTIVATE WINDOW msg                 
                           @ 0,0 SAY 'If height > 10 m, volume source and SCREEN does not apply. '
                           @ 2,0 SAY 'The user may want to consult the Industrial Source Complex ' 
                           @ 3,0 SAY '(ISC) Model for this application.'
                           WAIT              
                           RELEASE WINDOW msg
                           *WAIT 'If height > 10 m, volume source and SCREEN does not apply, '+press WINDOW
                           cntr = 1
                           LOOP                  
                        ENDIF   
                        cntr = 2
                  ENDCASE 
              CASE cntr = 2
                 @ 5,58 GET A PICTURE '@!' VALID Chk(A,2)
                 READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 1
                     CASE prev             && F9
                        model = ''                       
                        RETURN   
                     OTHERWISE 
                        cntr = 3
                  ENDCASE 
               CASE cntr = 3
                  @ 8,58 GET Ruclass PICTURE '@!' VALID ChkRU(Ruclass)           
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 2
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 4
                  ENDCASE 
              CASE cntr = 4
                 @ 12,58 GET Fence PICTURE '@!' VALID Chk(Fence,4)
                 READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 3
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        IF VAL(Fence) > 50000
                           WAIT 'Fenceline must be  50000 m, '+press WINDOW
                           cntr = 4
                           LOOP                  
                        ENDIF   
                        cntr = 5
                  ENDCASE 
                  
               CASE cntr = 5
                  @ 15, 58 GET Zr PICTURE '@!' VALID Chk(Zr,2)   
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 4
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 6
                  ENDCASE                   
               CASE cntr = 6        
                  @ 19,58 GET Isd PICTURE '@!' VALID ChkYN(Isd)
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 5
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 7
                  ENDCASE                   
               CASE cntr = 7            
                  IF ALLTRIM(Isd) = 'Y'
                     DO EL2Keys
                  ELSE
                     DO EL3Keys
                  ENDIF

                  IF prev           && F9                  
                     model = ''
                     RETURN
                  ENDIF                 
                  IF prcd           && F10
                     IF ALLTRIM(Isd) = 'Y'
                        DO scrnax2
                     ELSE
                        DO ScrnASav
                        DO RunModel
                        abort = .T.
                     ENDIF
                  ENDIF   
                  EXIT                               
            ENDCASE
            IF LASTKEY() = 27
               abort = .T.
               EXIT
            ENDIF               
         ENDDO  
      ENDDO
   ELSE && GotArea
      DO WHILE .NOT. abort
         CLEAR     
         DO ClrEL1Key 
         DO endline1
         DO EL1Keys
         edit = .F.
         prcd = .F.
         @ 0, 3 SAY 'Based on user input, SCREEN3 model has been selected.'
         @ 2, 3 SAY 'SCREEN3 MODEL INPUTS - Page 1 of 2'
         @ 4, 3 SAY 'RELEASE PARAMETER'
         @ 5, 3 SAY '                   Release Height above Ground (Hs) -> ' + LEFT(Hs+SPACE(8),8) + ' m'
         @ 7, 3 SAY 'URBAN/RURAL CLASSIFICATION'
         @ 8, 3 SAY '                    Enter U for Urban - R for Rural -> '+LEFT(Ruclass+' ',1)
         @ 10,3 SAY 'FENCELINE DISTANCE'
         @ 11,3 SAY '      Enter the minimum distance from the center of '
         @ 12,3 SAY '                  the source to the plant fenceline -> '+LEFT(Fence+SPACE(8),8)+' m'
         @ 14,3 SAY 'FLAG POLE RECEPTORS'
         @ 15,3 SAY '            Enter Receptor Height above Ground (Zr) -> '+LEFT(Zr+SPACE(8),8)+' m'
         @ 17,3 SAY 'RECEPTOR LOCATIONS'
         @ 18,3 SAY 'Do you have specific locations where you would like '
         @ 19,3 SAY '    pollutant concentrations to be calculated (Y/N) -> '+LEFT(Isd+' ',1)
             
         @ 5, 58 FILL TO 5,65 COLOR &IPColor  
         @ 8, 58 FILL TO 8,58 COLOR &IPColor 
         @ 12, 58 FILL TO 12,65 COLOR &IPColor 
         @ 15, 58 FILL TO 15,65 COLOR &IPColor 
         @ 19, 58 FILL TO 19,58 COLOR &IPColor  
   
         cntr = 1
         DO WHILE .NOT. abort
            DO CASE 
              CASE cntr = 1
                 @ 5,58 GET Hs PICTURE '@!' VALID Chk(Hs,2)
                 READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 1
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE                      
                        IF VAL(Hs) > 10
                           DEFINE WINDOW msg FROM 7,10 TO 14,70 SHADOW COLOR &MesColor
                           ACTIVATE WINDOW msg                 
                           @ 0,0 SAY 'If height > 10 m, volume source and SCREEN does not apply. '
                           @ 2,0 SAY 'The user may want to consult the Industrial Source Complex ' 
                           @ 3,0 SAY '(ISC) Model for this application.'
                           WAIT              
                           RELEASE WINDOW msg
                           *WAIT 'If height > 10 m, volume source and SCREEN does not apply, '+press WINDOW
                           cntr = 1
                           LOOP                  
                        ENDIF   
                        cntr = 2
                  ENDCASE 
               CASE cntr = 2
                  @ 8,58 GET Ruclass PICTURE '@!' VALID ChkRU(Ruclass)           
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 1
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 3
                  ENDCASE                   
              CASE cntr = 3
                 @ 12,58 GET Fence PICTURE '@!' VALID Chk(Fence,4)
                 READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 2
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        IF VAL(Fence) > 50000
                           WAIT 'Fenceline must be  50000, '+press WINDOW
                           cntr = 3
                           LOOP                  
                        ENDIF   
                        cntr = 4
                  ENDCASE 
               CASE cntr = 4
                  @ 15, 58 GET Zr PICTURE '@!' VALID Chk(Zr,2)   
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 3
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 5
                  ENDCASE                                     
               CASE cntr = 5
                  @ 19,58 GET Isd PICTURE '@!' VALID ChkYN(Isd)
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 4
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 6
                  ENDCASE                   
               CASE cntr = 6        
                  IF ALLTRIM(Isd) = 'Y'
                     DO EL2Keys
                  ELSE
                     DO EL3Keys
                  ENDIF
                   
                  IF prev           && F9
                     model = ''
                     RETURN
                  ENDIF                 
                  IF prcd           && F10
                     IF ALLTRIM(Isd) = 'Y'
                        DO scrnax2
                     ELSE
                        DO ScrnASav
                        DO RunModel
                        abort = .T.
                     ENDIF
                  ENDIF   
                  EXIT                               
            ENDCASE
            IF LASTKEY() = 27
               abort = .T.
               EXIT
            ENDIF               
         ENDDO  
      ENDDO   
   ENDIF   
ELSE && scenario <> '1.2' .AND. scenario <> '2.9'
   Hs = '0       '
   IF .NOT. GotArea       
      DO WHILE .NOT. abort
         CLEAR     
         DO ClrEL1Key 
         DO endline1
         DO EL1Keys
         edit = .F.
         prcd = .F.
         @ 0, 3 SAY 'Based on user input, SCREEN3 model has been selected.'
         @ 2, 3 SAY 'SCREEN3 MODEL INPUTS - Page 1 of 2'
         @ 4, 3 SAY 'RELEASE PARAMETER'
         @ 5, 3 SAY '                    Area of the Emitting Source (A) -> ' + LEFT(A+SPACE(8),8) + ' m'
         @ 7, 3 SAY 'URBAN/RURAL CLASSIFICATION'
         @ 8, 3 SAY '                    Enter U for Urban - R for Rural -> '+LEFT(Ruclass+' ',1)
         @ 10,3 SAY 'FENCELINE DISTANCE'
         @ 11,3 SAY '      Enter the minimum distance from the center of '
         @ 12,3 SAY '                  the source to the plant fenceline -> '+LEFT(Fence+SPACE(8),8)+' m'
         @ 14,3 SAY 'FLAG POLE RECEPTORS'
         @ 15,3 SAY '            Enter Receptor Height above Ground (Zr) -> '+LEFT(Zr+SPACE(8),8)+' m'
         @ 17,3 SAY 'RECEPTOR LOCATIONS'
         @ 18,3 SAY 'Do you have specific locations where you would like '
         @ 19,3 SAY '    pollutant concentrations to be calculated (Y/N) -> '+LEFT(Isd+' ',1)
             
         @ 5, 58 FILL TO 5,65 COLOR &IPColor       
         @ 8, 58 FILL TO 8,58 COLOR &IPColor 
         @ 12, 58 FILL TO 12,65 COLOR &IPColor 
         @ 15, 58 FILL TO 15,65 COLOR &IPColor 
         @ 19, 58 FILL TO 19,58 COLOR &IPColor  
   
         cntr = 1
         DO WHILE .NOT. abort
            DO CASE 
               CASE cntr = 1
                  @ 5,58 GET A PICTURE '@!' VALID Chk(A,2)           
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 1
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 2
                  ENDCASE 
               CASE cntr = 2
                  @ 8,58 GET Ruclass PICTURE '@!' VALID ChkRU(Ruclass)           
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 1
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 3
                  ENDCASE                   
               CASE cntr = 3                          
                  @ 12,58 GET Fence PICTURE '@!' VALID Chk(Fence,4)
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 2
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        IF VAL(Fence) > 50000
                           WAIT 'Fenceline must be  50000 m, '+press WINDOW
                           cntr = 3
                           LOOP
                        ENDIF
                        cntr = 4
                  ENDCASE 
               CASE cntr = 4
                  @ 15, 58 GET Zr PICTURE '@!' VALID Chk(Zr,2)   
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 3
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 5
                  ENDCASE                                     
               CASE cntr = 5
                  @ 19,58 GET Isd PICTURE '@!' VALID ChkYN(Isd)
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 4
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 6
                  ENDCASE                   

               CASE cntr = 6               
                  IF ALLTRIM(Isd) = 'Y'
                     DO EL2Keys
                  ELSE
                     DO EL3Keys
                  ENDIF

                  IF prev           && F9
                     model = ''
                     RETURN
                  ENDIF                 
                  IF prcd           && F10
                     IF ALLTRIM(Isd) = 'Y'
                        DO scrnax2
                     ELSE
                        DO ScrnASav
                        DO RunModel
                        abort = .T.
                     ENDIF
                  ENDIF   
                  EXIT                               
            ENDCASE
            IF LASTKEY() = 27
               abort = .T.
               EXIT
            ENDIF               
         ENDDO  
      ENDDO
   ELSE && GotArea
      DO WHILE .NOT. abort
         CLEAR     
         DO ClrEL1Key 
         DO endline1
         DO EL1Keys
         edit = .F.
         prcd = .F.
         @ 0, 3 SAY 'Based on user input, SCREEN3 model has been selected.'
         @ 2, 3 SAY 'SCREEN3 MODEL INPUTS - Page 1 of 2'
         @ 4, 3 SAY 'URBAN/RURAL CLASSIFICATION'
         @ 5, 3 SAY '                    Enter U for Urban - R for Rural -> '+LEFT(Ruclass+' ',1)
         @ 7, 3 SAY 'FENCELINE DISTANCE'
         @ 8, 3 SAY '      Enter the minimum distance from the center of '
         @ 9, 3 SAY '                  the source to the plant fenceline -> '+LEFT(Fence+SPACE(8),8)+' m'
         @ 11,3 SAY 'FLAG POLE RECEPTORS'
         @ 12,3 SAY '            Enter Receptor Height above Ground (Zr) -> '+LEFT(Zr+SPACE(8),8)+' m'         
         @ 14,3 SAY 'RECEPTOR LOCATIONS'
         @ 15,3 SAY 'Do you have specific locations where you would like '
         @ 16,3 SAY '    pollutant concentrations to be calculated (Y/N) -> '+LEFT(Isd+' ',1)
             
         @ 5, 58 FILL TO 5,58 COLOR &IPColor  
         @ 9, 58 FILL TO 9,65 COLOR &IPColor 
         @ 12, 58 FILL TO 12,65 COLOR &IPColor          
         @ 16, 58 FILL TO 16,58 COLOR &IPColor  
   
         cntr = 1
         DO WHILE .NOT. abort
            DO CASE 
               CASE cntr = 1
                  @ 5,58 GET Ruclass PICTURE '@!' VALID ChkRU(Ruclass)           
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 1
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 2
                  ENDCASE             
               CASE cntr = 2
                  @ 9,58 GET Fence PICTURE '@!' VALID Chk(Fence,4)           
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 1
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        IF VAL(Fence) > 50000
                           WAIT 'Fenceline must be  50000 m, '+press WINDOW
                           cntr = 2
                           LOOP
                        ENDIF
                        cntr = 3
                  ENDCASE 
               CASE cntr = 3
                  @ 12, 58 GET Zr PICTURE '@!' VALID Chk(Zr,2)   
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 2
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 4
                  ENDCASE                                     
               CASE cntr = 4
                  @ 16,58 GET Isd PICTURE '@!' VALID ChkYN(Isd)
                  READ   
                  DO CASE
                     CASE LASTKEY() = 27  && ESCAPE
                        abort = .T.
                        EXIT 
                     CASE LASTKEY() = 5   && UP 
                        cntr = 3
                     CASE prev             && F9
                        model = ''                     
                        RETURN   
                     OTHERWISE 
                        cntr = 5
                  ENDCASE                               
               CASE cntr = 5
                   IF ALLTRIM(Isd) = 'Y'
                     DO EL2Keys
                  ELSE
                     DO EL3Keys
                  ENDIF
                   
                  IF prev           && F9
                     model = ''
                     RETURN
                  ENDIF                 
                  IF prcd           && F10
                     IF ALLTRIM(Isd) = 'Y'
                        DO scrnax2
                     ELSE
                        DO ScrnASav
                        DO RunModel
                        abort = .T.
                     ENDIF
                  ENDIF   
                  EXIT                               
            ENDCASE
            IF LASTKEY() = 27
               abort = .T.
               EXIT
            ENDIF               
         ENDDO  
      ENDDO   
   ENDIF 
ENDIF             
DEACTIVATE WINDOW datawind
model = ''
RETURN

****************************** ScrnA x 2 ********************************
PROCEDURE scrnax2

Dist(1) = Fence
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SCREEN3 MODEL INPUTS - Page 2 of 2'
   @ 2, 3 SAY 'RECEPTOR LOCATIONS:  Enter (up to 30) distances from'
   @ 3, 3 SAY 'the source at which concentrations should be calculated.'
   @ 4, 3 SAY 'Enter a blank after the last distance to stop input.'
   @ 6, 3 SAY '   Distance from          Distance from          Distance from'
   @ 7, 3 SAY '  source (meters)        source (meters)        source (meters)'
   @ 8, 3 SAY '                '
   @ 9, 3 SAY '    1          fence      11                     21'
   @ 10,3 SAY '    2                     12                     22'
   @ 11,3 SAY '    3                     13                     23'
   @ 12,3 SAY '    4                     14                     24'
   @ 13,3 SAY '    5                     15                     25'
   @ 14,3 SAY '    6                     16                     26'
   @ 15,3 SAY '    7                     17                     27'
   @ 16,3 SAY '    8                     18                     28'
   @ 17,3 SAY '    9                     19                     29'
   @ 18,3 SAY '   10                     20                     30'
   
   FOR i = 0 TO 2
      FOR j = 1 TO 10
         DO CASE
            CASE i = 0
               col = 9
            CASE i = 1
               col = 32
            CASE i = 2
               col = 55
         ENDCASE
         @ 8+j, col SAY LEFT(Dist((10*i)+j)+SPACE(8),8)
      NEXT j
   NEXT i
   @ 10,9 FILL TO 18,16 COLOR &IPColor
   @ 9,32 FILL TO 18,39 COLOR &IPColor
   @ 9,55 FILL TO 18,62 COLOR &IPColor
   cntr = 1
   dist_cntr = 2
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 1
            DO WHILE dist_cntr <= 30               
               IF dist_cntr <=10 
                  row = 8+dist_cntr
                  col = 9
               ELSE
                  IF dist_cntr <= 20 
                     row = 8+(dist_cntr-10)
                     col = 32
                  ELSE
                     row = 8+(dist_cntr-20)
                     col = 55
                  ENDIF
               ENDIF
            
               @ row, col GET Dist(dist_cntr) PICTURE '@!' VALID Chk(Dist(dist_cntr),-1)
               READ
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT
                  CASE LASTKEY() = 5   && UP 
                     IF dist_cntr > 2   
                        dist_cntr = dist_cntr -1
                     ENDIF
                  CASE prev  && F9            
                     RETURN                
                  OTHERWISE                       
                     IF LEN(ALLTRIM(Dist(dist_cntr))) = 0  
                        IF LEN(ALLTRIM(Dist(dist_cntr+1))) > 0
                           WAIT 'Enter a DISTANCE, '+press WINDOW
                           LOOP
                        ELSE
                           *num_dist = dist_cntr - 1                                                                                                            
                           EXIT
                        ENDIF
		     ENDIF
*                     IF model = 'ScrnA'
*                     IF VAL(Dist(dist_cntr)) <= VAL(Dist(dist_cntr-1))
*                        WAIT 'Distance must be > previous distance, '+press WINDOW
*                        LOOP
*                     ENDIF
*                     ENDIF
                     IF VAL(Dist(dist_cntr)) > 100000
                        WAIT 'Distance must be  100000, '+press WINDOW
                        LOOP
                     ENDIF
                     dist_cntr = dist_cntr + 1
               ENDCASE
            ENDDO
            num_dist = dist_cntr - 1
            cntr = 2 
         CASE cntr = 2
             DO EL3Keys
             IF prev           && F9
                RETURN
             ENDIF                 
             IF prcd           && F10
                DO ScrnASav                
                DO RunModel 
                abort = .T. 
             ENDIF               
             EXIT                               
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
RETURN

****************************** ScrnA Save ********************************
PROCEDURE scrnasav

* Calculate emission rate for SCREEN3 model in g/(s-m^2).
rs = convert(SQRT(VAL(A)))
Qmnew = convert(VAL(Qm) / (VAL(rs) * VAL(rs)))

ifp = FCREATE('SCREEN.IN')
bytes = FPUTS(ifp,Title)
bytes = FPUTS(ifp,source)
bytes = FPUTS(ifp,Qmnew)
bytes = FPUTS(ifp,Hs)
bytes = FPUTS(ifp,rs)
bytes = FPUTS(ifp,rs)        && second side length for new area source
bytes = FPUTS(ifp,Zr)           && receptor height

IF Ruclass = 'U'
   ru = 'U'
ELSE 
   ru = 'R'
ENDIF

bytes = FPUTS(ifp,ru)       && rural / urban classification
bytes = FPUTS(ifp,'y')       && search through directions for new area source
bytes = FPUTS(ifp,'1')           && full meterology
bytes = FPUTS(ifp,'y')           && automated distance array
bytes = FPUTS(ifp,ALLTRIM(Fence)+','+'50000')
bytes = FPUTS(ifp,Isd)
IF Isd = 'Y'
   FOR i = 1 TO num_dist
      bytes = FPUTS(ifp,Dist(i))
   NEXT i
   bytes = FPUTS(ifp,'0')
ENDIF

bytes = FPUTS(ifp,'n')           && Print option
x=FCLOSE(ifp)

IF Isd = 'Y'
   distfile = FCREATE('DISTNUM')
   bytes = FPUTS(distfile,ALLTRIM(STR(num_dist))+','+'0')
   =FCLOSE(distfile)
ELSE  
   distfile = FCREATE('DISTNUM')
   bytes = FPUTS(distfile,'0'+','+'0')
   =FCLOSE(distfile)
ENDIF


RETURN
