* system : tscreen
* program : scrnfsub
* author : Kevin Stroupe, PES
* purpose : accesses screen model based on flare source input
* update author : Gerry Chike, PES
* update purpose : change string constants on page 1 of 7
* modified by: roger brode, pes
*   Modified references from SCREEN model to SCREEN2 model.

model = 'ScrnF'
source = 'F'

PUBLIC Hs1

ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 0, 3 SAY 'Based on user input, SCREEN3 model has been selected.'
   @ 2, 3 SAY 'SCREEN3 MODEL INPUTS - Page 1 of 7'
   @ 6, 3 SAY 'RELEASE PARAMETERS'
   @ 7, 3 SAY 'Enter the Emission Rate (Qm), if unknown enter'
   @ 8, 3 SAY '        the boxed variables below to calculate -> '+LEFT(Qm+SPACE(8),8)+' g/s' 
   @ 9,3 TO 13,75
   @ 10,5 SAY '          Volume Fraction of Pollutant (Vol) -> '+LEFT(Vol+SPACE(8),8)+' %'
*  @ 11,5 SAY '                      Material Flow Rate (V) -> ' + LEFT(V+SPACE(8),8) + ' cubic m/s'
   @ 11,5 SAY '           Volumetric Feed Gas Flow Rate (V) -> ' + LEFT(V+SPACE(8),8) + ' cubic m/s'   
*  @ 12,5 SAY '  Molecular Weight of Material Released (Mw) -> ' + LEFT(Mw+SPACE(8),8) + ' g/g-mole'
   @ 12,5 SAY '           Molecular Weight of Feed Gas (Mw) -> ' + LEFT(Mw+SPACE(8),8) + ' g/g-mole'
   @ 15,3 SAY '                  Total Heat Release Rate (Hr) -> '+ LEFT(Hr+SPACE(8),8) + ' J/s'
   @ 16,3 SAY '              Release Height above Ground (Hs) -> '+LEFT(Hs+SPACE(8),8) + ' m'
   
   @ 8, 53 FILL TO 8,60 COLOR &IPColor  
   @ 10, 53 FILL TO 10,60 COLOR &IPColor 
   @ 11, 53 FILL TO 11,60 COLOR &IPColor 
   @ 12, 53 FILL TO 12,60 COLOR &IPColor  
   @ 15, 53 FILL TO 15,60 COLOR &IPColor 
   @ 16, 53 FILL TO 16,60 COLOR &IPColor 
   
   cntr = 0
   DO WHILE .NOT. abort
      holdf = Qm
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  model = ''               
                  RETURN                
               OTHERWISE                 
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 8,53 GET Qm PICTURE '@!' VALID Chk(Qm,-3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  model = ''               
                  RETURN   
               CASE LEN(ALLTRIM(Qm)) = 0
                  cntr = 2   
               OTHERWISE 
                  IF Qm <> holdf
                     Vol =SPACE(8)
                     V=SPACE(8)
                     Mw = SPACE(8)
                     @ 10,53 SAY Vol
                     @ 11,53 SAY V
                     @ 12,53 SAY Mw
                     @ 10, 53 FILL TO 10,60 COLOR &IPColor   
                     @ 11, 53 FILL TO 11,60 COLOR &IPColor
                     @ 12, 53 FILL TO 12,60 COLOR &IPColor
                  ENDIF   
                  cntr = 3
            ENDCASE 
   
         CASE cntr = 2
            @ 10,53 GET Vol PICTURE '@!' VALID Chk(Vol,16)           
            @ 11,53 GET V PICTURE '@!' VALID Chk(V,3)           
            @ 12,53 GET Mw PICTURE '@!' VALID Chk(Mw,8)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  model = ''               
                  RETURN   
               OTHERWISE 
                  v_num = (VAL(Vol)/100) * VAL(V)                                                  
                  Qm = convert(v_num * VAL(Mw) * .02 / .0224)                  
                  @ 8,53 SAY Qm
                  @ 8,53 FILL TO 8,60 COLOR &IPColor
                  IF VAL(Qm) <= 0 
                     WAIT 'Release Rate must be > 0, '+press WINDOW
                     cntr = 1
                     LOOP
                  ENDIF
                  cntr = 3
             ENDCASE 
         CASE cntr = 3
            @ 15,53 GET Hr PICTURE '@!' VALID Chk(Hr,7)           
            @ 16,53 GET Hs PICTURE '@!' VALID Chk(Hs,2)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  model = ''               
                  RETURN   
               OTHERWISE
                  *Calculate effective stack height
                  Hs1 = convert(VAL(Hs) + 4.56E-03 * (VAL(Hr)/4.1868)**0.478)
               
                 * IF VAL(Hs) = 0 
                 *    Hb = '0       '
                 *    Bmin = '0       '
                 *    Bmax = '0       '
                 * ENDIF
                  cntr = 4
             ENDCASE 
         CASE cntr = 4       
             DO EL2Keys
             IF prev           && F9
                model = ''
                RETURN
             ENDIF                 
             IF prcd           && F10
                DO scrnfx2
             ENDIF   
             EXIT                               
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
             
DEACTIVATE WINDOW datawind
model = ''
RELEASE Hs1
RETURN

******************************* ScrnF x 2 ********************************
*PROCEDURE scrnfx2
*
*DO WHILE .NOT. abort
*   CLEAR
*   DO ClrEL1Key 
*   DO endline1
*   DO EL1Keys
*   edit = .F.
*   prcd = .F.
*   @ 1, 3 SAY 'SCREEN3 MODEL INPUTS - Page 2 of 3'
*   @ 3, 3 SAY 'BUILDING PARAMETERS'
*   @ 4, 3 SAY '      Building Height (enter 0 if no building) -> '+LEFT(Hb+SPACE(8),8) + ' m'
*   @ 5, 3 SAY '         Minimum Horizontal Building Dimension -> '+LEFT(Bmin+SPACE(8),8)+' m'
*   @ 6, 3 SAY '         Maximum Horizontal Building Dimension -> '+LEFT(Bmax+SPACE(8),8) +' m'
*   @ 8,3 SAY 'FENCELINE DISTANCE'
*   @ 9,3 SAY ' Enter the distance from the base of the stack' 
*   @ 10,3 SAY '                        to the plant fenceline -> '+LEFT(Fence+SPACE(8),8) + ' m'
*   @ 12,3 SAY 'URBAN/RURAL CLASSIFICATION'
*   @ 13,3 SAY '               Enter U for Urban - R for Rural -> '+LEFT(Ruclass+' ',1)
*   @ 15,3 SAY 'RECEPTOR LOCATIONS'
*   @ 16,3 SAY 'Do you have specific locations where you would'
*   @ 17,3 SAY 'like pollutant concentrations calculated (Y/N) -> '+LEFT(Isd+' ',1)
*   
*   IF VAL(Hs) <> 0
*      @ 4, 53 FILL TO 4,60 COLOR &IPColor  
*      @ 5, 53 FILL TO 5,60 COLOR &IPColor 
*      @ 6, 53 FILL TO 6,60 COLOR &IPColor 
*      cntr = 1
*   ELSE 
*      cntr = 3
*   ENDIF
*   @ 10, 53 FILL TO 10,60 COLOR &IPColor  
*   @ 13, 53 FILL TO 13,53 COLOR &IPColor 
*   @ 17, 53 FILL TO 17,53 COLOR &IPColor 
*   
*   DO WHILE .NOT. abort
*      DO CASE 
*         CASE cntr = 1
*            @ 4, 53 GET Hb PICTURE '@!' VALID Chk(Hb,2)
*            READ
*            DO CASE
*               CASE LASTKEY() = 27  && ESCAPE
*                  abort = .T.
*                  EXIT
*               CASE LASTKEY() = 5   && UP    
*                  cntr = 1
*               CASE prev  && F9            
*                  RETURN                
*               OTHERWISE  
*                  IF VAL(Hb) = 0 
*                     Bmin = '0       '  
*                     Bmax = '0       ' 
*                     @ 5, 53 SAY Bmin 
*                     @ 6, 53 SAY Bmax 
*                     @ 5, 53 FILL TO 5,60 COLOR &HLColor 
*                     @ 6, 53 FILL TO 6,60 COLOR &HLColor                                                 
*                     cntr = 3
*                  ELSE
*                     @ 5, 53 FILL TO 5,60 COLOR &IPColor 
*                     @ 6, 53 FILL TO 6,60 COLOR &IPColor                                                 
*                     cntr = 2
*                 ENDIF                  
*            ENDCASE
*         CASE cntr = 2
*            @ 5,53 GET Bmin PICTURE '@!' VALID Chk(Bmin,2)
*            @ 6,53 GET Bmax PICTURE '@!' VALID Chk(Bmax,2)
*            READ   
*            DO CASE
*               CASE LASTKEY() = 27  && ESCAPE
*                  abort = .T.
*                  EXIT 
*               CASE LASTKEY() = 5   && UP 
*                  cntr = 1
*               CASE prev             && F9
*                  RETURN   
*               OTHERWISE 
*                  IF VAL(Bmin) > VAL(Bmax)
*                     temp = Bmin
*                     Bmin = Bmax
*                     Bmax = temp
*                     @ 5,53 SAY Bmin
*                     @ 6,53 SAY Bmax
*                     @ 5,53 FILL TO 5,60 COLOR &IPColor
*                     @ 6,53 FILL TO 6,60 COLOR &IPColor
*                  ENDIF                     
*                  cntr = 3
*            ENDCASE 
*         CASE cntr = 3
*            @ 10,53 GET Fence PICTURE '@!' VALID Chk(Fence,4)
*            READ   
*            DO CASE
*               CASE LASTKEY() = 27  && ESCAPE
*                  abort = .T.
*                  EXIT 
*               CASE LASTKEY() = 5   && UP 
*                  DO CASE
*                     CASE VAL(Hs) = 0
*                        cntr = 3
*                     CASE VAL(Hb) = 0
*                        cntr = 1
*                     OTHERWISE
*                        KEYBOARD CHR(13)
*                        cntr = 2
*                  ENDCASE
*               CASE prev             && F9
*                  RETURN   
*               OTHERWISE 
*                  IF VAL(Fence) > 50000
*                     WAIT 'Fenceline must be  50000, '+press WINDOW
*                     cntr = 3
**                     LOOP
*                  ENDIF                  
*                  cntr = 4
*            ENDCASE 
*               
*         CASE cntr = 4
*            @ 13,53 GET Ruclass PICTURE '@!' VALID ChkRU(Ruclass)
*            READ   
*            DO CASE
*               CASE LASTKEY() = 27  && ESCAPE
*                  abort = .T.
*                  EXIT 
*               CASE LASTKEY() = 5   && UP 
*                  cntr = 3
*               CASE prev             && F9
*                  RETURN   
*               OTHERWISE 
*                  IF Ruclass = 'U'
*                     ru = '1'
*                  ELSE
*                     ru = '2'
*                  ENDIF
*                  cntr = 5
*            ENDCASE 
*   
*         CASE cntr = 5
*            @ 17,53 GET Isd PICTURE '@!' VALID ChkYN(Isd)           
*            READ   
*            DO CASE
*               CASE LASTKEY() = 27  && ESCAPE
*                  abort = .T.
*                  EXIT 
*               CASE LASTKEY() = 5   && UP 
*                  cntr = 4
*               CASE prev             && F9
*                  RETURN   
*               OTHERWISE 
*                  cntr = 6
*             ENDCASE 
*          CASE cntr = 6
*             IF ALLTRIM(Isd) = 'Y'
*                DO EL2Keys
*             ELSE
*                DO EL3Keys
*             ENDIF
*             IF prev           && F9
*                RETURN
*             ENDIF                 
*             IF prcd           && F10
*                IF ALLTRIM(Isd) = 'Y'
*                   DO scrnfx3
*                ELSE
*                   DO ScrnFSav
*                   DO RunModel
*                   abort = .T.
*                ENDIF
*             ENDIF   
*             EXIT                               
*      ENDCASE
*      IF LASTKEY() = 27
*         abort = .T.
*         EXIT
*      ENDIF               
*   ENDDO  
*ENDDO
*RETURN
*
******************************* ScrnF x 3 ********************************
*PROCEDURE scrnfx3
*
*Dist(1) = Fence
*DO WHILE .NOT. abort
*   CLEAR
*   DO ClrEL1Key 
*   DO endline1
*   DO EL1Keys
*   edit = .F.
*   prcd = .F.
*   @ 1, 3 SAY 'SCREEN3 MODEL INPUTS - Page 3 of 3'
*   @ 2, 3 SAY 'RECEPTOR LOCATIONS:  Enter (up to 30) distances from'
*   @ 3, 3 SAY 'the source at which concentrations should be calculated.'
*   @ 4, 3 SAY 'Enter a blank after the last distance to stop input.'
*   @ 6, 3 SAY '   Distance from          Distance from          Distance from'
*   @ 7, 3 SAY '  source (meters)        source (meters)        source (meters)'
*   @ 8, 3 SAY '                '
*   @ 9, 3 SAY '    1          fence      11                     21'
*   @ 10,3 SAY '    2                     12                     22'
*   @ 11,3 SAY '    3                     13                     23'
*   @ 12,3 SAY '    4                     14                     24'
*   @ 13,3 SAY '    5                     15                     25'
*   @ 14,3 SAY '    6                     16                     26'
*   @ 15,3 SAY '    7                     17                     27'
*   @ 16,3 SAY '    8                     18                     28'
*   @ 17,3 SAY '    9                     19                     29'
*   @ 18,3 SAY '   10                     20                     30'
*   
*   FOR i = 0 TO 2
*      FOR j = 1 TO 10
*         DO CASE
*            CASE i = 0
*               col = 9
*            CASE i = 1
*               col = 32
*            CASE i = 2
*               col = 55
*         ENDCASE
*         @ 8+j, col SAY LEFT(Dist((10*i)+j)+SPACE(8),8)
*      NEXT j
*   NEXT i
*   @ 9,9 FILL TO 18,16 COLOR &IPColor
*   @ 9,32 FILL TO 18,39 COLOR &IPColor
*   @ 9,55 FILL TO 18,62 COLOR &IPColor
*   cntr = 1
*   dist_cntr = 2
*   DO WHILE .NOT. abort
*      DO CASE 
*         CASE cntr = 1
*            DO WHILE dist_cntr <= 30               
*               IF dist_cntr <=10 
*                  row = 8+dist_cntr
*                  col = 9
*               ELSE
*                  IF dist_cntr <= 20 
*                     row = 8+(dist_cntr-10)
*                     col = 32
*                  ELSE
*                     row = 8+(dist_cntr-20)
*                     col = 55
*                  ENDIF
*               ENDIF
*            
*               @ row, col GET Dist(dist_cntr) PICTURE '@!' VALID Chk(Dist(dist_cntr),-1)
*               READ
*               DO CASE
*                  CASE LASTKEY() = 27  && ESCAPE
*                     abort = .T.
*                     EXIT
*                  CASE LASTKEY() = 5   && UP 
*                     IF dist_cntr > 2   
*                        dist_cntr = dist_cntr -1
*                     ENDIF
*                  CASE prev  && F9            
*                     RETURN                
*                  OTHERWISE                       
*                     IF LEN(ALLTRIM(Dist(dist_cntr))) = 0  
*                        IF LEN(ALLTRIM(Dist(dist_cntr+1))) > 0
*                            WAIT 'Enter a DISTANCE, '+press WINDOW
*                           LOOP
*                        ELSE
*                           num_dist = dist_cntr - 1                                                                                                            
*                           EXIT
*                        ENDIF
*                     ENDIF
*                     IF VAL(Dist(dist_cntr)) <= VAL(Dist(dist_cntr-1))
*                        WAIT 'Distance must be > previous distance, '+press WINDOW
*                        LOOP
*                     ENDIF
*                     IF VAL(Dist(dist_cntr)) > 100000
*                        WAIT 'Distance must be  100000, '+press WINDOW
*                        LOOP
*                     ENDIF
*                     dist_cntr = dist_cntr + 1
*               ENDCASE
*            ENDDO
*            cntr = 2 
*         CASE cntr = 2
*             DO EL3Keys
*             IF prev           && F9
*                RETURN
*             ENDIF                 
*             IF prcd           && F10
*                DO ScrnFSav
*                DO RunModel 
*                abort = .T.    
*             ENDIF   
*
*             EXIT                               
*      ENDCASE
*      IF LASTKEY() = 27
*         abort = .T.
*         EXIT
*      ENDIF               
*   ENDDO  
*ENDDO
*RETURN
*
******************************* ScrnF Save ********************************
*PROCEDURE scrnfsav
*
*ifp = FCREATE('SCREEN.IN')
*bytes = FPUTS(ifp,Title)
*bytes = FPUTS(ifp,source)
*bytes = FPUTS(ifp,Qm)
*bytes = FPUTS(ifp,Hs)
*bytes = FPUTS(ifp,Hr)
*bytes = FPUTS(ifp,'0')           && receptor height
*bytes = FPUTS(ifp,ru)       && rural / urban classification
*bytes = FPUTS(ifp,'y')           && building downwash
*bytes = FPUTS(ifp,Hb)
*bytes = FPUTS(ifp,Bmin)
*bytes = FPUTS(ifp,Bmax)
*bytes = FPUTS(ifp,'n')           && complex terrain
*bytes = FPUTS(ifp,'n')           && simple terrain above stack height
*bytes = FPUTS(ifp,'1')           && full meterology
*bytes = FPUTS(ifp,'y')           && automated distance array
*bytes = FPUTS(ifp,ALLTRIM(Fence)+','+'50000')
*bytes = FPUTS(ifp,Isd)
*IF Isd = 'Y'
*   FOR i = 1 TO num_dist
*      bytes = FPUTS(ifp,Dist(i))
*   NEXT i
*   bytes = FPUTS(ifp,'0')
*ENDIF
*
*EffectHs = (VAL(Hs) + 4.56E-03 * (VAL(Hr))^.478)
*IF ru = '2' .AND. EffectHs >=0
*   bytes = FPUTS(ifp,'n')
*ENDIF
*bytes = FPUTS(ifp,'n')           && Print option
*x=FCLOSE(ifp)
*IF Isd = 'Y'
*   distfile = FCREATE('DISTNUM')
*   bytes = FPUTS(distfile,STR(num_dist),',','0')
*   =FCLOSE(distfile)
*ELSE  
*   distfile = FCREATE('DISTNUM')
*   bytes = FPUTS(distfile,'0',',','0')
*   =FCLOSE(distfile)
*ENDIF
*RETURN




****************************** ScrnF x 2 ********************************
PROCEDURE scrnfx2

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SCREEN3 MODEL INPUTS - Page 2 of 7'
   @ 3, 3 SAY 'BUILDING PARAMETERS'
   @ 4, 3 SAY '      Building Height (enter 0 if no building) -> '+LEFT(Hb+SPACE(8),8) + ' m'
   @ 5, 3 SAY '         Minimum Horizontal Building Dimension -> '+LEFT(Bmin+SPACE(8),8)+' m'
   @ 6, 3 SAY '         Maximum Horizontal Building Dimension -> '+LEFT(Bmax+SPACE(8),8) +' m'
   @ 8,3 SAY 'URBAN/RURAL CLASSIFICATION'
   @ 9,3 SAY '               Enter U for Urban - R for Rural -> '+LEFT(Ruclass+' ',1)
   @ 11,3 SAY 'FENCELINE DISTANCE'
   @ 12,3 SAY ' Enter the distance from the base of the stack' 
   @ 13,3 SAY '                        to the plant fenceline -> '+LEFT(Fence+SPACE(8),8) + ' m'
   
   @ 4, 53 FILL TO 4,60 COLOR &IPColor  
   @ 5, 53 FILL TO 5,60 COLOR &IPColor 
   @ 6, 53 FILL TO 6,60 COLOR &IPColor 
   cntr = 1
   @ 9, 53 FILL TO 9,53 COLOR &IPColor  
   @ 13, 53 FILL TO 13,60 COLOR &IPColor 
   
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 1
            @ 4, 53 GET Hb PICTURE '@!' VALID Chk(Hb,2)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 1
               CASE prev  && F9            
                   RETURN                
               OTHERWISE  
                  IF VAL(Hb) = 0 
                     Bmin = '0       '  
                     Bmax = '0       ' 
                     @ 5, 53 SAY Bmin 
                     @ 6, 53 SAY Bmax 
                     @ 5, 53 FILL TO 5,60 COLOR &HLColor 
                     @ 6, 53 FILL TO 6,60 COLOR &HLColor                                                 
                     cntr = 3
                  ELSE
                     @ 5, 53 FILL TO 5,60 COLOR &IPColor 
                     @ 6, 53 FILL TO 6,60 COLOR &IPColor                                                 
                     cntr = 2
                 ENDIF                  
            ENDCASE
         CASE cntr = 2
            @ 5,53 GET Bmin PICTURE '@!' VALID Chk(Bmin,2)
            @ 6,53 GET Bmax PICTURE '@!' VALID Chk(Bmax,2)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9              
                  RETURN   
               OTHERWISE 
                  IF VAL(Bmin) > VAL(Bmax)
                     temp = Bmin
                     Bmin = Bmax
                     Bmax = temp
                     @ 5,53 SAY Bmin
                     @ 6,53 SAY Bmax
                     @ 5,53 FILL TO 5,60 COLOR &IPColor
                     @ 6,53 FILL TO 6,60 COLOR &IPColor
                  ENDIF                     
                  cntr = 3
            ENDCASE 
         CASE cntr = 3
            @ 9,53 GET Ruclass PICTURE '@!' VALID ChkRU(Ruclass)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  DO CASE
                     CASE VAL(Hb) = 0
                        cntr = 1
                     OTHERWISE
                        KEYBOARD CHR(13)
                        cntr = 2
                  ENDCASE
               CASE prev             && F9
                  RETURN   
               OTHERWISE 
                  cntr = 4
            ENDCASE             
         CASE cntr = 4
            @ 13,53 GET Fence PICTURE '@!' VALID Chk(Fence,4)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP                
                  cntr = 3               
               CASE prev             && F9
                  RETURN   
               OTHERWISE 
                  IF VAL(Fence) > 50000
                     WAIT 'Fenceline must be  50000, '+press WINDOW
                     cntr = 4
                     LOOP
                  ENDIF                  
                  cntr = 5
            ENDCASE                   
         CASE cntr = 5
            DO EL2Keys
            IF prev           && F9
                RETURN
             ENDIF                 
             IF prcd           && F10
                DO scrnfx3
             ENDIF   
             EXIT                               
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
RETURN


***************************** ScrnF x 3 *******************************
PROCEDURE scrnfx3
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 0, 3 SAY 'SCREEN3 MODEL INPUTS - Page 3 of 7'
*   @ 3, 3 SAY 'SIMPLE TERRAIN'
*   @ 2, 3 SAY '       Do you want to model terrain below stack top '
*   @ 3, 3 SAY '                        (i.e. Simple Terrain) (Y/N) -> ' + LEFT(Simple+' ',1)
   @ 2, 3 SAY 'TERRAIN TYPE'
   @ 3, 3 SAY '  Is this a FLAT or SIMPLE TERRAIN evaluation (Y/N) -> ' + LEFT(Simple+' ',1)

   @ 3, 58 FILL TO 3,58 COLOR &IPColor  

   cntr = 1   
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 1
            @ 3, 58 GET Simple PICTURE '@!' VALID ChkYN(Simple)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 1
               CASE prev  && F9            
                  RETURN                
               OTHERWISE
                  @ 4,3 CLEAR TO 19,75  
                  IF Simple = 'Y'
                     cntr = 2  
                  ELSE 
                     Zr = '0       '               
                     cntr = 7
                  ENDIF
            ENDCASE
         CASE cntr = 2
            @ 5, 3 SAY 'SIMPLE TERRAIN' 
*            @ 7, 3 SAY '    Do you want to model receptors on terrain above'
*            @ 8, 3 SAY '    stack base (i.e. Simple Elevated Terrain) (Y/N) -> '+ LEFT(Simpeltrn+' ',1)
*            @ 6, 3 SAY  '                  Is terrain above stack base (Y/N) -> '+ LEFT(Simpeltrn+' ',1)
            @ 6, 3 SAY  '               Are receptors above stack-base (Y/N) -> '+ LEFT(Simpeltrn+' ',1)
            @ 6, 58 FILL TO 6,58 COLOR &IPColor
            @ 6, 58 GET Simpeltrn PICTURE '@!' VALID ChkYN(Simpeltrn)
            READ
              DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 1
               CASE prev  && F9            
                  RETURN                
               OTHERWISE 
                  @ 7, 3 CLEAR TO 19,75                 
                  IF Simpeltrn = 'Y'
                     @ 8, 3 SAY "SIMPLE NON-FLAT TERRAIN"
                     @ 9,3 SAY ' You have terrain between stack base and stack top. '
                     cntr = 4  
                  ELSE                     
                     @ 8, 3 SAY "SIMPLE FLAT TERRAIN"
                     cntr = 3
                  ENDIF
            ENDCASE          
         CASE cntr = 3
            @ 9,3 SAY 'Do you have specific locations where you would like '
            @ 10,3 SAY '    pollutant concentrations to be calculated (Y/N) -> '+LEFT(Isd+' ',1)
            @ 10, 58 FILL TO 10,58 COLOR &IPColor
            @ 10, 58 GET Isd PICTURE '@!' VALID ChkYN(Isd)
            READ
              DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 2
               CASE prev  && F9            
                  RETURN                
               OTHERWISE 
                  @ 11, 3 CLEAR TO 19,75                                                                   
                  cntr = 4                 
            ENDCASE  
         CASE cntr = 4
            @ 12,3 SAY '           Do you have receptors above ground level'                    
            @ 13,3 SAY '                   (i.e. Flag Pole Receptors) (Y/N) -> ' +LEFT(Ragyn + ' ',1)
            @ 13,58 FILL TO 13,58 COLOR &IPColor
            @ 13, 58 GET Ragyn PICTURE '@!' VALID ChkYN(Ragyn)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP  
                  DO CASE
                     CASE Simpeltrn = 'N'
                        cntr = 3
                     OTHERWISE     
                        cntr = 2
                  ENDCASE
               CASE prev  && F9            
                  RETURN                
               OTHERWISE  
                  @ 14,3 CLEAR TO 19,75
                  IF Ragyn = 'Y'
                     cntr = 5
                  ELSE   
                     Zr = '0       '
                     IF Isd= 'Y' .OR. Simpeltrn = 'Y' 
                        cntr = 8
                     ELSE                               
                        cntr = 6
                     ENDIF    
                  ENDIF
             ENDCASE

         CASE cntr = 5    
            @ 14,3 SAY '                 Enter receptor height above ground -> '+LEFT(Zr+SPACE(8),8) + ' m'
          * @ 15,3 SAY '                   (i.e. Flag Pole Receptor Height) -> '+LEFT(Zr+SPACE(8),8) + ' m'
            @ 14,58 FILL TO 14,65 COLOR &IPColor
            @ 14, 58 GET Zr PICTURE '@!' VALID Chk(Zr,2)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP  
                  cntr = 4
                 * DO CASE
                    * CASE Simpeltrn = 'N'
                    *    cntr = 3
                    * OTHERWISE     
                    *    cntr = 2
                 * ENDCASE
               CASE prev  && F9            
                  RETURN                
               OTHERWISE  
                  @ 15,3 CLEAR TO 19,75
                  IF Isd= 'Y' .OR. Simpeltrn = 'Y' 
                     cntr = 8
                  ELSE                               
                     cntr = 6
                  ENDIF
             ENDCASE
         CASE cntr = 6
           * @ 17,3 SAY 'COMPLEX TERRAIN'
            @ 16,0 SAY '      You have completed simple terrain inputs. Do you '
            @ 17,0 SAY '           want to continue with complex terrain (Y/N) -> '+LEFT(Cmplxtrn+' ',1)
         *  @ 17,3 SAY '    Do you want to model receptors on terrain above '
         *  @ 18,3 SAY '          stack height (i.e. Complex Terrain) (Y/N) -> '+LEFT(Cmplxtrn+' ',1)            
            @ 17, 58 FILL TO 17,58 COLOR &IPColor
            @ 17,58 GET Cmplxtrn PICTURE '@!' VALID ChkYN(Cmplxtrn) 
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  IF Ragyn = 'Y'
                     cntr = 5
                  ELSE
                     cntr = 4
                  ENDIF   
               CASE prev  && F9            
                  RETURN                
               OTHERWISE 
                  *IF Cmplxtrn = 'Y'
                  *   @ 18,3 SAY 'COMPLEX TERRAIN' 
                  *   @ 19,3 SAY ' Receptors above stack height are assumed. (i. e. Complex Terrain)'               
                  *ENDIF   
                  cntr = 8
            ENDCASE              
         CASE cntr = 7
            @ 10,3 SAY 'COMPLEX TERRAIN'
            @ 11,3 SAY 'You have terrain above stack top. (i. e. Complex Terrain)'
            Cmplxtrn = 'Y'
            cntr = 8
         CASE cntr = 8
            IF Simple = 'Y' .AND. Simpeltrn = 'N' .AND. Isd = 'N' .AND. Cmplxtrn <> 'Y'
               DO EL3Keys
            ELSE
               DO EL2Keys          
            ENDIF
            IF prev           && F9
                RETURN
            ENDIF                 
            IF prcd           && F10
               IF Simple = 'Y'
                  DO CASE
                     CASE Simpeltrn = 'Y'
                        DO scrnfx4
                     CASE Isd = 'Y'
                        DO scrnfx5c
                     CASE Cmplxtrn ='Y'
                        DO scrnfx6
                     OTHERWISE                      
                        DO ScrnFSav
                        DO RunModel 
                        abort = .T.    
                  ENDCASE
               ELSE  && Cmplxtrn = 'Y'
                   DO scrnfx6
               ENDIF                                
            ENDIF                                       
            EXIT               
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
RETURN
                  
****************************** ScrnF x 4 ********************************
PROCEDURE scrnfx4

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SCREEN3 MODEL INPUTS/SIMPLE TERRAIN STAIRSTEP SEARCH - Page 4 of 7'
*   @ 2, 3 SAY 'SIMPLE ELEVATED TERRAIN'
   @ 3, 3 SAY 'Enter distance and terrain elevation for "stair-step search".'
   @ 4, 3 SAY 'Enter a blank Maximum Distance to stop input.'COLOR &ELColor
   @ 6, 3 SAY '               Distance (meters)'
   @ 7, 3 SAY '       Minimum                Maximum            Height (meters)'
   @ 8, 3 SAY '                '
   @ 9, 3 SAY '                fence'

   colmin = 10
   colmax = 33
   colht = 55
    
   @ 8+1, colmin SAY LEFT(Fence+SPACE(8),8)   
   @ 8+1, colmax SAY LEFT(Hterdist(1)+SPACE(8),8)   
   @ 8+1, colht SAY LEFT(Hter(1) + SPACE(8),8)
   FOR i = 2 TO 10
      IF LEN(ALLTRIM(Hterdist(i))) <> 0
         @ 8+i, colmin SAY LEFT(Hterdist(i-1) + SPACE(8),8)        
      ENDIF
      @ 8+i, colmax SAY LEFT(Hterdist(i) + SPACE(8),8)        
      @ 8+i, colht SAY LEFT(Hter(i) + SPACE(8),8)        
   NEXT i
        
   @ 9,colmax FILL TO 18,colmax+7 COLOR &IPColor
   @ 9,colht FILL TO 18,colht+7 COLOR &IPColor
   cntr = 1
   hdistcntr = 1
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 1 
            IF hdistcntr > 1
               @ 8+hdistcntr, colmin SAY Hterdist(hdistcntr-1)  
            ENDIF             
            @ 8+hdistcntr, colmax GET Hterdist(hdistcntr) PICTURE '@!' VALID Chk(Hterdist(hdistcntr),-3)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP 
                  IF hdistcntr > 1             
                     hdistcntr = hdistcntr -1                      
                  ENDIF                 
               CASE LASTKEY() = 19
                  IF hdistcntr > 1 
                     hdistcntr = hdistcntr - 1
                     cntr = 2
                  ENDIF  
               CASE prev  && F9            
                  RETURN                
               OTHERWISE 
                  IF LEN(ALLTRIM(Hterdist(hdistcntr))) = 0  
                     IF hdistcntr = 10
                        IF  LEN(ALLTRIM(Hter(hdistcntr))) > 0
                           WAIT 'Enter a DISTANCE, '+press WINDOW
                           LOOP
                        ELSE
                           num_eltrn = hdistcntr - 1                                                                                                            
                           cntr = 3
                           LOOP
                        ENDIF   
                     ENDIF      
                     IF LEN(ALLTRIM(Hterdist(hdistcntr+1))) > 0 .OR. hdistcntr = 1;
                      .OR. LEN(ALLTRIM(Hter(hdistcntr))) > 0
                        WAIT 'Enter a DISTANCE, '+press WINDOW
                        LOOP
                     ELSE
                        num_eltrn = hdistcntr - 1                                                                                                            
                        cntr = 3
                        LOOP
                     ENDIF
                  ENDIF
                  IF VAL(Hterdist(hdistcntr)) > 50000
                     WAIT 'Distance must be  50000 m, '+press WINDOW
                     LOOP
                  ENDIF                     
                  IF hdistcntr = 1
                     IF VAL(Hterdist(hdistcntr)) <= VAL(Fence)
                        WAIT 'Distance must be > '+ALLTRIM(Fence) +' m fenceline distance, '+press WINDOW
                        LOOP
                     ENDIF
                  ELSE
                     IF VAL(Hterdist(hdistcntr)) <= VAL(Hterdist(hdistcntr-1))
                        WAIT 'Maximum Distance must be > previous Maximum Distance, '+press WINDOW
                        LOOP
                     ENDIF
                  ENDIF                  
                  cntr = 2
            ENDCASE       
         CASE cntr = 2           
            @ 8+hdistcntr, colht GET Hter(hdistcntr) PICTURE '@!' VALID Chk(hter(hdistcntr),-1)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP 
                  IF hdistcntr >= 2             
                     hdistcntr = hdistcntr -1 
                  ENDIF 
               CASE LASTKEY() = 19 
                  cntr = 1                            
               CASE prev  && F9            
                  RETURN                
               OTHERWISE   
                  IF LEN(ALLTRIM(Hter(hdistcntr))) = 0
                     WAIT 'Enter a HEIGHT, '+press WINDOW
                     LOOP
                  ENDIF  
                  *IF VAL(Hter(hdistcntr)) > VAL(Hs)
                  IF VAL(Hter(hdistcntr)) > VAL(Hs1)
                     *WAIT 'Height must be  '+ALLTRIM(Hs)+' m Stack Height, '+press WINDOW
                     WAIT 'Height must be  '+ALLTRIM(Hs1)+' m Effective Stack Height, '+press WINDOW
                     LOOP
                  ENDIF 
                                        
                  IF hdistcntr > 1
                     IF VAL(Hter(hdistcntr)) <= VAL(Hter(hdistcntr-1)) 
                        WAIT 'Height must be > previous height, '+press WINDOW
                        LOOP
                     ENDIF
                  ENDIF
                  hdistcntr = hdistcntr + 1
                  IF hdistcntr = 11 .OR. VAL(Hterdist(hdistcntr-1)) = 50000
                     num_eltrn = hdistcntr - 1                                                                                                            
                     cntr = 3
                     LOOP
                  ENDIF                                           
                  cntr = 1                  
            ENDCASE           
         CASE cntr = 3
            DEFINE WINDOW question FROM 10,10 TO 15,70 SHADOW COLOR &MesColor
            ACTIVATE WINDOW question  
            @ 2,57 FILL TO 2,57 COLOR &IPColor
            @ 0,0 SAY 'DISCRETE RECEPTORS'
            @ 1,0 SAY '  Do you have specific locations where you would like '  
            @ 2,0 SAY '      pollutant concentrations to be calculated (Y/N) -> '+LEFT(Isd+' ',1)
            @ 2,57 GET Isd PICTURE '@!' VALID ChkYN(Isd)
            READ
            RELEASE WINDOW question                  
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 1
               CASE prev  && F9            
                  RETURN                
               OTHERWISE 
                  IF Isd = 'N'
                     cntr = 4
                  ELSE
                     cntr = 5
                  ENDIF
            ENDCASE                   
         CASE cntr = 4
            DEFINE WINDOW question FROM 10,10 TO 15,70 SHADOW COLOR &MesColor
            ACTIVATE WINDOW question  
            @ 2,57 FILL TO 2,57 COLOR &IPColor
         *   @ 0,0 SAY 'COMPLEX TERRAIN'
         *   @ 1,0 SAY '    Do you want to model receptors located on terrain '  
         *   @ 2,0 SAY '      above stack height (i.e. Complex Terrain) (Y/N) -> '+LEFT(Cmplxtrn+' ',1)
            @ 1,0 SAY 'You have completed simple terrain inputs. Do you want'
            @ 2,0 SAY '               to continue with complex terrain (Y/N) -> '+LEFT(Cmplxtrn+' ',1)
            @ 2,57 GET Cmplxtrn PICTURE '@!' VALID ChkYN(Cmplxtrn)
            READ
            RELEASE WINDOW question                  
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 3
               CASE prev  && F9            
                  RETURN                
               OTHERWISE 
                  cntr = 5
            ENDCASE                   
         CASE cntr = 5
            IF VAL(Hterdist(num_eltrn)) < 50000  
               @ 19,3 SAY 'Last Maximum Distance will be extended to 50000 m'
               Hterdist(num_eltrn) = '50000   '
            ENDIF
            IF Isd = 'Y' .OR. Cmplxtrn = 'Y'
               DO EL2Keys
            ELSE
               DO EL3Keys
            ENDIF
            IF prev           && F9
               RETURN
            ENDIF
            IF prcd           && F10
               DO CASE
                  CASE Isd = 'Y'
                     DO scrnfx5a
                  CASE Cmplxtrn = 'Y'
                     DO scrnfx6
                  OTHERWISE
                     DO ScrnFSav
                     DO RunModel
                     abort = .T.
               ENDCASE
            ENDIF
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
RETURN

****************************** ScrnF x 5a ************************************
PROCEDURE scrnfx5a

IF LEN(ALLTRIM(Dhter(1))) = 0 .AND. LEN(ALLTRIM(Dist(1))) > 0
   FOR i = 1 TO 50
      Dist(i) = SPACE(8)
   NEXT i 
ENDIF   
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SCREEN3 MODEL INPUTS DISCRETE RECEPTORS - Page 5 of 7'
*   @ 3, 3 SAY 'DISCRETE RECEPTORS WITH ELEVATED TERRAIN'
   @ 4, 3 SAY 'Enter a height and distance(s) from the source to terrain feature(s)'
   @ 5, 3 SAY 'at which a specific receptor will be located.'
   @ 6, 3 SAY 'Enter a blank after the distance to stop inputs for that height.  ' COLOR &ELColor  
   @ 7, 3 SAY 'Enter a blank height to stop input.'COLOR &ELColor  

   @ 10, 1 SAY 'Height (m)      Height (m)      Height (m)      Height (m)      Height (m)'

   col1 = 2 
   col2 = 18
   col3 = 34
   col4 = 50
   col5 = 66
   row_ht = 11
   row_dist = 13
   @ row_dist,0 SAY 'Distances (m)   Distances (m)   Distances (m)   Distances (m)   Distances (m)'   

   FOR i = 1 TO 5
      col_hold = 'col'+ALLTRIM(STR(i))
      @ row_ht, &col_hold SAY Dhter(i)
      @ row_ht, &col_hold FILL TO row_ht,&col_hold+7 COLOR &IPColor
      FOR j = 1 TO 5
         row = row_dist + j
         @ row ,&col_hold SAY Dist(5*(i-1) + j)
         @ row ,&col_hold FILL TO row ,&col_hold+7 COLOR &IPColor
      NEXT j
   NEXT i

   cntr = 1
   dist_cntr = 1
   ht_cntr = 1
   
   DO WHILE .NOT. abort
      col_hold = 'col'+ALLTRIM(STR(ht_cntr))
      DO CASE 
         CASE cntr = 1
            @ row_ht, &col_hold GET Dhter(ht_cntr) PICTURE '@!' VALID Chk(Dhter(ht_cntr),-3)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP 
                  IF ht_cntr > 1             
                     ht_cntr = ht_cntr -1  
                     dist_cntr = ht_cntr * 5
                     DO WHILE .T.
                        IF LEN(ALLTRIM(Dist(dist_cntr))) = 0
                           dist_cntr = dist_cntr - 1
                        ELSE
                           EXIT
                        ENDIF
                     ENDDO
                     cntr = 2
                     LOOP                    
                  ENDIF                 
               CASE LASTKEY() = 19   && UP 
                  IF ht_cntr > 1             
                     ht_cntr = ht_cntr -1  
                     dist_cntr = ht_cntr * 5
                     DO WHILE .T.
                        IF LEN(ALLTRIM(Dist(dist_cntr))) = 0
                           dist_cntr = dist_cntr - 1
                        ELSE
                           EXIT
                        ENDIF
                     ENDDO
                     cntr = 2
                     LOOP                    
                  ENDIF                 
               CASE prev  && F9            
                  RETURN                
               OTHERWISE                      
                  IF LEN(ALLTRIM(Dhter(1))) = 0
                     WAIT 'Enter a HEIGHT, '+ press WINDOW
                     LOOP
                  ENDIF
                  IF LEN(ALLTRIM(Dhter(ht_cntr))) = 0
                     IF ht_cntr = 5
                        IF LEN(ALLTRIM(Dist(ht_cntr*5-4))) > 0 
                           WAIT 'Enter a HEIGHT, '+press WINDOW
                           LOOP
                        ELSE                                                                                                                                   
                           cntr = 3
                           LOOP
                        ENDIF                   
                     ENDIF                   
                     IF LEN(ALLTRIM(Dhter(ht_cntr+1))) > 0 ;
                      .OR. LEN(ALLTRIM(Dist(ht_cntr*5-4))) > 0 
                        WAIT 'Enter a HEIGHT, '+press WINDOW
                        LOOP
                     ELSE                                                                                                                                   
                        cntr = 3
                        LOOP
                     ENDIF                     
                  ENDIF                   
                  dist_cntr = ht_cntr * 5 - 4 
                  *IF VAL(Dhter(ht_cntr)) > VAL(Hs)
                  IF VAL(Dhter(ht_cntr)) > VAL(Hs1)
                    * WAIT 'Height must be  '+ALLTRIM(Hs)+' m Stack Height, '+press WINDOW
                     WAIT 'Height must be  '+ALLTRIM(Hs1)+' m Effective Stack Height, '+press WINDOW
                     LOOP
                  ENDIF                                         
                  cntr = 2  
            ENDCASE       
         CASE cntr = 2   
            row = IIF(MOD(dist_cntr,5)>0,row_dist+MOD(dist_cntr,5),row_dist+5)         
            @ row, &col_hold GET Dist(dist_cntr) PICTURE '@!' VALID Chk(Dist(dist_cntr),-1)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP 
                  dist_cntr = dist_cntr -1 
                  IF MOD(dist_cntr,5) = 0                                  
                     cntr = 1 
                  ENDIF 
               CASE LASTKEY() = 19   && UP 
                  dist_cntr = dist_cntr -1 
                  IF MOD(dist_cntr,5) = 0                                  
                     cntr = 1 
                  ENDIF 
               CASE prev  && F9            
                  RETURN                
               OTHERWISE
                  IF LEN(ALLTRIM(Dist(dist_cntr))) = 0
                     IF dist_cntr <> 25                     
                        IF MOD(dist_cntr,5) = 1;
                         .OR. (LEN(ALLTRIM(Dist(dist_cntr+1))) <> 0 .AND. MOD(dist_cntr,5) <> 0)
                           WAIT 'Enter a DISTANCE, '+press WINDOW
                           LOOP
                        ENDIF
                     ENDIF   
                  ENDIF
                  IF LEN(ALLTRIM(Dist(dist_cntr))) = 0 .OR. MOD(dist_cntr,5) = 0                     
                     ht_cntr = ht_cntr + 1
                     IF MOD(ht_cntr,5) = 1                        
                        cntr = 3
                     ELSE                                            
                        cntr = 1
                     ENDIF
                     LOOP
                  ENDIF                               
                  IF VAL(Dist(dist_cntr)) > 100000
                     WAIT 'Distance must be  100000 m, '+press WINDOW
                     LOOP
                  ENDIF                     
                  IF VAL(Dist(dist_cntr)) < VAL(Fence)
                     WAIT 'Distance must be  '+ALLTRIM(Fence) +' m fenceline distance, '+press WINDOW
                     LOOP
                  ENDIF   
                  dist_cntr = dist_cntr + 1 
                  IF dist_cntr = 26                                                                                                                           
                     cntr = 3
                     LOOP
                  ENDIF                                                                            
                  cntr = 2
            ENDCASE   
         CASE cntr = 3
            IF LEN(ALLTRIM(Dist(26))) > 0
               proc = 'Y'
            ELSE
               proc = 'N'
            ENDIF
            num_dist = dist_cntr - 1
            num_ht = ht_cntr - 1                                
            IF num_ht = 5
               DEFINE WINDOW question FROM 10,10 TO 14,70 SHADOW COLOR &MesColor
               ACTIVATE WINDOW question  
               @ 1,54 FILL TO 1,54 COLOR &IPColor
               @ 1,0 SAY '   Do you want to enter additional distances (Y/N) -> '+LEFT(proc+' ',1)
               @ 1,54 GET proc PICTURE '@!' VALID ChkYN(proc)
               READ
               RELEASE WINDOW question                  
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT
                  CASE LASTKEY() = 5   && UP    
                     dist_cntr = num_dist
                     ht_cntr = num_ht                                       
                     cntr = 2
                  CASE prev  && F9            
                     RETURN                
                  OTHERWISE 
                     IF proc = 'Y'
                        cntr = 5
                     ELSE
                        cntr = 4
                     ENDIF
               ENDCASE                        
            ELSE 
               cntr = 4
            ENDIF
         CASE cntr = 4
            DEFINE WINDOW question FROM 10,10 TO 15,70 SHADOW COLOR &MesColor
            ACTIVATE WINDOW question  
            @ 2,57 FILL TO 2,57 COLOR &IPColor
            @ 1,0 SAY 'You have completed simple terrain inputs. Do you want'
            @ 2,0 SAY '               to continue with complex terrain (Y/N) -> '+LEFT(Cmplxtrn+' ',1)
            @ 2,57 GET Cmplxtrn PICTURE '@!' VALID ChkYN(Cmplxtrn)
            READ
            RELEASE WINDOW question                  
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 3
               CASE prev  && F9            
                  RETURN                
               OTHERWISE 
                  cntr = 5
            ENDCASE                                       
         CASE cntr = 5
           * num_dist = dist_cntr - 1
           * num_ht = ht_cntr - 1            
            IF Cmplxtrn = 'Y' .OR. proc = 'Y'
               DO EL2Keys
            ELSE
               DO EL3Keys
            ENDIF
            IF prev           && F9
               RETURN
            ENDIF
            IF prcd           && F10
               DO CASE
                  CASE proc = 'Y'
                     DO scrnfx5b
                  CASE Cmplxtrn = 'Y'
                     DO scrnfx6
                  OTHERWISE
                     DO ScrnFSav
                     DO RunModel
                     abort = .T.
               ENDCASE
            ENDIF
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO           
RETURN   

****************************** ScrnF x 5b ************************************
PROCEDURE scrnfx5b

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SCREEN3 MODEL INPUTS DISCRETE RECEPTORS - Page 6 of 7'
*   @ 3, 3 SAY 'DISCRETE RECEPTORS WITH ELEVATED TERRAIN'
   @ 4, 3 SAY 'Enter a height and distance(s) from the source to terrain feature(s)'
   @ 5, 3 SAY 'at which a specific receptor will be located.'
   @ 6, 3 SAY 'Enter a blank after the distance to stop inputs for that height.  ' COLOR &ELColor  
   @ 7, 3 SAY 'Enter a blank height to stop input.'COLOR &ELColor  

   @ 10, 1 SAY 'Height (m)      Height (m)      Height (m)      Height (m)      Height (m)'

   col1 = 2 
   col2 = 18
   col3 = 34
   col4 = 50
   col5 = 66
   row_ht = 11
   row_dist = 13
   @ row_dist,0 SAY 'Distances (m)   Distances (m)   Distances (m)   Distances (m)   Distances (m)'   

   FOR i = 6 TO 10
      col_hold = 'col'+ALLTRIM(STR(i-5))
      @ row_ht, &col_hold SAY Dhter(i)
      @ row_ht, &col_hold FILL TO row_ht,&col_hold+7 COLOR &IPColor
      FOR j = 1 TO 5
         row = row_dist + j 
         @ row ,&col_hold SAY Dist(5*(i-1) + j)
         @ row ,&col_hold FILL TO row ,&col_hold+7 COLOR &IPColor
      NEXT j
   NEXT i

   cntr = 1
   dist_cntr = 26
   ht_cntr = 6
   
   DO WHILE .NOT. abort
      col_hold = 'col'+ALLTRIM(STR(ht_cntr-5))
      DO CASE 
         CASE cntr = 1
            @ row_ht, &col_hold GET Dhter(ht_cntr) PICTURE '@!' VALID Chk(Dhter(ht_cntr),-3)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP 
                  IF ht_cntr > 1             
                     ht_cntr = ht_cntr -1  
                     dist_cntr = ht_cntr * 5
                     cntr = 2
                     LOOP                    
                  ENDIF                 
               CASE LASTKEY() = 19   && UP 
                  IF ht_cntr > 1             
                     ht_cntr = ht_cntr -1  
                     dist_cntr = ht_cntr * 5
                     cntr = 2
                     LOOP                    
                  ENDIF                 
               CASE prev  && F9            
                  RETURN                
               OTHERWISE                      
                  IF LEN(ALLTRIM(Dhter(1))) = 0
                     WAIT 'Enter a HEIGHT, '+ press WINDOW
                     LOOP
                  ENDIF
                  IF LEN(ALLTRIM(Dhter(ht_cntr))) = 0
                     IF ht_cntr = 10
                        IF LEN(ALLTRIM(Dist(ht_cntr*5-4))) > 0 
                           WAIT 'Enter a HEIGHT, '+press WINDOW
                           LOOP
                        ELSE                                                                                                                                   
                           cntr = 3
                           LOOP
                        ENDIF                   
                     ENDIF
                     IF LEN(ALLTRIM(Dhter(ht_cntr+1))) > 0 ;
                      .OR. LEN(ALLTRIM(Dist(ht_cntr*5-4))) > 0 
                        WAIT 'Enter a HEIGHT, '+press WINDOW
                        LOOP
                     ELSE                                                                                                                                   
                        cntr = 3
                        LOOP
                     ENDIF                     
                  ENDIF                   
                  dist_cntr = ht_cntr * 5 - 4 
                  *IF VAL(Dhter(ht_cntr)) > VAL(Hs)
                  IF VAL(Dhter(ht_cntr)) > VAL(Hs1)
                     *WAIT 'Height must be  '+ALLTRIM(Hs)+' m Stack Height, '+press WINDOW
                     WAIT 'Height must be  '+ALLTRIM(Hs1)+' m Stack Height, '+press WINDOW
                     LOOP
                  ENDIF                                         
                  cntr = 2  
            ENDCASE       
         CASE cntr = 2   
            row = IIF(MOD(dist_cntr,5)>0,row_dist+MOD(dist_cntr,5),row_dist+5)         
            @ row, &col_hold GET Dist(dist_cntr) PICTURE '@!' VALID Chk(Dist(dist_cntr),-1)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP 
                  dist_cntr = dist_cntr -1 
                  IF MOD(dist_cntr,5) = 0                                  
                     cntr = 1 
                  ENDIF 
               CASE LASTKEY() = 19   && UP 
                  dist_cntr = dist_cntr -1 
                  IF MOD(dist_cntr,5) = 0                                  
                     cntr = 1 
                  ENDIF 
               CASE prev  && F9            
                  RETURN                
               OTHERWISE
                  IF LEN(ALLTRIM(Dist(dist_cntr))) = 0
                     IF dist_cntr < 50                      
                        IF MOD(dist_cntr,5) = 1;
                         .OR. (LEN(ALLTRIM(Dist(dist_cntr+1))) <> 0 .AND. MOD(dist_cntr,5) <> 0)
                           WAIT 'Enter a DISTANCE, '+press WINDOW
                           LOOP
                        ENDIF
                     ENDIF   
                  ENDIF
                  IF LEN(ALLTRIM(Dist(dist_cntr))) = 0 .OR. MOD(dist_cntr,5) = 0                     
                     ht_cntr = ht_cntr + 1
                     IF MOD(ht_cntr,5) = 1                        
                        cntr = 3
                     ELSE                                            
                        cntr = 1
                     ENDIF
                     LOOP
                  ENDIF                               
                  IF VAL(Dist(dist_cntr)) > 100000
                     WAIT 'Distance must be  100000 m, '+press WINDOW
                     LOOP
                  ENDIF                     
                  IF VAL(Dist(dist_cntr)) <= VAL(Fence)
                     WAIT 'Distance must be > '+ALLTRIM(Fence) +' m fenceline distance, '+press WINDOW
                     LOOP
                  ENDIF   
                  dist_cntr = dist_cntr + 1 
                  IF dist_cntr = 26                                                                                                                           
                     cntr = 3
                     LOOP
                  ENDIF                                                                            
                  cntr = 2
            ENDCASE 
         CASE cntr = 3  
            DEFINE WINDOW question FROM 10,10 TO 15,70 SHADOW COLOR &MesColor
            ACTIVATE WINDOW question  
            @ 2,57 FILL TO 2,57 COLOR &IPColor
            @ 1,0 SAY 'You have completed simple terrain inputs. Do you want'
            @ 2,0 SAY '               to continue with complex terrain (Y/N) -> '+LEFT(Cmplxtrn+' ',1)
            @ 2,57 GET Cmplxtrn PICTURE '@!' VALID ChkYN(Cmplxtrn)
            READ
            RELEASE WINDOW question                  
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 1
               CASE prev  && F9            
                  RETURN                
               OTHERWISE 
                  cntr = 4
            ENDCASE                                                           
         CASE cntr = 4
            num_dist = dist_cntr - 1
            num_ht = ht_cntr - 1            
            IF Cmplxtrn = 'Y'
               DO EL2Keys
            ELSE
               DO EL3Keys
            ENDIF
            IF prev           && F9
               RETURN
            ENDIF
            IF prcd           && F10
               DO CASE
                  CASE Cmplxtrn = 'Y'
                     DO scrnfx6
                  OTHERWISE
                     DO ScrnFSav
                     DO RunModel
                     abort = .T.
               ENDCASE
            ENDIF
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO           
RETURN   

****************************** ScrnF x 5c ********************************
PROCEDURE scrnfx5c

Dist(1) = Fence
IF LEN(ALLTRIM(Dhter(1))) > 0
   FOR i = 1 TO 10
      Dhter(i) = SPACE(8)
   NEXT i
   FOR i = 2 TO 30 
      Dist(i) = SPACE(8)
   NEXT i
ENDIF
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SCREEN3 MODEL INPUTS - Page 5 of 6'
   @ 2, 3 SAY 'RECEPTOR LOCATIONS:  Enter (up to 30) distances from'
   @ 3, 3 SAY 'the source at which concentrations should be calculated.'
   @ 4, 3 SAY 'Enter a blank after the last distance to stop input.' COLOR &ELColor  
   @ 6, 3 SAY '   Distance from          Distance from          Distance from'
   @ 7, 3 SAY '  source (meters)        source (meters)        source (meters)'
   @ 8, 3 SAY '                '
   @ 9, 3 SAY '    1          fence      11                     21'
   @ 10,3 SAY '    2                     12                     22'
   @ 11,3 SAY '    3                     13                     23'
   @ 12,3 SAY '    4                     14                     24'
   @ 13,3 SAY '    5                     15                     25'
   @ 14,3 SAY '    6                     16                     26'
   @ 15,3 SAY '    7                     17                     27'
   @ 16,3 SAY '    8                     18                     28'
   @ 17,3 SAY '    9                     19                     29'
   @ 18,3 SAY '   10                     20                     30'
   
   FOR i = 0 TO 2
      FOR j = 1 TO 10
         DO CASE
            CASE i = 0
               col = 9
            CASE i = 1
               col = 32
            CASE i = 2
               col = 55
         ENDCASE
         @ 8+j, col SAY LEFT(Dist((10*i)+j)+SPACE(8),8)
      NEXT j
   NEXT i
   @ 10,9 FILL TO 18,16 COLOR &IPColor
   @ 9,32 FILL TO 18,39 COLOR &IPColor
   @ 9,55 FILL TO 18,62 COLOR &IPColor
   cntr = 1
   dist_cntr = 2
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 1
            DO WHILE dist_cntr <= 30               
               IF dist_cntr <=10 
                  row = 8+dist_cntr
                  col = 9
               ELSE
                  IF dist_cntr <= 20 
                     row = 8+(dist_cntr-10)
                     col = 32
                  ELSE
                     row = 8+(dist_cntr-20)
                     col = 55
                  ENDIF
               ENDIF
            
               @ row, col GET Dist(dist_cntr) PICTURE '@!' VALID Chk(Dist(dist_cntr),-1)
               READ
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT
                  CASE LASTKEY() = 5   && UP 
                     IF dist_cntr > 2   
                        dist_cntr = dist_cntr -1
                     ENDIF
                  CASE prev  && F9            
                     RETURN                
                  OTHERWISE                       
                     IF LEN(ALLTRIM(Dist(dist_cntr))) = 0  
                        IF dist_cntr = 30
                           *num_dist = dist_cntr - 1
                           EXIT
                        ENDIF                        
                        IF LEN(ALLTRIM(Dist(dist_cntr+1))) > 0
                           WAIT 'Enter a DISTANCE, '+press WINDOW
                           LOOP
                        ELSE
                           *num_dist = dist_cntr - 1
                           EXIT
                        ENDIF
                     ENDIF
                     IF VAL(Dist(dist_cntr)) <= VAL(Dist(dist_cntr-1))
                        WAIT 'Distance must be > previous distance, '+press WINDOW
                        LOOP
                     ENDIF
                     IF VAL(Dist(dist_cntr)) > 100000
                        WAIT 'Distance must be  100000, '+press WINDOW
                        LOOP
                     ENDIF
                     dist_cntr = dist_cntr + 1
               ENDCASE
            ENDDO
            num_dist = dist_cntr - 1
            cntr = 2 
         CASE cntr = 2
            DEFINE WINDOW question FROM 10,10 TO 15,70 SHADOW COLOR &MesColor
            ACTIVATE WINDOW question  
            @ 2,57 FILL TO 2,57 COLOR &IPColor
*            @ 0,0 SAY 'COMPLEX TERRAIN'
*            @ 1,0 SAY '    Do you want to model receptors located on terrain '  
*            @ 2,0 SAY '      above stack height (i.e. Complex Terrain) (Y/N) -> '+LEFT(Cmplxtrn+' ',1)
            @ 1,0 SAY 'You have completed simple terrain inputs. Do you want'
            @ 2,0 SAY '               to continue with complex terrain (Y/N) -> '+LEFT(Cmplxtrn+' ',1)
            @ 2,57 GET Cmplxtrn PICTURE '@!' VALID ChkYN(Cmplxtrn)
            READ
            RELEASE WINDOW question                  
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 1
               CASE prev  && F9            
                  RETURN                
               OTHERWISE 
                  cntr = 3
            ENDCASE                                                   
         CASE cntr = 3
            IF Cmplxtrn = 'Y'
               DO EL2Keys
            ELSE
               DO EL3Keys
            ENDIF
            IF prev           && F9
               RETURN
            ENDIF
            IF prcd           && F10
               num_dist = dist_cntr - 1
               DO CASE
                  CASE Cmplxtrn = 'Y'
                     DO scrnfx6
                  OTHERWISE                  
                     DO ScrnFSav
                     DO RunModel
                     abort = .T.
               ENDCASE
            ENDIF
            EXIT
      ENDCASE         
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
RETURN

****************************** ScrnF x 6 ********************************
PROCEDURE scrnfx6

*+++++++ plume calculations +++++

Exitv = '20.0'
Ts = '1273.'
Ta = '293.'
D = convert(9.88E-04*(0.45*VAL(Hr))**0.5)
IF (VAL(D) < 1E-05)
   D=convert(1.0E-05)
ENDIF   
*Hs1 = convert(VAL(Hs) + 4.56E-03 * VAL(Hr)**0.478)

IF Ruclass = 'U'
   dtdz = .02
ELSE
   dtdz = .035
ENDIF

Us = 2.5
g = 9.806

s = g * dtdz/VAL(Ta)

DeltaTc = .019582 * VAL(Ts) * VAL(Exitv) * SQRT(s)
DeltaT = VAL(Ts)-VAL(Ta)

dist_plm_rise = ALLTRIM(STR(0.0020715 * 2.5/SQRT(s) * 1000,8,1)) && equation from SCREEN
IF VAL(Exitv) < 1.5*Us
   HsPrime = VAL(Hs1) + 2*VAL(D)*(VAL(Exitv)/Us - 1.5)
ELSE
   HsPrime = VAL(Hs1)
ENDIF

IF DeltaT > DeltaTc
   IF VAL(Ta) > VAL(Ts)
      Fb = 0.0
   ELSE
      Fb = g * VAL(Exitv) * VAL(D)^2 * ( DeltaT/(4*VAL(Ts)) )
   ENDIF
   plume_ht = HsPrime + 2.6*(Fb/(Us*s))^(1/3)
ELSE   
   Fm = (VAL(Exitv))^2 * (VAL(D))^2 * ( VAL(Ta)/(4*VAL(Ts)) )
   
   PlumeH1 = HsPrime + 1.5 * ( Fm/(Us * SQRT(s)) )^(1/3)
   PlumeH2 = HsPrime + 3 * VAL(D) * (VAL(Exitv)/Us)
   IF PlumeH1 > PlumeH2
      plume_ht = PlumeH2
   ELSE
      plume_ht = PlumeH1
   ENDIF
ENDIF

plume_ht = ALLTRIM(STR(plume_ht,8,1))

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 0, 3 SAY 'SCREEN3 MODEL INPUTS COMPLEX TERRAIN - Page 7 of 7'
*   @ 1, 3 SAY 'COMPLEX TERRAIN'
   @ 1, 3 SAY 'Enter height and distance for receptor location.'
   @ 2, 3 SAY 'Enter a blank Distance to stop input.' COLOR &ELColor
*   @ 3, 31 TO 6,75 COLOR &ELColor
*   @ 4, 33 SAY '                Plume Height -> '+plume_ht + ' m'
*   @ 5, 33 SAY 'Distance to Final Plume Rise -> '+dist_plm_rise + ' m'
   @ 3, 7 TO 6,75 COLOR &ELColor
   @ 4, 9 SAY 'Effective Release Height -> '+ ALLTRIM(STR(VAL(Hs1),8,2))+' m    Plume Height -> '+plume_ht + ' m'
   @ 5, 32 SAY 'Distance to Final Plume Rise -> '+dist_plm_rise + ' m'
   @ 7, 7 SAY '  Height (m)  Distance (m)           Height (m)   Distance (m) '
   @ 8, 7 SAY '                 '
   @ 9, 7 SAY ' 1                                  11'
   @ 10,7 SAY ' 2                                  12'
   @ 11,7 SAY ' 3                                  13'
   @ 12,7 SAY ' 4                                  14'
   @ 13,7 SAY ' 5                                  15'
   @ 14,7 SAY ' 6                                  16'
   @ 15,7 SAY ' 7                                  17'
   @ 16,7 SAY ' 8                                  18'
   @ 17,7 SAY ' 9                                  19'
   @ 18,7 SAY '10                                  20'
   
*   colht1 = 3
*   colht2 = 30
   colht1 = 10
   colht2 = 46
   
*   coldist1 = 13
*   coldist2 = 42
   coldist1 = 22
   coldist2 = 58
   
   FOR i = 0 TO 1
      FOR j = 1 TO 10
         DO CASE
            CASE i = 0
               colht = colht1
               coldist = coldist1
            CASE i = 1
               colht = colht2
               coldist = coldist2
         ENDCASE
         @ 8+j, colht SAY LEFT(Chter((10*i)+j)+SPACE(8),8)
         @ 8+j, coldist SAY LEFT(Cx((10*i)+j)+SPACE(8),8)
      NEXT j
   NEXT i
   @ 9,colht1 FILL TO 18,colht1+7 COLOR &IPColor
   @ 9,coldist1 FILL TO 18,coldist1+7 COLOR &IPColor
   @ 9,colht2 FILL TO 18,colht2+7 COLOR &IPColor
   @ 9,coldist2 FILL TO 18,coldist2+7 COLOR &IPColor

   cntr = 1
   cdistcntr = 1
   
   DO WHILE .NOT. abort
      DO CASE
         CASE cdistcntr < 11 
            colht = colht1
            coldist = coldist1
         CASE cdistcntr >= 11 .AND. cdistcntr < 21 
            colht = colht2
            coldist = coldist2
      ENDCASE   
      DO CASE 
         CASE cntr = 1
            row = IIF(MOD(cdistcntr,10)>0,8+MOD(cdistcntr,10),18) 
            @ row, colht GET Chter(cdistcntr) PICTURE '@!' VALID Chk(Chter(cdistcntr),-3)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP 
                  IF cdistcntr > 1             
                     cdistcntr = cdistcntr -1                      
                  ENDIF                 
               CASE LASTKEY() = 19
                  IF cdistcntr > 1 
                     cdistcntr = cdistcntr - 1
                     cntr = 2
                  ENDIF  
               CASE prev  && F9            
                  RETURN                
               OTHERWISE  
                  IF LEN(ALLTRIM(Chter(1))) = 0                 
                     WAIT 'Enter a HEIGHT, '+press WINDOW
                     LOOP
                  ENDIF   
                  IF LEN(ALLTRIM(Chter(cdistcntr))) = 0
                     IF cdistcntr = 20
                        IF LEN(ALLTRIM(Cx(cdistcntr))) > 0 
                           WAIT 'Enter a HEIGHT, '+press WINDOW
                           LOOP
                        ELSE
                           num_cmplx = cdistcntr - 1                                                                                                            
                           cntr = 3
                           LOOP
                        ENDIF                     
                     ENDIF                                          
                     IF LEN(ALLTRIM(Chter(cdistcntr+1))) > 0 ;
                      .OR. LEN(ALLTRIM(Cx(cdistcntr))) > 0 
                        WAIT 'Enter a HEIGHT, '+press WINDOW
                        LOOP
                     ELSE
                        num_cmplx = cdistcntr - 1                                                                                                            
                        cntr = 3
                        LOOP
                     ENDIF                     
                  ENDIF                   
                  IF VAL(Chter(cdistcntr)) > 9999
                     WAIT 'Height must be  9999 m, '+press WINDOW
                     LOOP
                  ENDIF                                         

                  IF VAL(Chter(cdistcntr)) <= VAL(Hs1)
                     WAIT 'Height must be > '+ALLTRIM(STR(VAL(Hs1),8,2))+' m Effective Release Height, Press any key...' WINDOW
                     LOOP
                  ENDIF
                  
*                  IF VAL(Chter(cdistcntr)) <= VAL(Hs)
*                     WAIT 'Height must be > '+ALLTRIM(Hs)+' m Stack Height, '+press WINDOW
*                     LOOP
*                  ENDIF
*                  IF cdistcntr > 1
*                     IF VAL(Chter(cdistcntr)) < VAL(Chter(cdistcntr-1)) 
*                        WAIT 'Height must be  previous height, '+press WINDOW
*                        LOOP
*                     ENDIF
*                  ENDIF
                  cntr = 2  
            ENDCASE       
         CASE cntr = 2   
            row = IIF(MOD(cdistcntr,10)>0,8+MOD(cdistcntr,10),18)         
            @ row, coldist GET Cx(cdistcntr) PICTURE '@!' VALID Chk(Cx(cdistcntr),-1)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP 
                  IF cdistcntr >= 2             
                     cdistcntr = cdistcntr -1 
                  ENDIF 
               CASE LASTKEY() = 19 
                  cntr = 1                            
               CASE prev  && F9            
                  RETURN                
               OTHERWISE                  
                  IF LEN(ALLTRIM(Cx(cdistcntr))) = 0  
                     WAIT 'Enter a DISTANCE, '+press WINDOW
                     LOOP
                  ENDIF                               
                  IF VAL(Cx(cdistcntr)) > 100000
                     WAIT 'Distance must be  100000 m, '+press WINDOW
                     LOOP
                  ENDIF                     
                  IF VAL(Cx(cdistcntr)) < VAL(Fence)
                     WAIT 'Distance must be  '+ALLTRIM(Fence) +' m fenceline distance, '+press WINDOW
                     LOOP
                  ENDIF   
*                  IF VAL(Chter(cdistcntr)) = VAL(Chter(cdistcntr-1)) .AND. ;
*                   VAL(Cx(cdistcntr)) <= VAL(Cx(cdistcntr-1))
*                     WAIT 'Distance must be > previous Distance, '+press WINDOW
*                    LOOP
*                  ENDIF   
                  cdistcntr = cdistcntr + 1 
                  IF cdistcntr = 21
                     num_cmplx = cdistcntr - 1                                                                                                            
                     cntr = 3
                     LOOP
                  ENDIF                                                                            
                  cntr = 1
            ENDCASE           
         CASE cntr = 3
            DO EL3Keys
            IF prev           && F9
               RETURN
            ENDIF
            IF prcd           && F10
               DO ScrnFSav               
               DO RunModel
               abort = .T.  
            ENDIF
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
RETURN

****************************** ScrnF Save ********************************
PROCEDURE ScrnFsav


ifp = FCREATE('SCREEN.IN')
bytes = FPUTS(ifp,Title)
bytes = FPUTS(ifp,source)
bytes = FPUTS(ifp,Qm)
bytes = FPUTS(ifp,Hs)
bytes = FPUTS(ifp,Convert(VAL(Hr)/4.1868))
bytes = FPUTS(ifp,Zr)           && receptor height
IF Ruclass = 'U'
   ru = '1'
ELSE
   ru = '2'
ENDIF
bytes = FPUTS(ifp,ru)       && rural / urban classification
bytes = FPUTS(ifp,'y')           && building downwash
bytes = FPUTS(ifp,Hb)
bytes = FPUTS(ifp,Bmin)
bytes = FPUTS(ifp,Bmax)
bytes = FPUTS(ifp,Cmplxtrn)           && complex terrain
IF Cmplxtrn = 'Y'
   FOR i = 1 TO num_cmplx
      bytes = FPUTS(ifp,ALLTRIM(Chter(i))+', '+ALLTRIM(Cx(i)))
   NEXT i
   bytes = FPUTS(ifp,'0, 0')
   bytes = FPUTS(ifp,Simple)
ENDIF

IF Simple = 'Y'
   bytes = FPUTS(ifp,Simpeltrn)           && simple terrain above stack height
   bytes = FPUTS(ifp,'1')           && full meterology
   bytes = FPUTS(ifp,'y')           && automated distance array
   
   IF Simpeltrn = 'Y'
      HterDistFile = FCREATE('HTDIST.FIL',0)
      bytes = FPUTS(ifp,ALLTRIM(Hter(1)))
      bytes = FPUTS(ifp,ALLTRIM(Fence)+', '+ALLTRIM(Hterdist(1)))       
      HDbytes = FPUTS(HterDistFile,ALLTRIM(STR(num_eltrn)))
      HDbytes = FPUTS(HterDistFile,ALLTRIM(Hs))
      HDbytes = FPUTS(HterDistFile,ALLTRIM(Hter(1)))
      HDbytes = FPUTS(HterDistFile,ALLTRIM(Fence))
      HDbytes = FPUTS(HterDistFile,ALLTRIM(Hterdist(1)))      
      IF LEN(ALLTRIM(Hter(2))) <> 0         
         bytes = FPUTS(ifp,'Y')
      ENDIF
      FOR i = 1 TO num_eltrn-1
         bytes = FPUTS(ifp,ALLTRIM(Hter(i+1)))
         bytes = FPUTS(ifp,ALLTRIM(Hterdist(i))+', '+ALLTRIM(Hterdist(i+1)))
         HDbytes = FPUTS(HterDistFile,ALLTRIM(Hter(i+1)))        
         HDbytes = FPUTS(HterDistFile,ALLTRIM(Hterdist(i)))
         HDbytes = FPUTS(HterDistFile,ALLTRIM(Hterdist(i+1)))
         IF i+1 < num_eltrn
            bytes = FPUTS(ifp,'Y')
         ENDIF
      NEXT i
      bytes = FPUTS(ifp,'N')
      =FCLOSE(HterDistFile)
   ELSE
      bytes = FPUTS(ifp,ALLTRIM(Fence)+', '+'50000')
   ENDIF

   
*   IF Simpeltrn = 'Y'
*      bytes = FPUTS(ifp,ALLTRIM(Hter(1)))
*      bytes = FPUTS(ifp,ALLTRIM(Fence)+', '+ALLTRIM(Hterdist(1))) 
*      IF LEN(ALLTRIM(Hter(2))) <> 0         
*         bytes = FPUTS(ifp,'Y')
*      ENDIF
*      FOR i = 1 TO num_eltrn-1
*         bytes = FPUTS(ifp,ALLTRIM(Hter(i+1)))
*         bytes = FPUTS(ifp,ALLTRIM(Hterdist(i))+', '+ALLTRIM(Hterdist(i+1)))
*         IF i+1 < num_eltrn
*            bytes = FPUTS(ifp,'Y')
*         ENDIF
*      NEXT i
*      bytes = FPUTS(ifp,'N')
*   ELSE
*      bytes = FPUTS(ifp,ALLTRIM(Fence)+', '+'50000')
*   ENDIF

   bytes = FPUTS(ifp,Isd)   
   IF Isd = 'Y'
      IF Simpeltrn = 'Y'
         num_dist = 0
         FOR i = 1 TO num_ht
            IF i <> 1
               IF Dhter(i) <> Dhter(i-1)
                  bytes = FPUTS(ifp,'0')
                  bytes = FPUTS(ifp,'Y')
               ENDIF
            ENDIF
            IF i > 1 
               IF  Dhter(i) <> Dhter(i-1)
                  bytes = FPUTS(ifp,Dhter(i))
               ENDIF
            ELSE
               bytes = FPUTS(ifp,Dhter(i))
            ENDIF
            j = i * 5 - 4
            FOR indx = j TO j + 4            
               IF LEN(ALLTRIM(Dist(indx))) = 0 
                  EXIT
               ELSE
                  bytes = FPUTS(ifp,Dist(indx))  
                  num_dist = num_dist + 1
               ENDIF
            NEXT indx
        NEXT i
        bytes = FPUTS(ifp,'0')
        bytes = FPUTS(ifp,'N')

        * FOR i = 1 TO num_dist                     
        *    IF Dhter(i) <> hold_dhter
        *       IF i <> 1 
        *          bytes = FPUTS(ifp,'0')
        *          bytes = FPUTS(ifp,'Y')
        *       ENDIF
        *       bytes = FPUTS(ifp,Dhter(i))
        *       hold_dhter = Dhter(i)
        *     ENDIF
        *     bytes = FPUTS(ifp,Dist(i))           
        * NEXT i
        * bytes = FPUTS(ifp,'0')
        * bytes = FPUTS(ifp,'N') 
      ELSE
         FOR i = 1 TO num_dist
            bytes = FPUTS(ifp,Dist(i))
         NEXT i
         bytes = FPUTS(ifp,'0')
      ENDIF      
   ENDIF
ENDIF
*EffectHs = (VAL(Hs) + 4.56E-03 * (VAL(Hr))^.478)

IF ru = '2' .AND. VAL(Hs1) >=10
   bytes = FPUTS(ifp,'n')
ENDIF

bytes = FPUTS(ifp,'n')           && Print option
x=FCLOSE(ifp)


IF Isd = 'Y' .AND. Simple = 'Y'
   IF Simpeltrn = 'Y'
      distfile = FCREATE('DISTNUM')
      bytes = FPUTS(distfile,STR(num_dist)+','+STR(num_ht))
      =FCLOSE(distfile)
   ELSE   
      distfile = FCREATE('DISTNUM')      
      bytes = FPUTS(distfile,STR(num_dist)+','+'0')
      =FCLOSE(distfile)
   ENDIF
ELSE  
   distfile = FCREATE('DISTNUM')
   bytes = FPUTS(distfile,'0'+','+'0')
   =FCLOSE(distfile)
ENDIF

*RELEASE Title,source,Qm,Hs,D,Exitv,Ts,Ta,ruclass,ru,Hb,Bmin,Bmax,dist

RETURN
