* program : subs.prg
* system : tscreen
* programmer: Kevin Stroupe, PES

*  update programmer: Gerry Chike, PES
*  	   update date: 11/10/92
*     update purpose: reconciled fields and memory variables and .dbf
*                     updated oldruns.dbf structure to include new fields


************************************ Chk ********************************
FUNCTION Chk
PARAMETER St,chk_type

DO CASE
   CASE chk_type = 9      &&   temperature
      type_hold = 9
      chk_type = 3
   CASE chk_type = 8      &&   Molecular weight
      type_hold = 8
      chk_type = 3
   CASE chk_type = 10     &&   Wind speed
      type_hold = 10
      chk_type = 1
   CASE chk_type = 11    &&   Boiling temp
      type_hold = 11
      chk_type = 3
   CASE chk_type = 12    && M - amount of refuse in landfill
      type_hold = 12
      chk_type = 3
   CASE chk_type = 13    && Constper - Constituent percent  
      type_hold = 13
      chk_type = 3 
   CASE chk_type = 14    &&K - Ratio of Specific Heat at Constant pressure to s.h. at const. temp.
      type_hold = 14
      chk_type = 3  
   CASE chk_type = 15     && Lvap - latent heat of vaporization
      type_hold = 15
      chk_type = 0   
   CASE chk_type = 16     && Percent
      type_hold = 16
      chk_type = 3
   CASE chk_type = 17     && P - days per year
      type_hold = 17
      chk_type = 2
   CASE chk_type = 18     && ambient pressure
      type_hold = 18
      chk_type = 3
   CASE chk_type = 19     && reservoir pressure
      type_hold = 19
      chk_type = 3      
   CASE chk_type = 20     && relative humidity
      type_hold = 16
      chk_type = 2            
   OTHERWISE 
      type_hold = 0
ENDCASE

IF LASTKEY() = 5
   RETURN -1
ENDIF
IF prev
   RETURN -100   && Needed to break out of READ
ENDIF
IF .NOT. prev 
   cnt_plus = 0
   cnt_minus = 0
   cnt_e = 0
   cnt_dec = 0   
   FOR j = 1 TO 8
      char = SUBSTR(St,j,1)
      IF char=' ' .OR. char='+' .OR. char='-' .OR. char='.' .OR. (char >= '0';
       .AND. char <='9') .OR. char= 'E'                      
         DO CASE
            CASE char = '+'
               cnt_plus = cnt_plus + 1
            CASE char = '-'
               IF j = 1 
                  cnt_minus = cnt_minus + 1
               ELSE
                  IF SUBSTR(St,j-1,1) = 'E'
                     cnt_minus = cnt_minus + 1
                  ELSE
                     cnt_minus = 2
                  ENDIF   
               ENDIF   
            CASE char = 'E'
               cnt_e = cnt_e + 1
               IF cnt_e = 1
                  IF cnt_plus <= 1
                     cnt_plus = 0
                  ENDIF   
                  IF cnt_minus <= 1
                     cnt_minus = 0
                  ENDIF   
                  IF cnt_dec <= 1
                     cnt_dec = 0
                  ENDIF   
               ENDIF      
            CASE char = '.'
               cnt_dec = cnt_dec + 1
         ENDCASE 
      ELSE
         WAIT 'Invalid Numeric Entry, '+press WINDOW
         RETURN 0
      ENDIF
   NEXT j

   IF cnt_plus > 1 .OR. cnt_minus > 1 .OR. cnt_e > 1 .OR. cnt_dec > 1
      WAIT 'Invalid Numeric Entry, '+press WINDOW
      RETURN 0
   ENDIF

   IF 'E' $ St .AND. .NOT. RIGHT(ALLTRIM(St),1) $ '0123456789'
      WAIT 'Invalid Numeric Entry, '+press WINDOW
      RETURN 0
   ENDIF
   
   IF ' '$ALLTRIM(St)
      WAIT 'Invalid Numeric Entry, '+press WINDOW
      RETURN 0
   ENDIF
   
   IF 'E'$St
      positions = LEN(St) - AT('E',St)
      IF AT('E',St) = 1 
         WAIT 'Invalid exponential entry, '+press WINDOW
         RETURN 0
      ENDIF 
      numb = RIGHT(St,positions)
      DO CASE
         CASE VAL(St) > 1E+08 .AND. chk_type <> 7
            WAIT 'Entry too large, '+press WINDOW
            RETURN 0
         CASE VAL(St) > 1E+10 .AND. chk_type = 7   
            WAIT 'Entry too large, '+press WINDOW
            RETURN 0
         CASE VAL(numb) < -10
            WAIT 'Entry too small, '+press WINDOW
            RETURN 0
      ENDCASE  
   ENDIF

   IF St = SPACE(8) .AND. chk_type > -1
      WAIT 'Invalid Entry, '+press WINDOW
      RETURN 0
   ENDIF

   DO CASE
      CASE VAL(St) < 0 .AND. ABS(chk_type) < 3
         WAIT 'Entry must be  0, '+press WINDOW
         RETURN 0
      CASE VAL(St) <= 0 .AND. ABS(chk_type) = 3 .AND. St <> SPACE(8)
         WAIT 'Entry must be > 0, '+press WINDOW
         RETURN 0
      CASE VAL(St) < 1 .AND. chk_type = 4 .AND. St <> SPACE(8)
         WAIT 'Entry must be  1, '+press WINDOW
         RETURN 0
      OTHERWISE
         IF type_hold = 0
            RETURN 1
         ELSE 
            DO CASE 
               CASE VAL(St) < 200 .AND. type_hold = 11 .AND. St <> SPACE(8)
                  WAIT 'Warning: Boiling Temperature < 200, '+press WINDOW
                  RETURN 1     
               CASE VAL(St) > 600 .AND. (type_hold = 9.OR. type_hold=11) .AND. St <> SPACE(8)
                  WAIT 'Warning: Temperature > 600, '+press WINDOW
                  RETURN 1     
               CASE VAL(St) > 1000 .AND. type_hold = 8 .AND. St <> SPACE(8)
                  WAIT 'Molecular Weight must be  1000, '+press WINDOW
                  RETURN 0
               CASE VAL(St) > 1000 .AND. type_hold = 12 .AND. St <> SPACE(8)
                  WAIT 'Warning: This number is extremely large, '+press WINDOW
                  RETURN 1
               CASE VAL(St) > 100 .AND. type_hold = 13 .AND. St <> SPACE(8)
                  WAIT 'Constituent Percent must be  100, '+press WINDOW
                  RETURN 0
               CASE type_hold = 10 
                  IF ((Sc = 'A' .AND. VAL(St) > 3) .OR.;
                   (Sc = 'B' .AND. VAL(St) > 5) .AND. (Sc = 'C' .AND. VAL(St)> 10);
                   .OR. (Sc = 'D' .AND. VAL(St) >20) .OR. (Sc = "E" .AND. VAL(St) > 5) .OR.;
                   (Sc = "F" .AND. VAL(St) > 4))
                     WAIT 'Invalid Stability Class/Wind Speed Combination, Press a key to continue' WINDOW
                     RETURN 0 
                  ENDIF  
               CASE  type_hold = 14 .AND. St <> SPACE(8)
                  DO CASE
                     CASE VAL(St) = 1 
                        WAIT 'Ratio must not equal 1, '+press WINDOW
                        RETURN 0
                     CASE VAL(St) >10
                        WAIT 'Ratio must be  10, '+press WINDOW 
                        RETURN 0
                  ENDCASE                
               CASE VAL(St) > 1.5E6 .AND. type_hold = 15 .AND. St <> SPACE(8)
                  WAIT 'Warning: Latent Heat > 1.5E6, '+press WINDOW
                  RETURN 1
               CASE VAL(St) > 100 .AND. type_hold = 16 .AND. St <> SPACE(8)
                  WAIT 'Percent must be  100, '+press WINDOW
                  RETURN 0
               CASE VAL(St) >= 365   .AND. type_hold = 17 .AND. St <> SPACE(8)
                  WAIT 'Number of Days must be < 365, '+press WINDOW
                  RETURN 0
               CASE type_hold = 18 .AND. VAL(St) > VAL(Pr)                       
                  WAIT 'Ambient Pressure must be  Release Press, '+press WINDOW
                  RETURN 0
               CASE type_hold = 19 .AND. VAL(St) <= VAL(Pa)                       
                  WAIT 'Reservoir Pressure must be > Ambient Press, '+press WINDOW
                  RETURN 0
            ENDCASE      
         ENDIF
   ENDCASE
ENDIF
RETURN 1

*********************************** ChkAF *******************************
FUNCTION ChkAF
PARAMETERS St

IF LASTKEY() = 5 && UP
   RETURN -1
ENDIF
IF prev
   RETURN -100
ENDIF

IF .NOT. prev
   IF .NOT. (ALLTRIM(St))$'ABCDEFF'  
      WAIT 'A through F Only, '+ press WINDOW
      RETURN 0
   ELSE 
      RETURN 1
   ENDIF
ENDIF
RETURN 1

*********************************** Chk *****************************
FUNCTION ChkDist
PARAMETERS st

IF LASTKEY() = 27
   RETURN 1
ENDIF
DO CASE
   CASE VAL(st) > VAL(MaxDist) 
      WAIT 'Distance must be  '+ ALLTRIM(MaxDist)+', '+ press WINDOW
      RETURN 0
   CASE VAL(st) <= 0 
      WAIT 'Distance > 0, '+ press WINDOW
      RETURN 0
   CASE VAL(st) < (VAL(fence)/1000)
      WAIT 'Distance must be  '+ALLTRIM(STR(VAL(fence)/1000))+ ' KM fenceline distance, '+ press WINDOW
      RETURN 0
   OTHERWISE
      RETURN 1
ENDCASE

*********************************** ChkFC *******************************
FUNCTION ChkFC
PARAMETERS fc

IF LASTKEY() = 5 && UP
   RETURN -1
ENDIF
IF prev
   RETURN -100
ENDIF

IF .NOT. prev
   IF .NOT. (ALLTRIM(fc))$'FC'  .AND. .NOT. prev .AND. LASTKEY() <> 5
      WAIT 'F or C Only, '+ press WINDOW
      RETURN 0
   ELSE 
      RETURN 1
   ENDIF
ENDIF
RETURN 1

*********************************** ChkGfrN *******************************
FUNCTION ChkGrfN
PARAMETERS st

st = ALLTRIM(st)

IF LASTKEY() = 27
   RETURN 1
ENDIF
IF LEN(st) = 0 
   WAIT 'Name cannot be blank, '+ press WINDOW
   RETURN 0
ENDIF
st = st+'.GRF'
IF FILE(st)
   WAIT st + ' already exists, '+ press WINDOW
   RETURN 0
ENDIF

RETURN 1


*********************************** ChkName *******************************
FUNCTION ChkName
PARAMETERS st

st = ALLTRIM(st)

IF LASTKEY() = 27
   RETURN 1
ENDIF
IF LEN(st) = 0 
   WAIT 'Name cannot be blank, '+ press WINDOW
   RETURN 0
ENDIF
st = st+'.RPT'
IF FILE(st)
   WAIT st + ' already exists, '+ press WINDOW
   RETURN 0
ENDIF

RETURN 1


*********************************** ChkRU *******************************
FUNCTION ChkRU
PARAMETERS st

IF LASTKEY() = 5 && UP
   RETURN -1
ENDIF
IF prev
   RETURN -100
ENDIF

IF .NOT. prev
   IF .NOT. (ALLTRIM(st))$'RU'  .AND. .NOT. prev .AND. LASTKEY() <> 5
      WAIT 'U or R Only, '+ press WINDOW
      RETURN 0
   ELSE 
      RETURN 1
   ENDIF
ENDIF
RETURN 1

*********************************** ChkCTYPE *******************************
FUNCTION ChkCTYPE
PARAMETERS st

IF LASTKEY() = 5 && UP
   RETURN -1
ENDIF
IF prev
   RETURN -100
ENDIF

IF .NOT. prev
   IF .NOT. (ALLTRIM(st))$'12'  .AND. .NOT. prev .AND. LASTKEY() <> 5
      WAIT '1 or 2 Only, '+ press WINDOW
      RETURN 0
   ELSE 
      RETURN 1
   ENDIF
ENDIF
RETURN 1

*********************************** ChkPT *******************************
FUNCTION ChkPT
PARAMETERS St

IF LASTKEY() = 5 && UP
   RETURN -1
ENDIF
IF prev
   RETURN -100
ENDIF

IF .NOT. prev
   IF .NOT. (ALLTRIM(St))$'PT'  .AND. .NOT. prev .AND. LASTKEY() <> 5
      WAIT 'P or T Only, '+ press WINDOW
      RETURN 0
   ELSE 
      RETURN 1
   ENDIF
ENDIF
RETURN 1

*********************************** ChkSO *******************************
FUNCTION ChkSO
PARAMETERS St

IF LASTKEY() = 5 && UP
   RETURN -1
ENDIF
IF prev
   RETURN -100
ENDIF

IF .NOT. prev
   IF .NOT. (ALLTRIM(St))$'SO'  .AND. .NOT. prev .AND. LASTKEY() <> 5
      WAIT 'S or O Only, '+ press WINDOW
      RETURN 0
   ELSE 
      RETURN 1
   ENDIF
ENDIF
RETURN 1

*********************************** ChkTitle *******************************
FUNCTION ChkTitle
PARAMETERS title

IF LEN(ALLTRIM(title)) = 0 .AND. .NOT. prev .AND. LASTKEY() <> 5
   WAIT 'Title cannot be blank, '+ press WINDOW
   RETURN 0
ELSE 
   RETURN 1
ENDIF

*********************************** ChkQA *******************************
FUNCTION ChkQA
PARAMETERS st

IF LASTKEY() = 5 && UP
   RETURN -1
ENDIF
IF prev
   RETURN -100
ENDIF

IF .NOT. prev
   IF .NOT. (ALLTRIM(st))$'QA'  .AND. .NOT. prev .AND. LASTKEY() <> 5
      WAIT 'Q or A Only, '+ press WINDOW
      RETURN 0
   ELSE 
      RETURN 1
   ENDIF
ENDIF
RETURN 1

*********************************** ChkVSW *******************************
FUNCTION ChkVSW
PARAMETERS St

IF LASTKEY() = 5 && UP
   RETURN -1
ENDIF
IF prev
   RETURN -100
ENDIF

IF .NOT. prev
   IF .NOT. (ALLTRIM(St))$'VSW'  
      WAIT 'V, S, or W Only, '+ press WINDOW
      RETURN 0
   ELSE 
      RETURN 1
   ENDIF
ENDIF
RETURN 1

*********************************** ChkYN *******************************
FUNCTION ChkYN
PARAMETERS st

IF LASTKEY() = 5 && UP
   RETURN -1
ENDIF
IF prev
   RETURN -100
ENDIF

IF .NOT. prev
   IF .NOT. (ALLTRIM(st)) $ 'YN' .AND. .NOT. prev .AND. LASTKEY() <> 5
      WAIT 'Y or N Only, '+ press WINDOW
      RETURN 0
   ELSE 
      RETURN 1
   ENDIF
ENDIF
RETURN 1

********************************** Clear Menu *****************************
PROCEDURE clrmenu
PARAMETERS clearing
SET COLOR TO W+/BG 
IF clearing = 'Title'
   @ 0,0 CLEAR TO 23,79
ELSE
   @ 0,0 CLEAR TO 22,79
ENDIF
SET COLOR TO W+/B
@0,0 SAY PADC("",80,' ')
SET COLOR OF SCHEME 1 TO &WindColor
SET COLOR OF SCHEME 2 TO &PopColor

RETURN

********************************** ClrEL1Key ******************************
PROCEDURE ClrEL1Key

prev = .F. 
ON KEY LABEL F9 =1
ON KEY LABEL F3 =1
ON KEY LABEL F1 = 1
RETURN

********************************** ClrEL2Key ******************************
PROCEDURE ClrEL2Key
 
ON KEY LABEL F9 =1
ON KEY LABEL F2 =1
ON KEY LABEL F10 =1

RETURN

********************************** ClrEL4Key ******************************
PROCEDURE ClrEL4Keys
 
ON KEY LABEL RIGHTARROW
ON KEY LABEL LEFTARROW

RETURN

********************************** ClrEL4All ******************************
PROCEDURE ClrEL4All

@ 23,0 TO 24,79 ' '  COLOR &IPColor
ON KEY LABEL F1 =1 
ON KEY LABEL RIGHTARROW
ON KEY LABEL LEFTARROW

RETURN

********************************** ClrEL4PCX ******************************
PROCEDURE ClrEL4PCX

@ 23,0 TO 24,79 ' '  COLOR &IPColor
ON KEY LABEL F1 =1 
ON KEY LABEL F9 =1 
ON KEY LABEL RIGHTARROW
ON KEY LABEL LEFTARROW

RETURN

************************************* Convert ******************************
FUNCTION convert
PARAMETER numb

IF numb = 0
   numb = '0      '
   RETURN numb
ENDIF

IF numb >= 1E+08
   numb = TRANSFORM(numb,'@^')
   first = LEFT(numb,AT('E',numb)-1)
   last = RIGHT(numb,LEN(numb)-AT('E',numb))
   first = STR(VAL(first)*10,4,2)
   last = STR(VAL(last)-1)
   numb = first+'E+'+ALLTRIM(last)
   RETURN numb
ELSE
   IF numb <= 1E-06
      numb = TRANSFORM(numb,'@^')
      first = LEFT(numb,AT('E',numb)-1)
      last = RIGHT(numb,LEN(numb)-AT('E',numb))
      first = STR(VAL(first)*10,4,2)     
      last = STR(VAL(last)-1)
      numb = first+'E'+ALLTRIM(last)
      RETURN numb
   ENDIF
ENDIF
*IF numb >= 1 
*   numb = STR(numb,8,2)
*ELSE
   numb = STR(numb,8,6)
*ENDIF
IF VAL(numb) = 0
   numb = '0       '   
   RETURN numb
ENDIF
IF .NOT. '.'$numb
   RETURN numb
ENDIF
DO WHILE .T.
   IF RIGHT(numb,1) = '0'
      numb = LEFT(numb,LEN(numb)-1)
   ELSE
      IF RIGHT(numb,1) = '.'
         numb = LEFT(numb,LEN(numb)-1)  
      ENDIF
      RETURN numb
   ENDIF
ENDDO
RETURN numb
     
********************************* EL1Keys ********************************
PROCEDURE EL1Keys

DO ClrEL4Keys
on key label f2 =1
ON KEY LABEL F10 =1

ON KEY LABEL F9 DO previous && KEYBOARD CHR(23) && RETURN && TO prgm
ON KEY LABEL F3 DO calculat WITH SYS(18)
ON KEY LABEL F1 DO helpsys WITH VARREAD(), scenario, model

RETURN

********************************** EL2Keys *******************************
PROCEDURE EL2Keys

DO ClrEL1Key
*ON KEY LABEL F9 RETURN TO prgm
prev = .F.
prcd = .F.
edit = .F.

CLEAR MACROS
*ON KEY LABEL F9 prev = .T.
*ON KEY LABEL F10 prcd = .T.
*ON KEY LABEL F2 edit = .T.

*SET ESCAPE ON
*ON ESCAPE abort = .T.
SET COLOR TO &LEColor
@ 22,1 SAY PADC('<F2> Edit    <F9> Previous Screen    <F10> Next Screen    <Esc> Abort',75)
SET COLOR TO &HLColor
 
DO WHILE .T.
   SET CURSOR OFF
   SET CONSOLE OFF
   wait '' 
   SET CURSOR ON
   SET CONSOLE ON
   y = lastkey()
   DO CASE
      CASE y = -1
         edit  = .T.
         EXIT
      CASE y = -8
         prev = .T.
         EXIT      
      CASE y = -9
         prcd = .T.
         EXIT 
      CASE y = 27
         abort = .T.
         EXIT        
     otherwise  
         LOOP  
   ENDCASE

*   DO CASE
*      CASE prev
*        EXIT
*      CASE edit
*         EXIT      
*      CASE prcd
*         EXIT 
*      CASE abort
*         EXIT        
*     otherwise    
*   ENDCASE
ENDDO
   
SET ESCAPE OFF
DO ClrEL2Key
RESTORE MACROS FROM tsmacro.fky
RETURN

********************************** EL3Keys *******************************
PROCEDURE EL3Keys

DO ClrEL1Key

prev = .F.
prcd = .F.
edit = .F.
CLEAR MACROS
SET COLOR TO &LEColor
@ 22,1 SAY PADC('<F2> Edit    <F9> Previous Screen    <F10> Run Model    <Esc> Abort',75)
SET COLOR TO &HLColor
 
DO WHILE .T.
   SET CURSOR OFF
   SET CONSOLE OFF
   wait '' 
   SET CURSOR ON
   SET CONSOLE ON
   y = lastkey()
   DO CASE
      CASE y = -1
         edit  = .T.
         EXIT
      CASE y = -8
         prev = .T.
         EXIT      
      CASE y = -9
         prcd = .T.
         EXIT 
      CASE y = 27
         abort = .T.
         EXIT        
     otherwise  
         LOOP  
   ENDCASE

ENDDO
   
SET ESCAPE OFF
DO ClrEL2Key
RESTORE MACROS FROM tsmacro.fky
RETURN

*DO ClrEL1Key
*DO BlockKey
**ON KEY LABEL F9 RETURN TO prgm
*prev = .F.
*prcd = .F.
*edit = .F.
*ON KEY LABEL F9 prev = .T.
*ON KEY LABEL F10 prcd = .T.
*ON KEY LABEL F2 edit = .T.
*on key label enter null = .t.

*SET ESCAPE ON
*ON ESCAPE abort = .T.
*SET COLOR TO &LEColor
*@ 22,1 SAY PADC('<F2> Edit    <F9> Previous Screen    <F10> Run Model    <Esc> Abort',75)
*SET COLOR TO &HLColor
*DO WHILE .T.
*   DO CASE
*      CASE prev
*         EXIT
*      CASE edit
*         EXIT      
*      CASE prcd
*         EXIT 
*      CASE abort
*         EXIT        
*     otherwise    
*   ENDCASE
*ENDDO
   
*on key label enter
*SET ESCAPE OFF
*DO ClrEL2Key
*RETURN

********************************** EL4Menu ********************************
PROCEDURE el4menu

DO ClrEL1Key
DO ClrEL2Key
DO EndLin4
ON KEY LABEL LEFTARROW DO Lt_Proc
ON KEY LABEL RIGHTARROW DO Rt_Proc
ON KEY LABEL F9 DO Prev_menu
ON KEY LABEL F1 DO MenuHelp
RETURN

********************************* Endline1 *******************************
PROCEDURE endline1

@ 21,1 SAY REPLICATE('',75)
SET COLOR TO &ELColor
@ 22,1 SAY PADC('<F1> Help    <F3> Calculator    <F9> Previous Screen    <Esc> Abort',75)
SET COLOR TO &HLColor
RETURN

********************************* Endlin4 *******************************
PROCEDURE Endlin4

@ 23,0 SAY PADC('<F1>Help      <>/<>Scroll Vertical Menus     <>/<>Scroll Horizontal Menu',80) COLOR &ELColor
@ 24,0 SAY PADC('<Enter>/Letter=Select Menu Item    <F9>Exit Current Menu   <Esc>Exit All Menus',80) COLOR &ELColor
@ 1,0 SAY ''
RETURN

*********************************** Init *********************************
PROCEDURE init

FOR i = 1 TO 50
   Dist(i) = SPACE(8)
NEXT i

Title = SPACE(63)
Fc =  ' '
Emyn = ' '
SigmaY = '0      '
SigmaZ = '0      '
E = SPACE(8)
Qm = SPACE(8)
Qm1 = SPACE(8)
Qm2 = SPACE(8)
QKG = SPACE(8)
A0CM = SPACE(8)
cpl = SPACE(8)
Pfr = SPACE(8)
Ne = SPACE(8)
Pr = SPACE(8)
Lvap = SPACE(8)
Tb = SPACE(8)
Ta = '293     '
Sc = ' '
U = SPACE(8)
Vi = SPACE(8)
Mw = SPACE(8)
Payn = ' '
YN = ' '
A = SPACE(8)
Rs = SPACE(8)
F = SPACE(8)
Cp = SPACE(8)
Ts = SPACE(8)
Ms = SPACE(8)
Pl = SPACE(8)
Dp = SPACE(8)
V = SPACE(8)
D = SPACE(8)
Q = SPACE(8)
Exitv = SPACE(8)
Pm = SPACE(8)
Pv = SPACE(8)
Pls = SPACE(8)
H = SPACE(8)
Pfr = SPACE(8)
Rd = SPACE(8)
Impoundtyp=' '
Co = SPACE(8)
Pd = SPACE(8)
Efs = SPACE(8)
Bcyn = ' '
Ap = SPACE(8)
Ef = SPACE(8)
M = SPACE(8)
Constper = SPACE(8)
Ppm = SPACE(8)
*K = '1.5     '
K = SPACE(8)
Pa = '101325  '
Exitv = SPACE(8)
Hs = SPACE(8)
Hb = SPACE(8)
Bmin=SPACE(8)
Bmax=SPACE(8)
Iwf = '5700    '
C=SPACE(8)
P = '        '
Ft= '20      '
Vol=SPACE(8)
S = '50      '
Vol = SPACE(8)
Hr = SPACE(8)
PlotAv = 1
Type = ' '
Fence = SPACE(8)
Ruclass = ' '
Isd = ' '
Dur = SPACE(8)
Mwc = SPACE(8)
Av = SPACE(8)
A0 = SPACE(8)
T1 = SPACE(8)
Tc = SPACE(8)
Zr = '0       '
Simple = ' '
Simpeltrn = ' '
Cmplxtrn = ' '
Ragyn = ' '
Areayn = 'N'

FOR i = 1 TO 20
   Chter(i) = SPACE(8)
   Cx(i) = SPACE(8)
NEXT i
FOR i = 1 TO 10   
   Hter(i) = SPACE(8)
   Hterdist(i) = SPACE(8)
NEXT i
FOR i = 1 TO 10
   Dhter(i) = SPACE(8)
NEXT i

abort = .F.
twophase = .F.
blankout = .F.
*rel_hold = 0
*part_hold = 0
*gas_hold = 0
*liq_hold = 0
*tim_hold = ''
*file_hold = 0
rel_hold = 1
part_hold = 1
gas_hold = 1
liq_hold = 1
sup_hold = 1
tim_hold = 1
file_hold = 1
sup_hold = 1
chem_hold = 1
quit_hold = 1
make_hs_0 = .T.
make_p_0 = .T.
model = ''
prev_menu = .F.
press= 'Press any key to continue...'

* Soil Excavation - Scenario 4.4.3
Csoil  = SPACE(8)			&& concentration of soil contaminant
Vsoil	 = '150     '		&& soil volume extracted
Asoil	 = '290     '		&& surface area of exposed soil
BDsoil = '1.5     '		&& bulk density of soil 
time	 = '1       '	   && time to excavate soil
Ksoil	 = '298     '		&& soil temp

* Thermal Incinerator - Scenario 4.4.4
Dre = '99.99   '
Frate = SPACE(8)
Trate = SPACE(8)
Conc = SPACE(8)

* Soil Vapor Extraction - Scenario 4.4.2
Cg = SPACE(8)
Pvap = SPACE(8)
Qext = SPACE(8)
Ctype = ' '
Qunc = SPACE(8)
Ceff = SPACE(8)

RETURN

***************************** Inst_Warning ********************************
* update programmer: Gerry Chike
* update purpose: put text into a screen format so text can be read
*						over other menus

PROCEDURE Inst_Warning
label = " Instantaneous Release Warning "
DEFINE WINDOW Warning FROM 0,0 TO 24,79 TITLE label  COLOR SCHEME 1 
ACTIVATE WINDOW Warning   
TEXT
	A release is considered (only) time limited if the release rate is
constant over the duration of the release, but the release duration is short
in comparison with other important time scales (e.g., the averaging time
used to assess the toxicity, or the cloud travel time to a downwind 
position of interest).  Typically, this behavior might be expected if, for 
example, an automatic shutoff system is assumed to stop the release after a 
specified (generally short) time period.  The release rate for time-limited
releases can still be estimated using the continuous sections; the total 
amount released (Q) could then be estimated by Qm Td where Qm is the release
rate and Td is the release duration (i.e., Qm = Td Q).

	Finally, a release may be both time varying and time limited.  As in
the time-varying case, a screening method which uses the initial reservoir
conditions can be used to (over) estimate the release rate and the total
amount released could be estimated by Qm Td.  Of course, the (estimated) 
total amount released cannot exceed the amount on hand before the release.

	To accurately determine if the release is instantaneous, run the 
continuous scenario first and compute the travel time.  If the travel time
is less than the release duration, then the release is instantaneous and 
this scenario may be applicable.

ENDTEXT
* SET COLOR TO GR+/B
WAIT 
RELEASE WINDOW Warning 
* SET COLOR TO W+/B
RETURN		
	
	


********************************* Lt_Proc *********************************
PROCEDURE Lt_Proc

KEYBOARD CHR(27)
PLAY MACRO move_lt
KEYBOARD CHR(13)                 

****************************** Make Public ********************************
PROCEDURE makepub

PUBLIC Title,Fc,Emyn,E,Qm,Qm1,Qm2,QKG,A0,A0CM,cpl,Pfr,Ne,prcd,edit,abort,prev
PUBLIC Pr,Lvap,Tb,Ta,Sc,Mw,U,Payn,YN,A,rs,F,Cp,Ts,press,prev_menu
PUBLIC Ms,Pl,Dp,V,Exitv,D,Q,Pm,Pv,H,Pls,Pfr,Rd,Co,Efs,SigmaY,SigmaZ
PUBLIC Impoundtyp,Pd,Bcyn,Ap,Ef,M,Constper,Ppm,K,Pa,Hs,Hb,Bmin,T1,Tc
PUBLIC Bmax,C,Iwf,Type,P,Ft,Vol,S,Fence,PlotAv,Vol,Hr,Ruclass,Isd,Dur,Av
PUBLIC Mwc,twophase,blankout,make_hs_0,model,Zr,Simple,Simpeltrn,Cmplxtrn 
PUBLIC cur_menu,Ragyn,Areayn,make_p_0
PUBLIC rel_hold,part_hold,gas_hold,liq_hold,sup_hold,tim_hold,file_hold,chem_hold,quit_hold,sup_hold
PUBLIC PpmYN,Vi,two_phase
PUBLIC ARRAY Dist(50)
PUBLIC ARRAY Hter(10), Hterdist(10), Chter(20), Cx(20), Dhter(10)
DIMENSION Dist(50)
DIMENSION Hter(10), Hterdist(10), Chter(20), Cx(20), Dhter(10)

* Soil Excavation - Scenario 4.4.3
PUBLIC Csoil	 		&& Concentration of Contaminated Soil 		
PUBLIC Vsoil	 		&& Volume of Soil Excavated 
PUBLIC Asoil	 		&& Exposed Surface Area of Contaminated Soil
PUBLIC BDsoil	 		&& Bulk Density of Soil
PUBLIC time		 		&& Time to Excavate Soil
PUBLIC Ksoil                    && Soil Temperature

* Thermal Incineration - Scenario 4.4.4
PUBLIC Dre, Frate, Trate, Conc
 
* Soil Vapor Extraction - Scenario 4.4.2
PUBLIC Cg, Pvap, Qext, Ctype, Qunc, Ceff



RETURN

************************************* Previous ****************************
PROCEDURE previous

CLEAR GET
KEYBOARD CHR(23)
prev = .T.
RETURN

***************************** Prev_menu *********************************
PROCEDURE prev_menu

prev_menu = .T.
CLEAR TYPEAHEAD
KEYBOARD CHR(27)

RETURN

**************************** Release Memory Variables *******************
PROCEDURE relmvars
RELEASE Title,Fc,Emyn,E,QKG,Qm,Qm1,Qm2,A0,A0CM,cpl,Pfr,Ne,SigmaY,SigmaZ   && A0CM added by G.Chike
RELEASE Pr,Lvap,Tb,Ta,Sc,Mw,U,Payn,YN,A,rs,F,Cp,Ts
RELEASE Ms,Pl,Dp,V,Exitv,D,Q,Pm,Pv,H,Pls,Pfr,Rd,Co
RELEASE Impoundtyp,Pd,Efs,Bcyn,Ap,Ef,M,Constper,Ppm,K,Pa,Hs,Hb,Bmin,T1
RELEASE Bmax,C,Iwf,Type,P,Ft,Vol,S,Fence,PlotAv,Vol,Hr,Ruclass,Isd,Dur,Av
RELEASE Mwc,twophase,Zr,Simpeltrn,Cmplxtrn,Ragyn,Areayn, Vi

RELEASE Dist
RELEASE Hter, Hterdist, Chter, Cx, Dhter

* Soil Excavation - Scenario 4.4.3
RELEASE Csoil			&& Concentration of Contaminated Soil 		
RELEASE Vsoil	 		&& Volume of Soil Excavated 
RELEASE Asoil	 		&& Exposed Surface Area of Contaminated Soil
RELEASE BDsoil 		&& Bulk Density of Soil
RELEASE time	 		&& Time to Excavate Soil
RELEASE Ksoil	 		&& Soil Temperature

* Thermal Incineration - Scenario 4.4.4
RELEASE Dre
RELEASE Frate
RELEASE Trate
RELEASE Conc

* Soil Vapor Extraction - Scenario 4.4.2
RELEASE Cg, Pvap, Qext, Ctype, Qunc, Ceff



RETURN

******************************* Restore Memory Variables ****************
PROCEDURE restormv
PARAMETERS recordnum

USE oldruns
GO recordnum
DO makepub

Dist(1) = Dist1
Dist(2) = Dist2
Dist(3) = Dist3
Dist(4) = Dist4
Dist(5) = Dist5
Dist(6) = Dist6
Dist(7) = Dist7
Dist(8) = Dist8
Dist(9) = Dist9
Dist(10) = Dist10
Dist(11) = Dist11
Dist(12) = Dist12
Dist(13) = Dist13
Dist(14) = Dist14
Dist(15) = Dist15
Dist(16) = Dist16
Dist(17) = Dist17
Dist(18) = Dist18
Dist(19) = Dist19
Dist(20) = Dist20
Dist(21) = Dist21
Dist(22) = Dist22
Dist(23) = Dist23
Dist(24) = Dist24
Dist(25) = Dist25
Dist(26) = Dist26
Dist(27) = Dist27
Dist(28) = Dist28
Dist(29) = Dist29
Dist(30) = Dist30
Dist(31) = Dist31
Dist(32) = Dist32  
Dist(33) = Dist33
Dist(34) = Dist34
Dist(35) = Dist35
Dist(36) = Dist36
Dist(37) = Dist37
Dist(38) = Dist38
Dist(39) = Dist39
Dist(40) = Dist40
Dist(41) = Dist41
Dist(42) = Dist42
Dist(43) = Dist43
Dist(44) = Dist44
Dist(45) = Dist45
Dist(46) = Dist46
Dist(47) = Dist47
Dist(48) = Dist48
Dist(49) = Dist49
Dist(50) = Dist50

Dhter(1)  = Dhter1
Dhter(2)  = Dhter2
Dhter(3)  = Dhter3
Dhter(4)  = Dhter4
Dhter(5)  = Dhter5
Dhter(6)  = Dhter6
Dhter(7)  = Dhter7
Dhter(8)  = Dhter8
Dhter(9)  = Dhter9
Dhter(10)= Dhter10

Chter(1) = Chter1
Chter(2) = Chter2
Chter(3) = Chter3
Chter(4) = Chter4
Chter(5) = Chter5
Chter(6) = Chter6
Chter(7) = Chter7
Chter(8) = Chter8
Chter(9) = Chter9
Chter(10) = Chter10
Chter(11) = Chter11
Chter(12) = Chter12
Chter(13) = Chter13
Chter(14) = Chter14
Chter(15) = Chter15
Chter(16) = Chter16
Chter(17) = Chter17
Chter(18) = Chter18
Chter(19) = Chter19
Chter(20) = Chter20

Cx(1) = Cx1
Cx(2) = Cx2
Cx(3) = Cx3
Cx(4) = Cx4
Cx(5) = Cx5
Cx(6) = Cx6
Cx(7) = Cx7
Cx(8) = Cx8
Cx(9) = Cx9
Cx(10) = Cx10
Cx(11) = Cx11
Cx(12) = Cx12
Cx(13) = Cx13
Cx(14) = Cx14
Cx(15) = Cx15
Cx(16) = Cx16
Cx(17) = Cx17
Cx(18) = Cx18
Cx(19) = Cx19
Cx(20) = Cx20

Hter(1) = Hter1
Hter(2) = Hter2
Hter(3) = Hter3
Hter(4) = Hter4
Hter(5) = Hter5
Hter(6) = Hter6
Hter(7) = Hter7
Hter(8) = Hter8
Hter(9) = Hter9
Hter(10) = Hter10

Hterdist(1)  = Hterdist1
Hterdist(2)  = Hterdist2
Hterdist(3)  = Hterdist3
Hterdist(4)  = Hterdist4
Hterdist(5)  = Hterdist5
Hterdist(6)  = Hterdist6
Hterdist(7)  = Hterdist7
Hterdist(8)  = Hterdist8
Hterdist(9)  = Hterdist9
Hterdist(10) =  Hterdist10

RELEASE ALL LIKE Dist*,Hter*,Hterdist*,Dhter*,Cx*,Chter*

SCATTER FIELDS Title,Fc,Emyn,E,Qm,cpl,Pfr,Ne MEMVAR
SCATTER FIELDS Pr,Lvap,Tb,Ta,Sc,Mw,U,Payn,YN,A,F,Cp,Ts MEMVAR
SCATTER FIELDS Ms,Pl,Dp,V,Exitv,D,Q,Pm,Pv,H,Rd,Co MEMVAR
SCATTER FIELDS Impoundtyp,Pd,Efs,Bcyn,Ap,Ef,M,Constper,Ppm,K,Pa,Hs,Hb,Bmin,T1 MEMVAR
SCATTER FIELDS Bmax,Type,P,Iwf,C,Ft,Vol,S,Fence,PlotAv MEMVAR
SCATTER FIELDS Vol,Hr,Ruclass,Isd,Dur,Av,A0,Vi MEMVAR
SCATTER FIELDS Mwc,Zr,Simple,Simpeltrn,Cmplxtrn MEMVAR
*SCATTER FIELDS relread,partread,gasread,liqread,timeread,stkread,chemread MEMVAR
SCATTER FIELDS Scenario,Tc,Rs,Vp,Ragyn,Areayn MEMVAR
SCATTER FIELDS A0CM, QKG, QM1, QM2, SigmaY, SigmaZ MEMVAR    && Added by GEC

* Soil Excavation - Scenario 4.4.3
SCATTER FIELDS	Csoil	 MEMVAR		&& Concentration of Contaminated Soil 		
SCATTER FIELDS	Vsoil	 MEMVAR		&& Volume of Soil Excavated 
SCATTER FIELDS	Asoil	 MEMVAR		&& Exposed Surface Area of Contaminated Soil
SCATTER FIELDS  BDsoil   MEMVAR         && Bulk Density of Soil
SCATTER FIELDS	time	 MEMVAR		&& Time to Excavate Soil
SCATTER FIELDS	Ksoil	 MEMVAR		&& Soil Temperature

* Thermal Incineration - Scenario 4.4.4
SCATTER FIELDS  Dre     MEMVAR
SCATTER FIELDS  Frate   MEMVAR
SCATTER FIELDS  Trate   MEMVAR
SCATTER FIELDS  Conc    MEMVAR

* Soil Vapor Extraction - Scenario 4.4.2
SCATTER FIELDS  Cg    MEMVAR
SCATTER FIELDS  Pvap  MEMVAR
SCATTER FIELDS  Qext  MEMVAR
SCATTER FIELDS  Ctype MEMVAR
SCATTER FIELDS  Qunc  MEMVAR
SCATTER FIELDS  Ceff  MEMVAR

USE
RETURN

********************************* Rt_Proc *********************************
PROCEDURE Rt_Proc

KEYBOARD CHR(27)
PLAY MACRO move_rt
KEYBOARD CHR(13)


*********************************** Title *******************************
PROCEDURE title
Title = LEFT(Title+SPACE(63),63)
@ 3,3 SAY "Enter a unique title for this data's model run:"
@ 4,3 GET Title VALID ChkTitle(Title)
READ
Title = STRTRAN(Title,',',' ')
@ 4,3 SAY Title COLOR &IPColor
RETURN
