SUBROUTINE tpr2rh (t, p, r, rh)

   !--------------------------------------------------------------------
   ! Descriptions:
   !    Calculate relative humidity from temperature, mixing ratio and
   !    pressure.
   ! 
   ! Preconditions required:
   !
   ! Functions and subroutines called:
   !
   ! Revision history:
   !    Created Oct 30, 2007 D. Yin ARB Cal/EPA
   !
   ! References:
   !    MODELS3/mcip
   !---------------------------------------------------------------------

   IMPLICIT none

   !arguments and their descriptions
   REAL, INTENT(IN) :: t                  !air temperature in K
   REAL, INTENT(IN) :: p                  !air pressure in Pa
   REAL, INTENT(IN) :: r                  !water vapor mixing ratio in kg/kg
   REAL, INTENt(OUT) :: rh                !relative humidity in %

   !parameters and their descriptions 
   REAL, PARAMETER :: stdtemp = 273.15    !in K
   REAL, PARAMETER :: vp0=611.29          !in Pa
   REAL, PARAMETER :: svp2= 17.67         ! from MM5
   REAL, PARAMETER :: svp3= 29.65         ! from MM5

   !local variables and their descriptions
   REAL :: es                             !saturation vapor pressure in Pa
   REAL :: qss                            !saturation mixing ratio in kg/kg

   !start of the executable code

   IF ( t <= stdtemp ) THEN
      es = vp0 * EXP( 22.514 - (6.15e3 / t) )
   ELSE
      es = vp0 * EXP( svp2 * (t - stdtemp) / (t - svp3) )
   ENDIF

   qss      = es * 0.622 / (p - es)
   rh = 100.0 * r / qss
   rh = MIN( 100.0, rh )

END SUBROUTINE tpr2rh
