require(ncdf4)
library(graphics)
library(jpeg)
library(sf)
require(fields)



my.colors <- colorRampPalette(c("white","purple","deepskyblue2","green","yellow","orange","red","brown"))
rev.colors <- colorRampPalette(c("brown","red","orange","yellow","green","deepskyblue2","purple","lightgray","white"))
my.diff.colors <- colorRampPalette(c("blue","deepskyblue2","white","white","orange","red"))

a <- "usalines.csv"
fh <- read.csv(file=a,skip=0,header=T)

a <- "worldlines.csv"
fh2 <- read.csv(file=a,skip=0,header=T)

#########################################################################################################################

a <- "temp.txt"
info <- read.csv(file=a,skip=0,header=T)



a <- "temppredobs.csv"
b <- read.csv(file=a,skip=0,header=T)
b$Time.On <- paste(b$SMM,b$SDD,b$SYYYY,sep="/")
#b$xtime <- as.POSIXct(strptime(b$Time.On, format= "%m/%d/%Y %H:%M")) + as.difftime(60*6,units="mins")
b$xtime <- as.POSIXct(strptime(b$Time.On, format= "%m/%d/%Y")) 
#b$bymin <- cut(b$xtime, breaks="5 min")
b$monid <- substr(b$SiteId,1,20)
head(b)

temp <- b[c("Longitude","Latitude")]
crs.new <- c("+proj=lcc +lat_1=33 +lat_2=45 +lat_0=40 +lon_0=-97 +datum=NAD83")
crs.old <- c("+proj=longlat +datum=NAD83")
g <- st_as_sf(temp,coords=c("Longitude","Latitude"),crs = crs.old)
p <- st_transform(g, crs.new)
g2 <- matrix(unlist(p),ncol=2,byrow=TRUE)
colnames(g2) <- c("coords.x","coords.y")
nox <- cbind(b,g2)

qa <- subset(nox,PM25_ob>0)
head(qa)



###note - the model output is in GMT and the obs file was converted to local time
cmaqhour <- 0 #61 to start in June
scenario <- info$SCEN
mons <- info$MON
days <- info$DAY
years <- info$YEAR
  
junk <- paste(years,mons,days,sep="-")
#junk <- paste("2021-",mons[i],"-",days[i]," 14:00:00",sep="")
xx <- as.POSIXct(junk) 
#xx <- as.POSIXct("2017-06-01 00:00:00") + as.difftime(60*(x-1),units="mins")
yy <- format(xx, "%m/%d/%Y")

print(yy)

fname <- paste("spat_PM25.png",sep="")
outfile <- paste("tempaq.ncf",sep="")
#pdf(file=fname,width=8,height=8)
png(file=fname,width=700,height=900)
par(mfrow=c(2,1))
par(mar=c(1,1,2,4))
### MAR (bottom, left, top, right)

labtext <- "ug/m3"


source.open <- nc_open(filename=outfile, write=FALSE, readunlim=FALSE)

x.orig.km <- ncatt_get(source.open,varid=0,attname="XORIG")$value/1000
y.orig.km <- ncatt_get(source.open,varid=0,attname="YORIG")$value/1000
x.cell.size <- ncatt_get(source.open,varid=0,attname="XCELL")$value/1000
y.cell.size <- ncatt_get(source.open,varid=0,attname="YCELL")$value/1000
num.grid.x <- ncatt_get(source.open,varid=0,attname="NCOLS")$value
num.grid.y <- ncatt_get(source.open,varid=0,attname="NROWS")$value
x.proj.12 <- seq(from=x.orig.km + x.cell.size/2, length=num.grid.x, by=x.cell.size)
y.proj.12 <- seq(from=y.orig.km + y.cell.size/2, length=num.grid.y, by=y.cell.size)

datavar.array <- ncvar_get(source.open,"PM25",start=c(1,1,1,1),count=c(num.grid.x,num.grid.y,1,1))

datavar.array.plot <- datavar.array 
maxmod <- quantile(datavar.array.plot,probs=c(0.99))

subaero <- subset(nox,xtime==xx & PM25_ob>0 )
maxob <-  quantile(subaero$PM25_ob,probs=c(0.99))

maxval <-  max(maxmod,maxob)
maxval <- round(maxval,0)

subaero$PM25_ob[subaero$PM25_ob > maxval] <- maxval*.9999
subaero$PM25_ob[subaero$PM25_ob < 0] <- 0.000001

ncol <- 50
breaks <- seq(0,maxval,by=(maxval/ncol))
nbreak <- length(breaks)+1
my.rsq.col <- my.colors(ncol)
cut.rsq <- cut(subaero$PM25_ob,breaks)

datavar.array.plot[datavar.array.plot > maxval] <- maxval

image.plot(x.proj.12,y.proj.12,datavar.array.plot,xlab="",ylab="",ylim=c(-1700,1600),xlim=c(-2400,2400),zlim=c(0,maxval),axes=F,col=my.colors(50),main=paste(" "),legend.args=list(text=labtext,col="black",cex=2,side=1,line=0.5))

lines(fh2$x/1000,fh2$y/1000, lwd=1.66,col="black")
lines(fh$x/1000,fh$y/1000, lwd=2,col="black")
points(subaero$coords.x/1000,subaero$coords.y/1000,col="black",bg=my.rsq.col[cut.rsq],pch=21,cex=1.5)

ttext <- paste("PM2.5",xx,sep="  ")
mtext(ttext,cex=1.5)
#legend("bottomright",c("HMS Fire Detects","AERONET site"),pch=c(19,22),col=c("green","black"),cex=1.25,bg="white")
box(col="black")




maxval <- 20
source.open <- nc_open(filename="temp0fire.ncf", write=FALSE, readunlim=FALSE)
datavar.nofire <- ncvar_get(source.open,"PM25",start=c(1,1,1,1),count=c(num.grid.x,num.grid.y,1,1))

datavar.array.plot <- datavar.array - datavar.nofire

datavar.array.plot[datavar.array.plot > maxval] <- maxval

image.plot(x.proj.12,y.proj.12,datavar.array.plot,xlab="",ylab="",zlim=c(0,maxval),axes=F,col=my.colors(50),main=paste(" "),legend.args=list(text=labtext,col="black",cex=2,side=1,line=0.5))

lines(fh2$x/1000,fh2$y/1000, lwd=1.66,col="black")
lines(fh$x/1000,fh$y/1000, lwd=2,col="black")
#points(subaero$coords.x/1000,subaero$coords.y/1000,col="black",bg=my.rsq.col[cut.rsq],pch=21,cex=1.5)

ttext <- paste("PM25",xx,"Fire contribution",sep="  ")
mtext(ttext,cex=1.5)
#legend("bottomright",c("HMS Fire Detects","AERONET site"),pch=c(19,22),col=c("green","black"),cex=1.25,bg="white")
box(col="black")




dev.off()



