require(ncdf4)
library(graphics)
library(jpeg)
library(sf)
require(fields)



my.colors <- colorRampPalette(c("white","purple","deepskyblue2","green","yellow","orange","red","brown"))
rev.colors <- colorRampPalette(c("brown","red","orange","yellow","green","deepskyblue2","purple","lightgray","white"))
my.diff.colors <- colorRampPalette(c("blue","deepskyblue2","white","white","orange","red"))

a <- "usalines.csv"
fh <- read.csv(file=a,skip=0,header=T)

a <- "worldlines.csv"
fh2 <- read.csv(file=a,skip=0,header=T)

#########################################################################################################################

a <- "temp.txt"
info <- read.csv(file=a,skip=0,header=T)

cmaqhour <- 0 #61 to start in June
scenario <- info$SCEN
mon <- info$MON
ndays <- info$NDAYS
year <- info$YEAR
xx <- paste(mon,year,sep="/")
days <- seq(1,ndays,by=1)

labtext <- "umol/cm2"
maxval <- 500
ncol <- 50
breaks <- seq(0,maxval,by=(maxval/ncol))
nbreak <- length(breaks)+1
my.rsq.col <- my.colors(ncol)

###############################################################

ydate <- 230601
modfile <- paste("/work/ROMO/lrt/cmaq/36US3/postp/",scenario,"/sat/cmaqsatellite.",ydate,".FORM.",scenario,".36US3.ncf",sep="")
source.open <- nc_open(filename=modfile, write=FALSE, readunlim=FALSE)
x.orig.km <- ncatt_get(source.open,varid=0,attname="XORIG")$value/1000
y.orig.km <- ncatt_get(source.open,varid=0,attname="YORIG")$value/1000
x.cell.size <- ncatt_get(source.open,varid=0,attname="XCELL")$value/1000
y.cell.size <- ncatt_get(source.open,varid=0,attname="YCELL")$value/1000
num.grid.x <- ncatt_get(source.open,varid=0,attname="NCOLS")$value
num.grid.y <- ncatt_get(source.open,varid=0,attname="NROWS")$value
x.proj.12 <- seq(from=x.orig.km + x.cell.size/2, length=num.grid.x, by=x.cell.size)
y.proj.12 <- seq(from=y.orig.km + y.cell.size/2, length=num.grid.y, by=y.cell.size)

##############################################################

obs.avg <- ncvar_get(source.open,"FORM") * 0.0
mod.avg <- ncvar_get(source.open,"FORM") * 0.0
obs.ndays <- ncvar_get(source.open,"FORM") * 0.0
obs.n <- obs.ndays
xmod.avg <- mod.avg

#read in obs files
for (i in 1:length(days)) {

xdate <- year*10000 + mon*100 + i
ydate <- 23*10000 +  mon*100 + i
obsfile <- paste("/work/MOD3EVAL/kbaker/data/satellite/tropomi/tropomi_36US3_HCHO_",xdate,".nc",sep="")
source.obs <- nc_open(filename=obsfile, write=FALSE, readunlim=FALSE)
modfile <- paste("/work/ROMO/lrt/cmaq/36US3/postp/",scenario,"/sat/cmaqsatellite.",ydate,".FORM.",scenario,".36US3.ncf",sep="")
source.mod <- nc_open(filename=modfile, write=FALSE, readunlim=FALSE)
print(obsfile)
print(modfile)

datavar.all <- ncvar_get(source.open,"FORM") * 0.0
for (time in 1:23) {
datavar.array <- ncvar_get(source.obs,"HCHO",start=c(1,1,1,time),count=c(num.grid.x,num.grid.y,1,1))
datavar.obs <- (datavar.array / 6.0221415E23 ) * 1E10
datavar.all <- pmax(datavar.all,datavar.obs)
}

obs.avg <- obs.avg + datavar.all
obs.n[obs.avg > 0] <- 1
obs.ndays <- obs.ndays + obs.n

datavar.mod <- ncvar_get(source.mod,"FORM") * (2.69E16) *  (1/6.022E23) * 1E10
mod.avg <- mod.avg + datavar.mod*obs.n
xmod.avg <-  xmod.avg + datavar.mod

}

obs.avg <- obs.avg / obs.ndays
mod.avg <- mod.avg / obs.ndays
xmod.avg <- xmod.avg / ndays


fname <- paste("spat_FORMcolumn.png",sep="")
#pdf(file=fname,width=8,height=8)
png(file=fname,width=1000,height=900)
par(mfrow=c(2,2))
par(mar=c(1,1,2,4))
### MAR (bottom, left, top, right)


obs.avg[obs.avg > maxval] <- maxval
image.plot(x.proj.12,y.proj.12,obs.avg,xlab="",ylab="",zlim=c(0,maxval),axes=F,col=my.colors(50),main=paste(" "),xlim=c(-2556,2952),ylim=c(-1728,1872),legend.args=list(text=labtext,col="black",cex=1,side=1,line=0.5))

lines(fh2$x/1000,fh2$y/1000, lwd=1.66,col="black")
lines(fh$x/1000,fh$y/1000, lwd=2,col="black")

ttext <- paste("TROPOMI HCHO column",xx,sep=" ")
mtext(ttext,cex=1)
box(col="black")




mod.avg[mod.avg > maxval] <- maxval

image.plot(x.proj.12,y.proj.12,mod.avg,xlab="",ylab="",zlim=c(0,maxval),axes=F,col=my.colors(50),main=paste(" "),xlim=c(-2556,2952),ylim=c(-1728,1872),legend.args=list(text=labtext,col="black",cex=1,side=1,line=0.5))

lines(fh2$x/1000,fh2$y/1000, lwd=1.66,col="black")
lines(fh$x/1000,fh$y/1000, lwd=2,col="black")

ttext <- paste("Modeled HCHO column missing obs masking",xx,sep="  ")
mtext(ttext,cex=1)
box(col="black")




image.plot(x.proj.12,y.proj.12,obs.ndays,xlab="",ylab="",zlim=c(0,31),axes=F,col=my.colors(50),main=paste(" "),xlim=c(-2556,2952),ylim=c(-1728,1872),legend.args=list(text="N",col="black",cex=1,side=1,line=0.5))

lines(fh2$x/1000,fh2$y/1000, lwd=1.66,col="black")
lines(fh$x/1000,fh$y/1000, lwd=2,col="black")

ttext <- paste("Number of valid TROPOMI measurement days ",xx,sep="  ")
mtext(ttext,cex=1)
box(col="black")





xmod.avg[xmod.avg > maxval] <- maxval

image.plot(x.proj.12,y.proj.12,xmod.avg,xlab="",ylab="",zlim=c(0,maxval),axes=F,col=my.colors(50),main=paste(" "),xlim=c(-2556,2952),ylim=c(-1728,1872),legend.args=list(text=labtext,col="black",cex=1,side=1,line=0.5))

lines(fh2$x/1000,fh2$y/1000, lwd=1.66,col="black")
lines(fh$x/1000,fh$y/1000, lwd=2,col="black")

ttext <- paste("Modeled HCHO column no masking",xx,sep="  ")
mtext(ttext,cex=1)
box(col="black")




dev.off()



