
a <- "temp.txt"
info <- read.csv(file=a,skip=0,header=T)
info





a <- "/work/ROMO/lrt/cmaq/36US3/postp/base2023/predobs.2023.36US3.35.base2023.airnow_O3.csv"
one <- read.csv(file=a,skip=5,header=T)
head(one)
two <- subset(one,Latitude > info$SLAT & Longitude < info$SLONG & Latitude < info$ELAT & Longitude > info$ELONG)
two$O3_8hrmax_ob[two$O3_8hrmax_ob <0] <- NA
two$O3_8hrmax_mod[two$O3_8hrmax_mod <0] <- NA
three <- aggregate(two,list(two$SYYYY,two$SMM,two$SDD),mean,na.rm=T)

three[is.na(three)] <- -9.0
head(three)
baseline <- three




a <- "/work/ROMO/lrt/cmaq/36US3/postp/base2023_newOMI/predobs.2023.36US3.35.base2023_newOMI.airnow_O3.csv"
one <- read.csv(file=a,skip=5,header=T)
head(one)
two <- subset(one,Latitude > info$SLAT & Longitude < info$SLONG & Latitude < info$ELAT & Longitude > info$ELONG)
two$O3_8hrmax_ob[two$O3_8hrmax_ob <0] <- NA
two$O3_8hrmax_mod[two$O3_8hrmax_mod <0] <- NA
three <- aggregate(two,list(two$SYYYY,two$SMM,two$SDD),mean,na.rm=T)

three[is.na(three)] <- -9.0
head(three)
omi <- three



#####################################################
#####################################################

fname <- paste("scatterplot_O3.png",sep="")
#pdf(file=fname,width=8,height=8)
png(file=fname,width=600,height=600)
par(mfrow=c(3,3))
par(mar=c(4,4,2,1))
### MAR (bottom, left, top, right)

labtext <- "ppb"


temp <- baseline
lim <- max(temp$O3_8hrmax_ob,temp$O3_8hrmax_mod,na.rm=T)*1.1
plot(temp$O3_8hrmax_ob,temp$O3_8hrmax_mod,xlab="Observations",ylab="Model",ylim=c(20,lim),xlim=c(20,lim),pch=19,col="red",cex=2)
legend("topleft","Baseline")
legend("bottomright",info$REGION)

temp <- omi
lim <- max(temp$O3_8hrmax_ob,temp$O3_8hrmax_mod,na.rm=T)*1.1
plot(temp$O3_8hrmax_ob,temp$O3_8hrmax_mod,xlab="Observations",ylab="Model",ylim=c(20,lim),xlim=c(20,lim),pch=19,col="blue",cex=2)
legend("topleft","Baseline with new OMI file")


dev.off()

################################

fname <- paste("timeseries_O3.png",sep="")
#pdf(file=fname,width=8,height=8)
png(file=fname,width=1000,height=400)
par(mfrow=c(1,1))
par(mar=c(4,4,2,1))
### MAR (bottom, left, top, right)

labtext <- "ppb"
lim <- 65


temp <- baseline
temp$Time.On <- paste(temp$SMM,temp$SDD,temp$SYYYY,sep="/")
temp$xtime <- as.POSIXct(strptime(temp$Time.On, format= "%m/%d/%Y"))

head(temp)
xtemp <- temp[order(temp$xtime),]
temp <- xtemp

plot(temp$xtime,temp$O3_8hrmax_ob,xlab="Date",ylab="MDA8 O3 mixing ratio (ppb)",xaxt='n',ylim=c(20,75),xlim=c(as.POSIXct("2023-04-01"),as.POSIXct("2023-10-01")))
x <- seq(as.POSIXct("2023-04-01"),as.POSIXct("2023-10-01"),by='2 week')
axis(1,at=x,labels=format(x, "%m/%d"))
legend("bottomleft",c("Observation","Baseline","New OMI"),pch=c(19,4,4,4,4,4,4),col=c("black","red","blue"),cex=1.,bg="white",ncol=3)
legend("topleft",info$REGION,cex=1.1,bty='n')

lines(temp$xtime,temp$O3_8hrmax_ob,pch=19,col="black")
points(temp$xtime,temp$O3_8hrmax_mod,pch=4,col="red")

temp <- omi
temp$Time.On <- paste(temp$SMM,temp$SDD,temp$SYYYY,sep="/")
temp$xtime <- as.POSIXct(strptime(temp$Time.On, format= "%m/%d/%Y"))
points(temp$xtime,temp$O3_8hrmax_mod,pch=4,col="blue")

dev.off()







#write.table(four, file='dailyavg.txt', sep=",",quote=FALSE,row.names=FALSE,col.names=TRUE)

