        PROGRAM calcDayMax

!***********************************************************************
!  DESCRIPTION:
!
!  PRECONDITIONS REQUIRED:
!       "setenv"s for input/output file
!
!  SUBROUTINES AND FUNCTIONS CALLED:
!
!  REVISION  HISTORY:
!
!***********************************************************************

      IMPLICIT NONE

!...........   INCLUDES:

      INCLUDE 'PARMS3.EXT'      ! I/O API constants
      INCLUDE 'FDESC3.EXT'      ! I/O API file description data structure
      INCLUDE 'IODECL3.EXT'     ! I/O API function declarations

!...........   EXTERNAL FUNCTIONS and their descriptions:

      INTEGER  ENVINT
      EXTERNAL NEXTIME, ENVSTR, ENVINT

!...........   LOCAL VARIABLES and their descriptions:

      CHARACTER*160 MESG
      CHARACTER*16  INFILE1, OUTFILE, STACK1,STACK2,INFILE2
      CHARACTER*16  SPECIES
      CHARACTER*16 SCLVAR1, SCLVAR2, SCLVAR3
      
      INTEGER JDATE, ODATE
      INTEGER JTIME, OTIME
      INTEGER JSTEP
      INTEGER LOGDEV
      INTEGER STATUS
      INTEGER T, N, I, J, L, HR, IMIN, IMAX, JMIN, JMAX
      INTEGER NHRS, XLOC, YLOC
      INTEGER NLAYS, MXREC
      
      REAL*8 AVERAGE, SCL
      
      REAL, ALLOCATABLE :: INCONC(:,:)
      REAL, ALLOCATABLE :: ALTCONC(:,:)
      REAL, ALLOCATABLE :: LATIT(:,:)
      REAL, ALLOCATABLE :: LONGI(:,:)

      INTEGER, ALLOCATABLE :: COL(:,:)
      INTEGER, ALLOCATABLE :: ROW(:,:)
      REAL, ALLOCATABLE :: XLOCA(:,:)
      REAL, ALLOCATABLE :: YLOCA(:,:)


      CHARACTER*16 :: PROGNAME = 'ScaleWindow'
      
!***********************************************************************
 
!.... Initialize the I/O API ...
      LOGDEV = INIT3()        !  initialization returns unit # for log

!.... Get infile/outfile

      INFILE1 = 'INFILE1'
      INFILE2 = 'INFILE2'
      OUTFILE = 'OUTFILE'
      STACK1 = 'STACK1'
      STACK2 = 'STACK2'

!.... Read stack input file      

      IF ( .NOT. OPEN3( STACK1, FSREAD3, PROGNAME ) ) THEN
         MESG = 'Could not open file "'//TRIM(STACK1)//'" for input'
         CALL M3EXIT( PROGNAME, 0, 0, MESG, 2 )
      ENDIF

      IF ( .NOT. DESC3( STACK1 ) ) THEN
         MESG = 'Could not get file description'
         CALL M3EXIT( PROGNAME, 0, 0, MESG, 2 )
      ENDIF

      ALLOCATE( LATIT( NCOLS3D, NROWS3D),
     &          LONGI( NCOLS3D, NROWS3D),
     &          COL( NCOLS3D, NROWS3D),
     &          ROW( NCOLS3D, NROWS3D),
     &          XLOCA( NCOLS3D, NROWS3D),
     &          YLOCA( NCOLS3D, NROWS3D),
     &          STAT = STATUS )

      JSTEP = TSTEP3D
      NLAYS = NLAYS3D
      MXREC = MXREC3D
      JDATE = SDATE3D
      JTIME = STIME3D

          IF ( .NOT. READ3( STACK1, 'LATITUDE',
     &            ALLAYS3, JDATE, JTIME, LATIT ) ) THEN
            MESG = 'Could not read from "'//TRIM(STACK1)//'"'
            CALL M3EXIT(PROGNAME,0,0,MESG,2)
          ENDIF

          IF ( .NOT. READ3( STACK1, 'LONGITUDE',
     &            ALLAYS3, JDATE, JTIME, LONGI ) ) THEN
            MESG = 'Could not read from "'//TRIM(STACK1)//'"'
            CALL M3EXIT(PROGNAME,0,0,MESG,2)
          ENDIF

          IF ( .NOT. READ3( STACK1, 'COL',
     &            ALLAYS3, JDATE, JTIME, COL ) ) THEN
            MESG = 'Could not read from "'//TRIM(STACK1)//'"'
            CALL M3EXIT(PROGNAME,0,0,MESG,2)
          ENDIF

          IF ( .NOT. READ3( STACK1, 'ROW',
     &            ALLAYS3, JDATE, JTIME, ROW ) ) THEN
            MESG = 'Could not read from "'//TRIM(STACK1)//'"'
            CALL M3EXIT(PROGNAME,0,0,MESG,2)
          ENDIF

          IF ( .NOT. READ3( STACK1, 'XLOCA',
     &            ALLAYS3, JDATE, JTIME, XLOCA ) ) THEN
            MESG = 'Could not read from "'//TRIM(STACK1)//'"'
            CALL M3EXIT(PROGNAME,0,0,MESG,2)
          ENDIF

          IF ( .NOT. READ3( STACK1, 'YLOCA',
     &            ALLAYS3, JDATE, JTIME, YLOCA ) ) THEN
            MESG = 'Could not read from "'//TRIM(STACK1)//'"'
            CALL M3EXIT(PROGNAME,0,0,MESG,2)
          ENDIF


!.... Open input file ...
      IF ( .NOT. OPEN3( INFILE1, FSREAD3, PROGNAME ) ) THEN
         MESG = 'Could not open file "'//TRIM(INFILE1)//'" for input'
         CALL M3EXIT( PROGNAME, 0, 0, MESG, 2 )
      ENDIF

      IF ( .NOT. DESC3( INFILE1 ) ) THEN
         MESG = 'Could not get file description'
         CALL M3EXIT( PROGNAME, 0, 0, MESG, 2 )
      ENDIF


      IF ( .NOT. OPEN3( INFILE2, FSREAD3, PROGNAME ) ) THEN
         MESG = 'Could not open file "'//TRIM(INFILE2)//'" for input'
         CALL M3EXIT( PROGNAME, 0, 0, MESG, 2 )
      ENDIF

      IF ( .NOT. DESC3( INFILE2 ) ) THEN
         MESG = 'Could not get file description'
         CALL M3EXIT( PROGNAME, 0, 0, MESG, 2 )
      ENDIF


!.... Save I/O API variables

      JSTEP = TSTEP3D
      NLAYS = NLAYS3D
      MXREC = MXREC3D
      
!.... Allocate arrays

      ALLOCATE( INCONC( NCOLS3D, NROWS3D ),
     &          ALTCONC( NCOLS3D, NROWS3D ),
     &          STAT = STATUS )
      IF( STATUS /= 0 ) STOP "Error allocating arrays"


!.... Scale factor to apply within window


      DO N = 1, NVARS3D, 1
        JDATE = SDATE3D
        JTIME = STIME3D
        
!.... read in data
        HR = 0
        DO T = 1, MXREC, 1
          HR = HR + 1


          IF ( .NOT. READ3( INFILE1, VNAME3D(N), 
     &            ALLAYS3, JDATE, JTIME, INCONC ) ) THEN
            MESG = 'Could not read from "'//TRIM(INFILE1)//'"'
            CALL M3EXIT(PROGNAME,0,0,MESG,2)
          ENDIF

          IF ( .NOT. READ3( INFILE2, VNAME3D(N),
     &            ALLAYS3, JDATE, JTIME, ALTCONC ) ) THEN
            MESG = 'Could not read from "'//TRIM(INFILE2)//'"'
            CALL M3EXIT(PROGNAME,0,0,MESG,2)
          ENDIF


            DO I = 1, NCOLS3D, 1
              DO J = 1, NROWS3D, 1
               IF(INCONC(I,J).NE.ALTCONC(I,J)) THEN
               XLOC = (XLOCA(I,J) - XORIG3D)/XCELL3D
               YLOC = (YLOCA(I,J) - YORIG3D)/YCELL3D
                 write(*,*)I,J,LATIT(I,J),LONGI(I,J),XLOCA(I,J),
     &            YLOCA(I,J),COL(I,J),ROW(I,J),XLOC,YLOC
                ELSE
                 
                ENDIF
              ENDDO
            ENDDO


            HR = 0        
          CALL NEXTIME( JDATE, JTIME, JSTEP )
        
        ENDDO
      ENDDO
      
!.... Deallocate arrays
!      DEALLOCATE( INCONC, OUTCONC, BUFFER )
      
      CALL M3EXIT( PROGNAME, 0, 0, '', 0)
      
      END
