c**** NCF_WRT_DATA_PTS
c
      subroutine ncf_wrt_data_pts(ierr,action,iounit)
      implicit none
c
c-----------------------------------------------------------------------
c    Description:
c-----------------------------------------------------------------------
c
c   This routine writes the variable data for the grid definiton 
c    variables to the NetCDF file
c
c      Argument description:
c       Inputs:
c           action      C name of file to open
c           iounit      I NetCDF file ID of file
c       Outputs:
c           ierr        I error code
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'camx2ncf_pts.inc'
      include 'netcdf.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer       ierr
      character*(*) action
      integer       iounit
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
      integer istrln
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*200 this_var
      real*4,       allocatable, dimension(:)   :: darray_1d
      integer,      allocatable, dimension(:)   :: iarray_1d
      integer       this_varid, ipts
c
c-----------------------------------------------------------------------
c    Entry point:
c-----------------------------------------------------------------------
c
c  --- allocate the array for sending ---
c
      allocate( darray_1d(nptsrc) )
      allocate( iarray_1d(nptsrc) )
c
c  --- variable for X coordinates ---
c
      this_var = "xcoord"
      do ipts=1,nptsrc
        darray_1d(ipts) = xstk(ipts)
      enddo
      ierr = nf_inq_varid(iounit,this_var,this_varid)
      if( ierr .NE. NF_NOERR ) goto 7000
      ierr = nf_put_var_real(iounit,this_varid,darray_1d)
      if( ierr .NE. NF_NOERR ) goto 7001
c
c  --- variable for Y coordinates ---
c
      this_var = "ycoord"
      do ipts=1,nptsrc
        darray_1d(ipts) = ystk(ipts)
      enddo
      ierr = nf_inq_varid(iounit,this_var,this_varid)
      if( ierr .NE. NF_NOERR ) goto 7000
      ierr = nf_put_var_real(iounit,this_varid,darray_1d)
      if( ierr .NE. NF_NOERR ) goto 7001
c
c  --- variable for stack height ---
c
      this_var = "stkheight"
      do ipts=1,nptsrc
        darray_1d(ipts) = hstk(ipts)
      enddo
      ierr = nf_inq_varid(iounit,this_var,this_varid)
      if( ierr .NE. NF_NOERR ) goto 7000
      ierr = nf_put_var_real(iounit,this_varid,darray_1d)
      if( ierr .NE. NF_NOERR ) goto 7001
c
c  --- variable for stack diameter ---
c
      this_var = "stkdiam"
      do ipts=1,nptsrc
        darray_1d(ipts) = dstk(ipts)
      enddo
      ierr = nf_inq_varid(iounit,this_var,this_varid)
      if( ierr .NE. NF_NOERR ) goto 7000
      ierr = nf_put_var_real(iounit,this_varid,darray_1d)
      if( ierr .NE. NF_NOERR ) goto 7001
c
c  --- variable for stack gas exit temperature ---
c
      this_var = "stktemp"
      do ipts=1,nptsrc
        darray_1d(ipts) = tstk(ipts)
      enddo
      ierr = nf_inq_varid(iounit,this_var,this_varid)
      if( ierr .NE. NF_NOERR ) goto 7000
      ierr = nf_put_var_real(iounit,this_varid,darray_1d)
      if( ierr .NE. NF_NOERR ) goto 7001
c
c  --- variable for stack gas exit velocity ---
c
      this_var = "stkspeed"
      do ipts=1,nptsrc
        darray_1d(ipts) = vstk(ipts)
      enddo
      ierr = nf_inq_varid(iounit,this_var,this_varid)
      if( ierr .NE. NF_NOERR ) goto 7000
      ierr = nf_put_var_real(iounit,this_varid,darray_1d)
      if( ierr .NE. NF_NOERR ) goto 7001
c
c  --- variable for PiG flag ---
c
      this_var = "pigflag"
      do ipts=1,nptsrc
        iarray_1d(ipts) = piglet(ipts)
      enddo
      ierr = nf_inq_varid(iounit,this_var,this_varid)
      if( ierr .NE. NF_NOERR ) goto 7000
      ierr = nf_put_var_int(iounit,this_varid,iarray_1d)
      if( ierr .NE. NF_NOERR ) goto 7001
c
c  --- variable for X coordinates ---
c
      this_var = "saoverride"
      do ipts=1,nptsrc
        iarray_1d(ipts) = sa_region(ipts)
      enddo
      ierr = nf_inq_varid(iounit,this_var,this_varid)
      if( ierr .NE. NF_NOERR ) goto 7000
      ierr = nf_put_var_int(iounit,this_varid,iarray_1d)
      if( ierr .NE. NF_NOERR ) goto 7001
c
c  --- deallocate the array and set return flag ---
c
      deallocate( darray_1d )
      deallocate( iarray_1d )
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c    Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(*,'(//,a)') 'ERROR in NCF_WRT_DATA_PTS:'
      write(*,'(A)') action(:istrln(action))
      write(*,'(2A)') 'Cannot find variable id for: ',
     &                                      this_var(:istrln(this_var))
      ierr = IFAIL
      goto 9999
c
 7001 continue
      write(*,'(//,a)') 'ERROR in NCF_WRT_DATA_PTS:'
      write(*,'(A)') action(:istrln(action))
      write(*,'(2A)') 'Cannot write data for the variable: ',
     &                                      this_var(:istrln(this_var))
      ierr = IFAIL
      goto 9999
c
c-----------------------------------------------------------------------
c    Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
 
