      subroutine rdpthdr(ierr,icur_file)
      implicit none
c
c----------------------------------------------------------------
c  
c    This routine reads the header from the point source file
c    and stores the data in global variables.
c
c----------------------------------------------------------------
c  Argument declarations:
c----------------------------------------------------------------
c
      integer ierr
      integer icur_file
c
c----------------------------------------------------------------
c  Include files:
c----------------------------------------------------------------
c
      include 'camx2ncf_pts.inc'
c
c----------------------------------------------------------------
c  Local variables:
c----------------------------------------------------------------
c
      character*10 spcname_in
      character*4  ifile(10), note(60)
      character*4  ptspec(10,MXSPEC)
      integer      nseg, idum, n, l, begdate_in, enddate_in
      integer      iuzon_in, ncol_in, nrow_in, nlay_in, iproj_in
      integer      nptsrc_in, nspec_in, idx, i
      real         begtim_in, endtim_in, polelon_in, polelat_in
      real         xorg_in, yorg_in, delx_in, dely_in
      real         tlat1_in, tlat2_in
      logical      lsame
c
c----------------------------------------------------------------
c  External Functions:
c----------------------------------------------------------------
c
      integer istrln
      integer fndchr
c
c----------------------------------------------------------------
c  Entry point:
c----------------------------------------------------------------
c
c  --- Read 1st PT header record and check inputs ---
c             
      rewind(ioremis(icur_file),ERR=7000)
      read(ioremis(icur_file),ERR=7000) ifile,note,nseg,nspec_in,
     &                  begdate_in,begtim_in,enddate_in,endtim_in
      nspec_file(icur_file) = nspec_in
c             
      if(INT(endtim_in) .EQ. 24) then
        endtim_in = 0.
        enddate_in = enddate_in + 1
        if( MOD(enddate_in,1000) .GT. 365 ) then
           if( MOD(INT(enddate_in/1000),4) .EQ. 0 ) then
              if( MOD(enddate_in,1000) .EQ. 367 ) 
     &              enddate_in = (INT(enddate_in/1000)+1)*1000 + 1
           else
              enddate_in = (INT(enddate_in/1000)+1)*1000 + 1
           endif
        endif
      endif
      begtim_in = 100.*begtim_in
      endtim_in = 100.*endtim_in
c 
c --- Read 2nd PT header ---
c 
      read(ioremis(icur_file),ERR=7000) polelon_in,polelat_in,iuzon_in,
     &                  xorg_in,yorg_in,delx_in,dely_in,ncol_in,nrow_in,
     &                           nlay_in,iproj_in,idum,tlat1_in,tlat2_in
c
c --- check the domain ----
c
      if( icur_file .EQ. 1 ) then
          write(runmsg,'(60A1)') note
          begdate = begdate_in
          begtim = begtim_in
          enddate = enddate_in
          endtim= endtim_in
          iuzon = iuzon_in
          xorg = xorg_in
          yorg = yorg_in
          delx = delx_in
          dely = dely_in
          ncol = ncol_in
          nrow = nrow_in
          nlay = nlay_in
      endif
      lsame = .TRUE.
      if( begtim_in .NE. begtim ) lsame = .FALSE.
      if( endtim_in .NE. endtim ) lsame = .FALSE.
      if( .NOT. lsame ) goto 7001
      lsame = .TRUE.
      if( xorg_in .NE. xorg ) lsame = .FALSE.
      if( yorg_in .NE. yorg ) lsame = .FALSE.
      if( delx_in .NE. delx ) lsame = .FALSE.
      if( dely_in .NE. dely ) lsame = .FALSE.
      if( ncol_in .NE. ncol ) lsame = .FALSE.
      if( nrow_in .NE. nrow ) lsame = .FALSE.
      if( nlay_in .NE. nlay ) lsame = .FALSE.
      if( .NOT. lsame ) goto 7002
c 
c  --- Read 3rd & 4th PT header ---
c 
      read(ioremis(icur_file),ERR=7000)
      read(ioremis(icur_file),ERR=7000) ((ptspec(n,l),n=1,10),l=1,nspec_in) 
      do l=1,nspec_in
         write(spcname_in,'(10A1)') (ptspec(n,l),n=1,10)
         idx = fndchr( spcname_in, 10, spcname, nspec ) 
         if( idx .EQ. 0 ) then
            nspec = nspec + 1
            if( nspec .GT. MXSPEC ) goto 7003
            idx = nspec
         endif
         idxspc(icur_file,l) = idx
         spcname(idx) = spcname_in
      enddo
c
c  --- Read time invariant data (assume nseg=1) 
c      check number of sources against max  ---
c
      read(ioremis(icur_file),ERR=7000) idum,nptsrc_in
      read(ioremis(icur_file),ERR=7000) (xstk(n),ystk(n),hstk(n),
     &           dstk(n),tstk(n),vstk(n),n=nptsrc+1,nptsrc+nptsrc_in)
      nptsrc = nptsrc + nptsrc_in
      if( nptsrc .GT. MXPTSRC ) goto 7004
c
c --- set error flag and return ---
c
      ierr = ISUCES
      goto 9999
c
c----------------------------------------------------------------
c  Error message:
c----------------------------------------------------------------
c
 7000 continue
      write(*,'(//,A)') 'ERROR: Reading input point source file.'
      write(*,'(A,//)') infile(icur_file)(:istrln(infile(icur_file)))
      ierr = IRDERR
      goto 9999
c
 7001 continue
      write(*,'(//,A)') 'ERROR: Reading input point source file.'
      write(*,'(A)') infile(icur_file)(:istrln(infile(icur_file)))
      write(*,'(A,//)') 'Number of hours on files is inconsistent.'
      ierr = IRDERR
      goto 9999
c
 7002 continue
      write(*,'(//,A)') 'ERROR: Reading input point source file.'
      write(*,'(A)') infile(icur_file)(:istrln(infile(icur_file)))
      write(*,'(A,//)') 'Domain definition is inconsistent.'
      ierr = IRDERR
      goto 9999
c
 7003 continue
      write(*,'(//,A)') 'ERROR: Reading input point source file.'
      write(*,'(A)') infile(icur_file)(:istrln(infile(icur_file)))
      write(*,'(A,I3)') 'Number of species exceeds max: ',MXSPEC
      write(*,'(A,//)') 'Increase parameter MXSPEC.'
      ierr = IRDERR
      goto 9999
c
 7004 continue
      write(*,'(//,A)') 'ERROR: Reading input point source file.'
      write(*,'(A)') infile(icur_file)(:istrln(infile(icur_file)))
      write(*,'(A,I10)') 'Number of points exceeds max: ',MXPTSRC
      write(*,'(A,//)') 'Increase parameter MXPTSRC'
      ierr = IRDERR
      goto 9999
c
c----------------------------------------------------------------
c  Return point:
c----------------------------------------------------------------
c
 9999 continue
      return
      end
