C**** RDSPCLST
c
c
      subroutine rdspclst( ierr )
c
c-----------------------------------------------------------------------
c
c     This routine returns the species list and assigns the gas/PM
c     flag.
c
c   Arguments:
c     Outputs:
c       ierr   I   error code
c
c-----------------------------------------------------------------------
c   Argument declaration:
c-----------------------------------------------------------------------
c
      integer ierr
c
c-----------------------------------------------------------------------
c   Include files;
c-----------------------------------------------------------------------
c
      include 'camx2ncf_pts.inc'
c
c-----------------------------------------------------------------------
c   External functions
c-----------------------------------------------------------------------
c
      integer istrln
      integer fndchr
c
c-----------------------------------------------------------------------
c   Local variables:
c-----------------------------------------------------------------------
c
      character*10 specin, gasflag, keyin
      logical      lfound(MXSPEC)
      integer      idx, i
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
      lfound = .FALSE.
c
  111 continue
      read(IORSPEC,'(A10,1X,A10)',END=222,ERR=7000) specin, gasflag
      keyin = gasflag
      call jstlft(specin)
      call jstlft(gasflag)
      call toupper(gasflag)
c
c   --- find species in species list ---
c
      idx = fndchr( specin, 10, spcname, nspec )
      if( idx .GT. 0 ) then 
         lfound(idx) = .TRUE.
c
c   --- check the gas flag --- 
c
         if( gasflag(:3) .EQ. 'GAS' ) then
             lgas(idx) = .TRUE.
         else if( gasflag(:2) .EQ. 'PM' ) then
             lgas(idx) = .FALSE.
         else
             goto 7001
         endif
      endif
c
c   --- get next line ---
c
      goto 111
c
c  --- entire file read, check that all species found a match ----
c
  222 continue
      do i=1,nspec
        if( .NOT. lfound(i) ) then
           write(*,'(/,A)') 'Warning: Species not found in species list file.'
           write(*,'(10X,A)') spcname(i)(:istrln(spcname(i)))
           write(*,'(A)') 'This species will assumed to be a gas species.'
           lgas(i) = .TRUE.
        endif
      enddo
c
c   --- set error flag and return ---
c
      ierr = ISUCES 
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(*,'(//,A)') 'ERROR: Reading species list file.'
      write(*,'(A)') spcfile(:istrln(spcfile))
      ierr = IFAIL
      goto 9999
c
 7001 continue
      write(*,'(//,3A)') 'ERROR: Invalid entry for gas flag read ',
     &                 'in species list file: ',keyin(:istrln(keyin)) 
      write(*,'(A)') 'Accceptable options are: '
      write(*,'(10X,A)') 'GAS'
      write(*,'(10X,A)') 'PM'
      ierr = IFAIL
      goto 9999
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
