#! /bin/csh

#SBATCH --no-requeue
#SBATCH -p singlepe
#SBATCH --account=romo
#SBATCH --gid=romo
#SBATCH --time=72:00:00

##PBS -r n
##PBS -q singlepe
##PBS -W group_list=romo
##PBS -l walltime=24:00:00
##PBS -j oe

cat $0
uname -a
date

if ( $USER == bkx ) then
# unalias certain common commands:

unalias rm
unalias cd
unalias ln
unalias mv

endif # user bkx

chdir $WCDIR/post

setenv IOAPI_ISPH 20  # this agrees with default from combine.F 
# C...check if IOAPI_ISPH is set, if not, set to 20
# call ENVSTR( 'IOAPI_ISPH','IOAPI_ISPH spheroid setting', '20', csphere, istat)
# if ( .not. SETENVVAR ('IOAPI_ISPH',csphere)) then !WRF-ARW sphere
# Write(*,'(''*WARNING* SETENVVAR for IOAPI_ISPH failed, using default'')')
# Write(*,'(''*WARNING* IOAPI_ISPH not set in script, using 20 (WRF-ARW sphere)'')')

#===========================================================================
# combine aconc and o3

#if ( $YEAR$MONTH == 201801 ) goto bypass1
run_combine.csh >& log/run_combine.log.$YEAR$MONTH
bypass1:

#===========================================================================
# hr2day concentrations

#> set to use local time (default is GMT)
setenv USELOCAL Y

#> set to use daylight savings time (default is N)
setenv USEDST N

#> starting hour for daily metrics (default is 0)
setenv START_HOUR 0

#> ending hour for daily metrics (default is 23)
setenv END_HOUR 23

#> Number of 8hr values to use when computing daily maximum 8hr ozone.
#> Allowed values are 24 (use all 8-hr averages with starting hours 
#> from 0 - 23 hr local time) and 17 (use only the 17 8-hr averages
#> with starting hours from 7 - 23 hr local time)
setenv HOURS_8HRMAX 24

setenv INFILE    $OUTDIR/combine_aconc$SFX$YEAR$MONTH
setenv M3_FILE_1 $INFILE
setenv OUTFILE   $OUTDIR/hr2day_avg_aconc_LST$SFX$YEAR$MONTH.p2

# setup species list
setenv TYPE  AVG
setenv VFILE $INFILE
setenv DSCR $WCDIR/post/tmp1_ac_$YEAR$MONTH
source /home/bkx/cmaq/misc/varas.csh

run_hr2day.csh >& log/run_hr2day_aconc.log.$YEAR$MONTH

#===========================================================================
# hr2day ozone

setenv USELOCAL      Y
setenv USEDST        N
setenv START_HOUR    0
setenv END_HOUR     23
setenv HOURS_8HRMAX 24

setenv INFILE    $OUTDIR/combine_aconc$SFX$YEAR$MONTH
setenv M3_FILE_1 $INFILE
setenv OUTFILE   $OUTDIR/hr2day_O3_LST$SFX$YEAR$MONTH.p2

# clear any previous SPECIES_n settings
\rm -f unset_$YEAR$MONTH.scr
touch  unset_$YEAR$MONTH.scr
echo 'now unsetenv SPECIES_1 to 2000'
set n = 1
while ( $n < 2001 )
echo "unsetenv SPECIES_$n" >> unset_$YEAR$MONTH.scr
@ n += 1
end
source unset_$YEAR$MONTH.scr

# setup species list
setenv SPECIES_1 "O3_8HRMAX,ppbV,O3,8HRMAX"
setenv SPECIES_2 "O3_8HRMAX_HR,hour,O3,HR@8HRMAX"
setenv SPECIES_3 "O3_AVG,ppbV,O3,AVG"
setenv SPECIES_4 "O3_HRMAX,ppbV,O3,MAX"

run_hr2day.csh >& log/run_hr2day_o3.log.$YEAR$MONTH

#===========================================================================
# hr2day 10to17 ozone

setenv USELOCAL      Y
setenv USEDST        N
setenv START_HOUR   10
setenv END_HOUR     17
setenv HOURS_8HRMAX na

setenv INFILE    $OUTDIR/combine_aconc$SFX$YEAR$MONTH
setenv M3_FILE_1 $INFILE
setenv OUTFILE   $OUTDIR/hr2day_O3_LST_10to17$SFX$YEAR$MONTH.p2

# clear any previous SPECIES_n settings
\rm -f unset_$YEAR$MONTH.scr
touch  unset_$YEAR$MONTH.scr
echo 'now unsetenv SPECIES_1 to 2000'
set n = 1
while ( $n < 2001 )
echo "unsetenv SPECIES_$n" >> unset_$YEAR$MONTH.scr
@ n += 1
end
source unset_$YEAR$MONTH.scr

# setup species list
setenv SPECIES_1 "O3_AVG8,ppbV,O3,AVG"

run_hr2day.csh >& log/run_hr2day_o3_10to17.log.$YEAR$MONTH

#============================================================================
# take off the prevday and lastday (.p2) from hr2day files with m3xtract

set afile = $OUTDIR/hr2day_avg_aconc_LST$SFX$YEAR$MONTH
setenv INFILE  $afile.p2
setenv OUTFILE $afile
m3xtr.csh >& log/m3xtr_aconc.log.$YEAR$MONTH

set afile = $OUTDIR/hr2day_O3_LST$SFX$YEAR$MONTH
setenv INFILE  $afile.p2
setenv OUTFILE $afile
m3xtr.csh >& log/m3xtr_o3.log.$YEAR$MONTH

set afile = $OUTDIR/hr2day_O3_LST_10to17$SFX$YEAR$MONTH
setenv INFILE  $afile.p2
setenv OUTFILE $afile
m3xtr.csh >& log/m3xtr_o3_10to17.log.$YEAR$MONTH

#============================================================================

if ( $status == 0 ) touch log/done_$YEAR$MONTH

exit
