#!/bin/csh -f

cat $0

echo " ************************************************************* "

unset verbose
set echo
echo

set uid = bkx
#set uid = hnf

set scenlist = ( dummy1      \
                 2016fm      \
                 2055fm_ref  \
		 dummy4      \
                 2055fm_ldlb \
                 2055fm_ldhb \
		 dummy7      \
		 2055fm_ldlb_onronly \
		 2055fm_hdhb \
		 2055fm_hdlb )

#foreach t (2 3 5 6)
foreach t (2)
  
  set SCEN1 = ${scenlist[${t}]}
  set tdir = task${t}.${SCEN1}
  
# set MODEL = CAMx ; set BDRY = 1
  set MODEL = CMAQ ; set BDRY = 0
  set SCENx = _16j_cb6r3_ae7_aq_nvpoa
  set SCEN  = ${SCEN1}${SCENx}
  set VRSN  = v532_m3dry
  
  set WO    = 280.2
  set GRID  = 12US2
  set YEAR  = `echo $SCEN1 | cut -c1-4`
  set BASE  = 2016
  
  set BASEDIR = [ENTER CORRECT PATHNAME]
  set EXECDIR = /usr/local/apps/ioapi-3.2/intel-17.0/bin
  set WORKDIR = $BASEDIR/${WO}/SMAT-CE/make_inputs
  set INDIR   = $WORKDIR/1.POST/${tdir}
  set OUTDIR  = $INDIR
  
  foreach RANGE (MaySep AprSep JunAug)
# foreach RANGE (JunAug)
    
    if ($RANGE == 'MaySep') then
      set mm_list = (05 06 07 08 09)
      set mtom    = '5-9'
      set ndays   = 153
      set flag    = ''
      set o3vars  = (O3_8HRMAX)
    else if ($RANGE == 'AprSep') then
      set mm_list = (04 05 06 07 08 09)
      set mtom    = '4-9'
      set ndays   = 183
      set flag    = ''
      set o3vars  = (O3_8HRMAX O3_HRMAX)
    else if ($RANGE == 'JunAug') then
      set mm_list = (06 07 08)
      set mtom    = '6-8'
      set ndays   = 92
      set flag    = '10to17_'
      set o3vars  = (O3_AVG8)
    endif
    
    foreach O3VAR (${o3vars})
      
      set cr =
      set allvar = "-1"
      set alllay = 0
      set O3 = 1    # for O3_AVG8 and O3_8HRMAX in their respective ncf files
      if ($O3VAR == 'O3_HRMAX')  set O3 = 4      
      setenv OUTFILE $OUTDIR/hr2day_O3_LST_${flag}${SCEN}.${VRSN}.${GRID}_35_${BASE}.${RANGE}.${O3VAR}
      
      foreach MONTH (${mm_list})
        
        # Needed julian day values by month (apply for leap year only)
        #
        if ( $MONTH == 01 ) then
         set juladd = 1
         set numday = 31
        else if ( $MONTH == 02 ) then
         set juladd = 32
         set numday = 29
        else if ( $MONTH == 03 ) then
         set juladd = 61
         set numday = 31
        else if ( $MONTH == 04 ) then
         set juladd = 92
         set numday = 30
        else if ( $MONTH == 05 ) then
         set juladd = 122
         set numday = 31
        else if ( $MONTH == 06 ) then
         set juladd = 153
         set numday = 30
        else if ( $MONTH == 07 ) then
         set juladd = 183
         set numday = 31
        else if ( $MONTH == 08 ) then
         set juladd = 214
         set numday = 31
        else if ( $MONTH == 09 ) then
         set juladd = 245
         set numday = 30
        else if ( $MONTH == 10 ) then
         set juladd = 275
         set numday = 31
        else if ( $MONTH == 11 ) then
         set juladd = 306
         set numday = 30
        else if ( $MONTH == 12 ) then
         set juladd = 336
         set numday = 30
        else
         echo " ========= MONTH MUST BE BETWEEN 1-12  =========="
         exit (1)
        endif
        
        @ duration = ${numday} * 24	# calculate the number of hours in the month for m3xtract
        
        echo; echo " STATUS:   Running m3xtract for SCEN: "$SCEN1" // for RANGE: "$RANGE" // for MONTH: "$MONTH" // for O3VAR: "$O3VAR; echo
        
        setenv INFILE   $INDIR/O3.${uid}/hr2day_O3_LST_${flag}${SCEN}.${VRSN}.${GRID}_35_${BASE}${MONTH}
	
##########################################################
$EXECDIR/m3xtract INFILE OUTFILE << ieof
$alllay
$O3

0


${duration}0000
ieof
##########################################################
	
      end #MONTH loop

    end #O3VAR loop
    
  end #month RANGE loop
  
end #scenario loop, actually as t (for task#) loop

echo; echo " STATUS:   Finished m3xtract script"; echo


exit
