%let base=.;

options nosymbolgen mprint mlogic errors=6;

***********************************************;

%MACRO program;

%macro qa1(modl,ocspec,scen);

  %let grid=12US2;
  %let yyyy=%SUBSTR(&scen.,1,4);

  filename lrg&yyyy. "[ENTER CORRECT PATHNAME]/smat.PM.&modl..&grid..&scen..csv";

  data lrgfil(drop=type lat lon);
    length colrow 4. date 5. crustal nh4 so4 ec no3 oc pm25 cm 5.;
    infile lrg&yyyy. firstobs=3 dlm=',' dsd;
    input colrow type $ lat lon date crustal nh4 so4 ec no3 oc pm25 cm;
    spec_sum=sum(crustal,nh4,so4,ec,no3,oc);
    diff=pm25-spec_sum;
  run;
  
  proc means n nmiss min max mean median;
    title "&modl. &scen. PM Large File (using &ocspec.)";
  run;

%mend qa1;
************;

%qa1(CMAQ,PM25_OM,2016gf_v7.10_CB6r5)
%qa1(CMAQ,PM25_OM,2026gf_v7.10_CB6r5)

%MEND program;
%program
