
      PROGRAM extract_aot_pbl_cld

      !-------------------------------------------------------------------------
      ! Descriptions:
      !    To extract aot, pbl and cld frac from cctm and mcip output files for airplane 
      !    measurement comparison.
      !
      ! Preconditions required:
      !
      ! Functions and subroutines called:
      !
      ! Revision history:
      !    Created Apr 15, 2008 D. Yin, ARB
      !--------------------------------------------------------------------------

      IMPLICIT none

      !includes

      INCLUDE 'PARMS3.EXT'      ! I/O API constants
      INCLUDE 'FDESC3.EXT'      ! I/O API file description data structure
      INCLUDE 'IODECL3.EXT'     ! I/O API function declarations

      !parameters
      CHARACTER(LEN=16), PARAMETER :: met_cro_2d='met_cro_2d' !met data file from mcip
      CHARACTER(LEN=16), PARAMETER :: m3_aot='m3_aot'         !aq data from cctm
      CHARACTER(LEN=16), PARAMETER :: pname='extract_aot_pbl' !caller

      !externals and their descriptions
      INTEGER, EXTERNAL :: GETEFILE
      !LOGICAL, EXTERNAL :: INTERPX
      

      CHARACTER(LEN=20) :: gname                              !grid name       
      CHARACTER(LEN=120) :: iname                             !input file name
      CHARACTER(LEN=120) :: oname                             !output file name

      INTEGER :: dev_in, dev_out                              !file units

      INTEGER :: day                                          !day of year
      INTEGER :: status
      !INTEGER :: xstat1
      INTEGER :: ncols,nrows
      INTEGER :: strtcol, endcol, strtrow, endrow
      INTEGER :: jdate, jtime
    
      REAL :: time, lon, lat, obs_pbl, obs_cld, obs_aot
      REAL :: x_cord, y_cord
 
      CHARACTER(LEN=120) :: xmsg
      
      !                       pbl height in m, cld fraction, aot

      REAL :: mod_pbl, mod_cld, mod_aot

      !start of the executable code
 
      CALL ENVSTR ( 'gname','name of grid','who knows',gname,status)
      IF ( status.NE.0) THEN
         PRINT *, 'Error in getting grid name!'
         STOP
      ENDIF

      CALL ENVSTR('input_data','input data file',' ',iname, status)
      IF ( status.NE.0) THEN
         PRINT *, 'Error in getting input data file name!'
         STOP
      ENDIF

      CALL ENVSTR('output_data','output data file',' ',oname, status)
      IF ( status.NE.0) THEN
         PRINT *, 'Error in getting output data file name!'
         STOP
      ENDIF

      dev_in=GETEFILE( iname,.TRUE., .TRUE., pname)
      IF (dev_in.LT.0) THEN
         PRINT *,'ERROR in opening input data file!'
         STOP
      ENDIF

      dev_out=GETEFILE( oname,.FALSE., .TRUE., pname)
      IF (dev_out.LT.0) THEN
         PRINT *,'ERROR in opening output data file!'
         STOP
      ENDIF

      DO 
         READ(dev_in,*, END=9999) day, time, lon,lat,
     &                            obs_pbl,obs_cld,obs_aot

         print *,day, time, lon,lat,obs_pbl,obs_cld,obs_aot
         jdate=2007*1000+day
         jtime=INT(time)*10000+INT((time-INT(time))*60.)*100+
     &         INT(((time-INT(time))*60.-
     &         INT((time-INT(time))*60.))*60.)
         !print *,jdate,jtime 
         !print *,(time-INT(time))*60.

         CALL latlon2xy(lon,lat,gname,ncols,nrows,x_cord,y_cord)
         x_cord=x_cord-0.5
         y_cord=y_cord-0.5       !dot to cross

         !print *,x_cord,y_cord,'x_cord'

         strtcol=NINT(x_cord)
         endcol=strtcol
         strtrow=NINT(y_cord)
         endrow=strtrow

         IF ( .NOT. INTERPX( met_cro_2d, 'PBL', pname,
     &                    strtcol,endcol, strtrow,endrow, 1,1,
     &                    jdate, jtime, mod_pbl ) ) THEN
            xmsg = 'Could not read PBL from ' // met_cro_2d
            CALL M3EXIT ( pname, jdate, jtime, xmsg, xstat1 )
         ENDIF

         IF ( .NOT. INTERPX( met_cro_2d, 'CFRAC', pname,
     &                    strtcol,endcol, strtrow,endrow, 1,1,
     &                    jdate, jtime, mod_cld ) ) THEN
            xmsg = 'Could not read CFRAC from ' // met_cro_2d
            CALL M3EXIT ( pname, jdate, jtime, xmsg, xstat1 )
         ENDIF


         IF ( .NOT. INTERPX( m3_aot, 'AOT', pname,
     &                    strtcol,endcol, strtrow,endrow, 1,1,
     &                    jdate, jtime, mod_aot ) ) THEN
            xmsg = 'Could not read PBL from ' // met_cro_2d
            CALL M3EXIT ( pname, jdate, jtime, xmsg, xstat1 )
         ENDIF

         print *,'jdate=',jdate,'jtime=',jtime,x_cord,y_cord,mod_aot

         WRITE(dev_out,100)time,obs_pbl,mod_pbl,obs_cld,mod_cld, 
     &                        obs_aot, mod_aot

      ENDDO

 9999 CONTINUE

100   FORMAT (f8.4,2f10.4,4f8.4)

      END 
