
      PROGRAM extract_curtain

      !-------------------------------------------------------------------------
      ! Descriptions:
      !
      ! Preconditions required:
      !
      ! Functions and subroutines called:
      !
      ! Revision history:
      !--------------------------------------------------------------------------

      IMPLICIT none

      !includes

      INCLUDE 'PARMS3.EXT'      ! I/O API constants
      INCLUDE 'FDESC3.EXT'      ! I/O API file description data structure
      INCLUDE 'IODECL3.EXT'     ! I/O API function declarations

      !parameters
      CHARACTER(LEN=16), PARAMETER :: met_cro_2d='met_cro_2d' !met data file from mci      
      CHARACTER(LEN=16), PARAMETER :: gridcro_2d='gridcro_2d' !met data file from mci
      CHARACTER(LEN=16), PARAMETER :: cmaq_conc='cmaq_conc'       !aqCdata from cctm
      CHARACTER(LEN=16), PARAMETER :: metcro_3d='metcro_3d'   !met dataCfrom mcip
      CHARACTER(LEN=16), PARAMETER :: pname='extract_3d' !caller
!      INTEGER, PARAMETER :: NLAY_MET = 34
!      INTEGER, PARAMETER :: PST_SFT  = 8
      INTEGER :: PST_SFT, NOBS
      INTEGER :: NLAY_MET, AGLFLAG

      !externals and their descriptions
      INTEGER, EXTERNAL :: GETEFILE
      CHARACTER*256        MESG
      CHARACTER(LEN=20) :: gname                              !grid name  
      CHARACTER(LEN=20) :: nlayers     
      CHARACTER(LEN=20) :: tzone
      CHARACTER(LEN=20) :: numberobs
      CHARACTER(LEN=20) :: aglopt
      CHARACTER(LEN=120) :: iname                             !input file name
      CHARACTER(LEN=120) :: oname                             !output file name
      INTEGER :: dev_in, dev_out                              !file units

      INTEGER :: day                                          !day of year
      INTEGER :: status
      INTEGER :: ncols,nrows
      INTEGER :: strtcol, endcol, strtrow, endrow
      INTEGER :: jdate, jtime
      real    :: jtimereal
    
      INTEGER :: utc, jday
      REAL :: height, lon, lat
      REAL :: mod_conc, ht, value
      REAL :: x_cord, y_cord
!      real :: zf(NLAY_MET),pres(NLAY_MET)
      real, ALLOCATABLE ::  zf(:),pres(:),obsvals(:)
      INTEGER :: z,iz,ilay,ispec,i
      CHARACTER*4 :: unit(13)
      REAL, ALLOCATABLE :: dummy ( : , : , : )     
      REAL, ALLOCATABLE :: dummy2 ( : , : , : )
      REAL, ALLOCATABLE :: dummy3 ( : , : )
      CHARACTER(LEN=120) :: xmsg

      INTEGER, PARAMETER :: NSPC = 19
      CHARACTER species(NSPC)
      DATA species /'NO',   'NO2',  'O3',   'CO',   'HNO3', 'SO2',
     &              'NH3',  'N2O5', 'HONO', 'FORM', 'MEOH', 'PAN', 
     &              'ETH', 'ISOP',  'TERP', 'ETOH', 'ETHA', 'HCL', 
     &              'BENZENE'/

      !start of the executable code
 
      CALL ENVSTR ( 'gname','name of grid','who knows',gname,status)
      IF ( status.NE.0) THEN
         PRINT *, 'Error in getting grid name!'
         STOP
      ENDIF

      CALL ENVSTR('input_data','input data file',' ',iname, status)
      IF ( status.NE.0) THEN
         PRINT *, 'Error in getting input data file name!'
         STOP
      ENDIF

      CALL ENVSTR('output_data','output data file',' ',oname, status)
      IF ( status.NE.0) THEN
         PRINT *, 'Error in getting output data file name!'
         STOP
      ENDIF

      CALL ENVSTR('numberobs','# of obs',' ',numberobs, status)
      IF ( status.NE.0) THEN
         PRINT *, 'Error in getting NOBS!'
         STOP
      ENDIF

       read(numberobs, *) NOBS
       write(*,*) 'Number of observations:',NOBS

      allocate ( obsvals(NOBS))

      CALL ENVSTR('nlayers','# of vert. layers',' ',nlayers, status)
      IF ( status.NE.0) THEN
         PRINT *, 'Error in getting NLAY_MET!'
         STOP
      ENDIF

       read(nlayers, *) NLAY_MET
       write(*,*) 'Number of vertical layers:',NLAY_MET
 
      allocate ( zf(NLAY_MET))
      allocate ( pres(NLAY_MET))

      CALL ENVSTR('tzone','time zone shift',' ',tzone, status)
      IF ( status.NE.0) THEN
         PRINT *, 'Error in getting PST_SFT!'
         STOP
      ENDIF

       read(tzone, *) PST_SFT 
       write(*,*) 'time zone shift:',PST_SFT


      CALL ENVSTR('aglopt','above ground level',' ',aglopt, status)
      IF ( status.NE.0) THEN
         PRINT *, 'Error in getting AGL flag!'
         STOP
      ENDIF

       read(aglopt, *) AGLFLAG 
       write(*,*) 'above ground level obs?(1=YES,0=MSL):',AGLFLAG


      dev_in=GETEFILE( iname,.TRUE., .TRUE., pname)
      IF (dev_in.LT.0) THEN
         PRINT *,'ERROR in opening input data file!'
         STOP
      ENDIF

      dev_out=GETEFILE( oname,.FALSE., .TRUE., pname)
      IF (dev_out.LT.0) THEN
         PRINT *,'ERROR in opening output data file!'
         STOP
      ENDIF

      IF ( .NOT. OPEN3( cmaq_conc, FSREAD3, PNAME ) ) THEN
          MESG = 'Could not open file "'//TRIM(iname)//'" for input'
          CALL M3EXIT( PNAME, 0, 0, MESG, 2 )
      ENDIF
      IF ( .NOT. DESC3(cmaq_conc) ) THEN
          MESG = 'Could not get desc of "'//TRIM(iname)//'"'
          CALL M3EXIT( PNAME, 0, 0, MESG, 2 )
      ENDIF

      DO I = 1,NVARS3D
        IF(UNITS3D(I) .EQ. "micrograms/m**3") UNITS3D(I) = "ug/m**3"
      ENDDO

      write(dev_out,102) 's','day ','hour ','deg','deg','m', 'col', 
     &                   'row', 'lay', (('unknown'),i=1,NOBS),
     &  (TRIM(UNITS3D(I)),I=1,NVARS3D)


      write(dev_out,101) 'UTC','JDAY','Time','LAT','LONG','Height',
     &            'COL', 'ROW', 'OBSLAY','MODLAY',(('OBS'),i=1,NOBS),
     &   (TRIM(VNAME3D(I)),I=1,NVARS3D)

c      write(dev_out,102) 's','day ','hour ','deg','deg','m', 'col', 
c     &                   'row', 'lay',
c     &  (TRIM(UNITS3D(I)),I=1,NVARS3D)


      read(dev_in,*)
      DO 
         READ(dev_in,*, END=9999)  jday,utc,lat,lon,height,
     &     (obsvals(i),i=1,NOBS)  

c         print*, 'jday: ', jday, 'utc: ', utc
c         print*, 'lon: ',  lon,  'lat: ', lat, 'hgh: ', height
c         jdate=2010*1000+jday
         jdate=jday !changed obs format to provide correct date format

cjk      using this integer value means we are not interpolating
cjk      in time in interpx call below, right?
cjk         jtime = utc/3600*10000  ! integer
         jtime = NINT(utc / 3600.0) * 10000  ! integer
         jtimereal = utc / 3600.0 - PST_SFT
         print*, 'jtime_utc: ', jtime, 'jtimereal_pst: ', jtimereal

         if (jtimereal .lt. 0) then
           jdate = jdate+1
         endif

         CALL latlon2xy(lon,lat,gname,ncols,nrows,x_cord,y_cord)
         x_cord=x_cord-0.5
         y_cord=y_cord-0.5       !dot to cross

         print*,lat,lon,gname,ncols,nrows
         print*, 'x_cord: ', x_cord, 'y_cord: ', y_cord

         strtcol=NINT(x_cord)
         endcol=strtcol
         strtrow=NINT(y_cord)
         endrow=strtrow

         ALLOCATE ( dummy(1,1,NLAY_MET))
         ALLOCATE ( dummy3(NCOLS,NROWS))

         print*, 'stcol: ', strtcol, 'endcol: ', endcol
         print*, 'strow: ', strtrow, 'endrow: ', endrow

         IF (STRTCOL .LT. 1 .OR. STRTCOL .GT. NCOLS .OR. STRTROW .LT. 1
     &       .OR. STRTROW .GT. NROWS .OR. ENDCOL .GT. NCOLS 
     &       .OR. ENDROW .GT. NROWS ) THEN
c          PRINT*,STRTCOL,STRTROW
c          pause
          ZF = -999.99
          MOD_CONC = -999.99
          HT = -999.0
          GOTO 999
         ENDIF

         IF ( .NOT. INTERPX( metcro_3d, 'ZF', pname,
     &                    strtcol,endcol, strtrow,endrow, 1,NLAY_MET,
     &                    jdate, jtime, dummy(1,1,1:NLAY_MET) ) ) THEN
            xmsg = 'Could not read zf from ' // metcro_3d
            CALL M3EXIT ( pname, jdate, jtime, xmsg, xstat1 )
         ENDIF

         zf = dummy(1,1,1:NLAY_MET)        


      IF ( .NOT. INTERP3( gridcro_2d , 'HT' , pname,
     &                    JDATE, JTIME, NCOLS * NROWS,
     &                    dummy3 ) ) THEN
                CALL M3ERR( pname, JDATE, JTIME,
     &                      'Could not read HT from ' // gridcro_2d,
     &                      .TRUE. )
      END IF      !  if INTERP3 failed

         ht = dummy3(strtcol,strtrow)

         if(AGLFLAG.eq.1) then 
          ! provided heights are above ground level so no adjustments needed
         else
          ! provided heights are above sea level so substract terrain height from observed height
          height = height - ht
          if(height.le.0) then
           height = 1.0
          endif
         endif


         do iz = 1,NLAY_MET-1
c           print*, zf(iz), zf(iz+1)
           if (height .gt. zf(iz).and.height.le.zf(iz+1)) then
             ilay = iz+1
c             print*,ilay
             exit
           endif
           if (height .gt. 0. .and. height.le.zf(1)) then
             ilay = 1
           endif
         enddo

         print*,"height= ",height,"is at layer ",ilay


         do iz = 1, NLAY_MET-1
         do ispec = 1,NVARS3D

         IF ( .NOT. INTERPX( cmaq_conc, VNAME3D(ISPEC), pname,
     &                    strtcol,endcol, strtrow,endrow, iz,iz,
     &                    jdate, jtime, mod_conc ) ) THEN
            CALL M3EXIT ( pname, jdate, jtime, xmsg, xstat1 )
         ENDIF

 
        if (ispec .eq. 1) then
         WRITE(dev_out,200) utc, jday, jtimereal, lat, lon, height, 
     &          strtcol, strtrow, ilay, iz
         WRITE(dev_out,301) (obsvals(i),i=1,NOBS)
        endif

200     format(i6,',',i7,',',4(f10.4,','),2(i3,','),i2,',',i2,$)

         WRITE(dev_out,300) mod_conc
        enddo !ispec

         write(dev_out,*) !newline
        enddo !nlays


999     write(*,*) 
c        write(dev_out,*) !newline
        DEALLOCATE (dummy)
        DEALLOCATE (dummy3)

      ENDDO

 9999 CONTINUE

100   FORMAT (f8.4,2f15.4,4f8.4)
300   format(','E12.4,$)
301   format(','f12.4,$)
101   format(a6,',',a5,',',7(a12,','),135(a8,','),a8)
102   format(a6,',',a5,',',7(a12,','),135(a12,','),a12)

      END 
