
        INTEGER FUNCTION GETFLINE( IDEV, DESCRIPT )

!***********************************************************************
!  function body starts at line
!
!  DESCRIPTION: 
!     Counts the number of lines in an ASCII file
!
!  PRECONDITIONS REQUIRED:
!     File opened and unit number provided
!
!  SUBROUTINES AND FUNCTIONS CALLED:  M3EXIT
!
!  REVISION  HISTORY:
!       prototype 10/98 by M Houyoux
!
!***********************************************************************
!
! Project Title: Sparse Matrix Operator Kernel Emissions (SMOKE) Modeling
!                System
! File: @(#)$Id: getfline.f,v 1.2 1999/11/23 12:46:31 mhouyoux Exp $
!
! COPYRIGHT (C) 1999, MCNC--North Carolina Supercomputing Center
! All Rights Reserved
!
! See file COPYRIGHT for conditions of use.
!
! Environmental Programs Group
! MCNC--North Carolina Supercomputing Center
! P.O. Box 12889
! Research Triangle Park, NC  27709-2889
!
! env_progs@mcnc.org
!
! Pathname: $Source: /afs/isis/depts/cep/emc/apps/archive/edss_tools/edss_tools/src/lib/getfline.f,v $
! Last updated: $Date: 1999/11/23 12:46:31 $ 
!
!****************************************************************************

        IMPLICIT NONE

!...........   ARGUMENTS and their descriptions:

        INTEGER       IDEV         ! Unit number for ASCII file
        CHARACTER*(*) DESCRIPT     ! Description of file

!...........   EXTERNAL FUNCTIONS:
        INTEGER    TRIMLEN

        EXTERNAL   TRIMLEN

!...........   LOCAL VARIABLES their descriptions:

        INTEGER       L1           ! length of DESCRIPT
        INTEGER       ICNT         ! line counter
        INTEGER       IOS          ! i/o status

        CHARACTER*1   BUFFER       ! ASCII LINE from X-ref file
        CHARACTER*256 MESG         ! Message buffer

        CHARACTER*16 :: PROGNAME = 'GETFLINE' ! program name

!***********************************************************************
!   begin body of subroutine GETFLINE

        L1 = TRIMLEN( DESCRIPT )

        REWIND( IDEV )

        ICNT = 0

!.........  Loop through lines of file, counting the lines
11      CONTINUE

            READ( IDEV, 93000, IOSTAT=IOS, END=22 ) BUFFER
 
            ICNT = ICNT + 1
 
            IF ( IOS .GT. 0 ) THEN
                WRITE( MESG,94010 )  &
                      'I/O error', IOS, &
                      'scanning ' // DESCRIPT( 1:L1 ) // &
                      ' file at line', ICNT  
                CALL M3EXIT( PROGNAME, 0, 0, MESG, 2 )
            END IF

        GO TO 11

22      CONTINUE

        GETFLINE = ICNT  

        REWIND( IDEV )

        RETURN

!******************  FORMAT  STATEMENTS   ******************************

!...........   Formatted file I/O formats............ 93xxx

93000   FORMAT( A )

!...........   Internal buffering formats.............94xxx
 
94010   FORMAT( 10( A, :, I6, :, 2X ) )

        END
