SUBROUTINE interpv_linear( num_source_layer, source_data, source_layer,num_target_layer,target_data,target_layer )
   !------------------------------------------------------------------------
   ! Description:
   !    carry out vertical linear interpolation
   ! 
   ! Preconditions required:
   ! 
   !
   ! Subroutines and functions called:
   !          
   ! 
   ! Revision history:
   !    Created   Nov 7, 2003  D. YIN
   !    Modified for dylib  July 28, 2004  D. YIN
   !-----------------------------------------------------------------------
 
   IMPLICIT none

   !---arguments and their descriptions 
   INTEGER, INTENT(IN) :: num_source_layer                       ! number of source levels
   REAL, INTENT(IN)    :: source_data(num_source_layer)          ! source data
   REAL, INTENT(IN)    :: source_layer(num_source_layer)         ! source level value( height ...)
   INTEGER, INTENT(IN) :: num_target_layer                       !number of target levels
   REAL, INTENT(OUT)   :: target_data(num_target_layer)          ! target data
   REAL, INTENT(IN)    :: target_layer(num_target_layer)         ! target level value( height ...)

   !---local variables
   INTEGER :: layerHigh_kk
   INTEGER :: layerLow_kk 
   INTEGER :: k_loop, k_loop2
   CHARACTER (LEN=256) :: mesg
   CHARACTER (LEN=40) :: program='interpv_linear'
 
   !---start of executable code

   DO k_loop=1, num_target_layer

      DO k_loop2=1, num_source_layer              ! assume values of layer levels (either sigma or height)
                                                  ! increase  as k_loop2 increases
         IF(source_layer(k_loop2) >= target_layer(k_loop)) EXIT
         IF(k_loop2 == num_source_layer) THEN
           target_data(k_loop)=99999.
           GO TO 30                               ! no extrapolation above the source data top 
         ENDIF
      ENDDO

      IF(k_loop2 /=1) THEN
         layerLow_kk=k_loop2-1
         layerHigh_kk=k_loop2
      ELSE
         layerLow_kk=k_loop2
         layerHigh_kk=k_loop2+1
      ENDIF

      ! weighted interpolation
      target_data(k_loop)= &
         ((source_layer(layerHigh_kk)-target_layer(k_loop))*source_data(layerLow_kk) &
         +(target_layer(k_loop)-source_layer(layerLow_kk))*source_data(layerHigh_kk)) &
         /(source_layer(layerHigh_kk)-source_layer(layerLow_kk))

30 CONTINUE
   ENDDO  !k_loop

END SUBROUTINE interpv_linear
