SUBROUTINE latlon2xy (lon,lat,gname,ncols,nrows,x_cord,y_cord)
   !-------------------------------------------------------------------------
   ! Description:
   !    Calculate x and y dot point coordinates for a pair of lat and lon in 
   !    a domain grid named as gname
   ! 
   ! Preconditions required:
   !
   ! 
   ! Subroutines and functions called:
   !    DSCGRID, LAMBERT, LL2LAM
   !
   ! Revision history:
   !    Created  28 Jul 2004 D.Yin
   !-------------------------------------------------------------------------

   IMPLICIT none

   ! arguments and their descriptions 
   REAL, INTENT (IN)               :: lat, lon                  ! lat and lon of the station
   CHARACTER (LEN=16), INTENT (IN) :: gname                     ! name of the grid
   INTEGER, INTENT (OUT)           :: ncols, nrows              ! col, row number of the grid
   REAL, INTENT (OUT)              :: x_cord, y_cord            ! dot point coordinates of the station in the grid

   ! local variables and their descriptions        
   CHARACTER (LEN=16)              :: cname                     ! coordinate name (projection)
   REAL*8                          :: p_alp,p_bet,p_gam         ! three map projection descriptive parameters
   REAL*8                          :: xcent,ycent               ! central lat and lon of the projection
   REAL*8                          :: xorig,yorig               ! x and y origin in the grid
   REAL*8                          :: xcell,ycell               ! x and y cell size in m
   INTEGER                         :: ctype                     ! projection type
   INTEGER                         :: nthick                    ! boundary cell no.
   REAL :: A, B, C, X, Y 

   LOGICAL :: status

   LOGICAL, EXTERNAL :: DSCGRID
   LOGICAL, EXTERNAL :: LAMBERT
   LOGICAL, EXTERNAL :: POLSTE
   LOGICAL, EXTERNAL :: LAM2LL
   LOGICAL, EXTERNAL :: LL2LAM

   status=DSCGRID(gname,cname,ctype,p_alp, p_bet, p_gam, &
                  xcent,ycent,xorig,yorig,xcell,ycell,ncols,nrows,nthick)

   IF( .NOT. status) THEN
      WRITE(*,*) 'run time error in DSCGRID!'
      STOP
   ENDIF

   status=LAMBERT(CNAME,A,B,C,X,Y)

   IF( .NOT. status) THEN
      WRITE(*,*) 'run time error in LAMBERT!'
      STOP
   ENDIF

   status=LL2LAM(lon, lat, x_cord, y_cord)

   IF( .NOT. status) THEN
      WRITE(*,*) 'run time error in LL2LAM!'
      STOP
   ENDIF

   ! convert projection coordinates to dot point coordinates

   x_cord=(x_cord-xorig)/xcell + 1
   y_cord=(y_cord-yorig)/ycell + 1         ! grid : grid spacing 

END SUBROUTINE latlon2xy
