library(maps);
library(mapproj);
library(fields);
library(graphics);
library(rgdal);
library(ncdf4);
library(M3);


## panel 1
source.open <- nc_open(filename="aq.aermodtestcase.12US2.2016.ncf", write=FALSE, readunlim=FALSE)

x.orig.km <- ncatt_get(source.open,varid=0,attname="XORIG")$value/1000
y.orig.km <- ncatt_get(source.open,varid=0,attname="YORIG")$value/1000
x.cell.size <- ncatt_get(source.open,varid=0,attname="XCELL")$value/1000
y.cell.size <- ncatt_get(source.open,varid=0,attname="YCELL")$value/1000
num.grid.x <- ncatt_get(source.open,varid=0,attname="NCOLS")$value
num.grid.y <- ncatt_get(source.open,varid=0,attname="NROWS")$value
x.proj.12 <- seq(from=x.orig.km + x.cell.size/2, length=num.grid.x, by=x.cell.size)
y.proj.12 <- seq(from=y.orig.km + y.cell.size/2, length=num.grid.y, by=y.cell.size)

datavar.array <- ncvar_get(source.open,"CONC")

max(datavar.array)
mean(datavar.array)



source.open <- nc_open(filename="/work/ROMO/users/kpc/flex/aermod2ncf/gridded.test.0p5km.ncf", write=FALSE, readunlim=FALSE)

x.orig.km <- ncatt_get(source.open,varid=0,attname="XORIG")$value/1000
y.orig.km <- ncatt_get(source.open,varid=0,attname="YORIG")$value/1000
x.cell.size <- ncatt_get(source.open,varid=0,attname="XCELL")$value/1000
y.cell.size <- ncatt_get(source.open,varid=0,attname="YCELL")$value/1000
num.grid.x <- ncatt_get(source.open,varid=0,attname="NCOLS")$value
num.grid.y <- ncatt_get(source.open,varid=0,attname="NROWS")$value
x.proj.12 <- seq(from=x.orig.km + x.cell.size/2, length=num.grid.x, by=x.cell.size)
y.proj.12 <- seq(from=y.orig.km + y.cell.size/2, length=num.grid.y, by=y.cell.size)

datavar.array <- ncvar_get(source.open,"CONC")
datavar.array[datavar.array < 0] <- 0

max(datavar.array)
mean(datavar.array)





