       program rfmx

!----------------------------------------------------------------------

c *** Variable declarations
      implicit none
      
      include 'PARMS3.EXT'
      include 'IODECL3.EXT'
      include 'FDESC3.EXT'

      INTEGER :: NCOLS, NROWS, NLAYS, NVARS, JDATE, JTIME, RUNLEN
      INTEGER :: TSTEP, NSTEPS, I,V, T, VMAX, UMAX, DMAX, JSTEP, MXREC
      CHARACTER*16    VNAME( MXVARS3 ) !  list of vble names, from user
      CHARACTER*16    UNITS( MXVARS3 ) !  list of vble units
      CHARACTER*80    VDESC( MXVARS3 ) !  list of vble descs
      CHARACTER*256   MESG    !  buffer for m3exit(), etc

      REAL    :: rlon0,rlat0,tlat1,tlat2,xloc,yloc,rlat,rlon,xpos,ypos
      REAL    :: xorg,yorg,dx,mesh,sum
      INTEGER :: nx,ny,ii,jj,xvars,idate,nfiles
      INTEGER :: c,r,k,j,n,x,icelloff,jcelloff,icount,jcount

      REAL, ALLOCATABLE :: TOTS( :,:,:,:),GRID( :,:,:)
      REAL, ALLOCATABLE :: convfac(:),res(:)
      INTEGER, ALLOCATABLE :: xday(:),xtime(:)

      CHARACTER(LEN=16) :: progname, outfile
      CHARACTER(LEN=180) :: ename(366),land,fname
      CHARACTER(LEN=16), ALLOCATABLE::xname(:), xdesc(:)

      INTEGER :: istatus
      INTEGER :: TRIMLEN
      real       envreal

      EXTERNAL TRIMLEN, envreal


c-----Input variables
      progname = 'MATCHY'
      write(*,*) 'max vars',MXVARS3

      read(*,'(a)') fname
      read(fname,*) rlon0,rlat0,tlat1,tlat2,nx,ny,xorg,yorg,dx
      write(*,'(a,t20,3f10.0)') 'Projection:',rlon0,rlat0,tlat1,tlat2
      write(*,*) 'X and Y cells:',nx,ny
      xorg=xorg*1000.
      yorg=yorg*1000.
      dx=dx*1000.
      write(*,*) 'X orig, Y orig, cell size (m):',xorg,yorg,dx

      read(*,'(a)') outfile
      write(*,*)'Output emissions file:', outfile

      read(*,'(a)') fname
      read(fname,*) nfiles
      write(*,*)'# of input files to matchy:',nfiles

      allocate(convfac(nfiles))
      allocate(res(nfiles))
      allocate(TOTS(nx,ny,300,25)) !third dimension is number of variables

      do n = 1, nfiles
      read(*,'(a)') fname
      read(fname,*) res(n)
      read(*,'(a)') ename(n)
      convfac(n) = (dx/1000)/res(n)
c       write(*,*)'FILE:',ename(n)
c       convfac(n) = 1 / (res(n)/(dx/1000))**2
c       convfac(n) = nint(convfac(n))
       write(*,*)'Mesh factor:',convfac(n)
      enddo

c---- Clear main arrays

        DO R = 1, ny
         DO C = 1, nx
          do V = 1, 300
           do T = 1, 25
           TOTS( C,R,V,T ) = 0.0
           enddo
          ENDDO
         ENDDO
        ENDDO

c---- start processing input files

      do n = 1, nfiles

c---- open file: gridded info

      land = ename(n)

      if ( .not. open3( land, FSREAD3, progname ) ) THEN
         MESG = 'Could not open file "' //
     &   land( 1: TRIMLEN(land))
     &   // '" for input'
         CALL M3EXIT( progname, 0, 0, MESG, 2 )
      end if

      IF ( .NOT. DESC3(land))THEN
         MESG = 'Could not get description info for file "' //
     &            land( 1: TRIMLEN( land) ) //'"'
         CALL M3EXIT( progname, 0, 0, MESG, 2 )
      ENDIF

        NCOLS = NCOLS3D
        NROWS = NROWS3D
        NLAYS = NLAYS3D
        TSTEP = TSTEP3D
        JSTEP = TSTEP3D
        MXREC = MXREC3D
        NVARS = NVARS3D

       write(*,*) NCOLS,NROWS,NLAYS,TSTEP,NVARS3D
       write(*,*) 'Reading model file'

C.......   Get max string-lengths for use in variables-listing:

        VMAX = TRIMLEN( VNAME3D( 1 ) )
        UMAX = TRIMLEN( UNITS3D( 1 ) )
        DMAX = TRIMLEN( VDESC3D( 1 ) )
        DO  I = 1, NVARS3D
            VMAX = MAX( VMAX , TRIMLEN( VNAME3D( I ) ) )
            UMAX = MAX( UMAX , TRIMLEN( UNITS3D( I ) ) )
            DMAX = MAX( DMAX , TRIMLEN( VDESC3D( I ) ) )
        END DO

        WRITE( *,92000 )
     &  ' ', 'The list of variables in this file is:', ' ',
     &  ( VNAME3D( I )( 1:VMAX ) // ' (' //
     &    UNITS3D( I )( 1:UMAX ) // '): ' //
     &    VDESC3D( I )( 1:DMAX ), I = 1, NVARS3D )


        if(n.eq.1) then !first file sets the variable list

         allocate(XNAME(NVARS3D))
         allocate(XDESC(NVARS3D))

         XVARS = NVARS3D
         do X=1, XVARS
         XNAME(X) = VNAME3D(X)
         XDESC(x) = UNITS3D(X)
         enddo

        endif

c------ Read in variables over time

        allocate(GRID(NCOLS3D,NROWS3D,1))

       JDATE = SDATE3D
       JTIME = STIME3D
       write(*,*)'max records',MXREC,JDATE,JTIME

       DO T = 1, MXREC
       write(*,*) 'Reading file at',JDATE,JTIME

         do K = 1, XVARS
         DO V = 1, NVARS3D

          if(VNAME3D(V).eq.XNAME(K)) then !match

            write(*,*),NVARS3D,V,VNAME3D(V),XNAME(K)

            IF ( .NOT. READ3( land, VNAME3D( V ), ALLAYS3,
     &                        JDATE, JTIME, GRID ) ) THEN
                MESG = 'Read failure:  file ' // land //
     &                 ' variable ' // VNAME3D( V )
                CALL M3EXIT( 'VERTOT:VERSTEP', JDATE, JTIME,
     &                       MESG, 2 )
            END IF      !  if read3() failed

c------------matchy  where mesh = 1

        MESH = DX/XCELL3D
        icelloff = INT(ABS(xorg - XORIG3D)/XCELL3D)
        jcelloff = INT(ABS(yorg - YORIG3D)/XCELL3D)
c        icellend = icelloff + nx
c        jcellend = jcelloff + ny

        write(*,*)'Mesh info:',MESH,XCELL3D,DX,icelloff,jcelloff

        if(MESH.eq.1.) then

           DO I = 1, nx
            DO J = 1, ny
            TOTS( I,J,K,T ) = GRID(I+icelloff,J+jcelloff,1) 
            ENDDO
           ENDDO

         endif !end condition mesh=1

c------------- matchy where mesh > 1

        if(MESH.gt.1.) then

        write(*,*)'Temp grid specs:',MESH,int(NROWS3D/MESH),int(NCOLS3D/MESH)
        write(*,*)'X Offset:',icelloff,xorg,XORIG3D,XCELL3D
        write(*,*)'Y Offset:',jcelloff,yorg,YORIG3D,YCELL3D


         jcount = 1
         DO J = 1, int(NROWS3D/MESH)
          icount = 1
          DO I = 1, int(NCOLS3D/MESH)
          sum = 0.

            DO JJ = jcount,jcount+MESH-1
             DO II = icount,icount+MESH-1
             sum = sum + GRID(II,JJ,1)
             ENDDO
            ENDDO

c         write(*,*)'QQ',icelloff+I,jcelloff+J,I,J,II,JJ,icount,jcount
c            TOTS(I,J,K,T) = sum
            TOTS(icelloff/MESH+I,jcelloff/MESH+J,K,T) = sum

 
          icount = icount + MESH
          ENDDO
         jcount = jcount + MESH
         ENDDO

         endif !end condition mesh>1

c------------- matchy where mesh < 1


        if(MESH.lt.1.) then

         jcount = 1
         DO J = 1, NROWS3D
          icount = 1
          DO I = 1, NCOLS3D

          do JJ = jcount,jcount+(nint(1/MESH))-1
          do II = icount,icount+(nint(1/MESH))-1

          TOTS(II,JJ,K,T) = 
     &      GRID(I+icelloff,J+jcelloff,1)/ float( nint(1/MESH) * nint(1/MESH) )

          enddo
          enddo
          
          icount = icount + (nint(1/MESH))
          ENDDO
         jcount = jcount + (nint(1/MESH))
         ENDDO
                
         endif !end condition mesh<1

c------------end matchy part

         endif !end condition on matched variable name to master list

        ENDDO !end loop over variables on file
        enddo !loop over final output set of variables from first file
 
          CALL NEXTIME( JDATE, JTIME, JSTEP )

      enddo !end loop over times

      if ( .not. close3 ( land ) ) THEN
         MESG = 'Could not close file'
         CALL M3EXIT( progname, 0, 0, MESG, 2 )
      end if

       deallocate(GRID)

c----- Loop over the rest of the input files
   
       enddo !end loop over all input files

c------
c------ create output file
c------       
     
c       JDATE = SDATE3D
c       JTIME = STIME3D
c       TSTEP3D = 240000
     
            NCOLS3D = NX
            NROWS3D = NY
            XORIG3D = XORG
            YORIG3D = YORG
            XCELL3D = DX
            YCELL3D = DX
            GDTYP3D = 2
            P_ALP3D = 33.
            P_BET3D = 45.
            P_GAM3D = -97.
            XCENT3D = -97.
            YCENT3D = 40.

c            SDATE3D = SDATE3D
c            STIME3D = STIME3D
            NLAYS3D = 1
            NVARS3D = XVARS

            JDATE = SDATE3D
            JTIME = STIME3D

            DO I = 1, XVARS
                VNAME3D( I ) = XNAME( I )
                UNITS3D( I ) = xdesc(I)
                VDESC3D( I ) = 'Gridded emissions'
                VTYPE3D( I ) = M3REAL  
            END DO     

            DO I = 1, XVARS
             write(*,*)   VNAME3D( I )
             write(*,*)   UNITS3D( I ) 
             write(*,*)   VDESC3D( I ) 
            END DO
                
      if ( .not. open3( outfile, FSCREA3, progname ) ) THEN
          MESG = 'Could not open file "' //
     &     outfile( 1: TRIMLEN(outfile))
     &     // '" for output'
           CALL M3EXIT( progname, 0, 0, MESG, 2 )
      end if    

       DO T = 1, MXREC  !only want 1 hour of averaged data
      write(*,*) 'Reading file at',JDATE,JTIME
                
          do V = 1,XVARS
           write(*,*)VNAME3D(V),UNITS3D(V)

      IF ( .NOT. WRITE3( OUTFILE,VNAME3D(V),JDATE, JTIME, TOTS(1,1,V,T) )) THEN
                 MESG = 'Could not write totals to ' // VNAME3D(V)
                  CALL M3EXIT( 'VERTOT:VERSTEP', JDATE, JTIME,
     &                          MESG, 2 )
                END IF      !  if write3() failed
      
          enddo !end loop over variables


          CALL NEXTIME( JDATE, JTIME, JSTEP )

      enddo !end loop over times





C******************  FORMAT  STATEMENTS   ******************************

C...........   Error and warning message formats..... 91xxx

91000   FORMAT ( //5X , '*** ERROR ABORT in program VERTOT ***',
     &            /5X , A ,
     &           // )        !  generic error message format

C...........   Informational (LOG) message formats... 92xxx

92000   FORMAT ( 5X , A )

92999   FORMAT ( //5X , A, // )

C...........   Formatted file I/O formats............ 93xxx

93000   FORMAT ( A16 )

C...........   Internal buffering formats............ 94xxx

C...........   Miscellaneous formats................. 95xxx

95000   FORMAT ( /5X , A , $ )          !  generic prompt format.


      stop

      END


c-----Start subroutines
      subroutine lcpgeo(iway,phic,xlonc,truelat1,truelat2,xloc,yloc,
     &                  xlon,ylat)
c
c     LCPGEO performs Lambert Conformal to geodetic (lat/lon) translation
c
c     Code based on the TERRAIN preprocessor for MM5 v2.0,
c     developed by Yong-Run Guo and Sue Chen, National Center for
c     Atmospheric Research, and Pennsylvania State University
c     10/21/1993
c
c     Input arguments:
c        iway                Conversion type
c                            0 = geodetic to Lambert Conformal
c                            1 = Lambert Conformal to geodetic
c        phic                Central latitude (deg, neg for southern hem)
c        xlonc               Central longitude (deg, neg for western hem)
c        truelat1            First true latitute (deg, neg for southern hem)
c        truelat2            Second true latitute (deg, neg for southern hem)
c        xloc/yloc           Projection coordinates (km)
c        xlon/ylat           Longitude/Latitude (deg)
c
c     Output arguments:
c        xloc/yloc           Projection coordinates (km)
c        xlon/ylat           Longitude/Latitude (deg)
c
      data conv/57.29578/, a/6370./
c
c-----Entry Point
c
      if (phic.lt.0) then
        sign = -1.
      else
        sign = 1.
      endif
      pole = 90.
      if (abs(truelat1).gt.90.) then
        truelat1 = 60.
        truelat2 = 30.
        truelat1 = sign*truelat1
        truelat2 = sign*truelat2
      endif
      xn = alog10(cos(truelat1/conv)) - alog10(cos(truelat2/conv))
      xn = xn/(alog10(tan((45. - sign*truelat1/2.)/conv)) -
     &         alog10(tan((45. - sign*truelat2/2.)/conv)))           
      psi1 = 90. - sign*truelat1
      psi1 = psi1/conv
      if (phic.lt.0.) then
        psi1 = -psi1
        pole = -pole
      endif
      psi0 = (pole - phic)/conv
      xc = 0.
      yc = -a/xn*sin(psi1)*(tan(psi0/2.)/tan(psi1/2.))**xn
c
c-----Calculate lat/lon of the point (xloc,yloc)
c
      if (iway.eq.1) then
        xloc = xloc + xc
        yloc = yloc + yc
        if (yloc.eq.0.) then
          if (xloc.ge.0.) flp = 90./conv
          if (xloc.lt.0.) flp = -90./conv
        else
          if (phic.lt.0.) then
            flp = atan2(xloc,yloc)
          else
            flp = atan2(xloc,-yloc)
          endif
        endif
        flpp = (flp/xn)*conv + xlonc
        if (flpp.lt.-180.) flpp = flpp + 360.
        if (flpp.gt. 180.) flpp = flpp - 360. 
        xlon = flpp 
c
        r = sqrt(xloc*xloc + yloc*yloc)
        if (phic.lt.0.) r = -r
        cell = (r*xn)/(a*sin(psi1))
        rxn  = 1.0/xn
        cel1 = tan(psi1/2.)*cell**rxn
        cel2 = atan(cel1)
        psx  = 2.*cel2*conv
        ylat = pole - psx
c
c-----Calculate x/y from lat/lon
c
      else
        ylon = xlon - xlonc
        if (ylon.gt. 180.) ylon = ylon - 360.
        if (ylon.lt.-180.) ylon = ylon + 360.
        flp = xn*ylon/conv
        psx = (pole - ylat)/conv
        r = -a/xn*sin(psi1)*(tan(psx/2.)/tan(psi1/2.))**xn
        if (phic.lt.0.) then
          xloc = r*sin(flp)
          yloc = r*cos(flp)
        else
          xloc = -r*sin(flp)
          yloc =  r*cos(flp)
        endif
      endif
c
      xloc = xloc - xc
      yloc = yloc - yc
c
      return
      end

      subroutine caldate(idate)

      integer idate
      dimension nday(12)
      data nday/31,28,31,30,31,30,31,31,30,31,30,31/

c
c-----Entry point
c
c-----If it is already in calender date, return
c

      icent = int(idate/100000)
      iyear = int((idate - icent*100000)/1000)
      jday = idate - icent*100000 - iyear*1000

      nday(2) = 28
      if (mod(iyear,4).eq.0) nday(2) = 29
      mday = 0
      do imonth = 1,12
        mday = mday + nday(imonth)
        if (mday.ge.jday) go to 20
      enddo
 20   iday = jday - (mday - nday(imonth))
      idate = icent*1000000 + iyear*10000 + imonth*100 + iday
c
c      write(*,'(4i6)') icent,iyear,imonth,iday

      return
      end
