        SUBROUTINE CONVERTDATE()

C***********************************************************************
C  DESCRIPTION:
C      This subroutine convert the modelstartdate to 
C       YYYY, DDD and MODELSTARTDATE
C       The converted data is public so all the programs can access
C
C  PRECONDITIONS REQUIRED:
C
C  SUBROUTINES AND FUNCTIONS CALLED:
C      Subroutines: I/O API subroutine
C
C  REVISION  HISTORY:
C      Created 11/2011 by Charles Chang
C
C****************************************************************************/
C.........  MODINFO contains all the public variables
        USE MODINFO

        IMPLICIT NONE

C.........  SUBROUTINE ARGUMENTS

C...........   Other local variables
        INTEGER              :: YR_PART
        CHARACTER(300)       :: MESG             !  message buffer
        CHARACTER(16) :: PROGNAME = 'CONVERTDATE' !  program name

C***********************************************************************
C   begin body of program CONVERTDATE

        DATE3 = MOD(MODELSTARTDATE, 1000)
        YR_PART = (MODELSTARTDATE - DATE3) / 1000

        IF (YR_PART .GT. 80) THEN
           YEAR = 1900 + YR_PART
        ELSE
           YEAR = 2000 + YR_PART
        END IF 
        JULIANDATE = YEAR * 1000 + DATE3
        RETURN

C******************  FORMAT  STATEMENTS   ******************************

C...........   Formatted file I/O formats............ 93xxx
C...........   Internal buffering formats............ 94xxx

94010   FORMAT( 10( A, :, I8, :, 1X ) )

        END SUBROUTINE CONVERTDATE
