        SUBROUTINE MASSCONVERT(OLDMASSUNIT, NEWMASSUNIT, MOLEWEIGHT, MASSRATIO)
!***********************************************************************
!  DESCRIPTION:
!      This function will return a ratio based on the oldmassunit, newmassunit
!        and mole wieght
!
!  PRECONDITIONS REQUIRED:
!
!  SUBROUTINES AND FUNCTIONS CALLED:
!      Subroutines: I/O API subroutine
!
!  REVISION  HISTORY:
!      Created 11/2011 by Charles Chang
!
!****************************************************************************/
!.........  MODINFO contains all the public variables
        USE MODINFO

        IMPLICIT NONE

!...........   SUBROUTINE ARGUMENTS
        CHARACTER(*), INTENT(IN)  :: OLDMASSUNIT
        CHARACTER(*), INTENT(IN)  :: NEWMASSUNIT
        REAL        , INTENT(IN)  :: MOLEWEIGHT
        REAL        , INTENT(OUT) :: MASSRATIO

C...........   Other local variables
        CHARACTER(300)              :: MESG             !  message buffer
        CHARACTER(16)               :: PROGNAME = 'MASSCONVERT' !  program name

C***********************************************************************
C   begin body of program MASSCONVERT
        ! Determine the ratio from different unit
           MASSRATIO = 1.0
           SELECT CASE (OLDMASSUNIT)
              CASE ('MOLES')
                 If (DEBUG .EQ. 2) Then 
                    WRITE(*,*) 'OLD UNIT IS MOLES'
                 End If
                 IF (NEWMASSUNIT .EQ. 'G') THEN
                    MASSRATIO = 1.0 * MOLEWEIGHT
                 ELSE IF (NEWMASSUNIT .EQ. 'KG') THEN
                    MASSRATIO = 1.0 * MOLEWEIGHT / 1000.0
                 ELSE IF (NEWMASSUNIT .EQ. 'TONS') THEN
                    MASSRATIO = 1.0 * MOLEWEIGHT / 907184.74
                 END IF
              CASE ('G')
                 IF (NEWMASSUNIT .EQ. 'G') THEN
                    MASSRATIO = 1.0
                 ELSE IF (NEWMASSUNIT .EQ. 'KG') THEN
                    MASSRATIO = 1.0 / 1000.0
                 ELSE IF (NEWMASSUNIT .EQ. 'TONS') THEN
                    MASSRATIO = 1.0 / 907184.74
                 END IF
              CASE ('KG')
                 IF (NEWMASSUNIT .EQ. 'G') THEN
                    MASSRATIO = 1.0 * 1000.0
                 ELSE IF (NEWMASSUNIT .EQ. 'KG') THEN
                    MASSRATIO = 1.0
                 ELSE IF (NEWMASSUNIT .EQ. 'TONS') THEN
                    MASSRATIO = 1.0 / 907.18474
                 END IF
              CASE ('TONS')
                 IF (NEWMASSUNIT .EQ. 'G') THEN
                    MASSRATIO = 1.0 * 907184.74
                 ELSE IF (NEWMASSUNIT .EQ. 'KG') THEN
                    MASSRATIO = 1.0 * 907.18474
                 ELSE IF (NEWMASSUNIT .EQ. 'TONS') THEN
                    MASSRATIO = 1.0
                 END IF
               CASE DEFAULT
                  WRITE(*,*) 'The program does not support ' // OLDMASSUNIT
     &              // 'to ' // NEWMASSUNIT // ' conversion.'
                  MASSRATIO = 1.0
           END SELECT

        RETURN

C******************  FORMAT  STATEMENTS   ******************************
C...........   Formatted file I/O formats............ 93xxx
93000   FORMAT(A)

        END SUBROUTINE MASSCONVERT
