
        MODULE MODINFO

!***********************************************************************
!  Module body starts at line
!
!  DESCRIPTION:
!     This module contains the public data that is related to
!     WO110.4 utility program
!
!  PRECONDITIONS REQUIRED:
!
!  SUBROUTINES AND FUNCTIONS CALLED:
!
!  REVISION HISTORY:
!     Created 11/2011 by Charles Chang
!
!***************************************************************************
        IMPLICIT NONE

!.........  Variables from emission input file
!........ These variables are read only once they are set from input text file
        INTEGER      , PUBLIC                :: MODELSTARTDATE  ! Start date from emis input file
        INTEGER      , PUBLIC                :: MODELSTARTHOUR  ! Start hour from emis input file
        INTEGER      , PUBLIC                :: NUM_STACKS
        INTEGER      , ALLOCATABLE, PUBLIC   :: STACK_ID(:)
        INTEGER      , ALLOCATABLE, PUBLIC   :: NUM_OF_POL(:)
        REAL         , ALLOCATABLE, PUBLIC   :: X_COORD(:)
        REAL         , ALLOCATABLE, PUBLIC   :: Y_COORD(:)
        REAL         , ALLOCATABLE, PUBLIC   :: LONGITUDE(:)
        REAL         , ALLOCATABLE, PUBLIC   :: LATITUDE(:)
        REAL         , ALLOCATABLE, PUBLIC   :: STK_HT(:)
        REAL         , ALLOCATABLE, PUBLIC   :: STK_DM(:)
        REAL         , ALLOCATABLE, PUBLIC   :: STK_ET(:)
        REAL         , ALLOCATABLE, PUBLIC   :: STK_VE(:)
        REAL         , ALLOCATABLE, PUBLIC   :: STK_FLW(:)
        INTEGER      , PUBLIC                :: YEAR            ! YYYY
        INTEGER      , PUBLIC                :: DATE3           ! DDD
        INTEGER      , PUBLIC                :: JULIANDATE      ! YYYYYDDD format
        INTEGER      , PUBLIC                :: DEBUG           ! Control debug setting
        CHARACTER(16), ALLOCATABLE, PUBLIC   :: POLNAME(:,:)
        INTEGER      , ALLOCATABLE, PUBLIC   :: POLPOSITION(:,:)
        CHARACTER(16), ALLOCATABLE, PUBLIC   :: EMIS_UNIT(:,:)
        REAL         , ALLOCATABLE, PUBLIC   :: DAILY_EMIS(:,:) ! (NUM_STACKS,TOTAL_NUM_POL)
        REAL         , ALLOCATABLE, PUBLIC   :: HR_RATIO(:,:,:) ! (NUM_STACKS,TOTAL_NUM_POL,24)

! .... Environmental Variable
        CHARACTER(16), PUBLIC  :: EMISINPUT
        CHARACTER(16), PUBLIC  :: MODELNAME
        CHARACTER(16), PUBLIC  :: STACK_GROUP
        CHARACTER(16), PUBLIC  :: INLINE_FILE
        CHARACTER(16), PUBLIC  :: IMC_FILE
        CHARACTER(16), PUBLIC  :: SCNNAME
        CHARACTER(16), PUBLIC  :: PTSRC_FILE
        CHARACTER(16), PUBLIC  :: GRIDNAME_INFO   ! This is coming from emis input file
        LOGICAL      , PUBLIC  :: FIPS_SUPPORT    ! Y = user need provide USA_340_NOFILL
                                                  ! N = skip asking user provide above info
        CHARACTER(16), PUBLIC  :: SURGFILE
        CHARACTER(16), PUBLIC  :: PTCOORDTYPE     ! LAMBERT or LATLONG
! .... Domain information
        INTEGER    , PUBLIC    :: CTYPE     !  coord sys type
        REAL       , PUBLIC    :: P_ALP     !  first, second, third map
        REAL       , PUBLIC    :: P_BET     !  projection descriptive
        REAL       , PUBLIC    :: P_GAM     !  parameters
        REAL       , PUBLIC    :: XCENT     !  lon for coord-system X=0
        REAL       , PUBLIC    :: YCENT     !  lat for coord-system Y=0
        REAL       , PUBLIC    :: XORIG     !  X-coordinate origin of grid (map units)
        REAL       , PUBLIC    :: YORIG     !  Y-coordinate origin of grid
        REAL       , PUBLIC    :: XCELL     !  X-coordinate cell dimension
        REAL       , PUBLIC    :: YCELL     !  Y-coordinate cell dimension
        INTEGER    , PUBLIC    :: NCOLS     !  number of grid columns
        INTEGER    , PUBLIC    :: NROWS     !  number of grid rows
        INTEGER    , PUBLIC    :: NTHIK     !  BOUNDARY:  perimeter thickness (cells)

!......... Information from SCICHEM IMC
        CHARACTER(10), ALLOCATABLE, PUBLIC :: IMC_SPECNAME(:)
        CHARACTER,     ALLOCATABLE, PUBLIC :: IMC_SPC_TYPE(:)
        REAL,          ALLOCATABLE, PUBLIC :: IMC_AMB_CONC(:)
        REAL,          ALLOCATABLE, PUBLIC :: IMC_ABS_TOL(:)
        REAL,          ALLOCATABLE, PUBLIC :: IMC_DEP_VEL(:)
        REAL,          ALLOCATABLE, PUBLIC :: IMC_WET_SCA_CO(:)
        REAL,          ALLOCATABLE, PUBLIC :: IMC_MOLEWEIGHT(:)
        INTEGER,                    PUBLIC :: IMC_POL_COUNT
        CHARACTER(16),              PUBLIC :: IMC_EMIS_UNIT
!........ Array for FIPS
        INTEGER,       ALLOCATABLE, PUBLIC :: FIPS(:,:)
        REAL,          ALLOCATABLE, PUBLIC :: SURGRATIO(:,:)

!........ Array for inline file
        CHARACTER(16), ALLOCATABLE, PUBLIC :: MASTERPOLLIST(:)
        INTEGER                   , PUBLIC :: TOTAL_NUM_POL
        INTEGER                   , PUBLIC :: SIZE_OF_MASTERLIST
        CHARACTER(16), ALLOCATABLE, PUBLIC :: CMAQ_EMIS_UNIT(:)

        END MODULE MODINFO
