        SUBROUTINE PARSEUNIT(STRUNIT, STRMASS, STRTIME)
!***********************************************************************
!  DESCRIPTION:
!      This subroutine parse the strunit into mass part and time part
!
!  PRECONDITIONS REQUIRED:
!
!  SUBROUTINES AND FUNCTIONS CALLED:
!      Subroutines: I/O API subroutine
!
!  REVISION  HISTORY:
!      Created 11/2011 by Charles Chang
!
!****************************************************************************/
!.........  MODINFO contains all the public variables
        USE MODINFO

        IMPLICIT NONE

!.........  EXTERNAL FUNCTIONS and their descriptions:
        INTEGER          TRIMLEN
        EXTERNAL         TRIMLEN

!...........   SUBROUTINE ARGUMENTS
        CHARACTER(*), INTENT(IN)  :: STRUNIT
        CHARACTER(*), INTENT(OUT) :: STRMASS
        CHARACTER(*), INTENT(OUT) :: STRTIME

C...........   Other local variables
        INTEGER                     :: L1, L2
        INTEGER                     :: STR_LENGTH
        CHARACTER(300)              :: MESG                   !  message buffer
        CHARACTER(16)               :: PROGNAME = 'PARSEUNIT' !  program name

C***********************************************************************
C   begin body of program PARSEUNIT
        STR_LENGTH = TRIMLEN(STRUNIT)
        L1 = INDEX(STRUNIT,'/',.FALSE.)
        L2 = INDEX(STRUNIT,'/',.TRUE.)
        ! L1 shoulde == L2
        IF (L1 .EQ. L2) THEN
           STRMASS = STRUNIT(1:L1-1)
           STRTIME = STRUNIT(L1+1:STR_LENGTH)
        ELSE
           WRITE(*,*) 'Unit string ' // STRUNIT // ' has error.'
           STRMASS = ' '
           STRTIME = ' '
        END IF

        RETURN

C******************  FORMAT  STATEMENTS   ******************************
C...........   Formatted file I/O formats............ 93xxx
93000   FORMAT(A)

        END SUBROUTINE PARSEUNIT
