        SUBROUTINE RDSCIIMC()
C***********************************************************************
C  DESCRIPTION:
C      This subroutine reads the IMC file for SCICHEM model.
C
C  PRECONDITIONS REQUIRED:
C
C  SUBROUTINES AND FUNCTIONS CALLED:
C      Subroutines: I/O API subroutine
C
C  REVISION  HISTORY:
C      Created 11/2011 by Charles Chang
C
C****************************************************************************/
C.........  MODINFO contains all the public variables
        USE MODINFO

        IMPLICIT NONE

        INCLUDE 'PARMS3.EXT'
        INCLUDE 'FDESC3.EXT'    !  I/O API file description data structures.
        INCLUDE 'IODECL3.EXT'

C.........  EXTERNAL FUNCTIONS and their descriptions:
        INTEGER          PROMPTFFILE
        LOGICAL          GETYN
        INTEGER          TRIMLEN
        REAL             STR2REAL
        EXTERNAL         PROMPTFFILE, GETYN, TRIMLEN, STR2REAL

C...........   Other local variables
        CHARACTER(16)               :: FNAME
        CHARACTER(16)               :: ANAME
        CHARACTER(16)               :: IMCNAME          ! SCICHEM IMC input logical name
        INTEGER                     :: I
        INTEGER                     :: IUNIT            ! Unit number for SCICHEM IMC file
        CHARACTER(300)              :: MESG             !  message buffer
        LOGICAL                     :: LAMSET
        LOGICAL                     :: rdonly, fmtflag
        CHARACTER(300)              :: LINE             !  input file line buffer
        INTEGER                     :: IREC
        INTEGER                     :: IOS
        INTEGER                     :: CONTROLCNT
        CHARACTER(300)              :: LINEBUF
        CHARACTER(40)               :: SEGMENT(7)
        INTEGER                     :: LOC_EMIS_UNIT
        INTEGER                     :: L1, L2


        CHARACTER(16) :: PROGNAME = 'RDSCIIMC' !  program name

C***********************************************************************
C   begin body of program RDSCIIMC
C   calling PROMPTFFILE to get the
        IREC = 0
        CONTROLCNT = 0
        IMC_POL_COUNT = 0
        RDONLY = .TRUE.
        FMTFLAG = .TRUE.
        IMCNAME = 'SCICHEM_IMC'
        MESG = 'Enter logical name of the SCICHEM IMC file '
        IUNIT = PROMPTFFILE(MESG, RDONLY, FMTFLAG, IMCNAME, PROGNAME)
        ! Read IUNIT first time to get how many species are there in this file
        DO
           READ( IUNIT, 93000, END=100) LINE

        ! Check first char if first char == # this is a section flag
           IF (LINE(1:1) == '#') THEN
              CONTROLCNT = CONTROLCNT + 1
           END IF
           ! Following code will get emission_unit from IMC file
           IF (CONTROLCNT == 1 .AND. LINE(1:1) .NE. '#') THEN
              LINEBUF = LINE
              CALL UPCASE(LINEBUF)
              LOC_EMIS_UNIT = INDEX(LINEBUF,'EMISSION_UNITS',.TRUE.)
              IF (LOC_EMIS_UNIT > 0) THEN
                 L1 = INDEX(LINEBUF, "'", .FALSE.)
                 L2 = INDEX(LINEBUF, "'", .TRUE.)
                 IMC_EMIS_UNIT = LINE(L1+1:L2-1)
                 ! WRITE(*,*) 'UNINT = ', IMC_EMIS_UNIT
              END IF
           ELSE IF (CONTROLCNT == 2 .AND. LINE(1:1) .NE. '#') THEN
              IMC_POL_COUNT = IMC_POL_COUNT + 1
           END IF
           IREC = IREC + 1
        END DO
100     CONTINUE

        IF (DEBUG == 1) THEN
           WRITE(*,*) 'TOTAL LINE = ', IREC
           WRITE(*,*) 'TOTAL SPECIES = ', IMC_POL_COUNT
        END IF
        REWIND(IUNIT)
        ! Read IUNIT 2nd time this, this time will build up species table
        ! Allocata memory for following arrays
        ALLOCATE(IMC_SPECNAME(IMC_POL_COUNT))
        ALLOCATE(IMC_SPC_TYPE(IMC_POL_COUNT))
        ALLOCATE(IMC_AMB_CONC(IMC_POL_COUNT))
        ALLOCATE(IMC_ABS_TOL(IMC_POL_COUNT))
        ALLOCATE(IMC_DEP_VEL(IMC_POL_COUNT))
        ALLOCATE(IMC_WET_SCA_CO(IMC_POL_COUNT))
        ALLOCATE(IMC_MOLEWEIGHT(IMC_POL_COUNT))

        IMC_POL_COUNT = 0
        CONTROLCNT = 0
        DO
           READ( IUNIT, 93000, END=100) LINE
           IF (LINE(1:1) == '#') THEN
              CONTROLCNT = CONTROLCNT + 1
           END IF

           ! Following code will build up arrays related SCICHEM IMC file
           IF (CONTROLCNT == 2 .AND. LINE(1:1) .NE. '#' ) THEN
              IMC_POL_COUNT = IMC_POL_COUNT + 1
              CALL PARSLINE(LINE,7,SEGMENT)
              IF (DEBUG == 2 .AND. IMC_POL_COUNT .EQ. 1) THEN
                 DO I = 1, 7
                    WRITE(*,*) 'SEGMENT(',I,') = ', SEGMENT(I)
                 END DO
              END IF
              IMC_SPECNAME(IMC_POL_COUNT)    = SEGMENT(1)
              IMC_SPC_TYPE(IMC_POL_COUNT)    = SEGMENT(2)
              IMC_AMB_CONC(IMC_POL_COUNT)    = STR2REAL(SEGMENT(3))
              IMC_ABS_TOL(IMC_POL_COUNT)     = STR2REAL(SEGMENT(4))
              IMC_DEP_VEL(IMC_POL_COUNT)     = STR2REAL(SEGMENT(5))
              IMC_WET_SCA_CO(IMC_POL_COUNT)  = STR2REAL(SEGMENT(6))
              IMC_MOLEWEIGHT(IMC_POL_COUNT)  = STR2REAL(SEGMENT(7))
            END IF

           IF (CONTROLCNT > 2) THEN
              EXIT
           END IF
        END DO

        IF (DEBUG == 2) THEN
            I = 1
            WRITE(*,*) 'SPECNAME(1) ', IMC_SPECNAME(I)
            WRITE(*,*) 'SPC_TYPE(1) ', IMC_SPC_TYPE(I)
            WRITE(*,*) 'AMB_CONC(1) ', IMC_AMB_CONC(I)
            WRITE(*,*) 'ABS_TOL(1) ', IMC_ABS_TOL(I)
            WRITE(*,*) 'DEP_VEL(1) ', IMC_DEP_VEL(I)
            WRITE(*,*) 'WET_SCA_CO(1)', IMC_WET_SCA_CO(I)
            WRITE(*,*) 'MOLEWEIGHT(1)', IMC_MOLEWEIGHT(I)
        END IF

        RETURN

C******************  FORMAT  STATEMENTS   ******************************
C...........   Formatted file I/O formats............ 93xxx
93000   FORMAT(A)
93010   FORMAT(A10,1X,A1,10X,E11.4,7X,E11.4,2X,F4.1,5X,F4.1,X,F5.2)

C...........   Internal buffering formats............ 94xxx

94010   FORMAT( 10( A, :, I8, :, 1X ) )

        END SUBROUTINE RDSCIIMC
