        SUBROUTINE TIMECONVERT(OLDTIMEUNIT, NEWTIMEUNIT, TIMERATIO)
!***********************************************************************
!  DESCRIPTION:
!      This function will return a ratio based on the oldtimeunit, newtimeunit
!        and mole wieght
!
!  PRECONDITIONS REQUIRED:
!
!  SUBROUTINES AND FUNCTIONS CALLED:
!      Subroutines: I/O API subroutine
!
!  REVISION  HISTORY:
!      Created 11/2011 by Charles Chang
!
!****************************************************************************/
!.........  MODINFO contains all the public variables
        USE MODINFO

        IMPLICIT NONE

!.........  EXTERNAL FUNCTIONS and their descriptions:
        INTEGER          TRIMLEN
        EXTERNAL         TRIMLEN

!...........   SUBROUTINE ARGUMENTS
        CHARACTER(*), INTENT(IN)  :: OLDTIMEUNIT
        CHARACTER(*), INTENT(IN)  :: NEWTIMEUNIT
        REAL        , INTENT(OUT) :: TIMERATIO

C...........   Other local variables
        CHARACTER                   :: SHORTUNITOLD
        CHARACTER                   :: SHORTUNITNEW
        CHARACTER(300)              :: MESG                     !  message buffer
        CHARACTER(16)               :: PROGNAME = 'TIMECONVERT' !  program name

C***********************************************************************
C   begin body of program TIMECONVERT
       ! Determine the ratio from different unit
      TIMERATIO = 1.0
      ! CONVERT OLDUNIT_TIME AND SHORTUNITNEW to a short version
      CALL TOSHORTUNIT(OLDTIMEUNIT,SHORTUNITOLD)
      CALL TOSHORTUNIT(NEWTIMEUNIT,SHORTUNITNEW)
      SELECT CASE (SHORTUNITOLD)
         CASE ('S')
            IF (SHORTUNITNEW .EQ. 'S') THEN
               TIMERATIO = 1.0
            ELSE IF  (SHORTUNITNEW .EQ. 'M') THEN
               TIMERATIO = 1.0 / 60.0
            ELSE IF (SHORTUNITNEW .EQ. 'H') THEN
               TIMERATIO = 1.0 / 3600.0
            END IF
         CASE ('M')
            IF (SHORTUNITNEW .EQ. 'S') THEN
               TIMERATIO = 1.0 * 60.0
            ELSE IF  (SHORTUNITNEW .EQ. 'M') THEN
               TIMERATIO = 1.0
            ELSE IF (SHORTUNITNEW .EQ. 'H') THEN
               TIMERATIO = 1.0 / 60.0
            END IF
         CASE ('H')
            IF (SHORTUNITNEW .EQ. 'S') THEN
               TIMERATIO = 1.0 * 3600.0
            ELSE IF  (SHORTUNITNEW .EQ. 'M') THEN
               TIMERATIO = 1.0 * 60.0
            ELSE IF (SHORTUNITNEW .EQ. 'H') THEN
               TIMERATIO = 1.0
            END IF
          CASE DEFAULT
             WRITE(*,*) 'The program does not support ' // OLDTIMEUNIT
     &         // 'to ' // NEWTIMEUNIT // ' conversion.'
             TIMERATIO = 1.0
      END SELECT

!  ******************  INTERNAL SUBPROGRAMS  *****************************
      CONTAINS
      SUBROUTINE TOSHORTUNIT(LONGUNIT,SHORTUNIT)
         CHARACTER(*), INTENT(IN)  :: LONGUNIT
         CHARACTER(*), INTENT(OUT) :: SHORTUNIT

         SELECT CASE (LONGUNIT)
         CASE ('S')
            SHORTUNIT = 'S'
         CASE ('SEC')
            SHORTUNIT = 'S'
         CASE ('M')
            SHORTUNIT = 'M'
         CASE ('MIN')
            SHORTUNIT = 'M'
         CASE ('H')
            SHORTUNIT = 'H'
         CASE ('HR')
            SHORTUNIT = 'H'
         CASE ('HOUR')
            SHORTUNIT = 'H'
         END SELECT

         END SUBROUTINE TOSHORTUNIT

C******************  FORMAT  STATEMENTS   ******************************

        END SUBROUTINE TIMECONVERT
