        SUBROUTINE UNITCONVERT(OLDUNIT, NEWUNIT, MOLEWEIGHT, RATIO)
C***********************************************************************
C  DESCRIPTION:
C      This function will return a ratio based on  the oldunit, newunit
C        and mole wieght
C
C  PRECONDITIONS REQUIRED:
C
C  SUBROUTINES AND FUNCTIONS CALLED:
C      Subroutines: I/O API subroutine
C
C  REVISION  HISTORY:
C      Created 11/2011 by Charles Chang
C
C****************************************************************************/
C.........  MODINFO contains all the public variables
        USE MODINFO

        IMPLICIT NONE

        INCLUDE 'PARMS3.EXT'
        INCLUDE 'IODECL3.EXT'

C.........  EXTERNAL FUNCTIONS and their descriptions:
        INTEGER          TRIMLEN
        REAL             STR2REAL
        INTEGER          STR2INT
        EXTERNAL         TRIMLEN, STR2REAL, STR2INT

C...........   SUBROUTINE ARGUMENTS
        CHARACTER(*), INTENT(IN)  :: OLDUNIT
        CHARACTER(*), INTENT(IN)  :: NEWUNIT
        REAL        , INTENT(IN)  :: MOLEWEIGHT
        REAL        , INTENT(OUT) :: RATIO

C...........   Other local variables
        CHARACTER(16)               :: OLDUNIT_MASS
        CHARACTER(16)               :: OLDUNIT_TIME
        CHARACTER(16)               :: NEWUNIT_MASS
        CHARACTER(16)               :: NEWUNIT_TIME
        INTEGER                     :: I
        INTEGER                     :: L1
        INTEGER                     :: UNIT_LENGTH
        INTEGER                     :: STR_LENGTH
        REAL                        :: TIME_CONVERSION
        REAL                        :: MASS_CONVERSION
        CHARACTER(300)              :: MESG             !  message buffer
        CHARACTER(16)               :: PROGNAME = 'UNITCONVERT' !  program name

C***********************************************************************
C   begin body of program UNITCONVERT
        ! Determine the ratio from different unit
        ! Get OLDUNIT_MASS part
        ! Find out / from OLDUNIT
        STR_LENGTH = TRIMLEN(OLDUNIT)
        L1 = INDEX(OLDUNIT,'/',.TRUE.)
        OLDUNIT_MASS = OLDUNIT(1:L1-1)
        WRITE(*,*) 'OLDUNIT_MASS = ', OLDUNIT_MASS
        OLDUNIT_TIME = OLDUNIT(L1+1:STR_LENGTH)
        WRITE(*,*) 'OLDUNIT_TIME = ', OLDUNIT_TIME

        STR_LENGTH = TRIMLEN(NEWUNIT)
        L1 = INDEX(NEWUNIT,'/',.TRUE.)
        NEWUNIT_MASS = NEWUNIT(1:L1-1)
        WRITE(*,*) 'NEWUNIT_MASS = ', NEWUNIT_MASS
        NEWUNIT_TIME = NEWUNIT(L1+1:STR_LENGTH)
        WRITE(*,*) 'NEWUNIT_TIME = ', NEWUNIT_TIME

        IF (OLDUNIT_TIME .EQ. NEWUNIT_TIME) THEN
           WRITE(*,*) 'ONLY CONVERT MASS'
           IF (OLDUNIT_MASS .EQ. 'MOLES' .AND. NEWUNIT_MASS .EQ. 'G') THEN
              RATIO = 1.0 *  MOLEWEIGHT
           ELSE IF (OLDUNIT_MASS .EQ. 'G' .AND. NEWUNIT_MASS .EQ. 'MOLES') THEN
              RATIO = 1.0 / MOLEWEIGHT
           END IF
        ELSE
           WRITE(*,*) 'NEED CONVERT BOTH MASS AND TIME'
        END IF

        RETURN

C******************  FORMAT  STATEMENTS   ******************************
C...........   Formatted file I/O formats............ 93xxx
93000   FORMAT(A)

C...........   Internal buffering formats............ 94xxx

94010   FORMAT( 10( A, :, I8, :, 1X ) )

        END SUBROUTINE UNITCONVERT
