        SUBROUTINE WRINLINE()

!***********************************************************************
!  DESCRIPTION:
!      This subroutine writes a inline emission in ioapi format.
!      The information will come from emission input file in text format
!
!  PRECONDITIONS REQUIRED:
!
!  SUBROUTINES AND FUNCTIONS CALLED:
!      Subroutines: I/O API subroutine
!
!  REVISION  HISTORY:
!      Created 11/2011 by Charles Chang
!
!****************************************************************************/
!.........  MODINFO contains all the public variables
        USE MODINFO

        IMPLICIT NONE

        INCLUDE 'PARMS3.EXT'
        INCLUDE 'FDESC3.EXT'    !  I/O API file description data structures.
        INCLUDE 'IODECL3.EXT'

!.........  EXTERNAL FUNCTIONS and their descriptions:
        CHARACTER*16            PROMPTMFILE
        LOGICAL                 GETYN
        INTEGER                 TRIMLEN
        EXTERNAL                PROMPTMFILE, GETYN, TRIMLEN

!...........   Other local variables
        CHARACTER(16)        :: FNAME
        INTEGER              :: I, J

        CHARACTER(300)       :: MESG             !  message buffer
        INTEGER              :: HOUR_LOOP
        REAL                 :: LAST_HOUR_RATE
        REAL                 :: CONV
        INTEGER              :: JDATE, JTIME
        REAL, ALLOCATABLE    :: DAILYEMIS2HOUR(:,:)  ! Contains the hourly emission rate for all species
        REAL, ALLOCATABLE    :: HOURLY_EMISSION(:,:) ! Hourly emission for all the stack for one species

        CHARACTER(16) :: PROGNAME = 'WRINLINE' !  program name
 


!***********************************************************************
!   begin body of program WRINLINE
!   set up necessary information before calling PROMPTMFILE
        FTYPE3D = 1
        NVARS3D = TOTAL_NUM_POL
        NCOLS3D = 1
        NROWS3D = NUM_STACKS
        NLAYS3D = 1
        VGTYP3D = -9999
        SDATE3D = JULIANDATE
        STIME3D = MODELSTARTHOUR
        TSTEP3D = 10000
        MXREC3D = 25

        ALLOCATE(DAILYEMIS2HOUR(NUM_STACKS,TOTAL_NUM_POL))
        ALLOCATE(HOURLY_EMISSION(NUM_STACKS,25))

        CONV = 1.0
        DAILYEMIS2HOUR = 0.
        HOURLY_EMISSION = 0.

! set up variable name and description
        DO I = 1, TOTAL_NUM_POL

        write(*,*)  MASTERPOLLIST(I), CMAQ_EMIS_UNIT(I)
        if(CMAQ_EMIS_UNIT(I).eq.'tons/hr'.or.
     &     CMAQ_EMIS_UNIT(I).eq.'TONS/HR'.or.
     &     CMAQ_EMIS_UNIT(I).eq.'TPH') then !convert to moles/g

         if (MASTERPOLLIST(I).eq.'NO') then 
          CONV = (1./3600.)*907184.*(1./30.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'NO2') then 
          CONV = (1./3600.)*907184.*(1./46.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'SO2') then 
          CONV = (1./3600.)*907184.*(1./64.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'CO') then 
          CONV = (1./3600.)*907184.*(1./28.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'NH3') then 
          CONV = (1./3600.)*907184.*(1./17.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'HONO') then 
          CONV = (1./3600.)*907184.*(1./47.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'SULF') then 
          CONV = (1./3600.)*907184.*(1./98.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'

         else if (MASTERPOLLIST(I).eq.'ALD2') then 
          CONV = (1./3600.)*907184.*(1./44.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'ALDX') then 
          CONV = (1./3600.)*907184.*(1./44.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'ETH') then 
          CONV = (1./3600.)*907184.*(1./28.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'ETHA') then 
          CONV = (1./3600.)*907184.*(1./30.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'ETOH') then 
          CONV = (1./3600.)*907184.*(1./46.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'FORM') then 
          CONV = (1./3600.)*907184.*(1./30.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'IOLE') then 
          CONV = (1./3600.)*907184.*(1./48.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'ISOP') then 
          CONV = (1./3600.)*907184.*(1./68.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'MEOH') then 
          CONV = (1./3600.)*907184.*(1./32.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'NVOL') then 
          CONV = (1./3600.)*907184.*(1./1.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'OLE') then 
          CONV = (1./3600.)*907184.*(1./27.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'PAR') then 
          CONV = (1./3600.)*907184.*(1./14.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'TERP') then 
          CONV = (1./3600.)*907184.*(1./136.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'TOL') then 
          CONV = (1./3600.)*907184.*(1./92.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'UNR') then 
          CONV = (1./3600.)*907184.*(1./1.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'
         else if (MASTERPOLLIST(I).eq.'XYL') then 
          CONV = (1./3600.)*907184.*(1./106.)
          CMAQ_EMIS_UNIT(I) = 'moles/s'

         else if (MASTERPOLLIST(I).eq.'PEC') then 
          CONV = (1./3600.)*907184.*(1./1.)
          CMAQ_EMIS_UNIT(I) = 'g/s'
         else if (MASTERPOLLIST(I).eq.'POC') then 
          CONV = (1./3600.)*907184.*(1./1.)
          CMAQ_EMIS_UNIT(I) = 'g/s'
         else if (MASTERPOLLIST(I).eq.'POA') then 
          CONV = (1./3600.)*907184.*(1./1.)
          CMAQ_EMIS_UNIT(I) = 'g/s'
         else if (MASTERPOLLIST(I).eq.'PNCOM') then 
          CONV = (1./3600.)*907184.*(1./1.)
          CMAQ_EMIS_UNIT(I) = 'g/s'
         else if (MASTERPOLLIST(I).eq.'PNO3') then 
          CONV = (1./3600.)*907184.*(1./1.)
          CMAQ_EMIS_UNIT(I) = 'g/s'
         else if (MASTERPOLLIST(I).eq.'PNH4') then 
          CONV = (1./3600.)*907184.*(1./1.)
          CMAQ_EMIS_UNIT(I) = 'g/s'
         else if (MASTERPOLLIST(I).eq.'PSO4') then 
          CONV = (1./3600.)*907184.*(1./1.)
          CMAQ_EMIS_UNIT(I) = 'g/s'

         endif

        else
         CONV = 1.0
          CMAQ_EMIS_UNIT(I) = 'moles/s'
        endif
        write(*,*)  MASTERPOLLIST(I), CMAQ_EMIS_UNIT(I), CONV

           VNAME3D( I ) = MASTERPOLLIST(I)
           VTYPE3D( I ) = M3REAL
           UNITS3D( I ) = CMAQ_EMIS_UNIT(I)
           VDESC3D( I ) = 'Model species ' // MASTERPOLLIST(I)
           DO J = 1, NUM_STACKS
              DAILYEMIS2HOUR(J,I) = DAILY_EMIS(J,I) * CONV
           END DO
        END DO

        DO I = 1, MXDESC3
           FDESC3D( I ) = ''
        END DO
        FDESC3D( 1 ) = '/NUMBER OF FILES/ 1'
        FDESC3D( 2 ) = '/FILE POSITION/   1'
        WRITE( FDESC3D(3), 94010 ) '/Num of Stack/', NUM_STACKS
        FDESC3D( 4 ) = ''

        MESG = 'Enter the name of the inline output file'
        FNAME = PROMPTMFILE('Enter the name of the inline output file',
     &        FSNEW3, 'INLINE', PROGNAME )



!*************************************************
!  Write data to Stack Group file
!    Allocate memory for all the local arrays
!*************************************************
        DO I = 1, TOTAL_NUM_POL
           ! Write data to ioapi file
           JDATE = JULIANDATE
           JTIME = MODELSTARTHOUR
           HOURLY_EMISSION = 0.
           DO HOUR_LOOP = 1, 25
              IF (HOUR_LOOP .EQ. 25) THEN
                HOURLY_EMISSION(:,25) = DAILYEMIS2HOUR(:,I) * HR_RATIO(:,I,24)
              ELSE
                HOURLY_EMISSION(:,HOUR_LOOP) = DAILYEMIS2HOUR(:,I) * HR_RATIO(:,I,HOUR_LOOP)
              END IF

              MESG = 'Error writing to output file "' // FNAME // '"'
              IF (.NOT. WRITE3(FNAME, MASTERPOLLIST(I), JDATE, JTIME, HOURLY_EMISSION(:,HOUR_LOOP))) THEN
                 CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
              END IF
              CALL NEXTIME(JDATE,JTIME,TSTEP3D)
           END DO ! end HOUR_LOOP

        END DO  ! end I
        
        IF ( .NOT. CLOSE3( FNAME ) ) THEN
           MESG = 'Could not close file'
           CALL M3EXIT( progname, 0, 0, MESG, 2 )
        END IF 

        RETURN

!******************  FORMAT  STATEMENTS   ******************************
!...........   Internal buffering formats............ 94xxx

94010   FORMAT( 10( A, :, I8, :, 1X ) )

        END SUBROUTINE WRINLINE
