        SUBROUTINE WRSTKGRP()

!***********************************************************************
!  DESCRIPTION:
!      This subroutine writes a stack group file in ioapi format.
!      The information will come from emission input file in text format
!
!  PRECONDITIONS REQUIRED:
!
!  SUBROUTINES AND FUNCTIONS CALLED:
!      Subroutines: I/O API subroutine
!
!  REVISION  HISTORY:
!      Created 11/2011 by Charles Chang
!
!****************************************************************************/
!.........  MODINFO contains all the public variables
        USE MODINFO

        IMPLICIT NONE

        INCLUDE 'PARMS3.EXT'
        INCLUDE 'FDESC3.EXT'    !  I/O API file description data structures.
        INCLUDE 'IODECL3.EXT'


C.........  EXTERNAL FUNCTIONS and their descriptions:
        CHARACTER*16     PROMPTMFILE
        LOGICAL          DSCGRID
        LOGICAL          GETYN
        INTEGER          TRIMLEN
        LOGICAL          LAMBERT
        LOGICAL          LAM2LL
        EXTERNAL         PROMPTMFILE, DSCGRID, GETYN, TRIMLEN
     &       LAMBERT, LAM2LL

C...........   Other local variables
        CHARACTER(16)      :: FNAME
        CHARACTER(16)      :: ANAME
        INTEGER            :: I
        CHARACTER(16)      :: COORUN3D
C......... Follow variables are related to stack_group file
        INTEGER, ALLOCATABLE :: LOCSTKID( : )
        INTEGER, ALLOCATABLE :: LOCCNT( : )
        INTEGER, ALLOCATABLE :: LOCCOL( : )
        INTEGER, ALLOCATABLE :: LOCROW( : )
        INTEGER, ALLOCATABLE :: LOCFIP( : )
        INTEGER, ALLOCATABLE :: LOCLMAJOR( : )
        INTEGER, ALLOCATABLE :: LOCLPING( : )
        REAL   , ALLOCATABLE :: LOCDM ( : )
        REAL   , ALLOCATABLE :: LOCFL ( : )
        REAL   , ALLOCATABLE :: LOCHT ( : )
        REAL   , ALLOCATABLE :: LOCLAT( : )
        REAL   , ALLOCATABLE :: LOCLON( : )
        REAL   , ALLOCATABLE :: LOCTK ( : )
        REAL   , ALLOCATABLE :: LOCVE ( : )
        REAL   , ALLOCATABLE :: LOCXL ( : )
        REAL   , ALLOCATABLE :: LOCYL ( : )

        CHARACTER(300)       :: MESG             !  message buffer
        LOGICAL              :: LAMSET
        LOGICAL              :: Special_LAMSET
        REAL                 :: NEW_XLOC, NEW_YLOC
        INTEGER, ALLOCATABLE :: NEW_COL(:), NEW_ROW(:)
        REAL                 :: NEWXORIG, NEWYORIG
        CHARACTER(16)        :: LAMBERNAME

        CHARACTER(16) :: PROGNAME = 'WRSKTGRP' !  program name

C***********************************************************************
C   begin body of program WRSKTGRP

        ! Call LAMBERT
        LAMBERNAME = GRIDNAME_INFO
        LAMSET = LAMBERT(LAMBERNAME,P_ALP, P_BET, P_GAM, XCENT, YCENT)
        IF ( .NOT. LAMSET ) THEN
                CALL M3WARN( PROGNAME, 0, 0,
     &          'Error getting projection' )
        ELSE
           IF (DEBUG == 1) THEN
              WRITE(*,*) 'CALL LAMBERT successfully'
           END IF
        END IF
        IF (CTYPE == 2) THEN
           COORUN3D = "LAMBERT"
        END IF

!   set up necessary information before calling PROMPTMFILE
        FTYPE3D = 1
        GDTYP3D = 2
        NVARS3D = 16
        NCOLS3D = 1
        NROWS3D = NUM_STACKS
        NLAYS3D = 1
        VGTYP3D = -9999
        SDATE3D = JULIANDATE
        STIME3D = MODELSTARTHOUR
        TSTEP3D = 10000

! set up variable name and description
        VNAME3D( 1 ) = 'ISTACK'
        VTYPE3D( 1 ) = M3INT
        UNITS3D( 1 ) = 'none'
        VDESC3D( 1 ) = 'Stack group number'

        VNAME3D( 2 ) = 'LATITUDE'
        VTYPE3D( 2 ) = M3REAL
        UNITS3D( 2 ) = 'degrees'
        VDESC3D( 2 ) = 'Latitude'

        VNAME3D( 3 ) = 'LONGITUDE'
        VTYPE3D( 3 ) = M3REAL
        UNITS3D( 3 ) = 'degrees'
        VDESC3D( 3 ) = 'Longitude'

        VNAME3D( 4 ) = 'STKDM'
        VTYPE3D( 4 ) = M3REAL
        UNITS3D( 4 ) = 'm'
        VDESC3D( 4 ) = 'Inside stack diameter'

        VNAME3D( 5 ) = 'STKHT'
        VTYPE3D( 5 ) = M3REAL
        UNITS3D( 5 ) = 'm'
        VDESC3D( 5 ) = 'Stack height above ground surface'

        VNAME3D( 6 ) = 'STKTK'
        VTYPE3D( 6 ) = M3REAL
        UNITS3D( 6 ) = 'degrees K'
        VDESC3D( 6 ) = 'Stack exit temperature'

        VNAME3D( 7 ) = 'STKVE'
        VTYPE3D( 7 ) = M3REAL
        UNITS3D( 7 ) = 'm/s'
        VDESC3D( 7 ) = 'Stack exit velocity'

        VNAME3D( 8 ) = 'STKFLW'
        VTYPE3D( 8 ) = M3REAL
        UNITS3D( 8 ) = 'm**3/s'
        VDESC3D( 8 ) = 'Stack exit flow rate'

        VNAME3D( 9 ) = 'STKCNT'
        VTYPE3D( 9 ) = M3INT
        UNITS3D( 9 ) = 'none'
        VDESC3D( 9 ) = 'Number of stacks in group'

        VNAME3D( 10 ) = 'ROW'
        VTYPE3D( 10 ) = M3INT
        UNITS3D( 10 ) = 'none'
        VDESC3D( 10 ) = 'Grid row number'

        VNAME3D( 11 ) = 'COL'
        VTYPE3D( 11 ) = M3INT
        UNITS3D( 11 ) = 'none'
        VDESC3D( 11 ) = 'Grid column number'

        VNAME3D( 12 ) = 'XLOCA'
        VTYPE3D( 12 ) = M3REAL
        UNITS3D( 12 ) = COORUN3D
        VDESC3D( 12 ) = 'Projection x coordinate'

        VNAME3D( 13 ) = 'YLOCA'
        VTYPE3D( 13 ) = M3REAL
        UNITS3D( 13 ) = COORUN3D
        VDESC3D( 13 ) = 'Projection y coordinate'

        VNAME3D( 14 ) = 'IFIP'
        VTYPE3D( 14 ) = M3INT
        UNITS3D( 14 ) = 'none'
        VDESC3D( 14 ) = 'FIPS CODE'

        VNAME3D( 15 ) = 'LMAJOR'
        VTYPE3D( 15 ) = M3INT
        UNITS3D( 15 ) = 'none'
        VDESC3D( 15 ) = '1= MAJOR SOURCE in domain, 0=otherwise'

        VNAME3D( 16 ) = 'LPING'
        VTYPE3D( 16 ) = M3INT
        UNITS3D( 16 ) = 'none'
        VDESC3D( 16 ) = '1=PING SOURCE in domain, 0=otherwise'

        DO I = 1, MXDESC3
           FDESC3D( I ) = ''
        END DO
        FDESC3D( 1 ) = ' Point source stack groups file'
        FDESC3D( 2 ) = '/FROM/ ' // PROGNAME
        FDESC3D( 3 ) = '/VERSION 1.0.0/ '
        FDESC3D( 4 ) = 'Stack group information is coming from emis input text file'
        WRITE( FDESC3D(5), 94010 ) '/Num of Stack/', NROWS3D

        MESG = 'Enter the name of the STACK GROUP output file'
        FNAME = PROMPTMFILE('Enter the name of the STACK GROUP output file',
     &        FSNEW3, 'STACK_GROUP', PROGNAME )


        !*************************************************
        !  Write data to Stack Group file
        !*************************************************

        ! Allocate memory for all the local arrays

        Allocate(LOCSTKID(NUM_STACKS))
        Allocate(LOCCNT(NUM_STACKS))
        Allocate(LOCCOL(NUM_STACKS))
        Allocate(LOCROW(NUM_STACKS))
        Allocate(LOCFIP(NUM_STACKS))
        Allocate(LOCLMAJOR(NUM_STACKS))
        Allocate(LOCLPING(NUM_STACKS))
        Allocate(LOCDM(NUM_STACKS))
        Allocate(LOCFL(NUM_STACKS))
        Allocate(LOCHT(NUM_STACKS))
        Allocate(LOCLAT(NUM_STACKS))
        Allocate(LOCLON(NUM_STACKS))
        Allocate(LOCTK(NUM_STACKS))
        Allocate(LOCVE(NUM_STACKS))
        Allocate(LOCXL(NUM_STACKS))
        Allocate(LOCYL(NUM_STACKS))

        ! Assign value to these arrays
        DO I = 1, NUM_STACKS
           LOCSTKID(I) = STACK_ID(I)
           LOCCNT(I) = 1
           LOCDM(I) = STK_DM(I)
           LOCHT(I) = STK_HT(I)
           LOCTK(I) = STK_ET(I)
           LOCVE(I) = STK_VE(I)
c           LOCFL(I) = STK_FLW(I) / 2118.88
           LOCFL(I) = STK_VE(I) * 3.1416 * (STK_DM(I)/2.) * (STK_DM(I)/2.)
           LOCLMAJOR(I) = 1
           LOCLPING(I) = 0
           LOCXL(I) = X_COORD(I)
           LOCYL(I) = Y_COORD(I)

           ! Following variables need calculate from other value
           LOCFIP(I) = 0
           LOCLAT(I) = 0
           LOCLON(I) = 0
           LOCCOL(I) = 1 + INT((X_COORD(I)-XORIG)/XCELL)
           LOCROW(I) = 1 + INT((Y_COORD(I)-YORIG)/YCELL)

           IF (LAM2LL(LOCXL(I),LOCYL(I),LOCLON(I),LOCLAT(I))) THEN
              ! Following statement is for debug only
              ! write(*,*) 'Successfully calling LAM2LL'
           END IF
        END DO

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!! Special case for 12EUS1, since 12EUS1 is using US12KM_444X336
!!!! US12KM_444X336 has following character
!!!! Same Alpha, Beta and Gama, same XCELL3D, YCELL3D
!!!! XORIG = -2736000.000000
!!!! YORIG = -2088000.000000
!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!   IF GRIDNAME_INFO = 12EUS1_279X240 then
!!!    After set LAMBER then call the LL2LAM(using LOCLON(1),LOCLAT(1),new_X,new_Y)
!!!    From new_X, new_Y to get new_COL, new_ROW
!!!!   Then using this new_COL, and new_ROW to get FIPS for this point source
!!
        IF (TRIM(GRIDNAME_INFO) .EQ. '12EUS1_279X240') THEN
           NEWXORIG = -2736000.
           NEWYORIG = -2088000.
           ALLOCATE(NEW_COL(NUM_STACKS))
           ALLOCATE(NEW_ROW(NUM_STACKS))
           DO I = 1, NUM_STACKS
              NEW_COL(I) = 1 + INT((X_COORD(I)-NEWXORIG)/XCELL)
              NEW_ROW(I) = 1 + INT((Y_COORD(I)-NEWYORIG)/YCELL)
              IF (FIPS_SUPPORT) THEN
                 LOCFIP(I) = FIPS(NEW_COL(I),NEW_ROW(I))
              END IF
           END DO
        ELSE
           WRITE(*,*) 'GRIDNAME_INFO = ', GRIDNAME_INFO
        END IF
        ! Write data to ioapi file
        MESG = 'Error writing to output file "' // FNAME // '"'
        IF (.NOT. WRITE3(FNAME, 'ISTACK', SDATE3D, STIME3D, LOCSTKID)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'LATITUDE', SDATE3D, STIME3D, LOCLAT)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'LONGITUDE', SDATE3D, STIME3D, LOCLON)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'STKDM', SDATE3D, STIME3D, LOCDM)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'STKHT', SDATE3D, STIME3D, LOCHT)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'STKTK', SDATE3D, STIME3D, LOCTK)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'STKVE', SDATE3D, STIME3D, LOCVE)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'STKFLW', SDATE3D, STIME3D, LOCFL)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'STKCNT', SDATE3D, STIME3D, LOCCNT)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'ROW', SDATE3D, STIME3D, LOCROW)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'COL', SDATE3D, STIME3D, LOCCOL)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'XLOCA', SDATE3D, STIME3D, LOCXL)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'YLOCA', SDATE3D, STIME3D, LOCYL)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'IFIP', SDATE3D, STIME3D, LOCFIP)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'LMAJOR', SDATE3D, STIME3D, LOCLMAJOR)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        IF (.NOT. WRITE3(FNAME, 'LPING', SDATE3D, STIME3D, LOCLPING)) THEN
           CALL M3EXIT( PROGNAME, 0, 0, MESG, 2)
        END IF

        RETURN

6001    MESG = 'ERROR writing stack group file'
        CALL M3EXIT( PROGNAME, 0, 0, MESG, 2 )

C******************  FORMAT  STATEMENTS   ******************************

C...........   Formatted file I/O formats............ 93xxx

C...........   Internal buffering formats............ 94xxx
94010   FORMAT( 10( A, :, I8, :, 1X ) )

        END SUBROUTINE WRSTKGRP
