#!/bin/csh -f

set log = $0.log
cat $0 >! $log
uname -a >> $log
date >> $log

setenv PROMPTFLAG       Y
setenv IOAPI_ISPH       6370000
setenv EMISINPUT        $PWD/emission_input_lambert.txt
setenv GRIDDESC         /home/qpa/temp/griddesc_lambertonly_11may2011_v39.txt
setenv USA340_SURG      $PWD/USA_340_NOFILL_12US1_444X336.txt
setenv CAMX_FILE        $PWD/camx_file_lam.bin
if (-e $CAMX_FILE) rm -f $CAMX_FILE

create_pt_emission.x  << EOF >>& $log
CAMX
LAMBERT

N

$CAMX_FILE

EOF

