# HTAPv3 Emissions

HTAPv3 became available on June 13, 2022. The data provides global emissions of
PM10, PM25, OC, EC, NOx, SO2 and NMVOC. The global inventory is stitched
together from a harmonized version of EPA, ECCC, CAMS-REG, REAS, CAPPS-KU, and
JAPAN with EDGARv6.1 filling in the gaps. All inventories are normalized to a
set of common sectors:

* 1 International_Shipping
* 2.1 Domestic_Aviation
* 2.2 International_Aviation
* 3 Energy
* 4.1 Industry
* 4.2 Fugitive
* 4.3 Solvents
* 5.1 Road Transport
* 5.3 Domestic shipping
* 5.4 Other ground transport
* 6 Residential
* 7 Waste
* 8.1 Agricultural waste burning
* 8.2 Agriculture livestock
* 8.3 Agriculture crops

Care should be taken with Waste, Agricultural waste burning and Agriculture
crops. Each has the potential to double count other inventories. For example,
soil NOx is often included in biogenic inventories. Ag and Waste burning may
be in the fire inventory.

For more details, see https://edgar.jrc.ec.europa.eu/dataset_htap_v3.

This project folder converts the 

# Annotated Directory Structure

```
.
|-- README.md
|   # This file
|-- HTAPv3_Allocator.ipynb
|-- download.sh
|   # Script to download files
|-- cidportal.jrc.ec.europa.eu/ftp/jrc-opendata/EDGAR/datasets/htap_v3/
|   |   # Downloaded files
|   `-- gridmaps_01x01/fluxes/{SPC}/edgar_HTAPv3_%Y_{SPC}.zip
|-- fluxes/edgar_HTAPv3_%Y_{SPC}.nc
|   Unzipped from downloaded
|-- CreateSpeciation.ipynb
|   # Create sepciation/*.txt files
|-- factors
|   |   # Factors to allocate emissions to hour and layer
|   |-- dayofweek.108NHEMI2.IOAPI.nc
|   |-- diurnal.108NHEMI2.IOAPI.nc
|   |-- layerfactors.108NHEMI2.IOAPI.%y%m.nc
|   `-- monthly.108NHEMI2.IOAPI.nc
|-- mcip/METCRO3D.108NHEMI2.44L.%y%mmean
|   # MCIP files averaged for each month
|   # Used to identify altitudes. Prerequisite
|-- merged
|   `-- %Y-%m
|       `-- edgar_HTAPv3_%Y-%m-%a_merged_108NHEMI2_v0.0.nc
|-- miniconda -> ../HTAPv3_BETA/miniconda
|-- smokelite -> /home/bhenders/devel/smokelite/smokelite
|-- premerged
|   `-- %Y-%m-%a
|       |-- edgar_HTAPv3_%Y-%m-%a_HTAPv3_1_International_Shipping_108NHEMI2_v0.0.nc
|       |-- edgar_HTAPv3_%Y-%m-%a_HTAPv3_1_International_Shipping_108NHEMI2_v0.0.nc4
|       |-- edgar_HTAPv3_%Y-%m-%a_HTAPv3_2_1_Domestic_Aviation_108NHEMI2_v0.0.nc
|       |-- edgar_HTAPv3_%Y-%m-%a_HTAPv3_2_2_International_Aviation_108NHEMI2_v0.0.nc
|       |-- edgar_HTAPv3_%Y-%m-%a_HTAPv3_3_Energy_108NHEMI2_v0.0.nc
|       |-- edgar_HTAPv3_%Y-%m-%a_HTAPv3_4_1_Industry_108NHEMI2_v0.0.nc
|       |-- edgar_HTAPv3_%Y-%m-%a_HTAPv3_4_2_Fugitive_108NHEMI2_v0.0.nc
|       |-- edgar_HTAPv3_%Y-%m-%a_HTAPv3_4_3_Solvents_108NHEMI2_v0.0.nc
|       |-- edgar_HTAPv3_%Y-%m-%a_HTAPv3_5_1_Road_Transport_108NHEMI2_v0.0.nc
|       |-- edgar_HTAPv3_%Y-%m-%a_HTAPv3_5_3_Domestic_shipping_108NHEMI2_v0.0.nc
|       `-- edgar_HTAPv3_%Y-%m-%a_HTAPv3_5_4_Other_ground_transport_108NHEMI2_v0.0.nc
|-- regrid
|   |-- 108NHEMI2.grid -> /work/ROMO/users/bhenders/gis/cdo/EPA_HEMIS_PROJ.grid
|   |   # Polar Stereograph projected definition for CDO
|   |-- AREA_108NHEMI2.nc
|   |   # Area file made from CDO
|   |-- edgar_HTAPv3_%Y_{SPC}_108NHEMI2.nc
|   |   # Fluxes on the polar stereographic grid
|   `-- GRIDDESC
`-- speciation
    |-- 0000000000.txt
    |-- AG_BURNING.txt
    |-- AG.txt
    |-- AIR_CDS.txt
    |-- AIR_CRS.txt
    |-- AIR_LTO.txt
    |-- ENERGY.txt
    |-- INDUSTRY.txt
    |-- LS_BURNING.txt -> AG_BURNING.txt
    |-- RESIDENT.txt
    |-- SHIPS.txt
    `-- TRANSPORT.txt
```