# HTAPv3 Emissions Processor for Hemispheric CMAQ

---
    author: Barron H. Henderson
    date: 2022-08-06
    updated: 2024-04-04
---

This Notebook is designed to make CMAQ-ready emissions from the HTAPv3. It requires that you have HTAPv3 zip file, SMOKE allocation file, a timezone netcdf file, monthly mean met files, and speciation files.

## Basic Steps

* Calculate mass rate from fluxes [tons/month/m2]
  * tonpermonth = fluxes * area (tons/month)
  * tonpersecond = tonpermonth / ts (tons/s)
  * kgpersecond = tonpersecond * 1e3 (kg/s)
* Allocate to layers based on factors
* Allocate to times (day-of-week and hour) based on factors
* Speciate results to cb6 and ae6

## Annotated Directory Structure

The required files are described by the annotated directory structure below. All other files will be created.

```
./
|-- cidportal.jrc.ec.europa.eu/ftp/jrc-opendata/EDGAR/datasets/htap_v3/gridmaps_01x01/fluxes
|   |   # files downloaded from the HTAPv3 archive
|   |-- BC/edgar_HTAPv3_2018_BC.zip
|   |-- CO/edgar_HTAPv3_2018_CO.zip
|   |-- NH3/edgar_HTAPv3_2018_NH3.zip
|   |-- NMVOC/edgar_HTAPv3_2018_NMVOC.zip
|   |-- NOx/edgar_HTAPv3_2018_NOx.zip
|   |-- OC/edgar_HTAPv3_2018_OC.zip
|   |-- PM10/edgar_HTAPv3_2018_PM10.zip
|   |-- PM2.5/edgar_HTAPv3_2018_PM2.5.zip
|   `-- SO2/edgar_HTAPv3_2018_SO2.zip
|-- aux
|   |   # temporal allocation profiles
|   |-- HTAP_2011_BaseA_tpro_hourly_21mar2016_v0
|   |-- HTAP_2011_BaseA_tpro_monthly_21mar2016_v0
|   |-- HTAP_2011_BaseA_tpro_weekly_21mar2016_v0
|   |   # vertical allocation files
|   |-- layer_fraction_HTAP_agricultural_waste_burning_22mar2016_v0.csv
|   |-- layer_fraction_HTAP_air_cds_22mar2016_v0.csv
|   |-- layer_fraction_HTAP_air_crs_22mar2016_v0.csv
|   |-- layer_fraction_HTAP_air_lto_22mar2016_v0.csv
|   |-- layer_fraction_HTAP_energy_industry_27apr2016_nf_v1.csv
|   |-- layer_fraction_HTAP_industry_2016_20sep2017_v0.csv
|   |-- layer_fraction_HTAP_large_scale_biomass_burning_22mar2016_v0.csv
|   |-- layer_fraction_HTAP_ships_2016_20sep2017_v0.csv
|   |   # Time zone file made from the tz_world.json
|   `-- tz_world_hours_HEMIS.IOAPI.nc
|-- mcip
|   |   Monthly Mean ZF
|   |-- METCRO3D.108NHEMI2.44L.1601mean
|   |-- METCRO3D.108NHEMI2.44L.1602mean
|   |-- METCRO3D.108NHEMI2.44L.1603mean
|   |-- METCRO3D.108NHEMI2.44L.1604mean
|   |-- METCRO3D.108NHEMI2.44L.1605mean
|   |-- METCRO3D.108NHEMI2.44L.1606mean
|   |-- METCRO3D.108NHEMI2.44L.1607mean
|   |-- METCRO3D.108NHEMI2.44L.1608mean
|   |-- METCRO3D.108NHEMI2.44L.1609mean
|   |-- METCRO3D.108NHEMI2.44L.1610mean
|   |-- METCRO3D.108NHEMI2.44L.1611mean
|   `-- METCRO3D.108NHEMI2.44L.1612mean
`-- speciation
    |-- 0000000000.txt
    |-- AG_BURNING.txt
    |-- AG_CROPS.txt
    |-- AG_LIVESTOCK.txt
    |-- AG.txt
    |-- AIR_CDS.txt
    |-- AIR_CRS.txt
    |-- AIR_LTO.txt
    |-- BRAKETIRE.txt
    |-- ENERGY.txt
    |-- INDUSTRY.txt
    |-- LS_BIOBURN.txt -> AG_BURNING.txt
    |-- RESIDENT.txt
    |-- SHIPS.txt
    `-- TRANSPORT.txt
```

## Prerequisites

* Climate Data Operators (cdo)
* Python v3.6+
* Python libraries: numpy, matplotlib, pandas, cdo, pycno

Python and CDO can be installed via miniconda if you don't have them.

### Install Miniconda

To install cdo via miniconda, run the following commands.

```bash
wget -N -q https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-x86_64.sh
bash ./Miniconda3-latest-Linux-x86_64.sh  -b -p ./miniconda &> log.miniconda
./miniconda/bin/conda install -c conda-forge -q -y cdo &> log.conda
```

### Install Python Libraries

With python 3.6+ as your default python, run the commands below to install python libraries:

```bash
cat << EOF > requirements.txt
pandas==2.2.0
numpy==1.22.4
cdo==1.5.4
matplotlib==3.8.1
pycno==0.3.0
git+https://github.com/barronh/smokelite.git
EOF
python -m pip install -f requirements.txt
```

## Data Download Script

To get the cidportal.jrc.ec.europa.eu/ftp/jrc-opendata/EDGAR/datasets/htap_v3/gridmaps_01x01/fluxes subfolder, I ran the following script.

```bash
#!/bin/bash
YYYY=2018
for spc in BC CO NH3 NMVOC NOx OC PM10 PM2.5 SO2
do
wget --continue -r https://cidportal.jrc.ec.europa.eu/ftp/jrc-opendata/EDGAR/datasets/htap_v3/gridmaps_01x01/fluxes/${spc}/edgar_HTAPv3_${YYYY}_${spc}.zip
done
```