
!------------------------------------------------------------------------!
!  The Community Multiscale Air Quality (CMAQ) system software is in     !
!  continuous development by various groups and is based on information  !
!  from these groups: Federal Government employees, contractors working  !
!  within a United States Government contract, and non-Federal sources   !
!  including research institutions.  These groups give the Government    !
!  permission to use, prepare derivative works of, and distribute copies !
!  of their work in the CMAQ system to the public and to permit others   !
!  to do so.  The United States Environmental Protection Agency          !
!  therefore grants similar permission to use the CMAQ system software,  !
!  but users are requested to provide copies of derivative works or      !
!  products designed to operate in the CMAQ system to the United States  !
!  Government without restrictions as to use by others.  Software        !
!  that is used with the CMAQ system but distributed under the GNU       !
!  General Public License or the GNU Lesser General Public License is    !
!  subject to their copyright restrictions.                              !
!------------------------------------------------------------------------!
 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE aqchem_Function

  USE aqchem_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(59)
  A(2) = RCT(2)*V(60)
  A(3) = RCT(3)*V(61)
  A(4) = RCT(4)*V(62)
  A(5) = RCT(5)*V(63)
  A(6) = RCT(6)*V(64)
  A(7) = RCT(7)*V(65)
  A(8) = RCT(8)*V(66)
  A(9) = RCT(9)*V(69)
  A(10) = RCT(10)*V(70)
  A(11) = RCT(11)*V(68)
  A(12) = RCT(12)*V(52)
  A(13) = RCT(13)*V(54)
  A(14) = RCT(14)*V(55)
  A(15) = RCT(15)*V(56)
  A(16) = RCT(16)*V(57)
  A(17) = RCT(17)*V(58)
  A(18) = RCT(18)*V(90)
  A(19) = RCT(19)*V(71)
  A(20) = RCT(20)*V(73)
  A(21) = RCT(21)*V(74)
  A(22) = RCT(22)*V(87)
  A(23) = RCT(23)*V(91)
  A(24) = RCT(24)*V(77)
  A(25) = RCT(25)*V(89)
  A(26) = RCT(26)*V(86)
  A(27) = RCT(27)*V(80)
  A(28) = RCT(28)*V(67)
  A(29) = RCT(29)*V(53)
  A(30) = RCT(30)*V(84)
  A(31) = RCT(31)*V(96)
  A(32) = RCT(32)*V(99)
  A(33) = RCT(33)*V(85)
  A(34) = RCT(34)*V(95)
  A(35) = RCT(35)*V(1)
  A(36) = RCT(36)*V(2)
  A(37) = RCT(37)*V(3)
  A(38) = RCT(38)*V(4)
  A(39) = RCT(39)*V(5)
  A(40) = RCT(40)*V(6)
  A(41) = RCT(41)*V(7)
  A(42) = RCT(42)*V(8)
  A(43) = RCT(43)*V(90)
  A(44) = RCT(44)*V(93)
  A(45) = RCT(45)*V(71)
  A(46) = RCT(46)*V(73)
  A(47) = RCT(47)*V(81)
  A(48) = RCT(48)*V(74)
  A(49) = RCT(49)*V(77)
  A(50) = RCT(50)*V(80)
  A(51) = RCT(51)*F(1)
  A(52) = RCT(52)*V(79)
  A(53) = RCT(53)*V(83)
  A(54) = RCT(54)*V(84)
  A(55) = RCT(55)*V(93)*V(98)
  A(56) = RCT(56)*V(92)*V(98)
  A(57) = RCT(57)*V(72)*V(98)
  A(58) = RCT(58)*V(81)*V(98)
  A(59) = RCT(59)*V(82)*V(98)
  A(60) = RCT(60)*V(75)*V(76)
  A(61) = RCT(61)*V(78)*V(98)
  A(62) = RCT(62)*V(94)*V(98)
  A(63) = RCT(63)*V(76)*V(98)
  A(64) = RCT(64)*V(83)*V(98)
  A(65) = RCT(65)*V(88)*V(98)
  A(66) = RCT(66)*V(97)*V(98)
  A(67) = RCT(67)*V(67)*F(2)
  A(68) = RCT(68)*V(53)*F(2)
  A(69) = RCT(69)*V(87)*V(93)*V(98)
  A(70) = RCT(70)*V(90)*V(91)
  A(71) = RCT(71)*V(91)*V(93)
  A(72) = RCT(72)*V(91)*V(92)
  A(73) = RCT(73)*V(13)*V(90)
  A(74) = RCT(74)*V(13)*V(93)
  A(75) = RCT(75)*V(13)*V(92)
  A(76) = RCT(76)*V(12)*V(90)
  A(77) = RCT(77)*V(12)*V(93)
  A(78) = RCT(78)*V(12)*V(92)
  A(79) = RCT(79)*V(12)*V(13)*V(90)
  A(80) = RCT(80)*V(12)*V(13)*V(93)
  A(81) = RCT(81)*V(12)*V(13)*V(92)
  A(82) = RCT(82)*V(89)*V(93)*V(98)
  A(83) = RCT(83)*V(86)*V(93)*V(98)
  A(84) = RCT(84)*V(86)*V(93)
  A(85) = RCT(85)*V(99)
  A(86) = RCT(86)*V(96)*V(97)*V(98)
  A(87) = RCT(87)*V(85)*V(97)*V(98)
  A(88) = RCT(88)*V(94)*V(96)*V(98)
  A(89) = RCT(89)*V(95)
  A(90) = RCT(90)*V(90)
  A(91) = RCT(91)*V(71)
  A(92) = RCT(92)*V(73)
  A(93) = RCT(93)*V(74)
  A(94) = RCT(94)*V(87)
  A(95) = RCT(95)*V(91)
  A(96) = RCT(96)*V(77)
  A(97) = RCT(97)*V(89)
  A(98) = RCT(98)*V(86)
  A(99) = RCT(99)*V(79)
  A(100) = RCT(100)*V(80)
  A(101) = RCT(101)*V(67)
  A(102) = RCT(102)*V(53)
  A(103) = RCT(103)*V(88)
  A(104) = RCT(104)*V(72)
  A(105) = RCT(105)*V(75)
  A(106) = RCT(106)*V(94)
  A(107) = RCT(107)*V(9)
  A(108) = RCT(108)*V(10)
  A(109) = RCT(109)*V(39)
  A(110) = RCT(110)*V(11)
  A(111) = RCT(111)*V(14)
  A(112) = RCT(112)*V(15)
  A(113) = RCT(113)*V(16)
  A(114) = RCT(114)*V(17)
  A(115) = RCT(115)*V(12)
  A(116) = RCT(116)*V(13)
  A(117) = RCT(117)*V(98)
  A(118) = RCT(118)*V(76)
  A(119) = RCT(119)*V(93)
  A(120) = RCT(120)*V(92)
  A(121) = RCT(121)*V(81)
  A(122) = RCT(122)*V(82)
  A(123) = RCT(123)*V(78)
  A(124) = RCT(124)*V(83)
  A(125) = RCT(125)*V(84)
  A(126) = RCT(126)*V(96)
  A(127) = RCT(127)*V(99)
  A(128) = RCT(128)*V(85)
  A(129) = RCT(129)*V(95)
  A(130) = RCT(130)*V(97)

! Aggregate function
  Vdot(1) = -A(35)
  Vdot(2) = -A(36)
  Vdot(3) = -A(37)
  Vdot(4) = -A(38)
  Vdot(5) = -A(39)
  Vdot(6) = -A(40)
  Vdot(7) = -A(41)
  Vdot(8) = -A(42)
  Vdot(9) = A(42)-A(107)
  Vdot(10) = A(40)-A(108)
  Vdot(11) = A(41)-A(110)
  Vdot(12) = -A(115)
  Vdot(13) = -A(116)
  Vdot(14) = -A(111)
  Vdot(15) = -A(112)
  Vdot(16) = -A(113)
  Vdot(17) = A(38)-A(114)
  Vdot(18) = A(90)+A(119)+A(120)
  Vdot(19) = A(91)
  Vdot(20) = A(92)+A(121)+A(122)
  Vdot(21) = A(93)
  Vdot(22) = A(94)
  Vdot(23) = A(95)
  Vdot(24) = A(96)+A(123)
  Vdot(25) = A(97)
  Vdot(26) = A(98)
  Vdot(27) = A(99)+A(103)+A(124)
  Vdot(28) = A(100)
  Vdot(29) = A(101)
  Vdot(30) = A(102)
  Vdot(31) = A(104)
  Vdot(32) = A(105)
  Vdot(33) = A(106)
  Vdot(34) = A(107)
  Vdot(35) = A(115)
  Vdot(36) = A(116)
  Vdot(37) = A(108)
  Vdot(38) = A(109)
  Vdot(39) = 0.04*A(67)+0.04*A(68)-A(109)
  Vdot(40) = A(110)
  Vdot(41) = A(117)
  Vdot(42) = A(111)
  Vdot(43) = A(112)
  Vdot(44) = A(113)
  Vdot(45) = A(114)
  Vdot(46) = A(125)
  Vdot(47) = A(126)
  Vdot(48) = A(127)
  Vdot(49) = A(128)
  Vdot(50) = A(129)
  Vdot(51) = A(130)
  Vdot(52) = -A(12)+A(29)
  Vdot(53) = A(12)-A(29)-A(68)-A(102)
  Vdot(54) = -A(13)+A(30)
  Vdot(55) = -A(14)+A(31)
  Vdot(56) = -A(15)+A(32)
  Vdot(57) = -A(16)+A(33)
  Vdot(58) = -A(17)+A(34)
  Vdot(59) = -A(1)+A(18)
  Vdot(60) = -A(2)+A(19)
  Vdot(61) = -A(3)+A(20)
  Vdot(62) = -A(4)+A(21)
  Vdot(63) = -A(5)+A(22)
  Vdot(64) = -A(6)+A(23)
  Vdot(65) = -A(7)+A(24)
  Vdot(66) = -A(8)+A(25)
  Vdot(67) = A(11)-A(28)-A(67)-A(101)
  Vdot(68) = -A(11)+A(28)
  Vdot(69) = -A(9)+A(26)
  Vdot(70) = -A(10)+A(27)
  Vdot(71) = A(2)-A(19)-A(45)+A(57)-A(91)
  Vdot(72) = A(35)+A(45)-A(57)-A(104)
  Vdot(73) = A(3)-A(20)-A(46)+A(58)-A(92)
  Vdot(74) = A(4)-A(21)-A(48)+A(60)-A(93)
  Vdot(75) = A(36)+A(48)-A(60)-A(105)
  Vdot(76) = A(48)+A(51)-A(60)-A(63)-A(118)
  Vdot(77) = A(7)-A(24)-A(49)+A(61)-A(96)
  Vdot(78) = A(49)-A(61)-A(123)
  Vdot(79) = -A(52)+A(64)-A(99)
  Vdot(80) = A(10)-A(27)-A(50)+A(62)-A(100)
  Vdot(81) = A(46)-A(47)-A(58)+A(59)-A(121)
  Vdot(82) = A(47)-A(59)-A(122)
  Vdot(83) = A(52)-A(53)-A(64)+A(65)-A(124)
  Vdot(84) = A(13)-A(30)-A(54)+A(66)-A(125)
  Vdot(85) = A(16)-A(33)-A(87)-A(128)
  Vdot(86) = A(9)-A(26)-A(83)-A(84)-A(98)
  Vdot(87) = A(5)-A(22)-A(69)-A(94)
  Vdot(88) = A(39)+A(53)-A(65)+A(69)+A(70)+A(71)+A(72)+A(73)+A(74)+A(75)+A(76)+A(77)+A(78)+A(79)+A(80)+A(81)+A(82)+A(83)&
               &+A(84)-A(103)
  Vdot(89) = A(8)-A(25)-A(82)-A(97)
  Vdot(90) = A(1)-A(18)-A(43)+A(55)-A(70)-A(73)-A(76)-A(79)-A(90)
  Vdot(91) = A(6)-A(23)-A(70)-A(71)-A(72)-A(95)
  Vdot(92) = A(44)-A(56)-A(72)-A(75)-A(78)-A(81)-A(120)
  Vdot(93) = A(43)-A(44)-A(55)+A(56)-A(69)-A(71)-A(74)-A(77)-A(80)-A(82)-A(83)-A(84)-A(119)
  Vdot(94) = A(37)+A(50)-A(62)-A(88)+A(89)-A(106)
  Vdot(95) = A(17)-A(34)+A(87)+A(88)-A(89)-A(129)
  Vdot(96) = A(14)-A(31)+A(85)-A(86)-A(88)+A(89)-A(126)
  Vdot(97) = A(54)-A(66)+A(85)-A(86)-A(87)-A(130)
  Vdot(98) = A(43)+A(44)+A(45)+A(46)+A(47)+A(49)+A(50)+A(51)+A(52)+A(53)+A(54)-A(55)-A(56)-A(57)-A(58)-A(59)-A(61)-A(62)&
               &-A(63)-A(64)-A(65)-A(66)+A(69)+2*A(70)+A(71)+2*A(73)+A(74)+2*A(76)+A(77)+2*A(79)+A(80)+A(82)+A(83)+A(84)&
               &+A(85)-A(86)-A(87)-A(88)+A(89)-A(117)
  Vdot(99) = A(15)-A(32)-A(85)+A(86)-A(127)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE aqchem_Function

