
!------------------------------------------------------------------------!
!  The Community Multiscale Air Quality (CMAQ) system software is in     !
!  continuous development by various groups and is based on information  !
!  from these groups: Federal Government employees, contractors working  !
!  within a United States Government contract, and non-Federal sources   !
!  including research institutions.  These groups give the Government    !
!  permission to use, prepare derivative works of, and distribute copies !
!  of their work in the CMAQ system to the public and to permit others   !
!  to do so.  The United States Environmental Protection Agency          !
!  therefore grants similar permission to use the CMAQ system software,  !
!  but users are requested to provide copies of derivative works or      !
!  products designed to operate in the CMAQ system to the United States  !
!  Government without restrictions as to use by others.  Software        !
!  that is used with the CMAQ system but distributed under the GNU       !
!  General Public License or the GNU Lesser General Public License is    !
!  subject to their copyright restrictions.                              !
!------------------------------------------------------------------------!
 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Global Data Module File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE aqchem_Global

  USE aqchem_Parameters, ONLY: dp, NSPEC, NVAR, NFIX, NREACT
  PUBLIC
  SAVE


! Declaration of global variables

! C - Concentration of all species
  REAL(kind=dp) :: C(NSPEC)
! VAR - Concentrations of variable species (global)
  REAL(kind=dp) :: VAR(NVAR)
! FIX - Concentrations of fixed species (global)
  REAL(kind=dp) :: FIX(NFIX)
! VAR, FIX are chunks of array C
!      EQUIVALENCE( C(1),VAR(1) )
!      EQUIVALENCE( C(100),FIX(1) )
! RCONST - Rate constants (global)
  REAL(kind=dp) :: RCONST(NREACT)
! TIME - Current integration time
  REAL(kind=dp) :: TIME
! SUN - Sunlight intensity between [0,1]
  REAL(kind=dp) :: SUN
! TEMP - Temperature
  REAL(kind=dp) :: TEMP
! RTOLS - (scalar) Relative tolerance
  REAL(kind=dp) :: RTOLS
! TSTART - Integration start time
  REAL(kind=dp) :: TSTART
! TEND - Integration end time
  REAL(kind=dp) :: TEND
! DT - Integration step
  REAL(kind=dp) :: DT
! ATOL - Absolute tolerance
  REAL(kind=dp) :: ATOL(NVAR)
! RTOL - Relative tolerance
  REAL(kind=dp) :: RTOL(NVAR)
! STEPMIN - Lower bound for integration step
  REAL(kind=dp) :: STEPMIN
! STEPMAX - Upper bound for integration step
  REAL(kind=dp) :: STEPMAX
! CFACTOR - Conversion factor for concentration units
  REAL(kind=dp) :: CFACTOR

! INLINED global variable declarations

!
      REAL( kind=dp ), PARAMETER :: PHI = 6.0221413D17 ! Conversion factor (molec_m3/(mol_cm3))
      REAL( kind=dp ), PARAMETER :: DAQ = 1.0D-9  ! Aqueous phase diffusion coefficient (m2/s)  
      
      REAL( kind=dp ) :: INV_TEMP      ! Reciprocal of air temperature (1/K)
      REAL( kind=dp ) :: PRESS         ! Pressure (atm)
      REAL( kind=dp ) :: TEMP_KPP      ! Temperature (K)
      REAL( kind=dp ) :: LWC_KPP       ! Liquid water content (kg H2O / m3 air)
      REAL( kind=dp ) :: LWCFRAC       ! Liquid water content fraction
      REAL( kind=dp ) :: ALFA3_KPP     ! Aitken scavenging coefficient (mass)
      REAL( kind=dp ) :: ALFA0_KPP     ! Aitken scavenging coefficient (number)
      REAL( kind=dp ) :: WETFAC_KPP    ! Wet deposition rate coefficient 
      REAL( kind=dp ) :: FE_III        ! Fe(3+) fraction of Fe total
      REAL( kind=dp ) :: MN_II         ! Mn(2+) fraction of Mn total
      REAL( kind=dp ) :: FE_SOL        ! Fraction of soluble Fe
      REAL( kind=dp ) :: MN_SOL        ! Fraction of soluble Mn
      REAL( kind=dp ) :: DDIAM         ! Droplet Diameter (m)        
      REAL( kind=dp ) :: PHI2, INVPHI2 ! conversion factor (and inverse) (M/(molec/cm3air))  
      REAL( kind=dp ) :: STION         ! Ionic strength
      REAL( kind=dp ) :: GM1LOG, GM2LOG, GM1, GM2  ! Activity correction
      REAL( kind=dp ) :: DELINVT       ! 1/T - 1/298
      
      REAL( kind=dp ) :: SO2H          ! SO2 H Law coef - from HLCONST  
      REAL( kind=dp ) :: CO2H          ! CO2 H Law coef - from HLCONST
      REAL( kind=dp ) :: NH3H          ! NH3 H Law coef - from HLCONST 
      REAL( kind=dp ) :: H2O2H         ! H2O2 H Law coef - from HLCONST
      REAL( kind=dp ) :: O3H           ! O3 H Law coef - from HLCONST 
      REAL( kind=dp ) :: HCLH          ! HCL H Law coef - from HLCONST  
      REAL( kind=dp ) :: HNO3H         ! HNO3 H Law coef - from HLCONST
      REAL( kind=dp ) :: MHPH          ! MHP H Law coef - from HLCONST 
      REAL( kind=dp ) :: PAAH          ! PAA H Law coef - from HLCONST
      REAL( kind=dp ) :: FOAH          ! FOA H Law coef - from HLCONST 
      REAL( kind=dp ) :: GLYH          ! GLY H Law coef - from HLCONST
      REAL( kind=dp ) :: MGLYH         ! MGLY H Law coef - from HLCONST -- gas phase mech dependent  
      REAL( kind=dp ) :: HOH           ! HO H Law coef - from HLCONST
      
      REAL( kind=dp ) :: HBRH          ! HBR H Law coef - from HLCONST
      REAL( kind=dp ) :: HOBRH         ! HOBR H Law coef - from HLCONST
      REAL( kind=dp ) :: BR2H          ! BR2 H Law coef - from HLCONST
      REAL( kind=dp ) :: HOCLH         ! HOCL H Law coef - from HLCONST
      REAL( kind=dp ) :: BRCLH         ! BRCL H Law coef - from HLCONST

      INTEGER JDATEKPP
      INTEGER JTIMEKPP       


! INLINED global variable declarations


END MODULE aqchem_Global

