
!------------------------------------------------------------------------!
!  The Community Multiscale Air Quality (CMAQ) system software is in     !
!  continuous development by various groups and is based on information  !
!  from these groups: Federal Government employees, contractors working  !
!  within a United States Government contract, and non-Federal sources   !
!  including research institutions.  These groups give the Government    !
!  permission to use, prepare derivative works of, and distribute copies !
!  of their work in the CMAQ system to the public and to permit others   !
!  to do so.  The United States Environmental Protection Agency          !
!  therefore grants similar permission to use the CMAQ system software,  !
!  but users are requested to provide copies of derivative works or      !
!  products designed to operate in the CMAQ system to the United States  !
!  Government without restrictions as to use by others.  Software        !
!  that is used with the CMAQ system but distributed under the GNU       !
!  General Public License or the GNU Lesser General Public License is    !
!  subject to their copyright restrictions.                              !
!------------------------------------------------------------------------!
 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Jacobian of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE aqchem_Jacobian

  USE aqchem_Parameters
  USE aqchem_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP - the Jacobian of Variables in sparse matrix representation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      JVS       - sparse Jacobian of variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP ( V, F, RCT, JVS )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)


! Local variables
! B - Temporary array
  REAL(kind=dp) :: B(172)

! B(1) = dA(1)/dV(59)
  B(1) = RCT(1)
! B(2) = dA(2)/dV(60)
  B(2) = RCT(2)
! B(3) = dA(3)/dV(61)
  B(3) = RCT(3)
! B(4) = dA(4)/dV(62)
  B(4) = RCT(4)
! B(5) = dA(5)/dV(63)
  B(5) = RCT(5)
! B(6) = dA(6)/dV(64)
  B(6) = RCT(6)
! B(7) = dA(7)/dV(65)
  B(7) = RCT(7)
! B(8) = dA(8)/dV(66)
  B(8) = RCT(8)
! B(9) = dA(9)/dV(69)
  B(9) = RCT(9)
! B(10) = dA(10)/dV(70)
  B(10) = RCT(10)
! B(11) = dA(11)/dV(68)
  B(11) = RCT(11)
! B(12) = dA(12)/dV(52)
  B(12) = RCT(12)
! B(13) = dA(13)/dV(54)
  B(13) = RCT(13)
! B(14) = dA(14)/dV(55)
  B(14) = RCT(14)
! B(15) = dA(15)/dV(56)
  B(15) = RCT(15)
! B(16) = dA(16)/dV(57)
  B(16) = RCT(16)
! B(17) = dA(17)/dV(58)
  B(17) = RCT(17)
! B(18) = dA(18)/dV(90)
  B(18) = RCT(18)
! B(19) = dA(19)/dV(71)
  B(19) = RCT(19)
! B(20) = dA(20)/dV(73)
  B(20) = RCT(20)
! B(21) = dA(21)/dV(74)
  B(21) = RCT(21)
! B(22) = dA(22)/dV(87)
  B(22) = RCT(22)
! B(23) = dA(23)/dV(91)
  B(23) = RCT(23)
! B(24) = dA(24)/dV(77)
  B(24) = RCT(24)
! B(25) = dA(25)/dV(89)
  B(25) = RCT(25)
! B(26) = dA(26)/dV(86)
  B(26) = RCT(26)
! B(27) = dA(27)/dV(80)
  B(27) = RCT(27)
! B(28) = dA(28)/dV(67)
  B(28) = RCT(28)
! B(29) = dA(29)/dV(53)
  B(29) = RCT(29)
! B(30) = dA(30)/dV(84)
  B(30) = RCT(30)
! B(31) = dA(31)/dV(96)
  B(31) = RCT(31)
! B(32) = dA(32)/dV(99)
  B(32) = RCT(32)
! B(33) = dA(33)/dV(85)
  B(33) = RCT(33)
! B(34) = dA(34)/dV(95)
  B(34) = RCT(34)
! B(35) = dA(35)/dV(1)
  B(35) = RCT(35)
! B(36) = dA(36)/dV(2)
  B(36) = RCT(36)
! B(37) = dA(37)/dV(3)
  B(37) = RCT(37)
! B(38) = dA(38)/dV(4)
  B(38) = RCT(38)
! B(39) = dA(39)/dV(5)
  B(39) = RCT(39)
! B(40) = dA(40)/dV(6)
  B(40) = RCT(40)
! B(41) = dA(41)/dV(7)
  B(41) = RCT(41)
! B(42) = dA(42)/dV(8)
  B(42) = RCT(42)
! B(43) = dA(43)/dV(90)
  B(43) = RCT(43)
! B(44) = dA(44)/dV(93)
  B(44) = RCT(44)
! B(45) = dA(45)/dV(71)
  B(45) = RCT(45)
! B(46) = dA(46)/dV(73)
  B(46) = RCT(46)
! B(47) = dA(47)/dV(81)
  B(47) = RCT(47)
! B(48) = dA(48)/dV(74)
  B(48) = RCT(48)
! B(49) = dA(49)/dV(77)
  B(49) = RCT(49)
! B(50) = dA(50)/dV(80)
  B(50) = RCT(50)
! B(52) = dA(52)/dV(79)
  B(52) = RCT(52)
! B(53) = dA(53)/dV(83)
  B(53) = RCT(53)
! B(54) = dA(54)/dV(84)
  B(54) = RCT(54)
! B(55) = dA(55)/dV(93)
  B(55) = RCT(55)*V(98)
! B(56) = dA(55)/dV(98)
  B(56) = RCT(55)*V(93)
! B(57) = dA(56)/dV(92)
  B(57) = RCT(56)*V(98)
! B(58) = dA(56)/dV(98)
  B(58) = RCT(56)*V(92)
! B(59) = dA(57)/dV(72)
  B(59) = RCT(57)*V(98)
! B(60) = dA(57)/dV(98)
  B(60) = RCT(57)*V(72)
! B(61) = dA(58)/dV(81)
  B(61) = RCT(58)*V(98)
! B(62) = dA(58)/dV(98)
  B(62) = RCT(58)*V(81)
! B(63) = dA(59)/dV(82)
  B(63) = RCT(59)*V(98)
! B(64) = dA(59)/dV(98)
  B(64) = RCT(59)*V(82)
! B(65) = dA(60)/dV(75)
  B(65) = RCT(60)*V(76)
! B(66) = dA(60)/dV(76)
  B(66) = RCT(60)*V(75)
! B(67) = dA(61)/dV(78)
  B(67) = RCT(61)*V(98)
! B(68) = dA(61)/dV(98)
  B(68) = RCT(61)*V(78)
! B(69) = dA(62)/dV(94)
  B(69) = RCT(62)*V(98)
! B(70) = dA(62)/dV(98)
  B(70) = RCT(62)*V(94)
! B(71) = dA(63)/dV(76)
  B(71) = RCT(63)*V(98)
! B(72) = dA(63)/dV(98)
  B(72) = RCT(63)*V(76)
! B(73) = dA(64)/dV(83)
  B(73) = RCT(64)*V(98)
! B(74) = dA(64)/dV(98)
  B(74) = RCT(64)*V(83)
! B(75) = dA(65)/dV(88)
  B(75) = RCT(65)*V(98)
! B(76) = dA(65)/dV(98)
  B(76) = RCT(65)*V(88)
! B(77) = dA(66)/dV(97)
  B(77) = RCT(66)*V(98)
! B(78) = dA(66)/dV(98)
  B(78) = RCT(66)*V(97)
! B(79) = dA(67)/dV(67)
  B(79) = RCT(67)*F(2)
! B(81) = dA(68)/dV(53)
  B(81) = RCT(68)*F(2)
! B(83) = dA(69)/dV(87)
  B(83) = RCT(69)*V(93)*V(98)
! B(84) = dA(69)/dV(93)
  B(84) = RCT(69)*V(87)*V(98)
! B(85) = dA(69)/dV(98)
  B(85) = RCT(69)*V(87)*V(93)
! B(86) = dA(70)/dV(90)
  B(86) = RCT(70)*V(91)
! B(87) = dA(70)/dV(91)
  B(87) = RCT(70)*V(90)
! B(88) = dA(71)/dV(91)
  B(88) = RCT(71)*V(93)
! B(89) = dA(71)/dV(93)
  B(89) = RCT(71)*V(91)
! B(90) = dA(72)/dV(91)
  B(90) = RCT(72)*V(92)
! B(91) = dA(72)/dV(92)
  B(91) = RCT(72)*V(91)
! B(92) = dA(73)/dV(13)
  B(92) = RCT(73)*V(90)
! B(93) = dA(73)/dV(90)
  B(93) = RCT(73)*V(13)
! B(94) = dA(74)/dV(13)
  B(94) = RCT(74)*V(93)
! B(95) = dA(74)/dV(93)
  B(95) = RCT(74)*V(13)
! B(96) = dA(75)/dV(13)
  B(96) = RCT(75)*V(92)
! B(97) = dA(75)/dV(92)
  B(97) = RCT(75)*V(13)
! B(98) = dA(76)/dV(12)
  B(98) = RCT(76)*V(90)
! B(99) = dA(76)/dV(90)
  B(99) = RCT(76)*V(12)
! B(100) = dA(77)/dV(12)
  B(100) = RCT(77)*V(93)
! B(101) = dA(77)/dV(93)
  B(101) = RCT(77)*V(12)
! B(102) = dA(78)/dV(12)
  B(102) = RCT(78)*V(92)
! B(103) = dA(78)/dV(92)
  B(103) = RCT(78)*V(12)
! B(104) = dA(79)/dV(12)
  B(104) = RCT(79)*V(13)*V(90)
! B(105) = dA(79)/dV(13)
  B(105) = RCT(79)*V(12)*V(90)
! B(106) = dA(79)/dV(90)
  B(106) = RCT(79)*V(12)*V(13)
! B(107) = dA(80)/dV(12)
  B(107) = RCT(80)*V(13)*V(93)
! B(108) = dA(80)/dV(13)
  B(108) = RCT(80)*V(12)*V(93)
! B(109) = dA(80)/dV(93)
  B(109) = RCT(80)*V(12)*V(13)
! B(110) = dA(81)/dV(12)
  B(110) = RCT(81)*V(13)*V(92)
! B(111) = dA(81)/dV(13)
  B(111) = RCT(81)*V(12)*V(92)
! B(112) = dA(81)/dV(92)
  B(112) = RCT(81)*V(12)*V(13)
! B(113) = dA(82)/dV(89)
  B(113) = RCT(82)*V(93)*V(98)
! B(114) = dA(82)/dV(93)
  B(114) = RCT(82)*V(89)*V(98)
! B(115) = dA(82)/dV(98)
  B(115) = RCT(82)*V(89)*V(93)
! B(116) = dA(83)/dV(86)
  B(116) = RCT(83)*V(93)*V(98)
! B(117) = dA(83)/dV(93)
  B(117) = RCT(83)*V(86)*V(98)
! B(118) = dA(83)/dV(98)
  B(118) = RCT(83)*V(86)*V(93)
! B(119) = dA(84)/dV(86)
  B(119) = RCT(84)*V(93)
! B(120) = dA(84)/dV(93)
  B(120) = RCT(84)*V(86)
! B(121) = dA(85)/dV(99)
  B(121) = RCT(85)
! B(122) = dA(86)/dV(96)
  B(122) = RCT(86)*V(97)*V(98)
! B(123) = dA(86)/dV(97)
  B(123) = RCT(86)*V(96)*V(98)
! B(124) = dA(86)/dV(98)
  B(124) = RCT(86)*V(96)*V(97)
! B(125) = dA(87)/dV(85)
  B(125) = RCT(87)*V(97)*V(98)
! B(126) = dA(87)/dV(97)
  B(126) = RCT(87)*V(85)*V(98)
! B(127) = dA(87)/dV(98)
  B(127) = RCT(87)*V(85)*V(97)
! B(128) = dA(88)/dV(94)
  B(128) = RCT(88)*V(96)*V(98)
! B(129) = dA(88)/dV(96)
  B(129) = RCT(88)*V(94)*V(98)
! B(130) = dA(88)/dV(98)
  B(130) = RCT(88)*V(94)*V(96)
! B(131) = dA(89)/dV(95)
  B(131) = RCT(89)
! B(132) = dA(90)/dV(90)
  B(132) = RCT(90)
! B(133) = dA(91)/dV(71)
  B(133) = RCT(91)
! B(134) = dA(92)/dV(73)
  B(134) = RCT(92)
! B(135) = dA(93)/dV(74)
  B(135) = RCT(93)
! B(136) = dA(94)/dV(87)
  B(136) = RCT(94)
! B(137) = dA(95)/dV(91)
  B(137) = RCT(95)
! B(138) = dA(96)/dV(77)
  B(138) = RCT(96)
! B(139) = dA(97)/dV(89)
  B(139) = RCT(97)
! B(140) = dA(98)/dV(86)
  B(140) = RCT(98)
! B(141) = dA(99)/dV(79)
  B(141) = RCT(99)
! B(142) = dA(100)/dV(80)
  B(142) = RCT(100)
! B(143) = dA(101)/dV(67)
  B(143) = RCT(101)
! B(144) = dA(102)/dV(53)
  B(144) = RCT(102)
! B(145) = dA(103)/dV(88)
  B(145) = RCT(103)
! B(146) = dA(104)/dV(72)
  B(146) = RCT(104)
! B(147) = dA(105)/dV(75)
  B(147) = RCT(105)
! B(148) = dA(106)/dV(94)
  B(148) = RCT(106)
! B(149) = dA(107)/dV(9)
  B(149) = RCT(107)
! B(150) = dA(108)/dV(10)
  B(150) = RCT(108)
! B(151) = dA(109)/dV(39)
  B(151) = RCT(109)
! B(152) = dA(110)/dV(11)
  B(152) = RCT(110)
! B(153) = dA(111)/dV(14)
  B(153) = RCT(111)
! B(154) = dA(112)/dV(15)
  B(154) = RCT(112)
! B(155) = dA(113)/dV(16)
  B(155) = RCT(113)
! B(156) = dA(114)/dV(17)
  B(156) = RCT(114)
! B(157) = dA(115)/dV(12)
  B(157) = RCT(115)
! B(158) = dA(116)/dV(13)
  B(158) = RCT(116)
! B(159) = dA(117)/dV(98)
  B(159) = RCT(117)
! B(160) = dA(118)/dV(76)
  B(160) = RCT(118)
! B(161) = dA(119)/dV(93)
  B(161) = RCT(119)
! B(162) = dA(120)/dV(92)
  B(162) = RCT(120)
! B(163) = dA(121)/dV(81)
  B(163) = RCT(121)
! B(164) = dA(122)/dV(82)
  B(164) = RCT(122)
! B(165) = dA(123)/dV(78)
  B(165) = RCT(123)
! B(166) = dA(124)/dV(83)
  B(166) = RCT(124)
! B(167) = dA(125)/dV(84)
  B(167) = RCT(125)
! B(168) = dA(126)/dV(96)
  B(168) = RCT(126)
! B(169) = dA(127)/dV(99)
  B(169) = RCT(127)
! B(170) = dA(128)/dV(85)
  B(170) = RCT(128)
! B(171) = dA(129)/dV(95)
  B(171) = RCT(129)
! B(172) = dA(130)/dV(97)
  B(172) = RCT(130)

! Construct the Jacobian terms from B's
! JVS(1) = Jac_FULL(1,1)
  JVS(1) = -B(35)
! JVS(2) = Jac_FULL(2,2)
  JVS(2) = -B(36)
! JVS(3) = Jac_FULL(3,3)
  JVS(3) = -B(37)
! JVS(4) = Jac_FULL(4,4)
  JVS(4) = -B(38)
! JVS(5) = Jac_FULL(5,5)
  JVS(5) = -B(39)
! JVS(6) = Jac_FULL(6,6)
  JVS(6) = -B(40)
! JVS(7) = Jac_FULL(7,7)
  JVS(7) = -B(41)
! JVS(8) = Jac_FULL(8,8)
  JVS(8) = -B(42)
! JVS(9) = Jac_FULL(9,8)
  JVS(9) = B(42)
! JVS(10) = Jac_FULL(9,9)
  JVS(10) = -B(149)
! JVS(11) = Jac_FULL(10,6)
  JVS(11) = B(40)
! JVS(12) = Jac_FULL(10,10)
  JVS(12) = -B(150)
! JVS(13) = Jac_FULL(11,7)
  JVS(13) = B(41)
! JVS(14) = Jac_FULL(11,11)
  JVS(14) = -B(152)
! JVS(15) = Jac_FULL(12,12)
  JVS(15) = -B(157)
! JVS(16) = Jac_FULL(13,13)
  JVS(16) = -B(158)
! JVS(17) = Jac_FULL(14,14)
  JVS(17) = -B(153)
! JVS(18) = Jac_FULL(15,15)
  JVS(18) = -B(154)
! JVS(19) = Jac_FULL(16,16)
  JVS(19) = -B(155)
! JVS(20) = Jac_FULL(17,4)
  JVS(20) = B(38)
! JVS(21) = Jac_FULL(17,17)
  JVS(21) = -B(156)
! JVS(22) = Jac_FULL(18,18)
  JVS(22) = 0
! JVS(23) = Jac_FULL(18,90)
  JVS(23) = B(132)
! JVS(24) = Jac_FULL(18,92)
  JVS(24) = B(162)
! JVS(25) = Jac_FULL(18,93)
  JVS(25) = B(161)
! JVS(26) = Jac_FULL(19,19)
  JVS(26) = 0
! JVS(27) = Jac_FULL(19,71)
  JVS(27) = B(133)
! JVS(28) = Jac_FULL(20,20)
  JVS(28) = 0
! JVS(29) = Jac_FULL(20,73)
  JVS(29) = B(134)
! JVS(30) = Jac_FULL(20,81)
  JVS(30) = B(163)
! JVS(31) = Jac_FULL(20,82)
  JVS(31) = B(164)
! JVS(32) = Jac_FULL(21,21)
  JVS(32) = 0
! JVS(33) = Jac_FULL(21,74)
  JVS(33) = B(135)
! JVS(34) = Jac_FULL(22,22)
  JVS(34) = 0
! JVS(35) = Jac_FULL(22,87)
  JVS(35) = B(136)
! JVS(36) = Jac_FULL(23,23)
  JVS(36) = 0
! JVS(37) = Jac_FULL(23,91)
  JVS(37) = B(137)
! JVS(38) = Jac_FULL(24,24)
  JVS(38) = 0
! JVS(39) = Jac_FULL(24,77)
  JVS(39) = B(138)
! JVS(40) = Jac_FULL(24,78)
  JVS(40) = B(165)
! JVS(41) = Jac_FULL(25,25)
  JVS(41) = 0
! JVS(42) = Jac_FULL(25,89)
  JVS(42) = B(139)
! JVS(43) = Jac_FULL(26,26)
  JVS(43) = 0
! JVS(44) = Jac_FULL(26,86)
  JVS(44) = B(140)
! JVS(45) = Jac_FULL(27,27)
  JVS(45) = 0
! JVS(46) = Jac_FULL(27,79)
  JVS(46) = B(141)
! JVS(47) = Jac_FULL(27,83)
  JVS(47) = B(166)
! JVS(48) = Jac_FULL(27,88)
  JVS(48) = B(145)
! JVS(49) = Jac_FULL(28,28)
  JVS(49) = 0
! JVS(50) = Jac_FULL(28,80)
  JVS(50) = B(142)
! JVS(51) = Jac_FULL(29,29)
  JVS(51) = 0
! JVS(52) = Jac_FULL(29,67)
  JVS(52) = B(143)
! JVS(53) = Jac_FULL(30,30)
  JVS(53) = 0
! JVS(54) = Jac_FULL(30,53)
  JVS(54) = B(144)
! JVS(55) = Jac_FULL(31,31)
  JVS(55) = 0
! JVS(56) = Jac_FULL(31,72)
  JVS(56) = B(146)
! JVS(57) = Jac_FULL(32,32)
  JVS(57) = 0
! JVS(58) = Jac_FULL(32,75)
  JVS(58) = B(147)
! JVS(59) = Jac_FULL(33,33)
  JVS(59) = 0
! JVS(60) = Jac_FULL(33,94)
  JVS(60) = B(148)
! JVS(61) = Jac_FULL(34,9)
  JVS(61) = B(149)
! JVS(62) = Jac_FULL(34,34)
  JVS(62) = 0
! JVS(63) = Jac_FULL(35,12)
  JVS(63) = B(157)
! JVS(64) = Jac_FULL(35,35)
  JVS(64) = 0
! JVS(65) = Jac_FULL(36,13)
  JVS(65) = B(158)
! JVS(66) = Jac_FULL(36,36)
  JVS(66) = 0
! JVS(67) = Jac_FULL(37,10)
  JVS(67) = B(150)
! JVS(68) = Jac_FULL(37,37)
  JVS(68) = 0
! JVS(69) = Jac_FULL(38,38)
  JVS(69) = 0
! JVS(70) = Jac_FULL(38,39)
  JVS(70) = B(151)
! JVS(71) = Jac_FULL(39,39)
  JVS(71) = -B(151)
! JVS(72) = Jac_FULL(39,53)
  JVS(72) = 0.04*B(81)
! JVS(73) = Jac_FULL(39,67)
  JVS(73) = 0.04*B(79)
! JVS(74) = Jac_FULL(40,11)
  JVS(74) = B(152)
! JVS(75) = Jac_FULL(40,40)
  JVS(75) = 0
! JVS(76) = Jac_FULL(41,41)
  JVS(76) = 0
! JVS(77) = Jac_FULL(41,98)
  JVS(77) = B(159)
! JVS(78) = Jac_FULL(42,14)
  JVS(78) = B(153)
! JVS(79) = Jac_FULL(42,42)
  JVS(79) = 0
! JVS(80) = Jac_FULL(43,15)
  JVS(80) = B(154)
! JVS(81) = Jac_FULL(43,43)
  JVS(81) = 0
! JVS(82) = Jac_FULL(44,16)
  JVS(82) = B(155)
! JVS(83) = Jac_FULL(44,44)
  JVS(83) = 0
! JVS(84) = Jac_FULL(45,17)
  JVS(84) = B(156)
! JVS(85) = Jac_FULL(45,45)
  JVS(85) = 0
! JVS(86) = Jac_FULL(46,46)
  JVS(86) = 0
! JVS(87) = Jac_FULL(46,84)
  JVS(87) = B(167)
! JVS(88) = Jac_FULL(47,47)
  JVS(88) = 0
! JVS(89) = Jac_FULL(47,96)
  JVS(89) = B(168)
! JVS(90) = Jac_FULL(48,48)
  JVS(90) = 0
! JVS(91) = Jac_FULL(48,99)
  JVS(91) = B(169)
! JVS(92) = Jac_FULL(49,49)
  JVS(92) = 0
! JVS(93) = Jac_FULL(49,85)
  JVS(93) = B(170)
! JVS(94) = Jac_FULL(50,50)
  JVS(94) = 0
! JVS(95) = Jac_FULL(50,95)
  JVS(95) = B(171)
! JVS(96) = Jac_FULL(51,51)
  JVS(96) = 0
! JVS(97) = Jac_FULL(51,97)
  JVS(97) = B(172)
! JVS(98) = Jac_FULL(52,52)
  JVS(98) = -B(12)
! JVS(99) = Jac_FULL(52,53)
  JVS(99) = B(29)
! JVS(100) = Jac_FULL(53,52)
  JVS(100) = B(12)
! JVS(101) = Jac_FULL(53,53)
  JVS(101) = -B(29)-B(81)-B(144)
! JVS(102) = Jac_FULL(54,54)
  JVS(102) = -B(13)
! JVS(103) = Jac_FULL(54,84)
  JVS(103) = B(30)
! JVS(104) = Jac_FULL(55,55)
  JVS(104) = -B(14)
! JVS(105) = Jac_FULL(55,96)
  JVS(105) = B(31)
! JVS(106) = Jac_FULL(56,56)
  JVS(106) = -B(15)
! JVS(107) = Jac_FULL(56,99)
  JVS(107) = B(32)
! JVS(108) = Jac_FULL(57,57)
  JVS(108) = -B(16)
! JVS(109) = Jac_FULL(57,85)
  JVS(109) = B(33)
! JVS(110) = Jac_FULL(58,58)
  JVS(110) = -B(17)
! JVS(111) = Jac_FULL(58,95)
  JVS(111) = B(34)
! JVS(112) = Jac_FULL(59,59)
  JVS(112) = -B(1)
! JVS(113) = Jac_FULL(59,90)
  JVS(113) = B(18)
! JVS(114) = Jac_FULL(60,60)
  JVS(114) = -B(2)
! JVS(115) = Jac_FULL(60,71)
  JVS(115) = B(19)
! JVS(116) = Jac_FULL(61,61)
  JVS(116) = -B(3)
! JVS(117) = Jac_FULL(61,73)
  JVS(117) = B(20)
! JVS(118) = Jac_FULL(62,62)
  JVS(118) = -B(4)
! JVS(119) = Jac_FULL(62,74)
  JVS(119) = B(21)
! JVS(120) = Jac_FULL(63,63)
  JVS(120) = -B(5)
! JVS(121) = Jac_FULL(63,87)
  JVS(121) = B(22)
! JVS(122) = Jac_FULL(64,64)
  JVS(122) = -B(6)
! JVS(123) = Jac_FULL(64,91)
  JVS(123) = B(23)
! JVS(124) = Jac_FULL(65,65)
  JVS(124) = -B(7)
! JVS(125) = Jac_FULL(65,77)
  JVS(125) = B(24)
! JVS(126) = Jac_FULL(66,66)
  JVS(126) = -B(8)
! JVS(127) = Jac_FULL(66,89)
  JVS(127) = B(25)
! JVS(128) = Jac_FULL(67,67)
  JVS(128) = -B(28)-B(79)-B(143)
! JVS(129) = Jac_FULL(67,68)
  JVS(129) = B(11)
! JVS(130) = Jac_FULL(68,67)
  JVS(130) = B(28)
! JVS(131) = Jac_FULL(68,68)
  JVS(131) = -B(11)
! JVS(132) = Jac_FULL(69,69)
  JVS(132) = -B(9)
! JVS(133) = Jac_FULL(69,86)
  JVS(133) = B(26)
! JVS(134) = Jac_FULL(70,70)
  JVS(134) = -B(10)
! JVS(135) = Jac_FULL(70,80)
  JVS(135) = B(27)
! JVS(136) = Jac_FULL(71,60)
  JVS(136) = B(2)
! JVS(137) = Jac_FULL(71,71)
  JVS(137) = -B(19)-B(45)-B(133)
! JVS(138) = Jac_FULL(71,72)
  JVS(138) = B(59)
! JVS(139) = Jac_FULL(71,98)
  JVS(139) = B(60)
! JVS(140) = Jac_FULL(72,1)
  JVS(140) = B(35)
! JVS(141) = Jac_FULL(72,71)
  JVS(141) = B(45)
! JVS(142) = Jac_FULL(72,72)
  JVS(142) = -B(59)-B(146)
! JVS(143) = Jac_FULL(72,98)
  JVS(143) = -B(60)
! JVS(144) = Jac_FULL(73,61)
  JVS(144) = B(3)
! JVS(145) = Jac_FULL(73,73)
  JVS(145) = -B(20)-B(46)-B(134)
! JVS(146) = Jac_FULL(73,81)
  JVS(146) = B(61)
! JVS(147) = Jac_FULL(73,98)
  JVS(147) = B(62)
! JVS(148) = Jac_FULL(74,62)
  JVS(148) = B(4)
! JVS(149) = Jac_FULL(74,74)
  JVS(149) = -B(21)-B(48)-B(135)
! JVS(150) = Jac_FULL(74,75)
  JVS(150) = B(65)
! JVS(151) = Jac_FULL(74,76)
  JVS(151) = B(66)
! JVS(152) = Jac_FULL(75,2)
  JVS(152) = B(36)
! JVS(153) = Jac_FULL(75,74)
  JVS(153) = B(48)
! JVS(154) = Jac_FULL(75,75)
  JVS(154) = -B(65)-B(147)
! JVS(155) = Jac_FULL(75,76)
  JVS(155) = -B(66)
! JVS(156) = Jac_FULL(76,74)
  JVS(156) = B(48)
! JVS(157) = Jac_FULL(76,75)
  JVS(157) = -B(65)
! JVS(158) = Jac_FULL(76,76)
  JVS(158) = -B(66)-B(71)-B(160)
! JVS(159) = Jac_FULL(76,98)
  JVS(159) = -B(72)
! JVS(160) = Jac_FULL(77,65)
  JVS(160) = B(7)
! JVS(161) = Jac_FULL(77,77)
  JVS(161) = -B(24)-B(49)-B(138)
! JVS(162) = Jac_FULL(77,78)
  JVS(162) = B(67)
! JVS(163) = Jac_FULL(77,98)
  JVS(163) = B(68)
! JVS(164) = Jac_FULL(78,77)
  JVS(164) = B(49)
! JVS(165) = Jac_FULL(78,78)
  JVS(165) = -B(67)-B(165)
! JVS(166) = Jac_FULL(78,98)
  JVS(166) = -B(68)
! JVS(167) = Jac_FULL(79,79)
  JVS(167) = -B(52)-B(141)
! JVS(168) = Jac_FULL(79,83)
  JVS(168) = B(73)
! JVS(169) = Jac_FULL(79,98)
  JVS(169) = B(74)
! JVS(170) = Jac_FULL(80,70)
  JVS(170) = B(10)
! JVS(171) = Jac_FULL(80,80)
  JVS(171) = -B(27)-B(50)-B(142)
! JVS(172) = Jac_FULL(80,94)
  JVS(172) = B(69)
! JVS(173) = Jac_FULL(80,98)
  JVS(173) = B(70)
! JVS(174) = Jac_FULL(81,73)
  JVS(174) = B(46)
! JVS(175) = Jac_FULL(81,81)
  JVS(175) = -B(47)-B(61)-B(163)
! JVS(176) = Jac_FULL(81,82)
  JVS(176) = B(63)
! JVS(177) = Jac_FULL(81,98)
  JVS(177) = -B(62)+B(64)
! JVS(178) = Jac_FULL(82,81)
  JVS(178) = B(47)
! JVS(179) = Jac_FULL(82,82)
  JVS(179) = -B(63)-B(164)
! JVS(180) = Jac_FULL(82,98)
  JVS(180) = -B(64)
! JVS(181) = Jac_FULL(83,79)
  JVS(181) = B(52)
! JVS(182) = Jac_FULL(83,83)
  JVS(182) = -B(53)-B(73)-B(166)
! JVS(183) = Jac_FULL(83,88)
  JVS(183) = B(75)
! JVS(184) = Jac_FULL(83,98)
  JVS(184) = -B(74)+B(76)
! JVS(185) = Jac_FULL(84,54)
  JVS(185) = B(13)
! JVS(186) = Jac_FULL(84,84)
  JVS(186) = -B(30)-B(54)-B(167)
! JVS(187) = Jac_FULL(84,97)
  JVS(187) = B(77)
! JVS(188) = Jac_FULL(84,98)
  JVS(188) = B(78)
! JVS(189) = Jac_FULL(85,57)
  JVS(189) = B(16)
! JVS(190) = Jac_FULL(85,85)
  JVS(190) = -B(33)-B(125)-B(170)
! JVS(191) = Jac_FULL(85,97)
  JVS(191) = -B(126)
! JVS(192) = Jac_FULL(85,98)
  JVS(192) = -B(127)
! JVS(193) = Jac_FULL(86,69)
  JVS(193) = B(9)
! JVS(194) = Jac_FULL(86,86)
  JVS(194) = -B(26)-B(116)-B(119)-B(140)
! JVS(195) = Jac_FULL(86,93)
  JVS(195) = -B(117)-B(120)
! JVS(196) = Jac_FULL(86,98)
  JVS(196) = -B(118)
! JVS(197) = Jac_FULL(87,63)
  JVS(197) = B(5)
! JVS(198) = Jac_FULL(87,87)
  JVS(198) = -B(22)-B(83)-B(136)
! JVS(199) = Jac_FULL(87,93)
  JVS(199) = -B(84)
! JVS(200) = Jac_FULL(87,98)
  JVS(200) = -B(85)
! JVS(201) = Jac_FULL(88,5)
  JVS(201) = B(39)
! JVS(202) = Jac_FULL(88,12)
  JVS(202) = B(98)+B(100)+B(102)+B(104)+B(107)+B(110)
! JVS(203) = Jac_FULL(88,13)
  JVS(203) = B(92)+B(94)+B(96)+B(105)+B(108)+B(111)
! JVS(204) = Jac_FULL(88,83)
  JVS(204) = B(53)
! JVS(205) = Jac_FULL(88,86)
  JVS(205) = B(116)+B(119)
! JVS(206) = Jac_FULL(88,87)
  JVS(206) = B(83)
! JVS(207) = Jac_FULL(88,88)
  JVS(207) = -B(75)-B(145)
! JVS(208) = Jac_FULL(88,89)
  JVS(208) = B(113)
! JVS(209) = Jac_FULL(88,90)
  JVS(209) = B(86)+B(93)+B(99)+B(106)
! JVS(210) = Jac_FULL(88,91)
  JVS(210) = B(87)+B(88)+B(90)
! JVS(211) = Jac_FULL(88,92)
  JVS(211) = B(91)+B(97)+B(103)+B(112)
! JVS(212) = Jac_FULL(88,93)
  JVS(212) = B(84)+B(89)+B(95)+B(101)+B(109)+B(114)+B(117)+B(120)
! JVS(213) = Jac_FULL(88,98)
  JVS(213) = -B(76)+B(85)+B(115)+B(118)
! JVS(214) = Jac_FULL(89,66)
  JVS(214) = B(8)
! JVS(215) = Jac_FULL(89,89)
  JVS(215) = -B(25)-B(113)-B(139)
! JVS(216) = Jac_FULL(89,93)
  JVS(216) = -B(114)
! JVS(217) = Jac_FULL(89,98)
  JVS(217) = -B(115)
! JVS(218) = Jac_FULL(90,12)
  JVS(218) = -B(98)-B(104)
! JVS(219) = Jac_FULL(90,13)
  JVS(219) = -B(92)-B(105)
! JVS(220) = Jac_FULL(90,59)
  JVS(220) = B(1)
! JVS(221) = Jac_FULL(90,90)
  JVS(221) = -B(18)-B(43)-B(86)-B(93)-B(99)-B(106)-B(132)
! JVS(222) = Jac_FULL(90,91)
  JVS(222) = -B(87)
! JVS(223) = Jac_FULL(90,93)
  JVS(223) = B(55)
! JVS(224) = Jac_FULL(90,98)
  JVS(224) = B(56)
! JVS(225) = Jac_FULL(91,64)
  JVS(225) = B(6)
! JVS(226) = Jac_FULL(91,90)
  JVS(226) = -B(86)
! JVS(227) = Jac_FULL(91,91)
  JVS(227) = -B(23)-B(87)-B(88)-B(90)-B(137)
! JVS(228) = Jac_FULL(91,92)
  JVS(228) = -B(91)
! JVS(229) = Jac_FULL(91,93)
  JVS(229) = -B(89)
! JVS(230) = Jac_FULL(91,98)
  JVS(230) = 0
! JVS(231) = Jac_FULL(92,12)
  JVS(231) = -B(102)-B(110)
! JVS(232) = Jac_FULL(92,13)
  JVS(232) = -B(96)-B(111)
! JVS(233) = Jac_FULL(92,91)
  JVS(233) = -B(90)
! JVS(234) = Jac_FULL(92,92)
  JVS(234) = -B(57)-B(91)-B(97)-B(103)-B(112)-B(162)
! JVS(235) = Jac_FULL(92,93)
  JVS(235) = B(44)
! JVS(236) = Jac_FULL(92,98)
  JVS(236) = -B(58)
! JVS(237) = Jac_FULL(93,12)
  JVS(237) = -B(100)-B(107)
! JVS(238) = Jac_FULL(93,13)
  JVS(238) = -B(94)-B(108)
! JVS(239) = Jac_FULL(93,86)
  JVS(239) = -B(116)-B(119)
! JVS(240) = Jac_FULL(93,87)
  JVS(240) = -B(83)
! JVS(241) = Jac_FULL(93,89)
  JVS(241) = -B(113)
! JVS(242) = Jac_FULL(93,90)
  JVS(242) = B(43)
! JVS(243) = Jac_FULL(93,91)
  JVS(243) = -B(88)
! JVS(244) = Jac_FULL(93,92)
  JVS(244) = B(57)
! JVS(245) = Jac_FULL(93,93)
  JVS(245) = -B(44)-B(55)-B(84)-B(89)-B(95)-B(101)-B(109)-B(114)-B(117)-B(120)-B(161)
! JVS(246) = Jac_FULL(93,98)
  JVS(246) = -B(56)+B(58)-B(85)-B(115)-B(118)
! JVS(247) = Jac_FULL(94,3)
  JVS(247) = B(37)
! JVS(248) = Jac_FULL(94,80)
  JVS(248) = B(50)
! JVS(249) = Jac_FULL(94,94)
  JVS(249) = -B(69)-B(128)-B(148)
! JVS(250) = Jac_FULL(94,95)
  JVS(250) = B(131)
! JVS(251) = Jac_FULL(94,96)
  JVS(251) = -B(129)
! JVS(252) = Jac_FULL(94,98)
  JVS(252) = -B(70)-B(130)
! JVS(253) = Jac_FULL(95,58)
  JVS(253) = B(17)
! JVS(254) = Jac_FULL(95,85)
  JVS(254) = B(125)
! JVS(255) = Jac_FULL(95,94)
  JVS(255) = B(128)
! JVS(256) = Jac_FULL(95,95)
  JVS(256) = -B(34)-B(131)-B(171)
! JVS(257) = Jac_FULL(95,96)
  JVS(257) = B(129)
! JVS(258) = Jac_FULL(95,97)
  JVS(258) = B(126)
! JVS(259) = Jac_FULL(95,98)
  JVS(259) = B(127)+B(130)
! JVS(260) = Jac_FULL(96,55)
  JVS(260) = B(14)
! JVS(261) = Jac_FULL(96,94)
  JVS(261) = -B(128)
! JVS(262) = Jac_FULL(96,95)
  JVS(262) = B(131)
! JVS(263) = Jac_FULL(96,96)
  JVS(263) = -B(31)-B(122)-B(129)-B(168)
! JVS(264) = Jac_FULL(96,97)
  JVS(264) = -B(123)
! JVS(265) = Jac_FULL(96,98)
  JVS(265) = -B(124)-B(130)
! JVS(266) = Jac_FULL(96,99)
  JVS(266) = B(121)
! JVS(267) = Jac_FULL(97,84)
  JVS(267) = B(54)
! JVS(268) = Jac_FULL(97,85)
  JVS(268) = -B(125)
! JVS(269) = Jac_FULL(97,96)
  JVS(269) = -B(122)
! JVS(270) = Jac_FULL(97,97)
  JVS(270) = -B(77)-B(123)-B(126)-B(172)
! JVS(271) = Jac_FULL(97,98)
  JVS(271) = -B(78)-B(124)-B(127)
! JVS(272) = Jac_FULL(97,99)
  JVS(272) = B(121)
! JVS(273) = Jac_FULL(98,12)
  JVS(273) = 2*B(98)+B(100)+2*B(104)+B(107)
! JVS(274) = Jac_FULL(98,13)
  JVS(274) = 2*B(92)+B(94)+2*B(105)+B(108)
! JVS(275) = Jac_FULL(98,71)
  JVS(275) = B(45)
! JVS(276) = Jac_FULL(98,72)
  JVS(276) = -B(59)
! JVS(277) = Jac_FULL(98,73)
  JVS(277) = B(46)
! JVS(278) = Jac_FULL(98,76)
  JVS(278) = -B(71)
! JVS(279) = Jac_FULL(98,77)
  JVS(279) = B(49)
! JVS(280) = Jac_FULL(98,78)
  JVS(280) = -B(67)
! JVS(281) = Jac_FULL(98,79)
  JVS(281) = B(52)
! JVS(282) = Jac_FULL(98,80)
  JVS(282) = B(50)
! JVS(283) = Jac_FULL(98,81)
  JVS(283) = B(47)-B(61)
! JVS(284) = Jac_FULL(98,82)
  JVS(284) = -B(63)
! JVS(285) = Jac_FULL(98,83)
  JVS(285) = B(53)-B(73)
! JVS(286) = Jac_FULL(98,84)
  JVS(286) = B(54)
! JVS(287) = Jac_FULL(98,85)
  JVS(287) = -B(125)
! JVS(288) = Jac_FULL(98,86)
  JVS(288) = B(116)+B(119)
! JVS(289) = Jac_FULL(98,87)
  JVS(289) = B(83)
! JVS(290) = Jac_FULL(98,88)
  JVS(290) = -B(75)
! JVS(291) = Jac_FULL(98,89)
  JVS(291) = B(113)
! JVS(292) = Jac_FULL(98,90)
  JVS(292) = B(43)+2*B(86)+2*B(93)+2*B(99)+2*B(106)
! JVS(293) = Jac_FULL(98,91)
  JVS(293) = 2*B(87)+B(88)
! JVS(294) = Jac_FULL(98,92)
  JVS(294) = -B(57)
! JVS(295) = Jac_FULL(98,93)
  JVS(295) = B(44)-B(55)+B(84)+B(89)+B(95)+B(101)+B(109)+B(114)+B(117)+B(120)
! JVS(296) = Jac_FULL(98,94)
  JVS(296) = -B(69)-B(128)
! JVS(297) = Jac_FULL(98,95)
  JVS(297) = B(131)
! JVS(298) = Jac_FULL(98,96)
  JVS(298) = -B(122)-B(129)
! JVS(299) = Jac_FULL(98,97)
  JVS(299) = -B(77)-B(123)-B(126)
! JVS(300) = Jac_FULL(98,98)
  JVS(300) = -B(56)-B(58)-B(60)-B(62)-B(64)-B(68)-B(70)-B(72)-B(74)-B(76)-B(78)+B(85)+B(115)+B(118)-B(124)-B(127)-B(130)&
               &-B(159)
! JVS(301) = Jac_FULL(98,99)
  JVS(301) = B(121)
! JVS(302) = Jac_FULL(99,56)
  JVS(302) = B(15)
! JVS(303) = Jac_FULL(99,96)
  JVS(303) = B(122)
! JVS(304) = Jac_FULL(99,97)
  JVS(304) = B(123)
! JVS(305) = Jac_FULL(99,98)
  JVS(305) = B(124)
! JVS(306) = Jac_FULL(99,99)
  JVS(306) = -B(32)-B(121)-B(169)
      
END SUBROUTINE Jac_SP

! End of Jac_SP function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP_Vec - function for sparse multiplication: sparse Jacobian times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JUV       - Jacobian times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP_Vec ( JVS, UV, JUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JUV - Jacobian times user vector
  REAL(kind=dp) :: JUV(NVAR)

  JUV(1) = JVS(1)*UV(1)
  JUV(2) = JVS(2)*UV(2)
  JUV(3) = JVS(3)*UV(3)
  JUV(4) = JVS(4)*UV(4)
  JUV(5) = JVS(5)*UV(5)
  JUV(6) = JVS(6)*UV(6)
  JUV(7) = JVS(7)*UV(7)
  JUV(8) = JVS(8)*UV(8)
  JUV(9) = JVS(9)*UV(8)+JVS(10)*UV(9)
  JUV(10) = JVS(11)*UV(6)+JVS(12)*UV(10)
  JUV(11) = JVS(13)*UV(7)+JVS(14)*UV(11)
  JUV(12) = JVS(15)*UV(12)
  JUV(13) = JVS(16)*UV(13)
  JUV(14) = JVS(17)*UV(14)
  JUV(15) = JVS(18)*UV(15)
  JUV(16) = JVS(19)*UV(16)
  JUV(17) = JVS(20)*UV(4)+JVS(21)*UV(17)
  JUV(18) = JVS(22)*UV(18)+JVS(23)*UV(90)+JVS(24)*UV(92)+JVS(25)*UV(93)
  JUV(19) = JVS(26)*UV(19)+JVS(27)*UV(71)
  JUV(20) = JVS(28)*UV(20)+JVS(29)*UV(73)+JVS(30)*UV(81)+JVS(31)*UV(82)
  JUV(21) = JVS(32)*UV(21)+JVS(33)*UV(74)
  JUV(22) = JVS(34)*UV(22)+JVS(35)*UV(87)
  JUV(23) = JVS(36)*UV(23)+JVS(37)*UV(91)
  JUV(24) = JVS(38)*UV(24)+JVS(39)*UV(77)+JVS(40)*UV(78)
  JUV(25) = JVS(41)*UV(25)+JVS(42)*UV(89)
  JUV(26) = JVS(43)*UV(26)+JVS(44)*UV(86)
  JUV(27) = JVS(45)*UV(27)+JVS(46)*UV(79)+JVS(47)*UV(83)+JVS(48)*UV(88)
  JUV(28) = JVS(49)*UV(28)+JVS(50)*UV(80)
  JUV(29) = JVS(51)*UV(29)+JVS(52)*UV(67)
  JUV(30) = JVS(53)*UV(30)+JVS(54)*UV(53)
  JUV(31) = JVS(55)*UV(31)+JVS(56)*UV(72)
  JUV(32) = JVS(57)*UV(32)+JVS(58)*UV(75)
  JUV(33) = JVS(59)*UV(33)+JVS(60)*UV(94)
  JUV(34) = JVS(61)*UV(9)+JVS(62)*UV(34)
  JUV(35) = JVS(63)*UV(12)+JVS(64)*UV(35)
  JUV(36) = JVS(65)*UV(13)+JVS(66)*UV(36)
  JUV(37) = JVS(67)*UV(10)+JVS(68)*UV(37)
  JUV(38) = JVS(69)*UV(38)+JVS(70)*UV(39)
  JUV(39) = JVS(71)*UV(39)+JVS(72)*UV(53)+JVS(73)*UV(67)
  JUV(40) = JVS(74)*UV(11)+JVS(75)*UV(40)
  JUV(41) = JVS(76)*UV(41)+JVS(77)*UV(98)
  JUV(42) = JVS(78)*UV(14)+JVS(79)*UV(42)
  JUV(43) = JVS(80)*UV(15)+JVS(81)*UV(43)
  JUV(44) = JVS(82)*UV(16)+JVS(83)*UV(44)
  JUV(45) = JVS(84)*UV(17)+JVS(85)*UV(45)
  JUV(46) = JVS(86)*UV(46)+JVS(87)*UV(84)
  JUV(47) = JVS(88)*UV(47)+JVS(89)*UV(96)
  JUV(48) = JVS(90)*UV(48)+JVS(91)*UV(99)
  JUV(49) = JVS(92)*UV(49)+JVS(93)*UV(85)
  JUV(50) = JVS(94)*UV(50)+JVS(95)*UV(95)
  JUV(51) = JVS(96)*UV(51)+JVS(97)*UV(97)
  JUV(52) = JVS(98)*UV(52)+JVS(99)*UV(53)
  JUV(53) = JVS(100)*UV(52)+JVS(101)*UV(53)
  JUV(54) = JVS(102)*UV(54)+JVS(103)*UV(84)
  JUV(55) = JVS(104)*UV(55)+JVS(105)*UV(96)
  JUV(56) = JVS(106)*UV(56)+JVS(107)*UV(99)
  JUV(57) = JVS(108)*UV(57)+JVS(109)*UV(85)
  JUV(58) = JVS(110)*UV(58)+JVS(111)*UV(95)
  JUV(59) = JVS(112)*UV(59)+JVS(113)*UV(90)
  JUV(60) = JVS(114)*UV(60)+JVS(115)*UV(71)
  JUV(61) = JVS(116)*UV(61)+JVS(117)*UV(73)
  JUV(62) = JVS(118)*UV(62)+JVS(119)*UV(74)
  JUV(63) = JVS(120)*UV(63)+JVS(121)*UV(87)
  JUV(64) = JVS(122)*UV(64)+JVS(123)*UV(91)
  JUV(65) = JVS(124)*UV(65)+JVS(125)*UV(77)
  JUV(66) = JVS(126)*UV(66)+JVS(127)*UV(89)
  JUV(67) = JVS(128)*UV(67)+JVS(129)*UV(68)
  JUV(68) = JVS(130)*UV(67)+JVS(131)*UV(68)
  JUV(69) = JVS(132)*UV(69)+JVS(133)*UV(86)
  JUV(70) = JVS(134)*UV(70)+JVS(135)*UV(80)
  JUV(71) = JVS(136)*UV(60)+JVS(137)*UV(71)+JVS(138)*UV(72)+JVS(139)*UV(98)
  JUV(72) = JVS(140)*UV(1)+JVS(141)*UV(71)+JVS(142)*UV(72)+JVS(143)*UV(98)
  JUV(73) = JVS(144)*UV(61)+JVS(145)*UV(73)+JVS(146)*UV(81)+JVS(147)*UV(98)
  JUV(74) = JVS(148)*UV(62)+JVS(149)*UV(74)+JVS(150)*UV(75)+JVS(151)*UV(76)
  JUV(75) = JVS(152)*UV(2)+JVS(153)*UV(74)+JVS(154)*UV(75)+JVS(155)*UV(76)
  JUV(76) = JVS(156)*UV(74)+JVS(157)*UV(75)+JVS(158)*UV(76)+JVS(159)*UV(98)
  JUV(77) = JVS(160)*UV(65)+JVS(161)*UV(77)+JVS(162)*UV(78)+JVS(163)*UV(98)
  JUV(78) = JVS(164)*UV(77)+JVS(165)*UV(78)+JVS(166)*UV(98)
  JUV(79) = JVS(167)*UV(79)+JVS(168)*UV(83)+JVS(169)*UV(98)
  JUV(80) = JVS(170)*UV(70)+JVS(171)*UV(80)+JVS(172)*UV(94)+JVS(173)*UV(98)
  JUV(81) = JVS(174)*UV(73)+JVS(175)*UV(81)+JVS(176)*UV(82)+JVS(177)*UV(98)
  JUV(82) = JVS(178)*UV(81)+JVS(179)*UV(82)+JVS(180)*UV(98)
  JUV(83) = JVS(181)*UV(79)+JVS(182)*UV(83)+JVS(183)*UV(88)+JVS(184)*UV(98)
  JUV(84) = JVS(185)*UV(54)+JVS(186)*UV(84)+JVS(187)*UV(97)+JVS(188)*UV(98)
  JUV(85) = JVS(189)*UV(57)+JVS(190)*UV(85)+JVS(191)*UV(97)+JVS(192)*UV(98)
  JUV(86) = JVS(193)*UV(69)+JVS(194)*UV(86)+JVS(195)*UV(93)+JVS(196)*UV(98)
  JUV(87) = JVS(197)*UV(63)+JVS(198)*UV(87)+JVS(199)*UV(93)+JVS(200)*UV(98)
  JUV(88) = JVS(201)*UV(5)+JVS(202)*UV(12)+JVS(203)*UV(13)+JVS(204)*UV(83)+JVS(205)*UV(86)+JVS(206)*UV(87)+JVS(207)&
              &*UV(88)+JVS(208)*UV(89)+JVS(209)*UV(90)+JVS(210)*UV(91)+JVS(211)*UV(92)+JVS(212)*UV(93)+JVS(213)*UV(98)
  JUV(89) = JVS(214)*UV(66)+JVS(215)*UV(89)+JVS(216)*UV(93)+JVS(217)*UV(98)
  JUV(90) = JVS(218)*UV(12)+JVS(219)*UV(13)+JVS(220)*UV(59)+JVS(221)*UV(90)+JVS(222)*UV(91)+JVS(223)*UV(93)+JVS(224)&
              &*UV(98)
  JUV(91) = JVS(225)*UV(64)+JVS(226)*UV(90)+JVS(227)*UV(91)+JVS(228)*UV(92)+JVS(229)*UV(93)
  JUV(92) = JVS(231)*UV(12)+JVS(232)*UV(13)+JVS(233)*UV(91)+JVS(234)*UV(92)+JVS(235)*UV(93)+JVS(236)*UV(98)
  JUV(93) = JVS(237)*UV(12)+JVS(238)*UV(13)+JVS(239)*UV(86)+JVS(240)*UV(87)+JVS(241)*UV(89)+JVS(242)*UV(90)+JVS(243)&
              &*UV(91)+JVS(244)*UV(92)+JVS(245)*UV(93)+JVS(246)*UV(98)
  JUV(94) = JVS(247)*UV(3)+JVS(248)*UV(80)+JVS(249)*UV(94)+JVS(250)*UV(95)+JVS(251)*UV(96)+JVS(252)*UV(98)
  JUV(95) = JVS(253)*UV(58)+JVS(254)*UV(85)+JVS(255)*UV(94)+JVS(256)*UV(95)+JVS(257)*UV(96)+JVS(258)*UV(97)+JVS(259)&
              &*UV(98)
  JUV(96) = JVS(260)*UV(55)+JVS(261)*UV(94)+JVS(262)*UV(95)+JVS(263)*UV(96)+JVS(264)*UV(97)+JVS(265)*UV(98)+JVS(266)&
              &*UV(99)
  JUV(97) = JVS(267)*UV(84)+JVS(268)*UV(85)+JVS(269)*UV(96)+JVS(270)*UV(97)+JVS(271)*UV(98)+JVS(272)*UV(99)
  JUV(98) = JVS(273)*UV(12)+JVS(274)*UV(13)+JVS(275)*UV(71)+JVS(276)*UV(72)+JVS(277)*UV(73)+JVS(278)*UV(76)+JVS(279)&
              &*UV(77)+JVS(280)*UV(78)+JVS(281)*UV(79)+JVS(282)*UV(80)+JVS(283)*UV(81)+JVS(284)*UV(82)+JVS(285)*UV(83)&
              &+JVS(286)*UV(84)+JVS(287)*UV(85)+JVS(288)*UV(86)+JVS(289)*UV(87)+JVS(290)*UV(88)+JVS(291)*UV(89)+JVS(292)&
              &*UV(90)+JVS(293)*UV(91)+JVS(294)*UV(92)+JVS(295)*UV(93)+JVS(296)*UV(94)+JVS(297)*UV(95)+JVS(298)*UV(96)&
              &+JVS(299)*UV(97)+JVS(300)*UV(98)+JVS(301)*UV(99)
  JUV(99) = JVS(302)*UV(56)+JVS(303)*UV(96)+JVS(304)*UV(97)+JVS(305)*UV(98)+JVS(306)*UV(99)
      
END SUBROUTINE Jac_SP_Vec

! End of Jac_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacTR_SP_Vec - sparse multiplication: sparse Jacobian transposed times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JTUV      - Jacobian transposed times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacTR_SP_Vec ( JVS, UV, JTUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JTUV - Jacobian transposed times user vector
  REAL(kind=dp) :: JTUV(NVAR)

  JTUV(1) = JVS(1)*UV(1)+JVS(140)*UV(72)
  JTUV(2) = JVS(2)*UV(2)+JVS(152)*UV(75)
  JTUV(3) = JVS(3)*UV(3)+JVS(247)*UV(94)
  JTUV(4) = JVS(4)*UV(4)+JVS(20)*UV(17)
  JTUV(5) = JVS(5)*UV(5)+JVS(201)*UV(88)
  JTUV(6) = JVS(6)*UV(6)+JVS(11)*UV(10)
  JTUV(7) = JVS(7)*UV(7)+JVS(13)*UV(11)
  JTUV(8) = JVS(8)*UV(8)+JVS(9)*UV(9)
  JTUV(9) = JVS(10)*UV(9)+JVS(61)*UV(34)
  JTUV(10) = JVS(12)*UV(10)+JVS(67)*UV(37)
  JTUV(11) = JVS(14)*UV(11)+JVS(74)*UV(40)
  JTUV(12) = JVS(15)*UV(12)+JVS(63)*UV(35)+JVS(202)*UV(88)+JVS(218)*UV(90)+JVS(231)*UV(92)+JVS(237)*UV(93)+JVS(273)&
               &*UV(98)
  JTUV(13) = JVS(16)*UV(13)+JVS(65)*UV(36)+JVS(203)*UV(88)+JVS(219)*UV(90)+JVS(232)*UV(92)+JVS(238)*UV(93)+JVS(274)&
               &*UV(98)
  JTUV(14) = JVS(17)*UV(14)+JVS(78)*UV(42)
  JTUV(15) = JVS(18)*UV(15)+JVS(80)*UV(43)
  JTUV(16) = JVS(19)*UV(16)+JVS(82)*UV(44)
  JTUV(17) = JVS(21)*UV(17)+JVS(84)*UV(45)
  JTUV(18) = JVS(22)*UV(18)
  JTUV(19) = JVS(26)*UV(19)
  JTUV(20) = JVS(28)*UV(20)
  JTUV(21) = JVS(32)*UV(21)
  JTUV(22) = JVS(34)*UV(22)
  JTUV(23) = JVS(36)*UV(23)
  JTUV(24) = JVS(38)*UV(24)
  JTUV(25) = JVS(41)*UV(25)
  JTUV(26) = JVS(43)*UV(26)
  JTUV(27) = JVS(45)*UV(27)
  JTUV(28) = JVS(49)*UV(28)
  JTUV(29) = JVS(51)*UV(29)
  JTUV(30) = JVS(53)*UV(30)
  JTUV(31) = JVS(55)*UV(31)
  JTUV(32) = JVS(57)*UV(32)
  JTUV(33) = JVS(59)*UV(33)
  JTUV(34) = JVS(62)*UV(34)
  JTUV(35) = JVS(64)*UV(35)
  JTUV(36) = JVS(66)*UV(36)
  JTUV(37) = JVS(68)*UV(37)
  JTUV(38) = JVS(69)*UV(38)
  JTUV(39) = JVS(70)*UV(38)+JVS(71)*UV(39)
  JTUV(40) = JVS(75)*UV(40)
  JTUV(41) = JVS(76)*UV(41)
  JTUV(42) = JVS(79)*UV(42)
  JTUV(43) = JVS(81)*UV(43)
  JTUV(44) = JVS(83)*UV(44)
  JTUV(45) = JVS(85)*UV(45)
  JTUV(46) = JVS(86)*UV(46)
  JTUV(47) = JVS(88)*UV(47)
  JTUV(48) = JVS(90)*UV(48)
  JTUV(49) = JVS(92)*UV(49)
  JTUV(50) = JVS(94)*UV(50)
  JTUV(51) = JVS(96)*UV(51)
  JTUV(52) = JVS(98)*UV(52)+JVS(100)*UV(53)
  JTUV(53) = JVS(54)*UV(30)+JVS(72)*UV(39)+JVS(99)*UV(52)+JVS(101)*UV(53)
  JTUV(54) = JVS(102)*UV(54)+JVS(185)*UV(84)
  JTUV(55) = JVS(104)*UV(55)+JVS(260)*UV(96)
  JTUV(56) = JVS(106)*UV(56)+JVS(302)*UV(99)
  JTUV(57) = JVS(108)*UV(57)+JVS(189)*UV(85)
  JTUV(58) = JVS(110)*UV(58)+JVS(253)*UV(95)
  JTUV(59) = JVS(112)*UV(59)+JVS(220)*UV(90)
  JTUV(60) = JVS(114)*UV(60)+JVS(136)*UV(71)
  JTUV(61) = JVS(116)*UV(61)+JVS(144)*UV(73)
  JTUV(62) = JVS(118)*UV(62)+JVS(148)*UV(74)
  JTUV(63) = JVS(120)*UV(63)+JVS(197)*UV(87)
  JTUV(64) = JVS(122)*UV(64)+JVS(225)*UV(91)
  JTUV(65) = JVS(124)*UV(65)+JVS(160)*UV(77)
  JTUV(66) = JVS(126)*UV(66)+JVS(214)*UV(89)
  JTUV(67) = JVS(52)*UV(29)+JVS(73)*UV(39)+JVS(128)*UV(67)+JVS(130)*UV(68)
  JTUV(68) = JVS(129)*UV(67)+JVS(131)*UV(68)
  JTUV(69) = JVS(132)*UV(69)+JVS(193)*UV(86)
  JTUV(70) = JVS(134)*UV(70)+JVS(170)*UV(80)
  JTUV(71) = JVS(27)*UV(19)+JVS(115)*UV(60)+JVS(137)*UV(71)+JVS(141)*UV(72)+JVS(275)*UV(98)
  JTUV(72) = JVS(56)*UV(31)+JVS(138)*UV(71)+JVS(142)*UV(72)+JVS(276)*UV(98)
  JTUV(73) = JVS(29)*UV(20)+JVS(117)*UV(61)+JVS(145)*UV(73)+JVS(174)*UV(81)+JVS(277)*UV(98)
  JTUV(74) = JVS(33)*UV(21)+JVS(119)*UV(62)+JVS(149)*UV(74)+JVS(153)*UV(75)+JVS(156)*UV(76)
  JTUV(75) = JVS(58)*UV(32)+JVS(150)*UV(74)+JVS(154)*UV(75)+JVS(157)*UV(76)
  JTUV(76) = JVS(151)*UV(74)+JVS(155)*UV(75)+JVS(158)*UV(76)+JVS(278)*UV(98)
  JTUV(77) = JVS(39)*UV(24)+JVS(125)*UV(65)+JVS(161)*UV(77)+JVS(164)*UV(78)+JVS(279)*UV(98)
  JTUV(78) = JVS(40)*UV(24)+JVS(162)*UV(77)+JVS(165)*UV(78)+JVS(280)*UV(98)
  JTUV(79) = JVS(46)*UV(27)+JVS(167)*UV(79)+JVS(181)*UV(83)+JVS(281)*UV(98)
  JTUV(80) = JVS(50)*UV(28)+JVS(135)*UV(70)+JVS(171)*UV(80)+JVS(248)*UV(94)+JVS(282)*UV(98)
  JTUV(81) = JVS(30)*UV(20)+JVS(146)*UV(73)+JVS(175)*UV(81)+JVS(178)*UV(82)+JVS(283)*UV(98)
  JTUV(82) = JVS(31)*UV(20)+JVS(176)*UV(81)+JVS(179)*UV(82)+JVS(284)*UV(98)
  JTUV(83) = JVS(47)*UV(27)+JVS(168)*UV(79)+JVS(182)*UV(83)+JVS(204)*UV(88)+JVS(285)*UV(98)
  JTUV(84) = JVS(87)*UV(46)+JVS(103)*UV(54)+JVS(186)*UV(84)+JVS(267)*UV(97)+JVS(286)*UV(98)
  JTUV(85) = JVS(93)*UV(49)+JVS(109)*UV(57)+JVS(190)*UV(85)+JVS(254)*UV(95)+JVS(268)*UV(97)+JVS(287)*UV(98)
  JTUV(86) = JVS(44)*UV(26)+JVS(133)*UV(69)+JVS(194)*UV(86)+JVS(205)*UV(88)+JVS(239)*UV(93)+JVS(288)*UV(98)
  JTUV(87) = JVS(35)*UV(22)+JVS(121)*UV(63)+JVS(198)*UV(87)+JVS(206)*UV(88)+JVS(240)*UV(93)+JVS(289)*UV(98)
  JTUV(88) = JVS(48)*UV(27)+JVS(183)*UV(83)+JVS(207)*UV(88)+JVS(290)*UV(98)
  JTUV(89) = JVS(42)*UV(25)+JVS(127)*UV(66)+JVS(208)*UV(88)+JVS(215)*UV(89)+JVS(241)*UV(93)+JVS(291)*UV(98)
  JTUV(90) = JVS(23)*UV(18)+JVS(113)*UV(59)+JVS(209)*UV(88)+JVS(221)*UV(90)+JVS(226)*UV(91)+JVS(242)*UV(93)+JVS(292)&
               &*UV(98)
  JTUV(91) = JVS(37)*UV(23)+JVS(123)*UV(64)+JVS(210)*UV(88)+JVS(222)*UV(90)+JVS(227)*UV(91)+JVS(233)*UV(92)+JVS(243)&
               &*UV(93)+JVS(293)*UV(98)
  JTUV(92) = JVS(24)*UV(18)+JVS(211)*UV(88)+JVS(228)*UV(91)+JVS(234)*UV(92)+JVS(244)*UV(93)+JVS(294)*UV(98)
  JTUV(93) = JVS(25)*UV(18)+JVS(195)*UV(86)+JVS(199)*UV(87)+JVS(212)*UV(88)+JVS(216)*UV(89)+JVS(223)*UV(90)+JVS(229)&
               &*UV(91)+JVS(235)*UV(92)+JVS(245)*UV(93)+JVS(295)*UV(98)
  JTUV(94) = JVS(60)*UV(33)+JVS(172)*UV(80)+JVS(249)*UV(94)+JVS(255)*UV(95)+JVS(261)*UV(96)+JVS(296)*UV(98)
  JTUV(95) = JVS(95)*UV(50)+JVS(111)*UV(58)+JVS(250)*UV(94)+JVS(256)*UV(95)+JVS(262)*UV(96)+JVS(297)*UV(98)
  JTUV(96) = JVS(89)*UV(47)+JVS(105)*UV(55)+JVS(251)*UV(94)+JVS(257)*UV(95)+JVS(263)*UV(96)+JVS(269)*UV(97)+JVS(298)&
               &*UV(98)+JVS(303)*UV(99)
  JTUV(97) = JVS(97)*UV(51)+JVS(187)*UV(84)+JVS(191)*UV(85)+JVS(258)*UV(95)+JVS(264)*UV(96)+JVS(270)*UV(97)+JVS(299)&
               &*UV(98)+JVS(304)*UV(99)
  JTUV(98) = JVS(77)*UV(41)+JVS(139)*UV(71)+JVS(143)*UV(72)+JVS(147)*UV(73)+JVS(159)*UV(76)+JVS(163)*UV(77)+JVS(166)&
               &*UV(78)+JVS(169)*UV(79)+JVS(173)*UV(80)+JVS(177)*UV(81)+JVS(180)*UV(82)+JVS(184)*UV(83)+JVS(188)*UV(84)&
               &+JVS(192)*UV(85)+JVS(196)*UV(86)+JVS(200)*UV(87)+JVS(213)*UV(88)+JVS(217)*UV(89)+JVS(224)*UV(90)+JVS(236)&
               &*UV(92)+JVS(246)*UV(93)+JVS(252)*UV(94)+JVS(259)*UV(95)+JVS(265)*UV(96)+JVS(271)*UV(97)+JVS(300)*UV(98)&
               &+JVS(305)*UV(99)
  JTUV(99) = JVS(91)*UV(48)+JVS(107)*UV(56)+JVS(266)*UV(96)+JVS(272)*UV(97)+JVS(301)*UV(98)+JVS(306)*UV(99)
      
END SUBROUTINE JacTR_SP_Vec

! End of JacTR_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE aqchem_Jacobian

