
!------------------------------------------------------------------------!
!  The Community Multiscale Air Quality (CMAQ) system software is in     !
!  continuous development by various groups and is based on information  !
!  from these groups: Federal Government employees, contractors working  !
!  within a United States Government contract, and non-Federal sources   !
!  including research institutions.  These groups give the Government    !
!  permission to use, prepare derivative works of, and distribute copies !
!  of their work in the CMAQ system to the public and to permit others   !
!  to do so.  The United States Environmental Protection Agency          !
!  therefore grants similar permission to use the CMAQ system software,  !
!  but users are requested to provide copies of derivative works or      !
!  products designed to operate in the CMAQ system to the United States  !
!  Government without restrictions as to use by others.  Software        !
!  that is used with the CMAQ system but distributed under the GNU       !
!  General Public License or the GNU Lesser General Public License is    !
!  subject to their copyright restrictions.                              !
!------------------------------------------------------------------------!
 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Parameter Module File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE aqchem_Parameters

  USE aqchem_Precision
  PUBLIC
  SAVE


! NSPEC - Number of chemical species
  INTEGER, PARAMETER :: NSPEC = 102 
! NVAR - Number of Variable species
  INTEGER, PARAMETER :: NVAR = 99 
! NVARACT - Number of Active species
  INTEGER, PARAMETER :: NVARACT = 66 
! NFIX - Number of Fixed species
  INTEGER, PARAMETER :: NFIX = 3 
! NREACT - Number of reactions
  INTEGER, PARAMETER :: NREACT = 130 
! NVARST - Starting of variables in conc. vect.
  INTEGER, PARAMETER :: NVARST = 1 
! NFIXST - Starting of fixed in conc. vect.
  INTEGER, PARAMETER :: NFIXST = 100 
! NONZERO - Number of nonzero entries in Jacobian
  INTEGER, PARAMETER :: NONZERO = 305 
! LU_NONZERO - Number of nonzero entries in LU factoriz. of Jacobian
  INTEGER, PARAMETER :: LU_NONZERO = 306 
! CNVAR - (NVAR+1) Number of elements in compressed row format
  INTEGER, PARAMETER :: CNVAR = 100 
! NLOOKAT - Number of species to look at
  INTEGER, PARAMETER :: NLOOKAT = 102 
! NMONITOR - Number of species to monitor
  INTEGER, PARAMETER :: NMONITOR = 0 
! NMASS - Number of atoms to check mass balance
  INTEGER, PARAMETER :: NMASS = 1 

! Index declaration for variable species in C and VAR
!   VAR(ind_spc) = C(ind_spc)

  INTEGER, PARAMETER :: ind_A_NO3AKN = 1 
  INTEGER, PARAMETER :: ind_A_NH4AKN = 2 
  INTEGER, PARAMETER :: ind_A_CLAKN = 3 
  INTEGER, PARAMETER :: ind_A_NAAKN = 4 
  INTEGER, PARAMETER :: ind_A_SO4AKN = 5 
  INTEGER, PARAMETER :: ind_A_PECAKN = 6 
  INTEGER, PARAMETER :: ind_A_POAAKN = 7 
  INTEGER, PARAMETER :: ind_A_PRIAKN = 8 
  INTEGER, PARAMETER :: ind_L_PRIACC = 9 
  INTEGER, PARAMETER :: ind_L_PECACC = 10 
  INTEGER, PARAMETER :: ind_L_POAACC = 11 
  INTEGER, PARAMETER :: ind_L_FEPLUS3 = 12 
  INTEGER, PARAMETER :: ind_L_MNPLUS2 = 13 
  INTEGER, PARAMETER :: ind_L_CAPLUS2 = 14 
  INTEGER, PARAMETER :: ind_L_MGPLUS2 = 15 
  INTEGER, PARAMETER :: ind_L_KPLUS = 16 
  INTEGER, PARAMETER :: ind_L_NAPLUS = 17 
  INTEGER, PARAMETER :: ind_WD_SO2 = 18 
  INTEGER, PARAMETER :: ind_WD_HNO3 = 19 
  INTEGER, PARAMETER :: ind_WD_CO2 = 20 
  INTEGER, PARAMETER :: ind_WD_NH4OH = 21 
  INTEGER, PARAMETER :: ind_WD_H2O2 = 22 
  INTEGER, PARAMETER :: ind_WD_O3 = 23 
  INTEGER, PARAMETER :: ind_WD_HCOOH = 24 
  INTEGER, PARAMETER :: ind_WD_MHP = 25 
  INTEGER, PARAMETER :: ind_WD_PAA = 26 
  INTEGER, PARAMETER :: ind_WD_H2SO4 = 27 
  INTEGER, PARAMETER :: ind_WD_HCL = 28 
  INTEGER, PARAMETER :: ind_WD_GLY = 29 
  INTEGER, PARAMETER :: ind_WD_MGLY = 30 
  INTEGER, PARAMETER :: ind_WD_NO3MIN = 31 
  INTEGER, PARAMETER :: ind_WD_NH4PLUS = 32 
  INTEGER, PARAMETER :: ind_WD_CLMIN = 33 
  INTEGER, PARAMETER :: ind_WD_PRIACC = 34 
  INTEGER, PARAMETER :: ind_WD_FEPLUS3 = 35 
  INTEGER, PARAMETER :: ind_WD_MNPLUS2 = 36 
  INTEGER, PARAMETER :: ind_WD_PECACC = 37 
  INTEGER, PARAMETER :: ind_WD_ORGC = 38 
  INTEGER, PARAMETER :: ind_L_ORGC = 39 
  INTEGER, PARAMETER :: ind_WD_POAACC = 40 
  INTEGER, PARAMETER :: ind_WD_HPLUS = 41 
  INTEGER, PARAMETER :: ind_WD_CAPLUS2 = 42 
  INTEGER, PARAMETER :: ind_WD_MGPLUS2 = 43 
  INTEGER, PARAMETER :: ind_WD_KPLUS = 44 
  INTEGER, PARAMETER :: ind_WD_NAPLUS = 45 
  INTEGER, PARAMETER :: ind_WD_HBR = 46 
  INTEGER, PARAMETER :: ind_WD_HOBR = 47 
  INTEGER, PARAMETER :: ind_WD_BR2 = 48 
  INTEGER, PARAMETER :: ind_WD_HOCL = 49 
  INTEGER, PARAMETER :: ind_WD_BRCL = 50 
  INTEGER, PARAMETER :: ind_WD_BRMIN = 51 
  INTEGER, PARAMETER :: ind_G_MGLY = 52 
  INTEGER, PARAMETER :: ind_L_MGLY = 53 
  INTEGER, PARAMETER :: ind_G_HBR = 54 
  INTEGER, PARAMETER :: ind_G_HOBR = 55 
  INTEGER, PARAMETER :: ind_G_BR2 = 56 
  INTEGER, PARAMETER :: ind_G_HOCL = 57 
  INTEGER, PARAMETER :: ind_G_BRCL = 58 
  INTEGER, PARAMETER :: ind_G_SO2 = 59 
  INTEGER, PARAMETER :: ind_G_HNO3 = 60 
  INTEGER, PARAMETER :: ind_G_CO2 = 61 
  INTEGER, PARAMETER :: ind_G_NH3 = 62 
  INTEGER, PARAMETER :: ind_G_H2O2 = 63 
  INTEGER, PARAMETER :: ind_G_O3 = 64 
  INTEGER, PARAMETER :: ind_G_HCOOH = 65 
  INTEGER, PARAMETER :: ind_G_MHP = 66 
  INTEGER, PARAMETER :: ind_L_GLY = 67 
  INTEGER, PARAMETER :: ind_G_GLY = 68 
  INTEGER, PARAMETER :: ind_G_PAA = 69 
  INTEGER, PARAMETER :: ind_G_HCL = 70 
  INTEGER, PARAMETER :: ind_L_HNO3 = 71 
  INTEGER, PARAMETER :: ind_L_NO3MIN = 72 
  INTEGER, PARAMETER :: ind_L_H2CO3 = 73 
  INTEGER, PARAMETER :: ind_L_NH4OH = 74 
  INTEGER, PARAMETER :: ind_L_NH4PLUS = 75 
  INTEGER, PARAMETER :: ind_L_OHMIN = 76 
  INTEGER, PARAMETER :: ind_L_HCOOH = 77 
  INTEGER, PARAMETER :: ind_L_HCOOMIN = 78 
  INTEGER, PARAMETER :: ind_L_H2SO4 = 79 
  INTEGER, PARAMETER :: ind_L_HCL = 80 
  INTEGER, PARAMETER :: ind_L_HCO3MIN = 81 
  INTEGER, PARAMETER :: ind_L_CO3MIN2 = 82 
  INTEGER, PARAMETER :: ind_L_HSO4MIN = 83 
  INTEGER, PARAMETER :: ind_L_HBR = 84 
  INTEGER, PARAMETER :: ind_L_HOCL = 85 
  INTEGER, PARAMETER :: ind_L_PAA = 86 
  INTEGER, PARAMETER :: ind_L_H2O2 = 87 
  INTEGER, PARAMETER :: ind_L_SO4MIN2 = 88 
  INTEGER, PARAMETER :: ind_L_MHP = 89 
  INTEGER, PARAMETER :: ind_L_SO2 = 90 
  INTEGER, PARAMETER :: ind_L_O3 = 91 
  INTEGER, PARAMETER :: ind_L_SO3MIN2 = 92 
  INTEGER, PARAMETER :: ind_L_HSO3MIN = 93 
  INTEGER, PARAMETER :: ind_L_CLMIN = 94 
  INTEGER, PARAMETER :: ind_L_BRCL = 95 
  INTEGER, PARAMETER :: ind_L_HOBR = 96 
  INTEGER, PARAMETER :: ind_L_BRMIN = 97 
  INTEGER, PARAMETER :: ind_L_HPLUS = 98 
  INTEGER, PARAMETER :: ind_L_BR2 = 99 

! Index declaration for fixed species in C
!   C(ind_spc)

  INTEGER, PARAMETER :: ind_L_H2O = 100 
  INTEGER, PARAMETER :: ind_L_HO = 101 
  INTEGER, PARAMETER :: ind_DUMMY = 102 

! Index declaration for dummy species


! Index declaration for fixed species in FIX
!    FIX(indf_spc) = C(ind_spc) = C(NVAR+indf_spc)

  INTEGER, PARAMETER :: indf_L_H2O = 1 
  INTEGER, PARAMETER :: indf_L_HO = 2 
  INTEGER, PARAMETER :: indf_DUMMY = 3 

END MODULE aqchem_Parameters

